(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     76718,       2006]
NotebookOptionsPosition[     68982,       1757]
NotebookOutlinePosition[     72898,       1880]
CellTagsIndexPosition[     72808,       1874]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Mend - A Package for Mending Time Series with Missing Observations \
and Structural Breaks",
  FontFamily->"Arial",
  FontSize->22],
 "\n\n",
 StyleBox["by Ekkehart Schlicht",
  FontFamily->"Arial",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.512813708248047*^9, 3.512813795544922*^9}, {
   3.512835190955078*^9, 3.512835195626953*^9}, 3.512894248629883*^9, {
   3.5130716105585938`*^9, 3.5130716416210938`*^9}},
 CellTags->"b:0"],

Cell["\<\
Version 1, May 2011
 \
\>", "Text",
 CellFrame->{{0, 0}, {0.5, 0}},
 CellChangeTimes->{{3.512813802857422*^9, 3.512813813826172*^9}, {
  3.513394998051588*^9, 3.5133949986496224`*^9}},
 CellTags->"b:0"],

Cell[TextData[{
 "\n",
 StyleBox["The package implements a method for mending time series with \
missing observations and structural breaks. The method is described in \
Ekkehart Schlicht: \[OpenCurlyDoubleQuote]Trend Extraction from Time Series \
with Structural Breaks and Missing Observations\[CloseCurlyDoubleQuote], ",
  FontWeight->"Plain"],
 StyleBox[" Journal of the Japan Statistical Society ",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["  Vol. 38 (2008), No. 2, pages 285-292, freely available at",
  FontWeight->"Plain"],
 StyleBox[" http://www.jstage.jst.go.jp/article/jjss/38/2/285/_pdf. ",
  FontFamily->"Courier New",
  FontWeight->"Plain"],
 "\nThe package deals with a time series ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 "={",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]]],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "2"], TraditionalForm]]],
 ",..",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "T"], TraditionalForm]]],
 "} of length ",
 StyleBox["T. ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"The", " ", "value", " ", 
     SubscriptBox["x", "t"]}]}], TraditionalForm]]],
 " denotes the value of the time series at time ",
 StyleBox["t",
  FontSlant->"Italic"],
 ". A missing value is indicated by a blank, as for the forth element in  {",
 StyleBox["1,2,1, ,3,4,6",
  FontSlant->"Italic"],
 "}. Points where structural breaks occur are supplied by  a vector ",
 StyleBox["bp=",
  FontSlant->"Italic"],
 "{",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SubscriptBox["bp", 
      RowBox[{"1", " "}]],
     FontSlant->"Italic"], ","}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["bp", 
     RowBox[{"2", " "}]],
    FontSlant->"Italic"], TraditionalForm]]],
 ",..} where ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["bp", 
     RowBox[{"i", " "}]],
    FontSlant->"Italic"], TraditionalForm]]],
 "gives the point after which the structural break occurs. The method is \
designed for allowing trend extraction by means of the  Leser filter (also \
known as the HP-Filter) to enable dealing with time series with gaps and \
structural breaks.\nThe package provides the following three function for \
mending a time series:"
}], "Text",
 CellChangeTimes->{{3.512813835482422*^9, 3.512813958826172*^9}, {
   3.512813996201172*^9, 3.512814035873047*^9}, {3.51281442496875*^9, 
   3.512814461015625*^9}, {3.512814524828125*^9, 3.51281500971875*^9}, {
   3.5128150440625*^9, 3.51281519390625*^9}, {3.512815231171875*^9, 
   3.5128152480625*^9}, {3.512835273236328*^9, 3.512835374455078*^9}, {
   3.513177158491211*^9, 3.513177190975586*^9}, {3.5131772705996094`*^9, 
   3.5131772973027344`*^9}, 3.513404494210737*^9},
 CellTags->"b:0"],

Cell[TextData[{
 StyleBox["Mend[x,\[Alpha]]  repairs a time series with missing observations \
x by filling the gaps with appropriate estimates. The parameter \[Alpha] \
gives the smoothing parameter for the Leser filter (also known as the HP \
filter). If this parameter is not provided, the default \[Alpha]=100 is \
used..",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Mend[x,\[Alpha],bp] estimates dummies for the break points and \
returns the time series x adjusted for the break points. It also fills any \
missing values. If the parameter \[Alpha] is not provided, as in  \
Mend[x,,bp], the default value   \[Alpha]=100 is used.",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Mend[ ] returns a list {y,breaks,gaps}\n-  ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{"y", " "}], TraditionalForm]]],
 "= {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "1"], TraditionalForm]]],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "2"], TraditionalForm]]],
 ",..",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "T"], TraditionalForm]]],
 "} ",
 StyleBox[" is the mended time series, \n",
  FontSlant->"Italic"],
 StyleBox["-  breaks = ",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 StyleBox["{",
  FontFamily->"Times New Roman"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["break", "1"], ",", " ", 
        SubscriptBox["break", "2"], ",", " ", ".."}], "}"}], " ", "gives", 
      " ", "the", " ", "breaks"}], ",", " ", "with"}],
    FontSlant->"Italic"], TraditionalForm]],
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{
   StyleBox[" ",
    FontSlant->"Italic"], 
   StyleBox[
    SubscriptBox["break", "i"],
    FontFamily->"Times New Roman"]}]],
  FontSlant->"Italic"],
 "={",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["bp", 
     RowBox[{"i", " "}]],
    FontSlant->"Italic"], TraditionalForm]]],
 ",",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    SubscriptBox["d", "i"]}], TraditionalForm]]],
 ") ",
 StyleBox[" denoting the position ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["bp", 
     RowBox[{"i", " "}]],
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox["of break i  and  ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", "i"], TraditionalForm]]],
 StyleBox[" denotong the dummy.\n- gaps = ",
  FontSlant->"Italic"],
 StyleBox["{",
  FontFamily->"Times New Roman"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["gap", "1"], 
       StyleBox[",",
        FontSlant->"Italic"], 
       StyleBox[" ",
        FontSlant->"Italic"], 
       SubscriptBox["gap", "2"], 
       StyleBox[",",
        FontSlant->"Italic"], 
       StyleBox[" ",
        FontSlant->"Italic"], 
       StyleBox["..",
        FontSlant->"Italic"]}], 
      StyleBox["}",
       FontSlant->"Italic"]}], 
     StyleBox[" ",
      FontSlant->"Italic"], 
     StyleBox["gives",
      FontSlant->"Italic"], 
     StyleBox[" ",
      FontSlant->"Italic"], 
     StyleBox["the",
      FontSlant->"Italic"], 
     StyleBox[" ",
      FontSlant->"Italic"], 
     StyleBox["gaps",
      FontSlant->"Italic"]}], 
    StyleBox[",",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    StyleBox["with",
     FontSlant->"Italic"]}], TraditionalForm]],
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{
   StyleBox[" ",
    FontSlant->"Italic"], 
   StyleBox[
    SubscriptBox["gap", "i"],
    FontFamily->"Times New Roman"]}]],
  FontSlant->"Italic"],
 " = {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", 
    RowBox[{"i", " "}]], TraditionalForm]]],
 ",",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    SubscriptBox["d", "i"]}], TraditionalForm]]],
 ") ",
 StyleBox[" denoting the position ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["bp", 
     RowBox[{"i", " "}]],
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox["of ",
  FontSlant->"Italic"],
 "gap",
 StyleBox[" i  and  ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", "i"], TraditionalForm]]],
 StyleBox[" denotong the dummy that is used to fill gap i.  \nThe elements of \
the mended time series are the elements of the original series, with values ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", 
    RowBox[{"i", " "}]], TraditionalForm]]],
 StyleBox["substituted for the missing values at positions ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", 
    RowBox[{"i", " "}]], TraditionalForm]],
  FontSlant->"Italic"],
 StyleBox["and the sum of relevant dummies  ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", 
     RowBox[{" ", 
      RowBox[{
       RowBox[{"i", " ", "with", " ", 
        SubscriptBox["bp", "i"]}], "\[GreaterEqual]", " ", "t"}]}]], " ", 
    SubscriptBox["d", "i"]}], TraditionalForm]]],
 " ",
 StyleBox["added to each element ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "t"], TraditionalForm]]],
 StyleBox[".\n",
  FontSlant->"Italic"]
}], "DefinitionBox",
 CellChangeTimes->{{3.512814070294922*^9, 3.5128144155625*^9}, {
   3.512815262953125*^9, 3.5128153434375*^9}, {3.5128153756875*^9, 
   3.51281544146875*^9}, {3.5128154826875*^9, 3.51281599325*^9}, {
   3.51281603021875*^9, 3.5128162543125*^9}, {3.51281629165625*^9, 
   3.512816311171875*^9}, {3.512816354109375*^9, 3.512816652875*^9}, {
   3.512816693125*^9, 3.512816891194336*^9}, {3.512894255004883*^9, 
   3.512894378239258*^9}, {3.512894452192383*^9, 3.512894825567383*^9}, {
   3.512894864864258*^9, 3.512894915708008*^9}, {3.512894948895508*^9, 
   3.512895169067383*^9}, {3.513165514114258*^9, 3.513165557083008*^9}, {
   3.513165589176758*^9, 3.513165604364258*^9}, {3.513165665989258*^9, 
   3.513165673786133*^9}, {3.513165718661133*^9, 3.513166069114258*^9}, 
   3.513166420439453*^9, {3.513177113225586*^9, 3.513177119084961*^9}},
 CellTags->{"i:1", "b:0"}],

Cell["", "Text",
 CellChangeTimes->{{3.512817002100586*^9, 3.512817003741211*^9}}],

Cell["This loads the package", "MathCaption",
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{"<<", "Mend`"}]], "Input",
 CellChangeTimes->{{3.5126125039725475`*^9, 3.5126125324981794`*^9}, 
   3.512613129555329*^9, {3.512816923053711*^9, 3.512816923834961*^9}, 
   3.513086264852539*^9, 3.513127467588867*^9},
 CellTags->"b:0",
 CellLabel->"In[1]:="],

Cell["\<\
Here is a series with 52 elements - the US unemployment rate from 1951 \
through 2002:\
\>", "MathCaption",
 CellChangeTimes->{{3.512816981241211*^9, 3.512816981788086*^9}, 
   3.512817127538086*^9, {3.512895430723633*^9, 3.512895438442383*^9}, {
   3.512895504020508*^9, 3.512895540379883*^9}},
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"{", 
    RowBox[{
    "0.033054286", ",", "0.030252121", ",", "0.029335036", ",", "0.055997854",
      ",", "0.043621372", ",", "0.041253782", ",", "0.042983567", ",", 
     "0.068377089", ",", "0.054576795", ",", "0.055616434", ",", 
     "0.066794496", ",", "0.055476952", ",", "0.056434263", ",", 
     "0.051669067", ",", "0.045061629", ",", "0.03784539", ",", "0.038421758",
      ",", "0.035540616", ",", "0.03506801", ",", "0.049849379", ",", 
     "0.059515226", ",", "0.056036976", ",", "0.048756301", ",", 
     "0.056246608", ",", "0.084670976", ",", "0.076943478", ",", 
     "0.070384152", ",", "0.060519286", ",", "0.058453689", ",", 
     "0.071705897", ",", "0.076156094", ",", "0.097192669", ",", 
     "0.095894813", ",", "0.075125038", ",", "0.071997945", ",", 
     "0.069964438", ",", "0.061855025", ",", "0.055038601", ",", "0.05267365",
      ",", "0.056103504", ",", "0.068378853", ",", "0.07502916", ",", 
     "0.069099691", ",", "0.060859999", ",", "0.055979347", ",", 
     "0.053982948", ",", "0.049366231", ",", "0.045059882", ",", 
     "0.042198238", ",", "0.043358661", ",", "0.047586757", ",", 
     "0.057901872"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{3.512816949834961*^9, 3.512835414236328*^9},
 CellTags->"b:0",
 CellLabel->"In[2]:="],

Cell["\<\
We drop observations 20 through 25 to produce a time series with gaps at \
{20,21,22,23,24,25}:\
\>", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.512817267850586*^9, 3.512817324569336*^9}, {
  3.512817356147461*^9, 3.512817377225586*^9}, {3.512835424798828*^9, 
  3.512835490798828*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", 
    RowBox[{"[", 
     RowBox[{"20", ";;", "25"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{",", ",", ",", ",", ","}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.512817387991211*^9, 3.512817389709961*^9}, {
   3.51314599225*^9, 3.513145999875*^9}, 3.5131584371347656`*^9},
 CellLabel->"In[3]:="],

Cell[TextData[{
 "The following code mends the time series",
 StyleBox[" y",
  FontSlant->"Italic"],
 ":"
}], "MathCaption",
 CellChangeTimes->{{3.512817417975586*^9, 3.512817435116211*^9}, {
  3.51314602384375*^9, 3.51314602434375*^9}},
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"breaks", ",", "gaps"}], "}"}]}], "}"}], "=", 
   RowBox[{"Mend", "[", 
    RowBox[{"y", ",", "100"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.512817077303711*^9, 3.512817085194336*^9}, {
   3.512817440803711*^9, 3.512817491413086*^9}, {3.513045420645508*^9, 
   3.513045448801758*^9}, 3.513045608645508*^9, {3.513045650864258*^9, 
   3.513045654036133*^9}, {3.513146010875*^9, 3.513146019328125*^9}},
 CellTags->"b:0",
 CellLabel->"In[5]:="],

Cell[TextData[{
 "Here is a plot of the original time series ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "(blue),  the incomplete time series ",
 StyleBox["y",
  FontSlant->"Italic"],
 " (dots) and the  mended time series z",
 StyleBox[" ",
  FontSlant->"Italic"],
 "(red). \[LineSeparator]"
}], "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.512817505897461*^9, 3.512817516897461*^9}, {
   3.512835516845703*^9, 3.512835541064453*^9}, 3.512835709923828*^9, {
   3.512835807751953*^9, 3.512835876486328*^9}, {3.5130599286435547`*^9, 
   3.5130599387060547`*^9}, {3.513144561203125*^9, 3.51314459434375*^9}, {
   3.51314604209375*^9, 3.51314606903125*^9}, {3.513146164046875*^9, 
   3.51314616446875*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "z", ",", "y"}], "}"}], ",", 
    RowBox[{"Joined", "->", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PlotMarkers", "->", 
     RowBox[{"{", 
      RowBox[{",", ",", 
       RowBox[{"{", 
        RowBox[{"\[FilledCircle]", ",", "7"}], "}"}]}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.512613557412801*^9, 3.5126136016143293`*^9}, {
   3.512613673805458*^9, 3.512613727924554*^9}, {3.512817554194336*^9, 
   3.512817643366211*^9}, {3.512817704991211*^9, 3.512817705928711*^9}, 
   3.512817811069336*^9, 3.512835762626953*^9, 3.512835795330078*^9, 
   3.513045575129883*^9, {3.5131438370625*^9, 3.51314388934375*^9}, 
   3.513143977234375*^9, {3.51314401121875*^9, 3.513144061046875*^9}, {
   3.513144188125*^9, 3.513144213140625*^9}, {3.5131442560625*^9, 
   3.513144272609375*^9}, {3.513144354390625*^9, 3.51314435621875*^9}, {
   3.513144405421875*^9, 3.51314444778125*^9}, {3.51314451996875*^9, 
   3.513144526390625*^9}, 3.51314523603125*^9, {3.513145690078125*^9, 
   3.513145712234375*^9}, {3.51314608440625*^9, 3.51314610534375*^9}, {
   3.5133948391745005`*^9, 3.5133948588526263`*^9}},
 CellTags->"b:0",
 CellLabel->"In[6]:="],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGA4AsQgGgI+2O9atfNU7ZsF9lABh1PdgZWZv+ZB+RwOrC//
fGDggvEFHPIY1fUPrF4D5Ys47BT1jukKXQblSzh8q+C1NJdfCuXLONyYzK/7
kREmr+BQ8pPHULNxI5Sv5FBX5xVd+3E1lK/iUHnf59bBSpj5ag6MBffXF0rC
1Gs4xKpwz61Mh8lrOQh9eLX48xMYX8dh2ZqvhnElq6B8PYdCvh2xgULLoXwD
h+T8rRMqEhZD+YYObwwUXVjWwPhGDnuWnNFLNFoE5Rs7SL3T1sj/shDKN3EI
ucw/83brSijf1OF23sRZxyvWQflmDnrnJz17sAHmHnOHio2df6Z+WwHlWzic
frX3d9QZmLylQ7PKdYf/a7ZC+VYO99uWRU7ctBnKt3ZwU/8vt4llE5Rv48Cf
7u2S9Admn63DnbPaoUveroXy7Rw2z+4OCoyGqbd3aGeQt/1eBzPPwaFe9Eja
vIc7IPwGB4dtzzf87e+B8hkcHdRkg/6mWEPVNzg6iFepC5fmwcxzclC+IF5r
8BIaHw1ODuIH3luVrV4PlXd20OVZ8I9FD+q/BmeHunMWGVw/YPHh4pDyZa/p
zJ0weReH+Jr4k27w9ODqIOpSlCNjCrPf1aHdiqmwZQNM3s1B4v7aTVyaUPsa
3BzK5lobBq+Ehae7g4xjusbyxdD01ODusOtz+PV2N1h8eThczJXaLwZLDw0e
DgWBgS8YZ8PSq6dD6Yw/ttLG0PTa4Ong7Ss8yysWFn9eDkf/WecGLIWF92j+
ITX/VFXN0zw5CRaepg7q5VNUns+ExY+Zw41A9/kRd2D2mzuUTH7TJ+wBc5+F
w5ajO1/wnoaFv6XDoYInC22DYelvNP+M5p/hnH9G0/do+h5N36Ppe+DTNwCN
3k7I
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
        69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
       86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
       103, 104}]}}, {
     {Hue[0.67, 0.6, 0.6], InsetBox["", 1], InsetBox["", 2], InsetBox["", 3], 
      InsetBox["", 4], InsetBox["", 5], InsetBox["", 6], InsetBox["", 7], 
      InsetBox["", 8], InsetBox["", 9], InsetBox["", 10], InsetBox["", 11], 
      InsetBox["", 12], InsetBox["", 13], InsetBox["", 14], InsetBox["", 15], 
      InsetBox["", 16], InsetBox["", 17], InsetBox["", 18], InsetBox["", 19], 
      InsetBox["", 20], InsetBox["", 21], InsetBox["", 22], InsetBox["", 23], 
      InsetBox["", 24], InsetBox["", 25], InsetBox["", 26], InsetBox["", 27], 
      InsetBox["", 28], InsetBox["", 29], InsetBox["", 30], InsetBox["", 31], 
      InsetBox["", 32], InsetBox["", 33], InsetBox["", 34], InsetBox["", 35], 
      InsetBox["", 36], InsetBox["", 37], InsetBox["", 38], InsetBox["", 39], 
      InsetBox["", 40], InsetBox["", 41], InsetBox["", 42], InsetBox["", 43], 
      InsetBox["", 44], InsetBox["", 45], InsetBox["", 46], InsetBox["", 47], 
      InsetBox["", 48], InsetBox["", 49], InsetBox["", 50], InsetBox["", 51], 
      InsetBox["", 52]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], InsetBox["", 53], InsetBox["", 54], 
      InsetBox["", 55], InsetBox["", 56], InsetBox["", 57], InsetBox["", 58], 
      InsetBox["", 59], InsetBox["", 60], InsetBox["", 61], InsetBox["", 62], 
      InsetBox["", 63], InsetBox["", 64], InsetBox["", 65], InsetBox["", 66], 
      InsetBox["", 67], InsetBox["", 68], InsetBox["", 69], InsetBox["", 70], 
      InsetBox["", 71], InsetBox["", 72], InsetBox["", 73], InsetBox["", 74], 
      InsetBox["", 75], InsetBox["", 76], InsetBox["", 77], InsetBox["", 78], 
      InsetBox["", 79], InsetBox["", 80], InsetBox["", 81], InsetBox["", 82], 
      InsetBox["", 83], InsetBox["", 84], InsetBox["", 85], InsetBox["", 86], 
      InsetBox["", 87], InsetBox["", 88], InsetBox["", 89], InsetBox["", 90], 
      InsetBox["", 91], InsetBox["", 92], InsetBox["", 93], InsetBox["", 94], 
      InsetBox["", 95], InsetBox["", 96], InsetBox["", 97], InsetBox["", 98], 
      InsetBox["", 99], InsetBox["", 100], InsetBox["", 101], 
      InsetBox["", 102], InsetBox["", 103], InsetBox["", 104]}, 
     {Hue[0.1421359549995791, 0.6, 0.6], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 151], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 152], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 153], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 154], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 155], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 156], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 157], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 158], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 159], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 160], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 161], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 162], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 163], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 164], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 165], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 166], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 167], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 168], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 169], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 170], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 171], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 172], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 173], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 174], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 175], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 176], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 177], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 178], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 179], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 180], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 181], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 182], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 183], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 184], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 185], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 186], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 187], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 188], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 189], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 190], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 191], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 192], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 193], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 194], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 195], InsetBox[
       StyleBox["\[FilledCircle]",
        StripOnInput->False,
        FontSize->7], 196]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 52.}, {0, 0.097192669}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5128975505166016`*^9, 3.513045659583008*^9, 3.5130464442402344`*^9, 
   3.5130599432216797`*^9, 3.513069417323242*^9, 3.513069553479492*^9, 
   3.5130716614179688`*^9, 3.5130720334804688`*^9, 3.5130824327695312`*^9, 
   3.513086281008789*^9, {3.5131438500625*^9, 3.513143865390625*^9}, 
   3.51314397846875*^9, 3.513144013203125*^9, 3.5131440505625*^9, {
   3.513144232625*^9, 3.513144274234375*^9}, 3.51314435721875*^9, {
   3.51314441175*^9, 3.51314445075*^9}, {3.513144509359375*^9, 
   3.513144527125*^9}, 3.513145237890625*^9, 3.513145326359375*^9, {
   3.513145699578125*^9, 3.51314571290625*^9}, 3.5131459641875*^9, 
   3.513146116828125*^9, 3.513158452654297*^9, 3.513158683444336*^9, 
   3.513166154411133*^9, 3.513393888618132*^9, 3.513394916877945*^9, 
   3.5134045582494*^9},
 CellTags->"b:0",
 CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
 "As compared to the trend of the complete series, the trend looks quite \
similar, though, even with such a considerable gap.\n (",
 StyleBox["This uses the package HPFilter from the Wolfram Library Archive.)",
   "Input"]
}], "MathCaption",
 CellChangeTimes->{{3.512817756897461*^9, 3.512817786834961*^9}, 
   3.512817826147461*^9, {3.512835558548828*^9, 3.512835579658203*^9}, 
   3.512835644892578*^9, {3.512835899267578*^9, 3.512835901283203*^9}, {
   3.512895764504883*^9, 3.512895777020508*^9}, {3.51289671359375*^9, 
   3.512896736203125*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["", "Input"]], "Subsubsection",
 CellChangeTimes->{{3.5128111539208984`*^9, 3.5128112550927734`*^9}, {
  3.5128114420458984`*^9, 3.5128114462490234`*^9}, {3.5128116698271484`*^9, 
  3.5128116704365234`*^9}, {3.512812178876953*^9, 3.512812181580078*^9}, {
  3.512812655841797*^9, 3.512812722701172*^9}, {3.512817772038086*^9, 
  3.512817793084961*^9}, {3.512835572955078*^9, 3.512835573408203*^9}, {
  3.512895768786133*^9, 3.512895769333008*^9}}],

Cell[BoxData[
 RowBox[{"<<", "HPFilter`"}]], "Input",
 CellChangeTimes->{{3.5128111886552734`*^9, 3.5128111989990234`*^9}},
 CellLabel->"In[7]:="],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"yf", "=", 
   RowBox[{"HPFilter", "[", 
    RowBox[{"x", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"zf", "=", 
   RowBox[{"HPFilter", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mend", "[", 
       RowBox[{"z", ",", "100"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "100"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"yf", ",", "zf"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5128120294833984`*^9, 3.5128120583427734`*^9}, {
  3.512812235814453*^9, 3.512812259876953*^9}, {3.513146196078125*^9, 
  3.51314625175*^9}},
 CellLabel->"In[8]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw10ntI01EUB3ATLBERg8pYaUubiKk1Nec0/X2nc272j5SFSZrb7GnWcIEQ
ET+pkExdUVmmMl2bS2s+poaJxcCwFERUMIqeEkn+NdIGGvSicy5cLp97Lvdx
zt1uOLf/mL+fn1/y3/5v/N+8QrAgL6+KaBdoArFa1XK8y0YORHeQrb4s3U4O
Re18prHS4yBvgL7V0ngo2kneDHv4i5mxkw/JWyEzFmYYqjvJUsx9PtFYrO8i
R0K4eEq34mXvQEOnoacu4RE5GsvS5qnfEnYM7orWO7XDvD4WT658b6qPYsdh
pGJjTb+Jz0vAmZqGNwOjfJ/daE8MmpwHWw79B0eUMpCdiJBedCvi2Uk4m9/i
SR5iJ8OsuzGisPH+e3A4YMnlm+HzU1BU2bH2o/wxWYGI45qJgR4XORXjtqVt
1Zk9ZCXu/Xq7KDH0ktNwoDTvC0L7yOlwmcdMm5zsvWiZOD36LNZNzsBKR6Fb
28bOhKfJ1O4N6CcLKFVNB1vy2cDB2ZsOrZksAmmr6xeH9BxXYfKH9b4hnOMq
rIsL8foP8v5ZOCIP8z1QkMUseCLDJM39fL9sfLvwdOl8ClnMxvWya899r/h9
ahTLKqQL5WRRjbbXW/qawjieg4I1JfuUlyg/Yg5Gm7sSUt3dFNegKl9lwQTl
U9RAbp9dODrN+c6F5XLdkGyO/ouYi51u++rwV66PFsrbBcaXoWRRC706Ztd4
MddTh/dXBz/dmqJ6izqEJ0nURSVc/zwUibJ31p9O4Q+Dm+mb
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw10gtIU2EUB/ARPVagq8xN0h6KhJPho9lzuf11081mGEpZywQtkYIeuqGE
IpeEYROy5ipEaGnmeqjLuaA5hCLTpDBNhAIVy3AWmhkJCdGLzvngcvndcznf
+c75IgvPZRctE4lESX+ff+//66vmyU9/q2hzk4Y+oNL3osXobiaLoW5InJKh
hbwW815lzuP+O+QNuHZBMhKe4CKHoVwepxi13CVHICaw0amvu0feCumZb/ID
5++To5AWrp9y/WZHQ/p5wr5G9YC8DSpjT1h9FDsGy7Ps6jof/x+LyckSaWEo
W4GO1jG9P4v3i8NZd7+98hLXk4DW/MPjlmmuNxGf+iROj5W9HUU/1k+4q9hK
eEfifeJ37CTIK27KB+ycbweelzuiAw28305Ys/XOI2Nczy6YHbOXQwxt5N2o
7/PNBL1sJ+/BbMnHpuQcN3kv+iTDuZnFD8kqJCsc1bbQTvI+iHuWQp51sZOh
lMWv6NV6yGo0vs8r73rK1qDzqLtCF9lFBq5/MK2OPkQWgKpVbYtfDnI8BVsc
Jy6WSTmegt5g28kFL+dLxULUrbHvKrKQCmemx1fQzfVoYR24MqNTkwUtyjyG
pjdDfB4dTr/KtyrMZEEHUao/aG4Tx9NQXLpoaq+hfghpuCqrjDB3d1A8HYHc
Y5pTQ9Q/IR0Rw96aR6PcXz1umIZ/zb+l+yLooaotEGtmeB4GjLfZbmMdWTDA
Nm2yFB3n+WVgpaw6rnSQ5itk4HVw7WBtHs97PxoTjXOxSy7NH4Ew6rE=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 52.}, {0, 0.07597784082629506}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5128975507978516`*^9, 3.513045681770508*^9, 3.5130464577402344`*^9, 
   3.5130599554404297`*^9, 3.513069417745117*^9, 3.513069553791992*^9, 
   3.5130716621054688`*^9, 3.5130720337460938`*^9, 3.5130824333789062`*^9, 
   3.513086298758789*^9, {3.513145917375*^9, 3.513145940171875*^9}, 
   3.513146259328125*^9, {3.513158632491211*^9, 3.5131586511689453`*^9}, 
   3.513158695341797*^9, 3.513166154473633*^9, 3.513393888740139*^9, 
   3.5133949173159704`*^9, 3.513404558386408*^9},
 CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
 "The mended values at positions ",
 StyleBox["20 ",
  FontSlant->"Italic"],
 "through ",
 StyleBox["25",
  FontSlant->"Italic"],
 " are given by the trend:"
}], "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.512817267850586*^9, 3.512817324569336*^9}, {
  3.512817356147461*^9, 3.512817377225586*^9}, {3.512835424798828*^9, 
  3.512835490798828*^9}, {3.513158775373047*^9, 3.513158846734375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"zf", ",", "z"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.5131586188710938`*^9, 3.513158622576172*^9}},
 CellLabel->"In[11]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw10gtIU2EUB/ARPVagq8xN0h6KhJPho9lzuf11081mGEpZywQtkYIeuqGE
IpeEYROy5ipEaGnmeqjLuaA5hCLTpDBNhAIVy3AWmhkJCdGLzvngcvndcznf
+c75IgvPZRctE4lESX+ff+//66vmyU9/q2hzk4Y+oNL3osXobiaLoW5InJKh
hbwW815lzuP+O+QNuHZBMhKe4CKHoVwepxi13CVHICaw0amvu0feCumZb/ID
5++To5AWrp9y/WZHQ/p5wr5G9YC8DSpjT1h9FDsGy7Ps6jof/x+LyckSaWEo
W4GO1jG9P4v3i8NZd7+98hLXk4DW/MPjlmmuNxGf+iROj5W9HUU/1k+4q9hK
eEfifeJ37CTIK27KB+ycbweelzuiAw28305Ys/XOI2Nczy6YHbOXQwxt5N2o
7/PNBL1sJ+/BbMnHpuQcN3kv+iTDuZnFD8kqJCsc1bbQTvI+iHuWQp51sZOh
lMWv6NV6yGo0vs8r73rK1qDzqLtCF9lFBq5/MK2OPkQWgKpVbYtfDnI8BVsc
Jy6WSTmegt5g28kFL+dLxULUrbHvKrKQCmemx1fQzfVoYR24MqNTkwUtyjyG
pjdDfB4dTr/KtyrMZEEHUao/aG4Tx9NQXLpoaq+hfghpuCqrjDB3d1A8HYHc
Y5pTQ9Q/IR0Rw96aR6PcXz1umIZ/zb+l+yLooaotEGtmeB4GjLfZbmMdWTDA
Nm2yFB3n+WVgpaw6rnSQ5itk4HVw7WBtHs97PxoTjXOxSy7NH4Ew6rE=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7Het2nmq9s0Ce6iAw6nuwMrMX/OgfA4H1pd/
PjBwwfgCDnmM6voHVq+B8kUcdop6x3SFLoPyJRy+VfBamssvhfJlHG5M5tf9
yAiTV3Ao+cljqNm4EcpXcqir84qu/bgayldxqLzvc+tgJcx8NQfGgvvrCyVh
6jUcYlW451amw+S1HIQ+vFr8+QmMr+OwbM1Xw7iSVVC+nkMh347YQKHlUL6B
Q3L+1gkVCYuhfEOHNwaKLixrYHwjhz1LzuglGi2C8o0dpN5pa+R/WQjlmzhU
Vc3TPDlpBZRv6qBePkXl+cyVUL6Zw41A9/kRd2D2mzuUTH7TJ+wBc5+Fw5aj
O1/wnl4L5Vs6HCp4stA2eD2Ub+Vwv21Z5MRNm6F8awc39f9ym1g2Qfk2Dvzp
3i5Jf9ZB+bYOd85qhy55CzPPzmHz7O6gwGiYenuHdgZ52+91MPMcHOpFj6TN
e7gDwm9wcNj2fMPf/h4on8HRQU026G+KNVR9g6ODeJW6cGkezDwnB+UL4rUG
L6Hx0eDkIH7gvVXZapj7nR10eRb8Y9GD+rfB2aHunEUG1w9YeLg4pHzZazpz
J0zexSG+Jv6kGzw9uDqIuhTlyJjC7Hd1aLdiKmzZAJN3c5C4v3YTlybUvgY3
h7K51obBK2Hh6+4g45iusXwxND01uDvs+hx+vd0NFj8eDhdzpfaLwdJDg4dD
QWDgC8bZsPTq6VA644+ttDE0vTZ4Onj7Cs/yioXFt5fD0X/WuQFL19oDAAhs
4bg=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 52.}, {0, 0.097192669}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5131586251464844`*^9, 3.513158704026367*^9, 
  3.513166154520508*^9, 3.513393888860146*^9, 3.5133949173589725`*^9, 
  3.513404558453412*^9},
 CellLabel->"Out[11]="]
}, Open  ]],

Cell[TextData[{
 "Here we have the original time series (blue). We introduce a structural \
break of",
 StyleBox[" +.01",
  FontSlant->"Italic"],
 " at ",
 StyleBox["t=20 ",
  FontSlant->"Italic"],
 "(red) and correct for it (green). In this example, the structural break is \
over-corrected:"
}], "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{
  3.512835618642578*^9, {3.512895243473633*^9, 3.512895311973633*^9}, {
   3.512895900864258*^9, 3.512895901692383*^9}, {3.513144669171875*^9, 
   3.513144803828125*^9}, {3.513144870234375*^9, 3.513144892015625*^9}, 
   3.513145025359375*^9, {3.513158939583008*^9, 3.5131589597773438`*^9}, {
   3.513166176879883*^9, 3.513166177254883*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", 
    RowBox[{"[", 
     RowBox[{"20", ";;", 
      RowBox[{"Length", "[", "x", "]"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"[", 
      RowBox[{"20", ";;", 
       RowBox[{"Length", "[", "x", "]"}]}], "]"}], "]"}], "+", ".1"}]}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"breaks", ",", "gaps"}], "}"}]}], "}"}], "=", 
   RowBox[{"Mend", "[", 
    RowBox[{"y", ",", "100", ",", 
     RowBox[{"{", "20", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.512895327176758*^9, 3.512895410973633*^9}, {
   3.512895575536133*^9, 3.512895599192383*^9}, {3.512895632379883*^9, 
   3.512895643317383*^9}, {3.512895833817383*^9, 3.512895891520508*^9}, 
   3.512896294864258*^9, {3.513045474879883*^9, 3.513045492020508*^9}, {
   3.513045714754883*^9, 3.513045729348633*^9}, 3.513045767973633*^9, {
   3.513144808078125*^9, 3.513144859375*^9}, {3.5131449174375*^9, 
   3.513144945140625*^9}, {3.513144978296875*^9, 3.51314510490625*^9}, {
   3.513158921654297*^9, 3.5131589268935547`*^9}, {3.513166135239258*^9, 
   3.513166141004883*^9}},
 CellLabel->"In[12]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7Het2nmq9s0Ce6iAw6nuwMrMX/OgfA4H1pd/
PjBwwfgCDnmM6voHVq+B8kUcdop6x3SFLoPyJRy+VfBamssvhfJlHG5M5tf9
yAiTV3Ao+cljqNm4EcpXcqir84qu/bgayldxqLzvc+tgJcx8NQfGgvvrCyVh
6jUcYlW451amw+S1HIQ+vFr8+QmMr+OwbM1Xw7iSVVC+nkMh347YQKHlUL6B
Q3L+1gkVCYuhfEOHNwaKLixrYHwjhz1LzuglGi2C8o0dpN5pa+R/WQjlmziE
XOafebt1JZRv6nA7b+Ks4xXroHwzB73zk5492ABzj7lDxcbOP1O/rYDyLRxO
v9r7O+oMTN7SoVnlusP/NVuhfCuH+23LIidu2gzlWzu4qf+X28SyCcq3ceBP
93ZJ+gOzz9bhzlnt0CVv10L5dg6bZ3cHBUbD1Ns7tDPI236vg5nn4FAveiRt
3sMdEH6Dg8O25xv+9vdA+QyODmqyQX9TrKHqGxwdxKvUhUvzYOY5OShfEK81
eAmNjwYnB/ED763KVq+Hyjs76PIs+MeiB/Vfg7ND3TmLDK4fsPhwcUj5std0
5k6YvItDfE38STd4enB1EHUpypExhdnv6tBuxVTYsgEm7+YgcX/tJi5NqH0N
bg5lc60Ng1fCwtPdQcYxXWP5Ymh6anB32PU5/Hq7Gyy+PBwu5krtF4OlhwYP
h4LAwBeMs2Hp1dOhdMYfW2ljaHpt8HTw9hWe5RULiz8vh6P/rHMDlq61BwA+
/+WZ
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7Het2nmq9s0Ce6iAw6nuwMrMX/OgfA4H1pd/
PjBwwfgCDnmM6voHVq+B8kUcdop6x3SFLoPyJRy+VfBamssvhfJlHG5M5tf9
yAiTV3Ao+cljqNm4EcpXcqir84qu/bgayldxqLzvc+tgJcx8NQfGgvvrCyVh
6jUcYlW451amw+S1HIQ+vFr8+QmMr+OwbM1Xw7iSVVC+nkMh347YQKHlUL6B
Q3L+1gkVCYuhfEOHNwaKLixrYHwjhz1LzuglGi2C8o0dpN5pa+R/WQjlmzgs
Oiiw2VnvMJRv6tCiUbj5X9YRKN/MYUZDIRvrT5i8uYO25XvvIi4Y38KhwX1P
9+P/ML6lA1+8Ra7P4uNQvpWDjcCCStFlx6B8a4eCBJ87quePQvk2DhOX3Y99
2g2zz9bB5YD4I1MPGN/OYdksobLSXzD19g4CvjHZHj0w8xwceq7rMcyxPQnh
Nzg4rHBYelpEGMpncHRIuF3qXZ8FVd/g6HCjMyGMnQWm38nh3pYI7tSDUPMb
nBwu7+mIXrUdZr+zw43zJTx+N6D+a3B2yGG4nXa+C+ZfF4dnnjZSxr9h8i4O
f7pqDAt6Ye51dbjxjpU5Oh1mv6uDwCtfVv6lMHk3h8kuFZX806H2Nbg5aG2R
nqn4HWa+u4PI3GfTtm2Fme/usOfkokN5cjB5DwfHjMk1QRMPQeU9HDQVH7r1
GkP5DJ4Orz55z5kcCZP3dFBYEFgs/wQm7+VQd0b6hYLZEXsAz5rkaw==
     "]]}, 
   {Hue[0.1421359549995791, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7Het2nmq9s0Ce6iAw6nuwMrMX/OgfA4H1pd/
PjBwwfgCDnmM6voHVq+B8kUcdop6x3SFLoPyJRy+VfBamssvhfJlHG5M5tf9
yAiTV3Ao+cljqNm4EcpXcqir84qu/bgayldxqLzvc+tgJcx8NQfGgvvrCyVh
6jUcYlW451amw+S1HIQ+vFr8+QmMr+OwbM1Xw7iSVVC+nkMh347YQKHlUL6B
Q3L+1gkVCYuhfEOHNwaKLixrYHwjhz1LzuglGi2C8o0dpN5pa+R/WQjlmziU
LLr7agY8vEwd/tjGv2m5D/OvmYPPvASLeeJLoHxzhxkN4X7BsTD1Fg5vdnb7
ShjD5C0dhHj2vYxNgPnPyuHOHSnWB6fXQfnWDmtkz/QrFsDCx8bBwExymnwy
LDxtHf7M+bksMQRmv51DC9vTb/GysPCwd9C5wH1mdQrMPAcHvr+r+P9O2QLh
Nzg4uJ2fvuydPZTP4OiQw1nk0353LVTe0cHnsEzFcmeYeU4OKfl/veUsoe5p
cHKw6N/bYwwPX2cHn9u5AYemQMOzwdlhzly2XcfjYOHp4tByuLs9TAHq/wYX
hzvHe554ZcLiy9XBJ3yT1rcLMPtdHXRcLhkfOw6Td3OwWFfNcqIf6v8GN4cp
OZzNAgKw8HR3sBEwrUrhgtnv7nDnkKqm61pY+Hs4PKi8oLji4xyovIeDgqNd
SR3zLKi8p4PG+SnyG41nQ+U9HW5YHLrO3zEfKu/l8OQs535enqX2ANW24lg=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 52.}, {0, 0.197192669}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.513045769348633*^9, 3.5130464715996094`*^9, 3.5130599739091797`*^9, 
   3.513069418979492*^9, 3.513069554073242*^9, 3.5130716626367188`*^9, 
   3.5130720340117188`*^9, 3.5130824336914062`*^9, 3.513086316571289*^9, 
   3.513144896625*^9, 3.51314494946875*^9, {3.51314498046875*^9, 
   3.513145059921875*^9}, {3.513145098734375*^9, 3.513145105921875*^9}, 
   3.5131585197197266`*^9, 3.5131589282958984`*^9, {3.513166144692383*^9, 
   3.513166154770508*^9}, 3.5133938902012224`*^9, 3.513394918130017*^9, 
   3.5134045585334167`*^9},
 CellLabel->"Out[14]="]
}, Open  ]],

Cell["You can have several break points:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.512896265864258*^9, 3.512896287317383*^9}, {
  3.5130825385976562`*^9, 3.5130825442070312`*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"{", 
      RowBox[{"breaks", ",", "gaps"}], "}"}]}], "}"}], "=", 
   RowBox[{"Mend", "[", 
    RowBox[{"x", ",", "100", ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "23", ",", "31", ",", "34"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.512896311411133*^9, 3.512896412676758*^9}, {
  3.513045508395508*^9, 3.513045528520508*^9}, {3.513045692567383*^9, 
  3.513045700348633*^9}},
 CellLabel->"In[15]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7Het2nmq9s0Ce6iAw6nuwMrMX/OgfA4H1pd/
PjBwwfgCDnmM6voHVq+B8kUcdop6x3SFLoPyJRy+VfBamssvhfJlHG5M5tf9
yAiTV3Ao+cljqNm4EcpXcqir84qu/bgayldxqLzvc+tgJcx8NQfGgvvrCyVh
6jUcYlW451amw+S1HIQ+vFr8+QmMr+OwbM1Xw7iSVVC+nkMh347YQKHlUL6B
Q3L+1gkVCYuhfEOHNwaKLixrYHwjhz1LzuglGi2C8o0dpN5pa+R/WQjlmziE
XOafebt1JZRv6nA7b+Ks4xXroHwzB73zk5492ABzj7lDxcbOP1O/rYDyLRxO
v9r7O+oMTN7SoVnlusP/NVuhfCuH+23LIidu2gzlWzu4qf+X28SyCcq3ceBP
93ZJ+gOzz9bhzlnt0CVv10L5dg6bZ3cHBUbD1Ns7tDPI236vg5nn4FAveiRt
3sMdEH6Dg8O25xv+9vdA+QyODmqyQX9TrKHqGxwdxKvUhUvzYOY5OShfEK81
eAmNjwYnB/ED763KVq+Hyjs76PIs+MeiB/Vfg7ND3TmLDK4fsPhwcUj5std0
5k6YvItDfE38STd4enB1EHUpypExhdnv6tBuxVTYsgEm7+YgcX/tJi5NqH0N
bg5lc60Ng1fCwtPdQcYxXWP5Ymh6anB32PU5/Hq7Gyy+PBwu5krtF4OlhwYP
h4LAwBeMs2Hp1dOhdMYfW2ljaHpt8HTw9hWe5RULiz8vh6P/rHMDlq61BwA+
/+WZ
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7Het2nmq9s0Ce6iAw6nuwMrMX/OgfA4H1pd/
PjBwwfgCDnmM6voHVq+B8kUcdop6x3SFLoPyJRy+VfBamssvhfJlHG5M5tf9
yAiTV3Ao+cljqNm4EcpXcqir84qu/bgayldxqLzvc+tgJcx8NQfGgvvrCyVh
6jUcbHnEAme+g/G1HMQ/tYaE6W6C8nUcEgO6Z3N/3QDl6zn0Md1M4upYB+Ub
ODQkX5tqeG0VlG/owKHq5LlXEWa/kcONGW+NpVashPKNHcwe+ehqZMH4Jg47
kiX8T9XCzDd1qDG86e/wHWa/mcPShze/+gjD+OYON+SCcs8UwMy3cNCJaMuZ
6LYeyrd0MI62rpR6tQ3Kt3Lo38s1ac37LVC+tcO32OTws46boXwbB4tXnVE+
u2H22zrMk/2V9NYYxrdzSL70vitnBky9vYPAjO1F65tg/ndwYHjI8PjfYqj5
DQ4O5pvfVn7wg9nn6LB1+ZTomd4weUeHZSxZhSvrYOY5OWyKirqd8hPqvwYn
h9lZu6rfP4XZ7+zgo6i6O9cPal+Ds8Ocx3tViiXWQuVdHJo4nT8x3oLJuzi8
Y1ukXj0RFl6uDkvObTkV4Aqz39VB7KjL+R0HYPJuDtJVM7fvXAK1r8HNYcqm
A293n4T5z93BKuzNE/4jUPsa3B1ucNyd/CENFv4eDh+a5lfXG0Hjs8HDoS/t
2pKs3cuh8p4OU9Y2/moOXgGV93TISpoRtrkWll68HJ4IH9TceXS9PQCqVezb

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 52.}, {0, 0.097192669}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5128975512978516`*^9, 3.513045703645508*^9, 3.513045775754883*^9, 
   3.5130464782246094`*^9, 3.5130599780498047`*^9, 3.513069419338867*^9, 
   3.513069554416992*^9, 3.5130716630742188`*^9, 3.5130720342617188`*^9, 
   3.5130824340976562`*^9, 3.513086324399414*^9, {3.513158531397461*^9, 
   3.513158553080078*^9}, 3.5131589674404297`*^9, 3.513166155036133*^9, 
   3.513393890561243*^9, 3.5133949186330457`*^9, 3.5134045586134205`*^9},
 CellLabel->"Out[16]="]
}, Open  ]],

Cell["You can have a gap and a break at the same point in time:", \
"MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.512896476567383*^9, 3.512896479551758*^9}, {
  3.5130465207714844`*^9, 3.5130465312089844`*^9}, {3.513086337024414*^9, 
  3.513086340586914*^9}, {3.513158975944336*^9, 3.5131589776464844`*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", 
    RowBox[{"[", "32", "]"}], "]"}], "=", "Null"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"breaks", ",", "gaps"}], "}"}]}], "}"}], "=", 
   RowBox[{"Mend", "[", 
    RowBox[{"y", ",", "100", ",", 
     RowBox[{"{", "32", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "z"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.512896531161133*^9, {3.513045545411133*^9, 3.513045562411133*^9}, {
   3.513045793848633*^9, 3.513045800411133*^9}, {3.5131589874257812`*^9, 
   3.5131590076210938`*^9}},
 CellLabel->"In[17]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7Het2nmq9s0Ce6iAw6nuwMrMX/OgfA4H1pd/
PjBwwfgCDnmM6voHVq+B8kUcdop6x3SFLoPyJRy+VfBamssvhfJlHG5M5tf9
yAiTV3Ao+cljqNm4EcpXcqir84qu/bgayldxqLzvc+tgJcx8NQfGgvvrCyVh
6jUcYlW451amw+S1HIQ+vFr8+QmMr+OwbM1Xw7iSVVC+nkMh347YQKHlUL6B
Q3L+1gkVCYuhfEOHNwaKLixrYHwjhz1LzuglGi2C8o0dpN5pa+R/WQjlmziE
XOafebt1JZRv6nA7b+Ks4xXroHwzB73zk5492ABzj7lDxcbOP1O/rYDyLRxO
v9r7O+oMTN7SoVnlusP/NVuhfCuH+23LIidu2gzlWzu4qf+X28SyCcq3ceBP
93ZJ+gOzz9bhzlnt0CVv10L5dg6bZ3cHBUbD1Ns7tDPI236vg5nn4FAveiRt
3sMdEH6Dg8O25xv+9vdA+QyODmqyQX9TrKHqGxwdxKvUhUvzYOY5OShfEK81
eAmNjwYnB/ED763KVq+Hyjs76PIs+MeiB/Vfg7ND3TmLDK4fsPhwcUj5std0
5k6YvItDfE38STd4enB1EHUpypExhdnv6tBuxVTYsgEm7+YgcX/tJi5NqH0N
bg5lc60Ng1fCwtPdQcYxXWP5Ymh6anB32PU5/Hq7Gyy+PBwu5krtF4OlhwYP
h4LAwBeMs2Hp1dOhdMYfW2ljaHpt8HTw9hWe5RULiz8vh6P/rHMDlq61BwA+
/+WZ
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7Het2nmq9s0Ce6iAw6nuwMrMX/OgfA4H1pd/
PjBwwfgCDnmM6voHVq+B8kUcdop6x3SFLoPyJRy+VfBamssvhfJlHG5M5tf9
yAiTV3Ao+cljqNm4EcpXcqir84qu/bgayldxqLzvc+tgJcx8NQfGgvvrCyVh
6jUcYlW451amw+S1HIQ+vFr8+QmMr+OwbM1Xw7iSVVC+nkMh347YQKHlUL6B
Q3L+1gkVCYuhfEOHNwaKLixrYHwjhz1LzuglGi2C8o0dpN5pa+R/WQjlmziE
XOafebt1JZRv6nA7b+Ks4xXroHwzB73zk5492ABzj7lDxcbOP1O/rYDyLRxO
v9r7O+oMTN7SoVnlusP/NVuhfCuH+23LIidu2gzlWzu4qf+X28SyCcq3ceBP
93ZJ+gOzz9bhzlnt0CVv10L5dg6bZ3cHBUbD1Ns7tDPI236vg5nn4LD89Nmi
xF5oeDY4OCz9OO3SDOVtUHlHB1F1i0u5lzZA5R0d2Fp4X9SyQvkMTg4qW34v
LmJYD5V3cvh6efeT9puw8HZ24FbIWSEWAw3vBmeHmEcsQjJqsPh3cXDi6Lq/
6jlM3sVhDk+3zXwDmH9cHVj8IhxVz8Dsd3V403GhW6ofJu/m8O1TZYxMONS+
BjeHkI3st1Ouw+LX3eFXiPGlHReh9jW4O8xgV2mcWbIEKu/hsL7xWYaGAzR+
Gzwc/FJlJwmfhKV/T4fgNSee6yRC47vB00Ez8b5zTDcsfXg5LBbiEE+6vMIe
ACPW6D4=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 52.}, {0, 0.097192669}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.513045802942383*^9, 3.5130464922402344`*^9, 
  3.5130599887216797`*^9, 3.513069420385742*^9, 3.513069554666992*^9, 
  3.5130716643867188`*^9, 3.5130720346835938`*^9, 3.5130824351289062`*^9, 
  3.513086344446289*^9, 3.5131590098564453`*^9, 3.513166155270508*^9, 
  3.5133938909172635`*^9, 3.5133949189120617`*^9, 3.513404558707426*^9},
 CellLabel->"Out[20]="]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.512817002100586*^9, 3.512817003741211*^9}, {
   3.513061450263672*^9, 3.513061464326172*^9}, {3.513061512169922*^9, 
   3.513061513138672*^9}, 3.513061618669922*^9, {3.5131590223027344`*^9, 
   3.5131590334335938`*^9}}],

Cell[TextData[StyleBox["Too few data and too many gaps produce sundry error \
messages\n", "SmallText",
 FontFamily->"Times New Roman",
 FontSize->12]], "MathCaption",
 CellChangeTimes->{{3.513061390038086*^9, 3.513061390506836*^9}, {
   3.513061490498047*^9, 3.513061501904297*^9}, 3.513061652044922*^9, {
   3.5130717717148438`*^9, 3.5130718133085938`*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "0.033054286", ",", "0.030252121", ",", "0.029335036", ",", ",", 
     "0.043621372"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Mend", "[", 
   RowBox[{"y", ",", "100", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.513048953291992*^9, 3.513049011088867*^9}, {
  3.513049045682617*^9, 3.513049131198242*^9}, {3.513049161979492*^9, 
  3.513049190354492*^9}, {3.513049277104492*^9, 3.513049282370117*^9}, {
  3.5130718462617188`*^9, 3.5130718486679688`*^9}, {3.513159042607422*^9, 
  3.5131590983515625`*^9}},
 CellLabel->"In[21]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Inverse", "::", "sing"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Matrix \[NoBreak]\\!\\({\\(\\({0.2987125520924959`, \
\\(\\(-0.0015782691140304728`\\)\\), 0.3002908212065264`}\\)\\), \
\\(\\({\\(\\(-0.0015782691140306948`\\)\\), \\(\\(\[LeftSkeleton] 20 \
\[RightSkeleton]\\)\\), \\(\\(-0.39801937275092725`\\)\\)}\\)\\), \
\\(\\({0.3002908212065266`, \\(\\(-0.398019372750927`\\)\\), \
0.6983101939574536`}\\)\\)}\\)\[NoBreak] is singular. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/sing\\\", ButtonNote -> \
\\\"Inverse::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.513159089524414*^9, 3.5131590996123047`*^9}, 
   3.513166155364258*^9, 3.5133938915262985`*^9, 3.5133949192250795`*^9, 
   3.5134045588844366`*^9},
 CellLabel->"During evaluation of In[21]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Inverse", "::", "sing"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Matrix \[NoBreak]\\!\\({\\(\\({0.2987125520924959`, \
\\(\\(-0.0015782691140304728`\\)\\), 0.3002908212065264`}\\)\\), \
\\(\\({\\(\\(-0.0015782691140306948`\\)\\), \\(\\(\[LeftSkeleton] 20 \
\[RightSkeleton]\\)\\), \\(\\(-0.39801937275092725`\\)\\)}\\)\\), \
\\(\\({0.3002908212065266`, \\(\\(-0.398019372750927`\\)\\), \
0.6983101939574536`}\\)\\)}\\)\[NoBreak] is singular. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/sing\\\", ButtonNote -> \
\\\"Inverse::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.513159089524414*^9, 3.5131590996123047`*^9}, 
   3.513166155364258*^9, 3.5133938915262985`*^9, 3.5133949192250795`*^9, 
   3.513404558893437*^9},
 CellLabel->"During evaluation of In[21]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Mend", "::", "singular"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Singularity encountered, probably due to an overlap or bad \
combination of undefined data points and breaks.\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.513159089524414*^9, 3.5131590996123047`*^9}, 
   3.513166155364258*^9, 3.5133938915262985`*^9, 3.5133949192250795`*^9, 
   3.513404559051446*^9},
 CellLabel->"During evaluation of In[21]:="]
}, Open  ]],

Cell["\<\

\
\>", "Text",
 CellChangeTimes->{{3.512817002100586*^9, 3.512817003741211*^9}, {
   3.513061450263672*^9, 3.513061464326172*^9}, {3.513061512169922*^9, 
   3.513061513138672*^9}, 3.513061618669922*^9}],

Cell[TextData[StyleBox["Bad combinations of breaks and gaps may lead to \
similar error messages:", "SmallText",
 FontFamily->"Times New Roman",
 FontSize->12]], "MathCaption",
 CellChangeTimes->{{3.513061390038086*^9, 3.513061390506836*^9}, {
   3.513061490498047*^9, 3.513061501904297*^9}, 3.513061652044922*^9},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "3"}], "]"}], "]"}], "=", "Null"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Mend", "[", 
   RowBox[{"y", ",", "100", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.513049380260742*^9, 3.513049574573242*^9}, {
  3.5130718539335938`*^9, 3.5130718604492188`*^9}, {3.5131591089746094`*^9, 
  3.5131591175908203`*^9}},
 CellLabel->"In[23]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Inverse", "::", "luc"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Result for \[NoBreak]\\!\\(Inverse\\)\[NoBreak] of badly \
conditioned matrix \[NoBreak]\\!\\({\\(\\({\\(\\(-4.4524661260984984`*^-13\\)\
\\), \\(\\(-4.362167467248778`*^-13\\)\\), \\(\\(-4.2595040755449235`*^-13\\)\
\\), \\(\\(-9.029865884972038`*^-15\\)\\), \\(\\(-1.0266339170385448`*^-14\\)\
\\), \\(\\(-1.15534468148363`*^-14\\)\\)}\\)\\), \\(\\(\[LeftSkeleton] 4 \
\[RightSkeleton]\\)\\), \\(\\({\\(\\(\[LeftSkeleton] 23 \
\[RightSkeleton]\\)\\), \\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\), \
\\(\\(\[LeftSkeleton] 19 \[RightSkeleton]\\)\\)}\\)\\)}\\)\[NoBreak] may \
contain significant numerical errors. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/luc\\\", ButtonNote -> \
\\\"Inverse::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.513049469495117*^9, {3.513049509432617*^9, 3.513049522010742*^9}, {
   3.513049553495117*^9, 3.513049575807617*^9}, 3.5130600079541016`*^9, 
   3.513069421338867*^9, 3.513069555088867*^9, 3.5130716655898438`*^9, 
   3.5130718682460938`*^9, 3.5130720351367188`*^9, 3.5130824361132812`*^9, 
   3.513086363524414*^9, 3.5131591215703125`*^9, 3.513166155645508*^9, 
   3.5133938921073313`*^9, 3.513394919899118*^9, 3.5134045591924543`*^9},
 CellLabel->"During evaluation of In[23]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Mend", "::", "singular"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Singularity encountered, probably due to an overlap or bad \
combination of undefined data points and breaks.\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.513049469495117*^9, {3.513049509432617*^9, 3.513049522010742*^9}, {
   3.513049553495117*^9, 3.513049575807617*^9}, 3.5130600079541016`*^9, 
   3.513069421338867*^9, 3.513069555088867*^9, 3.5130716655898438`*^9, 
   3.5130718682460938`*^9, 3.5130720351367188`*^9, 3.5130824361132812`*^9, 
   3.513086363524414*^9, 3.5131591215703125`*^9, 3.513166155645508*^9, 
   3.5133938921073313`*^9, 3.513394919899118*^9, 3.513404559201454*^9},
 CellLabel->"During evaluation of In[23]:="]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.512813835482422*^9, 3.512813958826172*^9}, {
  3.512813996201172*^9, 3.512814035873047*^9}, {3.51281442496875*^9, 
  3.512814461015625*^9}, {3.512814524828125*^9, 3.51281500971875*^9}, {
  3.5128150440625*^9, 3.51281519390625*^9}, {3.512815231171875*^9, 
  3.5128152480625*^9}, {3.512835273236328*^9, 3.512835374455078*^9}, {
  3.5130601853134766`*^9, 3.5130602112666016`*^9}},
 CellTags->"b:0"],

Cell["", "Text",
 CellChangeTimes->{{3.512813835482422*^9, 3.512813958826172*^9}, {
  3.512813996201172*^9, 3.512814035873047*^9}, {3.51281442496875*^9, 
  3.512814461015625*^9}, {3.512814524828125*^9, 3.51281500971875*^9}, {
  3.5128150440625*^9, 3.51281519390625*^9}, {3.512815231171875*^9, 
  3.5128152480625*^9}, {3.512835273236328*^9, 3.512835374455078*^9}, {
  3.5130601853134766`*^9, 3.5130602411884766`*^9}},
 CellTags->"b:0"],

Cell[TextData[{
 StyleBox["GuessBreak[x,\[Alpha]]  returns a number that indicates the \
position of a possible structural break. It requires as an input the time \
series and the smoothing parameter ",
  FontSlant->"Italic"],
 "\[Alpha], ",
 StyleBox["as in Mend[ ] above.",
  FontSlant->"Italic"]
}], "DefinitionBox",
 CellChangeTimes->{{3.512814070294922*^9, 3.5128144155625*^9}, {
  3.512815262953125*^9, 3.5128153434375*^9}, {3.5128153756875*^9, 
  3.51281544146875*^9}, {3.5128154826875*^9, 3.51281599325*^9}, {
  3.51281603021875*^9, 3.5128162543125*^9}, {3.51281629165625*^9, 
  3.512816311171875*^9}, {3.512816354109375*^9, 3.512816652875*^9}, {
  3.512816693125*^9, 3.512816891194336*^9}, {3.512894255004883*^9, 
  3.512894378239258*^9}, {3.512894452192383*^9, 3.512894825567383*^9}, {
  3.512894864864258*^9, 3.512894915708008*^9}, {3.512894948895508*^9, 
  3.512895169067383*^9}, {3.5130602570634766`*^9, 3.5130603953603516`*^9}, {
  3.5130605148759766`*^9, 3.5130605994541016`*^9}},
 CellTags->{"i:1", "b:0"}],

Cell["\<\

\
\>", "Text",
 CellChangeTimes->{{3.512817002100586*^9, 3.512817003741211*^9}, {
   3.513061450263672*^9, 3.513061464326172*^9}, {3.513061512169922*^9, 
   3.513061513138672*^9}, 3.513061618669922*^9}],

Cell[TextData[{
 "We introduce a break of",
 StyleBox[" +.01 ",
  FontSlant->"Italic"],
 "at",
 StyleBox[" t=20 ",
  FontSlant->"Italic"],
 "and guess it:"
}], "MathCaption",
 CellChangeTimes->{{3.513061390038086*^9, 3.513061390506836*^9}, {
  3.513061490498047*^9, 3.513061501904297*^9}, {3.5131591798222656`*^9, 
  3.5131592609873047`*^9}, {3.5131592911347656`*^9, 3.5131592983916016`*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", 
    RowBox[{"[", 
     RowBox[{"20", ";;", 
      RowBox[{"Length", "[", "x", "]"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"[", 
      RowBox[{"20", ";;", 
       RowBox[{"Length", "[", "x", "]"}]}], "]"}], "]"}], "+", ".1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GuessBreak", "[", "y", "]"}]}], "Input",
 CellChangeTimes->{{3.5126125039725475`*^9, 3.5126125324981794`*^9}, 
   3.512613129555329*^9, {3.512816923053711*^9, 3.512816923834961*^9}, {
   3.513061541685547*^9, 3.513061556216797*^9}, {3.5131592508671875`*^9, 
   3.5131592550429688`*^9}, {3.5131593077773438`*^9, 3.5131593310029297`*^9}, 
   3.513159408330078*^9},
 CellTags->"b:0",
 CellLabel->"In[26]:="],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{3.513159401669922*^9, 3.5131594378583984`*^9, 
  3.5131595227558594`*^9, 3.51315960528125*^9, 3.513159735618164*^9, 
  3.5131608209677734`*^9, 3.513166173661133*^9, 3.513393921722026*^9, 
  3.5133949499188347`*^9, 3.513404560031502*^9},
 CellTags->"b:0",
 CellLabel->"Out[28]="]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.512813835482422*^9, 3.512813958826172*^9}, {
  3.512813996201172*^9, 3.512814035873047*^9}, {3.51281442496875*^9, 
  3.512814461015625*^9}, {3.512814524828125*^9, 3.51281500971875*^9}, {
  3.5128150440625*^9, 3.51281519390625*^9}, {3.512815231171875*^9, 
  3.5128152480625*^9}, {3.512835273236328*^9, 3.512835374455078*^9}, {
  3.513061807060547*^9, 3.513061842591797*^9}},
 CellTags->"b:0"],

Cell[TextData[{
 StyleBox["Criterion[x,\[Alpha]] mends possible gaps in the time series x and \
returns the value of the criterion that underlies the mending procedure.  It \
requires as an input the time series and the smoothing parameter ",
  FontSlant->"Italic"],
 "\[Alpha], ",
 StyleBox["as in Mend[ ] above.\n\nFor the definition and interpretation of \
the criterion, see Schlicht ",
  FontSlant->"Italic"],
 "(2008)",
 StyleBox[", equation 2.6.",
  FontSlant->"Italic"]
}], "DefinitionBox",
 CellChangeTimes->{{3.512814070294922*^9, 3.5128144155625*^9}, {
  3.512815262953125*^9, 3.5128153434375*^9}, {3.5128153756875*^9, 
  3.51281544146875*^9}, {3.5128154826875*^9, 3.51281599325*^9}, {
  3.51281603021875*^9, 3.5128162543125*^9}, {3.51281629165625*^9, 
  3.512816311171875*^9}, {3.512816354109375*^9, 3.512816652875*^9}, {
  3.512816693125*^9, 3.512816891194336*^9}, {3.512894255004883*^9, 
  3.512894378239258*^9}, {3.512894452192383*^9, 3.512894825567383*^9}, {
  3.512894864864258*^9, 3.512894915708008*^9}, {3.512894948895508*^9, 
  3.512895169067383*^9}, {3.513062264669922*^9, 3.513062473498047*^9}, {
  3.5130720908867188`*^9, 3.5130721036992188`*^9}},
 CellTags->{"i:1", "b:0"}],

Cell["", "Text",
 CellChangeTimes->{{3.512817002100586*^9, 3.512817003741211*^9}}],

Cell["Call the criterion:", "MathCaption",
 CellChangeTimes->{{3.513062497044922*^9, 3.513062503607422*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Criterion", "[", 
  RowBox[{"x", ",", "100"}], "]"}]], "Input",
 CellChangeTimes->{{3.5126125039725475`*^9, 3.5126125324981794`*^9}, 
   3.512613129555329*^9, {3.512816923053711*^9, 3.512816923834961*^9}, {
   3.513062507638672*^9, 3.513062523998047*^9}},
 CellTags->"b:0",
 CellLabel->"In[29]:="],

Cell[BoxData["0.00507270303175705`"], "Output",
 CellChangeTimes->{3.513062528451172*^9, 3.513069144154297*^9, 
  3.513069229791992*^9, 3.513069440495117*^9, 3.513069573854492*^9, 
  3.5130716852929688`*^9, 3.5130720538398438`*^9, 3.5130824592851562`*^9, 
  3.513086455336914*^9, 3.513160924076172*^9, 3.513166173989258*^9, 
  3.5133939221790514`*^9, 3.513394950394862*^9, 3.513404560066504*^9},
 CellTags->"b:0",
 CellLabel->"Out[29]="]
}, Open  ]],

Cell[TextData[{
 "You may use the criterion to evaluate different values for filling in gaps \
and breaks.\nThe following depicts how the criterion assumes different values \
for a break  inserted  at subsequent break points",
 StyleBox[" t=2, 3, ...,T. ",
  FontSlant->"Italic"],
 "It can be seen that the criterion is improved (reduced) most pronouncedly \
at",
 StyleBox[" t=15",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellChangeTimes->{{3.512816981241211*^9, 3.512816981788086*^9}, 
   3.512817127538086*^9, {3.512895430723633*^9, 3.512895438442383*^9}, {
   3.512895504020508*^9, 3.512895540379883*^9}, {3.513062541466797*^9, 
   3.513062665716797*^9}, {3.513071155001953*^9, 3.513071313095703*^9}, {
   3.5130721364804688`*^9, 3.5130721503710938`*^9}, {3.5130721822929688`*^9, 
   3.5130722127304688`*^9}, {3.5130722494335938`*^9, 3.5130722602929688`*^9}, 
   3.513086478399414*^9, {3.513086715868164*^9, 3.513086716790039*^9}, {
   3.5131611039941406`*^9, 3.5131612188779297`*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{"Length", "[", "x", "]"}]}], ";", " ", 
    RowBox[{"crit", "=", 
     RowBox[{"{", "Null", " ", "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Do", "[", "\t", "\n", "\t", 
     RowBox[{
      RowBox[{"crit", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"crit", ",", 
         RowBox[{"Criterion", "[", 
          RowBox[{
           RowBox[{"Mend", "[", 
            RowBox[{"x", ",", "100", ",", 
             RowBox[{"{", "k", "}"}]}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ",", "\n", "\t", 
      RowBox[{"{", 
       RowBox[{"k", ",", "2", ",", 
        RowBox[{"T", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"crit", "=", 
     RowBox[{"Append", "[", 
      RowBox[{"crit", ",", "Null"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"{", "crit", "}"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.513062672576172*^9, {3.513062775435547*^9, 3.513062971185547*^9}, {
   3.513063012529297*^9, 3.513063054904297*^9}, {3.513063197310547*^9, 
   3.513063198560547*^9}, {3.513063252904297*^9, 3.513063254998047*^9}, 
   3.513069697713867*^9, {3.513071097455078*^9, 3.513071112845703*^9}, {
   3.513071321658203*^9, 3.513071358267578*^9}, 3.5130717121992188`*^9, {
   3.5130721924960938`*^9, 3.5130722209960938`*^9}, {3.513090398265625*^9, 
   3.513090446765625*^9}, {3.51309047796875*^9, 3.513090490921875*^9}, {
   3.51309053796875*^9, 3.513090541640625*^9}, 3.513126927629883*^9, {
   3.513126974520508*^9, 3.513127018051758*^9}, {3.513127090676758*^9, 
   3.513127149426758*^9}},
 CellLabel->"In[30]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAmIQDQUOvVZOpg+OldhDuBwOf65uMy2aAOMLOMz4mpHM
XVIM5Ys43ImssbHcBZOXcEgJny3EvhrGl3FQWeT72dAUxldwqNjzh6UtHqZf
ySFh+g2r/KMweRUHr8WXMhfC7Vdz+NSzXevpHhhfwyHcOs4vbw1Mv5YDU1A8
2zlLGF/H4dHv5zkp/kVQvp6D5j/twLg3hVC+gcO/4rfPmCfC5A0deKYJLjn2
BabfyEHLxNF81QKYfcYOU9IX9VmvgfFNHNYkH64+0QBTb+rAo/3GW6kSxjdz
KAnwjj7gBlNv7iBxnYHTNRrGt3AQ5nw5aa0/TL2lw/wHZ+Int8LcY+XAxrAz
gHcHTL21w6xeY/mghTC+jYOs2e9jzn0wvq3D4x+Gc5QPwPh2DnbqEv9EtsDM
t3cI/D81uTgSxndwCPs5yy+yGMpvcHB40fdjvsAhmH5Hh3VxT8MLn0Hd0+Do
sKpjSvHKSzD3OTlkz1wu18IA0+/kIHOpz+2xAcx8Z4eNJ381XpeBmtfg7HCu
LW3fcXj8ujj41TKXOrvA5F0c1t5xObk4AKbf1WHOxOxnS5hg8q4Oy8TTN8yB
pwc3B74f517L1cPk3RxutU07tcIVJu/ukPHy8hdXd5i8uwNL199zp71g8h4O
HH8dLz/tgMl7OISLM+YdPwKT93RYnnZPonYOTN7T4bGFX5e8Xok9ANZ21sM=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.00438},
  PlotRange->{{0., 51.}, {0.004375809122165766, 0.005072475254691467}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.51309052403125*^9, 3.51309056315625*^9, 
  3.513126947786133*^9, 3.513127004036133*^9, 3.513127040270508*^9, 
  3.513127170114258*^9, 3.5131609648046875`*^9, 3.513166194614258*^9, 
  3.513393952800803*^9, 3.5133949815926466`*^9, 3.51340456122657*^9},
 CellLabel->"Out[33]="]
}, Open  ]],

Cell["\<\
GuessBreak returns the position of the minimum in this series:\
\>", "MathCaption",
 CellChangeTimes->{{3.512816981241211*^9, 3.512816981788086*^9}, 
   3.512817127538086*^9, {3.512895430723633*^9, 3.512895438442383*^9}, {
   3.512895504020508*^9, 3.512895540379883*^9}, {3.513062541466797*^9, 
   3.513062665716797*^9}, {3.513071155001953*^9, 3.513071313095703*^9}, {
   3.5130721364804688`*^9, 3.5130721503710938`*^9}, {3.5130721822929688`*^9, 
   3.5130722127304688`*^9}, {3.5130722494335938`*^9, 3.5130722602929688`*^9}, 
   3.513086478399414*^9, {3.513086715868164*^9, 3.513086716790039*^9}, {
   3.5131610136914062`*^9, 3.513161039111328*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"GuessBreak", "[", "x", "]"}]}]], "Input",
 CellChangeTimes->{
  3.513062672576172*^9, {3.513062775435547*^9, 3.513062971185547*^9}, {
   3.513063012529297*^9, 3.513063054904297*^9}, {3.513063197310547*^9, 
   3.513063198560547*^9}, {3.513063252904297*^9, 3.513063254998047*^9}, 
   3.513069697713867*^9, {3.513071097455078*^9, 3.513071112845703*^9}, {
   3.513071321658203*^9, 3.513071358267578*^9}, 3.5130717121992188`*^9, {
   3.5130721924960938`*^9, 3.5130722209960938`*^9}, {3.513090398265625*^9, 
   3.513090446765625*^9}, {3.51309047796875*^9, 3.513090490921875*^9}, {
   3.51309053796875*^9, 3.513090541640625*^9}, 3.513126927629883*^9, {
   3.513126974520508*^9, 3.513127018051758*^9}, {3.513127090676758*^9, 
   3.513127149426758*^9}, {3.513161042838867*^9, 3.5131610549501953`*^9}},
 CellLabel->"In[34]:="],

Cell[BoxData["15"], "Output",
 CellChangeTimes->{3.5131610849521484`*^9, 3.513166213067383*^9, 
  3.5133939834045534`*^9, 3.51339501381349*^9, 3.5134045624806423`*^9},
 CellLabel->"Out[34]="]
}, Open  ]],

Cell[TextData[{
 StyleBox["\n\nReferences\nLudsteck, Johannes (2005).: \"HPFilter, a ", 
  "SmallText",
  FontSize->12],
 StyleBox["Mathematica ", "SmallText",
  FontSize->12,
  FontSlant->"Italic"],
 StyleBox["Package", "SmallText",
  FontSize->12],
 StyleBox["\",  \[LineSeparator]", "SmallText",
  FontSize->12,
  FontSlant->"Italic"],
 StyleBox["freely available at", "SmallText",
  FontSize->12],
 StyleBox[" ", "SmallText",
  FontSize->12,
  FontSlant->"Italic"],
 StyleBox["\n", "SmallText",
  FontSize->12],
 StyleBox["http://library.wolfram.com/infocenter/MathSource/5161/",
  FontFamily->"Courier New",
  FontSize->12],
 StyleBox["\n",
  FontSize->12],
 StyleBox["\n", "SmallText"],
 StyleBox["Schlicht, Ekkehart (2005): \[OpenCurlyDoubleQuote]",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["Estimating the Smoothing Parameter in the So-called \n\
Hodrick-Prescott Filter",
  FontSize->12],
 StyleBox["\[CloseCurlyDoubleQuote], \n",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["Journal of the Japan Statistical Society ",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["  \nVol. 35 (2005), No. 1, pages 99-119, \nfreely available at",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox[" \n",
  FontFamily->"Courier New",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["http://www.scipress.org/journals/jjss/pdf/3501/35010099.pdf",
  FontFamily->"Courier New",
  FontSize->12],
 StyleBox["\n\n", "SmallText"],
 StyleBox["Schlicht, Ekkehart (2008): \[OpenCurlyDoubleQuote]Trend Extraction \
from Time Series with Structural Breaks \nand Missing Observations\
\[CloseCurlyDoubleQuote],\n",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["Journal of the Japan Statistical Society ",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["  \nVol. 38 (2008), No. 2, pages 285-292, \nfreely available at",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox[" \nhttp://www.jstage.jst.go.jp/article/jjss/38/2/285/_pdf. ",
  FontFamily->"Courier New",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["\n", "SmallText"],
 "\n",
 StyleBox["Acknowledgement\n",
  FontSize->12],
 "\n",
 StyleBox["I thank Johannes Ludsteck for helping me with expert advice in \
preparing this package. \n",
  FontSize->12],
 "\n",
 StyleBox["\nEkkehart Schlicht,\nDepartment of Economics\nUniversity of \
Munich,\nGermany\nwww.lrz.de/~ekkehart\n\nMay 2011",
  FontSize->10],
 "\n\n"
}], "SmallTextSans",
 PageWidth->WindowWidth,
 CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
 CellSize->{499, Inherited},
 CellChangeTimes->{
  3.512896588708008*^9, {3.5128966280908203`*^9, 3.5128966357314453`*^9}, {
   3.512896800828125*^9, 3.512896934453125*^9}, {3.512896966953125*^9, 
   3.5128970857978516`*^9}, {3.5128971551572266`*^9, 
   3.5128971972041016`*^9}, {3.5128972336884766`*^9, 3.5128972870478516`*^9}, 
   3.5128973417509766`*^9, 3.5128974250322266`*^9, {3.5128974683603516`*^9, 
   3.5128974969228516`*^9}, 3.5128975313916016`*^9, {3.513048800213867*^9, 
   3.513048889885742*^9}, {3.513048938604492*^9, 3.513048942620117*^9}, {
   3.513049239088867*^9, 3.513049265432617*^9}, {3.513049309760742*^9, 
   3.513049356713867*^9}, {3.5130717378710938`*^9, 3.5130717381210938`*^9}, {
   3.513166304473633*^9, 3.513166305083008*^9}, {3.513176508046875*^9, 
   3.513176876765625*^9}, {3.51317693246875*^9, 3.513176934328125*^9}, {
   3.513176973421875*^9, 3.5131770089375*^9}, {3.5131773805966797`*^9, 
   3.5131774035810547`*^9}, {3.5133949849998417`*^9, 3.5133949856148767`*^9}},
 TextJustification->0.,
 CellTags->"b:0"],

Cell["", "SmallTextSans",
 PageWidth->WindowWidth,
 CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
 CellSize->{499, Inherited},
 CellTags->"b:0"],

Cell["", "SmallTextSans",
 PageWidth->WindowWidth,
 CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
 CellSize->{499, Inherited},
 TextAlignment->Left,
 CellTags->"b:0"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1000, 613},
WindowMargins->{{99, Automatic}, {Automatic, 35}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], None, 
   Cell[
    TextData[{"The Season Package for ", 
      StyleBox["Mathematica", FontSlant -> "Italic"], 
      " by Ekkehart Schlicht"}], "PageHeader"]}, {
   Cell[
    TextData[{"The Mend Package for ", 
      StyleBox["Mathematica", FontSlant -> "Italic"], 
      " by Ekkehart Schlicht"}], "PageHeader"], None, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PrintingOptions->{"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{50.375, 50.375}, {54, 36}}},
TaggingRules:>{
 "NextIndexingNumber" -> 2, "IndexEntries" -> {{"i:1", "HPFilter"}}},
ImageSize->{288, 288},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (February 23, 2011)",
StyleDefinitions->"HelpBrowser.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0"->{
  Cell[579, 22, 464, 13, 258, "Title",
   CellTags->"b:0"],
  Cell[1046, 37, 212, 7, 74, "Text",
   CellTags->"b:0"],
  Cell[1261, 46, 2819, 82, 275, "Text",
   CellTags->"b:0"],
  Cell[4083, 130, 6064, 209, 394, "DefinitionBox",
   CellTags->{"i:1", "b:0"}],
  Cell[10235, 344, 63, 1, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[10301, 347, 280, 6, 37, "Input",
   CellTags->"b:0"],
  Cell[10584, 355, 323, 7, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[10910, 364, 1338, 24, 281, "Input",
   CellTags->"b:0"],
  Cell[13014, 413, 255, 8, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[13272, 423, 558, 14, 37, "Input",
   CellTags->"b:0"],
  Cell[13833, 439, 744, 19, 99, "MathCaption",
   CellTags->"b:0"],
  Cell[14602, 462, 1354, 28, 92, "Input",
   CellTags->"b:0"],
  Cell[15959, 492, 9520, 217, 353, "Output",
   CellTags->"b:0"],
  Cell[25494, 712, 585, 11, 112, "MathCaption",
   CellTags->"b:0"],
  Cell[32838, 885, 723, 18, 78, "MathCaption",
   CellTags->"b:0"],
  Cell[38557, 1016, 226, 4, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[41948, 1096, 348, 6, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[45802, 1188, 377, 7, 95, "MathCaption",
   CellTags->"b:0"],
  Cell[49471, 1277, 332, 6, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[52656, 1349, 434, 7, 32, "Text",
   CellTags->"b:0"],
  Cell[53093, 1358, 434, 7, 32, "Text",
   CellTags->"b:0"],
  Cell[53530, 1367, 1022, 19, 79, "DefinitionBox",
   CellTags->{"i:1", "b:0"}],
  Cell[54771, 1396, 410, 12, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[55206, 1412, 835, 22, 92, "Input",
   CellTags->"b:0"],
  Cell[56044, 1436, 327, 6, 35, "Output",
   CellTags->"b:0"],
  Cell[56386, 1445, 430, 7, 32, "Text",
   CellTags->"b:0"],
  Cell[56819, 1454, 1197, 23, 122, "DefinitionBox",
   CellTags->{"i:1", "b:0"}],
  Cell[58104, 1482, 126, 2, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[58255, 1488, 321, 7, 37, "Input",
   CellTags->"b:0"],
  Cell[58579, 1497, 437, 7, 35, "Output",
   CellTags->"b:0"],
  Cell[59031, 1507, 1017, 20, 107, "MathCaption",
   CellTags->"b:0"],
  Cell[63261, 1606, 677, 11, 56, "MathCaption",
   CellTags->"b:0"],
  Cell[65046, 1643, 3574, 97, 873, "SmallTextSans",
   CellTags->"b:0"],
  Cell[68623, 1742, 153, 4, 40, "SmallTextSans",
   CellTags->"b:0"],
  Cell[68779, 1748, 175, 5, 40, "SmallTextSans",
   CellTags->"b:0"]},
 "i:1"->{
  Cell[4083, 130, 6064, 209, 394, "DefinitionBox",
   CellTags->{"i:1", "b:0"}],
  Cell[53530, 1367, 1022, 19, 79, "DefinitionBox",
   CellTags->{"i:1", "b:0"}],
  Cell[56819, 1454, 1197, 23, 122, "DefinitionBox",
   CellTags->{"i:1", "b:0"}]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0", 70189, 1793},
 {"i:1", 72540, 1864}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 464, 13, 258, "Title",
 CellTags->"b:0"],
Cell[1046, 37, 212, 7, 74, "Text",
 CellTags->"b:0"],
Cell[1261, 46, 2819, 82, 275, "Text",
 CellTags->"b:0"],
Cell[4083, 130, 6064, 209, 394, "DefinitionBox",
 CellTags->{"i:1", "b:0"}],
Cell[10150, 341, 82, 1, 32, "Text"],
Cell[10235, 344, 63, 1, 56, "MathCaption",
 CellTags->"b:0"],
Cell[10301, 347, 280, 6, 37, "Input",
 CellTags->"b:0"],
Cell[10584, 355, 323, 7, 56, "MathCaption",
 CellTags->"b:0"],
Cell[10910, 364, 1338, 24, 281, "Input",
 CellTags->"b:0"],
Cell[12251, 390, 322, 7, 56, "MathCaption"],
Cell[12576, 399, 435, 12, 65, "Input"],
Cell[13014, 413, 255, 8, 56, "MathCaption",
 CellTags->"b:0"],
Cell[13272, 423, 558, 14, 37, "Input",
 CellTags->"b:0"],
Cell[13833, 439, 744, 19, 99, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[14602, 462, 1354, 28, 92, "Input",
 CellTags->"b:0"],
Cell[15959, 492, 9520, 217, 353, "Output",
 CellTags->"b:0"]
}, Open  ]],
Cell[25494, 712, 585, 11, 112, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[26104, 727, 469, 6, 48, "Subsubsection"],
Cell[26576, 735, 146, 3, 37, "Input"],
Cell[CellGroupData[{
Cell[26747, 742, 676, 20, 92, "Input"],
Cell[27426, 764, 2524, 48, 353, "Output"]
}, Open  ]],
Cell[29965, 815, 434, 12, 56, "MathCaption"],
Cell[CellGroupData[{
Cell[30424, 831, 205, 5, 37, "Input"],
Cell[30632, 838, 2191, 44, 353, "Output"]
}, Open  ]],
Cell[32838, 885, 723, 18, 78, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[33586, 907, 1498, 38, 119, "Input"],
Cell[35087, 947, 3455, 66, 358, "Output"]
}, Open  ]],
Cell[38557, 1016, 226, 4, 56, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[38808, 1024, 629, 18, 65, "Input"],
Cell[39440, 1044, 2493, 49, 353, "Output"]
}, Open  ]],
Cell[41948, 1096, 348, 6, 56, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[42321, 1106, 804, 24, 119, "Input"],
Cell[43128, 1132, 2398, 47, 353, "Output"]
}, Open  ]],
Cell[45541, 1182, 258, 4, 32, "Text"],
Cell[45802, 1188, 377, 7, 95, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[46204, 1199, 700, 17, 65, "Input"],
Cell[46907, 1218, 929, 17, 91, "Message"],
Cell[47839, 1237, 927, 17, 91, "Message"],
Cell[48769, 1256, 471, 10, 62, "Message"]
}, Open  ]],
Cell[49255, 1269, 213, 6, 62, "Text"],
Cell[49471, 1277, 332, 6, 56, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[49828, 1287, 593, 17, 92, "Input"],
Cell[50424, 1306, 1454, 24, 136, "Message"],
Cell[51881, 1332, 760, 14, 62, "Message"]
}, Open  ]],
Cell[52656, 1349, 434, 7, 32, "Text",
 CellTags->"b:0"],
Cell[53093, 1358, 434, 7, 32, "Text",
 CellTags->"b:0"],
Cell[53530, 1367, 1022, 19, 79, "DefinitionBox",
 CellTags->{"i:1", "b:0"}],
Cell[54555, 1388, 213, 6, 62, "Text"],
Cell[54771, 1396, 410, 12, 56, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[55206, 1412, 835, 22, 92, "Input",
 CellTags->"b:0"],
Cell[56044, 1436, 327, 6, 35, "Output",
 CellTags->"b:0"]
}, Open  ]],
Cell[56386, 1445, 430, 7, 32, "Text",
 CellTags->"b:0"],
Cell[56819, 1454, 1197, 23, 122, "DefinitionBox",
 CellTags->{"i:1", "b:0"}],
Cell[58019, 1479, 82, 1, 32, "Text"],
Cell[58104, 1482, 126, 2, 56, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[58255, 1488, 321, 7, 37, "Input",
 CellTags->"b:0"],
Cell[58579, 1497, 437, 7, 35, "Output",
 CellTags->"b:0"]
}, Open  ]],
Cell[59031, 1507, 1017, 20, 107, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[60073, 1531, 1767, 41, 227, "Input"],
Cell[61843, 1574, 1403, 29, 342, "Output"]
}, Open  ]],
Cell[63261, 1606, 677, 11, 56, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[63963, 1621, 874, 14, 65, "Input"],
Cell[64840, 1637, 191, 3, 35, "Output"]
}, Open  ]],
Cell[65046, 1643, 3574, 97, 873, "SmallTextSans",
 CellTags->"b:0"],
Cell[68623, 1742, 153, 4, 40, "SmallTextSans",
 CellTags->"b:0"],
Cell[68779, 1748, 175, 5, 40, "SmallTextSans",
 CellTags->"b:0"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
