(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    344792,       6283]
NotebookOptionsPosition[    338972,       6094]
NotebookOutlinePosition[    341908,       6190]
CellTagsIndexPosition[    341816,       6184]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
The Season Package (by Ekkehart Schlicht)\
\>", "Title",
 CellChangeTimes->{{3.8157058982148943`*^9, 3.8157059041424265`*^9}},
 CellTags->"b:0"],

Cell[TextData[{
 "Revision 4 of November 2020. Works with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 and up.\n "
}], "Text",
 CellFrame->{{0, 0}, {0.5, 0}},
 CellChangeTimes->{{3.695534808463867*^9, 3.695534849557617*^9}, {
  3.6957340498085938`*^9, 3.6957340786992188`*^9}, {3.8157058943239794`*^9, 
  3.815705957018895*^9}},
 CellTags->"b:0"],

Cell[TextData[{
 "\nThe package implements Schlicht's (1984) seasonal adjustment method. It \
decomposes a time series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "t"], ",", " ", 
    RowBox[{"t", " ", "\[Element]", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "...", ",", "T"}], "}"}], " "}]}], TraditionalForm]]],
 "into a trend ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "t"], ",", " ", 
    RowBox[{"t", " ", "\[Element]", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "...", ",", "T"}], "}"}], " "}]}], TraditionalForm]]],
 ", a seasonal component ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "t"], ",", " ", 
    RowBox[{"t", " ", "\[Element]", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "...", ",", "T"}], "}"}], " "}]}], TraditionalForm]]],
 ", and an irregular component ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "t"], ",", " ", 
    RowBox[{"t", " ", "\[Element]", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "...", ",", "T"}], "}"}], " "}]}], TraditionalForm]]],
 "such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "t"], "=", 
    RowBox[{
     SubscriptBox["y", "t"], "+", 
     SubscriptBox["z", "t"], "+", 
     RowBox[{
      SubscriptBox["u", "t"], " ", "for", " ", "all", "  ", 
      RowBox[{"t", ".", " "}]}]}]}], TraditionalForm]]],
 "The method uses non-parametric splines. It combines the trend filter \
proposed by Leser (1961),  known as the HP-Filter filter, the seasonal filter \
proposed by Schlicht and Pauly (1983) and the orthogonal parametrization \
proposed by Schlicht (1984, 2005). For the treatment of missing observations \
and structural breaks, see Schlicht(2009). In contrast to prevailing methods, \
the method used here is based on an explicit statistical model (state-space). \
\nSeason is appropriate for smoothing time series with higher than annual \
frequency.  Season is inappropriate for smoothing annual data or \
deseasonalized time series; for this, use the HPFilter package by Johannes \
Ludsteck.   \nThis package provides the following functions for seasonal \
adjustment:"
}], "Text",
 CellChangeTimes->{{3.6956278083408203`*^9, 3.6956279366845703`*^9}, {
  3.695629480100586*^9, 3.695629501647461*^9}, {3.695629531725586*^9, 
  3.695629679584961*^9}, {3.696134607640625*^9, 3.6961346791875*^9}},
 CellTags->"b:0"],

Cell[TextData[{
 "Season[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 "]  splits the series ",
 StyleBox["x",
  FontSlant->"Italic"],
 " into trend, seasonal component, and irregular component, using estimated \
optimum smoothing parameters.\nSeason[",
 StyleBox["x,s,",
  FontSlant->"Italic"],
 "\[Alpha],\[Gamma]] splits the series ",
 StyleBox["x",
  FontSlant->"Italic"],
 " into trend, seasonal component, and irregular component, using the \
smoothing parameters \[Alpha] and \[Gamma]. \n\n",
 StyleBox["Both versions of Season[ ] return a list {{", "Commentary"],
 StyleBox["x,y", "Commentary",
  FontSlant->"Italic"],
 StyleBox[",", "Commentary"],
 StyleBox["z,u", "Commentary",
  FontSlant->"Italic"],
 StyleBox["},{\[Alpha],\[Gamma]},", "Commentary"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]]],
 StyleBox["} where ", "Commentary"],
 StyleBox["x", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" is the input series, ", "Commentary"],
 StyleBox["y", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" is the trend, ", "Commentary"],
 StyleBox["z ", "Commentary",
  FontSlant->"Italic"],
 StyleBox["is the seasonal component, ", "Commentary"],
 StyleBox["u", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" is the irregular component, \[Alpha] and \[Gamma] are the \
smoothing parameters used and ", "Commentary"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]]],
 StyleBox[" is the variance of the irregular component..\n", "Commentary"],
 "\n",
 "LL",
 "[",
 StyleBox["x,s,",
  FontSlant->"Italic"],
 "\[Alpha],\[Gamma]] give the log likelihood of the constellation {",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ",\[Alpha],\[Gamma]}.\n\nLLPlot[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ", {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 ",{ ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "}] plots the log likelihood for the range {\[Alpha],\[Gamma]}\[Element][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "]"}], TraditionalForm]]],
 "\[Times][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "].\n"
}], "DefinitionBox",
 CellChangeTimes->{3.695534767182617*^9},
 CellTags->{"i:1", "b:0"}],

Cell[TextData[{
 "The method needs the time series ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "and the length of the season ",
 StyleBox["s ",
  FontSlant->"Italic"],
 "as an input (",
 StyleBox["e.g",
  FontSlant->"Italic"],
 ". ",
 StyleBox["s",
  FontSlant->"Italic"],
 "=",
 StyleBox["4 ",
  FontSlant->"Italic"],
 "for quarterly data or ",
 StyleBox["s",
  FontSlant->"Italic"],
 "=",
 StyleBox["12",
  FontSlant->"Italic"],
 " for monthly data). The function Season[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 "] computes smoothing parameters \[Alpha] and \[Gamma] by a maximum \
likelihood method and splits the time series, using these weights. \
Alternatively, the parameters can be provided in Season[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ",\[Alpha],\[Gamma]]. The parameter \[Alpha] controls the smoothness of the \
trend - the larger \[Alpha], the smoother the trend. The parameter \[Gamma] \
controls the rigidity of the seasonal pattern - the larger \[Gamma], the more \
time-invariant is the seasonal pattern. Both parameters interact: Increasing \
\[Alpha] while keeping \[Gamma] constant will shift some variabilty from the \
trend to the seasonal component, for example (and the rest to the irregular \
component). \nThe method assumes that trend, season and irregular component \
are ",
 StyleBox["additive",
  FontSlant->"Italic"],
 " components of the time series. For some time series, such as trended time \
series, a ",
 StyleBox["multiplicative",
  FontSlant->"Italic"],
 " formulation is preferable. In this case, take the logarithms of the \
original data as the input.\nInstructions: Place the package season6.m in \
$UserBaseDirectory\\Applications\\ (usually ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", ":", 
    RowBox[{
     RowBox[{
      RowBox[{"\\", "Users"}], "\\<", "username"}], ">", 
     RowBox[{"\\", "AppData", "\\", "Roaming", "\\"}]}]}], TraditionalForm]]],
 "Mathematica\\ Applications\\) and successively  evaluate the cells.\nTo \
obtain information of the available functions, such as",
 StyleBox[" Season[],",
  FontFamily->"Courier New"],
 " evaluate it with a question mark, like ",
 StyleBox["?Season. ",
  FontFamily->"Courier New"],
 StyleBox["The list of of functions in the package season6.m  can be obtained \
by opening it oin ",
  FontFamily->"Times New Roman"],
 StyleBox["Mathematica",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 StyleBox[" and click on \[OpenCurlyDoubleQuote]",
  FontFamily->"Times New Roman"],
 StyleBox["Functions",
  FontFamily->"Segoe UI"],
 StyleBox["\[CloseCurlyDoubleQuote].",
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6956163083222656`*^9, 3.6956164109785156`*^9}, {
   3.6956166953378906`*^9, 3.6956166991503906`*^9}, {3.695617980046875*^9, 
   3.695617995171875*^9}, {3.695618029140625*^9, 3.69561810528125*^9}, {
   3.695618161859375*^9, 3.695618178140625*^9}, {3.695618295921875*^9, 
   3.69561830728125*^9}, {3.6956183416933594`*^9, 3.6956184388496094`*^9}, {
   3.6956184771621094`*^9, 3.6956185456152344`*^9}, {3.695618920647461*^9, 
   3.695618938131836*^9}, 3.695619036053711*^9, {3.696093045375*^9, 
   3.696093077125*^9}, {3.696093162*^9, 3.696093169046875*^9}, {
   3.696093249602539*^9, 3.696093250336914*^9}, 3.696093408665039*^9, {
   3.696125797732422*^9, 3.696125798779297*^9}, 3.69612822078125*^9, {
   3.696135155953125*^9, 3.696135181625*^9}, {3.696135283834961*^9, 
   3.696135300084961*^9}, 3.6961354057822266`*^9, 3.696135475055664*^9, {
   3.696135549118164*^9, 3.696135579196289*^9}, {3.6961357522460938`*^9, 
   3.6961357946533203`*^9}}],

Cell["This loads the package", "MathCaption",
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{"<<", "Season`"}]], "Input",
 CellChangeTimes->{
  3.695618898569336*^9, {3.6956202856054688`*^9, 3.6956202873398438`*^9}, {
   3.6956203358085938`*^9, 3.6956203370117188`*^9}, 3.6956204148710938`*^9, 
   3.6956205578447266`*^9, 3.695871867666086*^9, 3.8157061754180875`*^9},
 CellTags->"b:0",
 CellLabel->"In[1]:="],

Cell["\<\
Here is a series with 358 elements - the time series of monthly German \
unemployment rates for 1991:01 through 2020:10.\
\>", "MathCaption",
 CellChangeTimes->{{3.8157061264985847`*^9, 3.815706138840704*^9}},
 CellTags->"b:0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", " ", "=", 
   RowBox[{"{", 
    RowBox[{
    "7.4`", ",", "7.5`", ",", "7.1`", ",", "7", ",", "6.9`", ",", "6.8`", ",",
      "7.7`", ",", "7.7`", ",", "7.4`", ",", "7.4`", ",", "7.4`", ",", "7.8`",
      ",", "8.3`", ",", "8.2`", ",", "7.7`", ",", "7.6`", ",", "7.4`", ",", 
     "7.3`", ",", "7.8`", ",", "7.7`", ",", "7.5`", ",", "7.6`", ",", "7.7`", 
     ",", "8.1`", ",", "9", ",", "9", ",", "8.7`", ",", "8.6`", ",", "8.4`", 
     ",", "8.5`", ",", "9.1`", ",", "9.1`", ",", "8.9`", ",", "9.1`", ",", 
     "9.2`", ",", "9.6`", ",", "10.5`", ",", "10.5`", ",", "10.1`", ",", 
     "9.9`", ",", "9.5`", ",", "9.3`", ",", "9.6`", ",", "9.4`", ",", "9.1`", 
     ",", "8.9`", ",", "8.9`", ",", "9.2`", ",", "10", ",", "10", ",", "9.6`",
      ",", "9.4`", ",", "9", ",", "9", ",", "9.4`", ",", "9.3`", ",", "9.2`", 
     ",", "9.2`", ",", "9.3`", ",", "9.9`", ",", "10.8`", ",", "11.1`", ",", 
     "10.8`", ",", "10.4`", ",", "10", ",", "9.9`", ",", "10.2`", ",", 
     "10.2`", ",", "10.1`", ",", "10.1`", ",", "10.3`", ",", "10.8`", ",", 
     "12.2`", ",", "12.2`", ",", "11.7`", ",", "11.3`", ",", "11.1`", ",", 
     "11", ",", "11.4`", ",", "11.4`", ",", "11.2`", ",", "11.2`", ",", 
     "11.3`", ",", "11.8`", ",", "12.6`", ",", "12.6`", ",", "12.1`", ",", 
     "11.4`", ",", "10.9`", ",", "10.5`", ",", "10.7`", ",", "10.6`", ",", 
     "10.3`", ",", "10.1`", ",", "10.2`", ",", "10.9`", ",", "11.5`", ",", 
     "11.6`", ",", "11.1`", ",", "10.7`", ",", "10.2`", ",", "10.1`", ",", 
     "10.3`", ",", "10.3`", ",", "10.1`", ",", "9.9`", ",", "10", ",", 
     "10.3`", ",", "11", ",", "10.9`", ",", "10.6`", ",", "9.8`", ",", "9.3`",
      ",", "9.1`", ",", "9.3`", ",", "9.3`", ",", "9", ",", "8.9`", ",", 
     "8.9`", ",", "9.3`", ",", "10", ",", "10.1`", ",", "9.8`", ",", "9.5`", 
     ",", "9", ",", "8.9`", ",", "9.2`", ",", "9.2`", ",", "9", ",", "9", ",",
      "9.2`", ",", "9.6`", ",", "10.4`", ",", "10.4`", ",", "10", ",", "9.7`",
      ",", "9.5`", ",", "9.5`", ",", "9.7`", ",", "9.6`", ",", "9.5`", ",", 
     "9.4`", ",", "9.7`", ",", "10.1`", ",", "11.1`", ",", "11.3`", ",", 
     "11.1`", ",", "10.8`", ",", "10.4`", ",", "10.2`", ",", "10.4`", ",", 
     "10.4`", ",", "10.1`", ",", "10", ",", "10", ",", "10.4`", ",", "11", 
     ",", "11.1`", ",", "10.9`", ",", "10.7`", ",", "10.3`", ",", "10.2`", 
     ",", "10.5`", ",", "10.5`", ",", "10.3`", ",", "10.1`", ",", "10.3`", 
     ",", "10.8`", ",", "12.3`", ",", "12.7`", ",", "12.7`", ",", "12.2`", 
     ",", "11.8`", ",", "11.5`", ",", "11.7`", ",", "11.6`", ",", "11.2`", 
     ",", "11", ",", "10.9`", ",", "11.1`", ",", "12.1`", ",", "12.2`", ",", 
     "12", ",", "11.5`", ",", "10.9`", ",", "10.5`", ",", "10.5`", ",", 
     "10.5`", ",", "10.1`", ",", "9.8`", ",", "9.6`", ",", "9.6`", ",", 
     "10.2`", ",", "10.1`", ",", "9.8`", ",", "9.5`", ",", "9.1`", ",", 
     "8.8`", ",", "8.8`", ",", "8.8`", ",", "8.4`", ",", "8.2`", ",", "8", 
     ",", "8.1`", ",", "8.7`", ",", "8.6`", ",", "8.3`", ",", "8.1`", ",", 
     "7.8`", ",", "7.5`", ",", "7.6`", ",", "7.6`", ",", "7.3`", ",", "7.1`", 
     ",", "7.1`", ",", "7.4`", ",", "8.3`", ",", "8.5`", ",", "8.5`", ",", 
     "8.5`", ",", "8.2`", ",", "8.1`", ",", "8.2`", ",", "8.2`", ",", "7.9`", 
     ",", "7.7`", ",", "7.6`", ",", "7.8`", ",", "8.6`", ",", "8.6`", ",", 
     "8.5`", ",", "8.1`", ",", "7.7`", ",", "7.5`", ",", "7.6`", ",", "7.6`", 
     ",", "7.2`", ",", "7", ",", "6.9`", ",", "7.1`", ",", "7.9`", ",", 
     "7.9`", ",", "7.6`", ",", "7.3`", ",", "7", ",", "6.9`", ",", "7", ",", 
     "7", ",", "6.6`", ",", "6.5`", ",", "6.4`", ",", "6.6`", ",", "7.3`", 
     ",", "7.4`", ",", "7.2`", ",", "7", ",", "6.7`", ",", "6.6`", ",", 
     "6.8`", ",", "6.8`", ",", "6.5`", ",", "6.5`", ",", "6.5`", ",", "6.7`", 
     ",", "7.4`", ",", "7.4`", ",", "7.3`", ",", "7.1`", ",", "6.8`", ",", 
     "6.6`", ",", "6.8`", ",", "6.8`", ",", "6.6`", ",", "6.5`", ",", "6.5`", 
     ",", "6.7`", ",", "7.3`", ",", "7.3`", ",", "7.1`", ",", "6.8`", ",", 
     "6.6`", ",", "6.5`", ",", "6.6`", ",", "6.7`", ",", "6.5`", ",", "6.3`", 
     ",", "6.3`", ",", "6.4`", ",", "7", ",", "6.9`", ",", "6.8`", ",", 
     "6.5`", ",", "6.3`", ",", "6.2`", ",", "6.3`", ",", "6.4`", ",", "6.2`", 
     ",", "6", ",", "6", ",", "6.1`", ",", "6.7`", ",", "6.6`", ",", "6.5`", 
     ",", "6.3`", ",", "6", ",", "5.9`", ",", "6", ",", "6.1`", ",", "5.9`", 
     ",", "5.8`", ",", "5.7`", ",", "5.8`", ",", "6.3`", ",", "6.3`", ",", 
     "6", ",", "5.8`", ",", "5.6`", ",", "5.5`", ",", "5.6`", ",", "5.7`", 
     ",", "5.5`", ",", "5.4`", ",", "5.3`", ",", "5.3`", ",", "5.8`", ",", 
     "5.7`", ",", "5.5`", ",", "5.3`", ",", "5.1`", ",", "5", ",", "5.1`", 
     ",", "5.2`", ",", "5", ",", "4.9`", ",", "4.8`", ",", "4.9`", ",", 
     "5.3`", ",", "5.3`", ",", "5.1`", ",", "4.9`", ",", "4.9`", ",", "4.9`", 
     ",", "5", ",", "5.1`", ",", "4.9`", ",", "4.8`", ",", "4.8`", ",", 
     "4.9`", ",", "5.3`", ",", "5.3`", ",", "5.1`", ",", "5.8`", ",", "6.1`", 
     ",", "6.2`", ",", "6.3`", ",", "6.4`", ",", "6.2`", ",", "6"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"startdate", "=", 
   RowBox[{
    RowBox[{"DateList", "[", 
     RowBox[{"{", 
      RowBox[{"1991", ",", "1"}], "}"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "2"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8157060465393124`*^9, 3.8157060985179453`*^9}, 
   3.815706160295828*^9, {3.815788735629363*^9, 3.815788785775441*^9}, {
   3.8157899221864347`*^9, 3.815789948807468*^9}, {3.8157900052015457`*^9, 
   3.8157900718989687`*^9}, {3.8157901648931518`*^9, 3.8157901840126967`*^9}, 
   3.8284917916469917`*^9},
 CellTags->"b:0",
 CellLabel->"In[2]:="],

Cell[TextData[{
 "The following code calls the decomposition routine for monthly data with \
smoothing parameter values \[Alpha]=100 and \[Gamma]=100 and returns the list \
{{",
 StyleBox["x,y,z,u",
  FontSlant->"Italic"],
 "},{\[Alpha],\[Gamma]}}."
}], "MathCaption",
 CellChangeTimes->{{3.6956204273242188`*^9, 3.6956204291523438`*^9}},
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", "varU"}], "}"}], "=", 
   RowBox[{"Season", "[", 
    RowBox[{"x", ",", "12", ",", "100", ",", " ", "100"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.695535332426758*^9, 3.695535351786133*^9}, 
   3.695535503661133*^9, 3.695535539958008*^9, 3.697436132169922*^9},
 CellTags->"b:0",
 CellLabel->"In[4]:="],

Cell[TextData[{
 "Here is a plot of the original time series ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "(red), the trend ",
 StyleBox["y ",
  FontSlant->"Italic"],
 "(blue), and the seasonal component ",
 StyleBox["z ",
  FontSlant->"Italic"],
 "(green)."
}], "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.81570618559671*^9, 3.81570618929434*^9}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], " ", "}"}], ",", "startdate", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue", ",", "Green"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8157062184430623`*^9, 3.8157062510197225`*^9}, 
   3.815788687624072*^9, {3.8157888120032997`*^9, 3.815788818964633*^9}},
 CellLabel->"In[5]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxVl39wFOUZxxclVdJqVoklsSYspJgwTewSLGiJzl7VVBsrayGOQMcsctiG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     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwl2HlczOsXB/CJhCxNhBYqumQppVxF0RxLlsL8omu9KgqFDOm2XGlkC0VF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     "]]}, 
   {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJwl2HlcjOsXAPAJRZGSkL3kKlQqS3ZzLF2UGqWU0FCWRA1Fi9IobqEoS6Fi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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{2871676800, 0}, {2.8716768*^9, 0}],
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[2840140800, 2.8401408*^9], 
       FormBox["\"1990\"", TraditionalForm]}, {
       NCache[3155673600, 3.1556736*^9], 
       FormBox["\"2000\"", TraditionalForm]}, {
       NCache[3471292800, 3.4712928*^9], 
       FormBox["\"2010\"", TraditionalForm]}, {
       NCache[3786825600, 3.7868256*^9], 
       FormBox["\"2020\"", TraditionalForm]}, {
       NCache[4102444800, 4.1024448*^9], 
       FormBox["\"2030\"", TraditionalForm]}, {
       NCache[2903212800, 2.9032128*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[2966371200, 2.9663712*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3029443200, 3.0294432*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3092601600, 3.0926016*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3218832000, 3.218832*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3281904000, 3.281904*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3408134400, 3.4081344*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3534364800, 3.5343648*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3597523200, 3.5975232*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3660595200, 3.6605952*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3723753600, 3.7237536*^9], 
       FormBox["\"\"", TraditionalForm]}}, {{
       NCache[2840140800, 2.8401408*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3155673600, 3.1556736*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3471292800, 3.4712928*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3786825600, 3.7868256*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[4102444800, 4.1024448*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[2903212800, 2.9032128*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[2966371200, 2.9663712*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3029443200, 3.0294432*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3092601600, 3.0926016*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3218832000, 3.218832*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3281904000, 3.281904*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3408134400, 3.4081344*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3534364800, 3.5343648*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3597523200, 3.5975232*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3660595200, 3.6605952*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3723753600, 3.7237536*^9], 
       FormBox["\"\"", TraditionalForm]}}}},
  GridLines->NCache[{{{2840140800, 
       GrayLevel[0.8]}, {3155673600, 
       GrayLevel[0.8]}, {3471292800, 
       GrayLevel[0.8]}, {3786825600, 
       GrayLevel[0.8]}, {4102444800, 
       GrayLevel[0.8]}}, None}, {{{2.8401408*^9, 
       GrayLevel[0.8]}, {3.1556736*^9, 
       GrayLevel[0.8]}, {3.4712928*^9, 
       GrayLevel[0.8]}, {3.7868256*^9, 
       GrayLevel[0.8]}, {4.1024448*^9, 
       GrayLevel[0.8]}}, None}],
  PlotRange->{{2.8716768*^9, 3.8104992*^9}, {-0.47040331692765297`, 12.7}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{3.828491838350483*^9},
 CellLabel->"Out[5]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Subsection",
 CellChangeTimes->{{3.69587363881843*^9, 3.69587364066218*^9}}],

Cell[CellGroupData[{

Cell["", "Subsubsection",
 CellChangeTimes->{{3.695873618490305*^9, 3.695873621677805*^9}}],

Cell[TextData[{
 "To view the effect of the choice of the smoothing parameters \[Alpha] and \
\[Gamma] over the ranges (",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "min"], ",", 
   SubscriptBox["\[Alpha]", "max"]}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}}],
 ") and (",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "min"], ",", 
     SubscriptBox["\[Gamma]", "max"]}], ")"}], " "}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}}],
 "evaluate the following. It uses  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "init"], "=", "10"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "min"], "=", ".1"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "max"], "=", "100"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ",  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "init"], "=", "10"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "min"], "=", ".1"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "max"], "=", "100"}]],
  CellChangeTimes->{
   3.695873594146555*^9, {3.695873800758859*^9, 3.695873859040109*^9}, 
    3.695873905946359*^9, {3.6958739535869846`*^9, 3.695873973696359*^9}, {
    3.6958740344619846`*^9, 3.6958742955244846`*^9}, {3.695874533227609*^9, 
    3.695874548227609*^9}}],
 "."
}], "MathCaption",
 CellChangeTimes->{{3.6958736996807346`*^9, 3.6958737673369846`*^9}, {
  3.6958738708994846`*^9, 3.6958739382119846`*^9}, {3.6958743052744846`*^9, 
  3.695874386321359*^9}, {3.6958747282119846`*^9, 3.6958747323369846`*^9}, {
  3.695874784383859*^9, 3.695874879977609*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.6958736895557346`*^9, 3.6958736945557346`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", "varU"}], "}"}], 
     "=", 
     RowBox[{"Season", "[", 
      RowBox[{"x", ",", "12", ",", "\[Alpha]", ",", " ", "\[Gamma]"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"DateListPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], " ", "}"}], ",", "startdate", ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Red", ",", "Blue", ",", "Green"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"\"\<\[Alpha] =  \>\"", "  ", "<>", " ", 
            RowBox[{"ToString", "[", " ", "\[Alpha]", " ", "]"}], "<>", " ", 
            "\"\<    \[Gamma] =  \>\"", "  ", "<>", " ", 
            RowBox[{"ToString", "[", " ", "\[Gamma]", " ", "]"}], "<>", 
            "\"\<\\nLogLikelihood = \>\"", "<>", 
            RowBox[{"ToString", "[", 
             RowBox[{"LL", "[", 
              RowBox[{"x", ",", "12", ",", "\[Alpha]", ",", "\[Gamma]"}], 
              "]"}], "]"}]}], ",", "12", ",", 
           RowBox[{"TextAlignment", "\[Rule]", "Left"}]}], "]"}], ",", "  ", 
         RowBox[{"{", 
          RowBox[{"80", ",", "5.5"}], "}"}]}], "]"}], "]"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "10"}], "}"}], ",", ".1", ",", "100"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Gamma]", ",", "10"}], "}"}], ",", ".1", ",", "100"}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6958746470244846`*^9, 3.695874651696359*^9}, {
   3.6958746905869846`*^9, 3.6958746938369846`*^9}, {3.695874738290109*^9, 
   3.6958747603057346`*^9}, {3.6959781294257812`*^9, 
   3.6959781535126953`*^9}, {3.697435994482422*^9, 3.697435996935547*^9}, 
   3.815706218458717*^9, {3.815706266497558*^9, 3.81570627107511*^9}, 
   3.815788687639718*^9, {3.8157901996915016`*^9, 3.8157902024234695`*^9}},
 CellLabel->"In[6]:="],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Alpha]$$ = 10, $CellContext`\[Gamma]$$ = 
    10, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Alpha]$$], 10}, 0.1, 100}, {{
       Hold[$CellContext`\[Gamma]$$], 10}, 0.1, 100}}, Typeset`size$$ = {
    360., {120., 125.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Alpha]$631$$ = 
    0, $CellContext`\[Gamma]$636$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`\[Alpha]$$ = 10, $CellContext`\[Gamma]$$ = 
        10}, "ControllerVariables" :> {
        Hold[$CellContext`\[Alpha]$$, $CellContext`\[Alpha]$631$$, 0], 
        Hold[$CellContext`\[Gamma]$$, $CellContext`\[Gamma]$636$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ({{$CellContext`x, $CellContext`y, $CellContext`z, \
$CellContext`u}, {$CellContext`\[Alpha]$$, $CellContext`\[Gamma]$$}, \
$CellContext`varU} = 
        Season`Season`Season[$CellContext`x, 
          12, $CellContext`\[Alpha]$$, $CellContext`\[Gamma]$$]; Show[
         DateListPlot[{$CellContext`x, $CellContext`y, $CellContext`z}, \
$CellContext`startdate, Joined -> True, PlotStyle -> {Red, Blue, Green}], 
         Graphics[
          Text[
           Style[
            StringJoin["\[Alpha] =  ", 
             ToString[$CellContext`\[Alpha]$$], "    \[Gamma] =  ", 
             ToString[$CellContext`\[Gamma]$$], "\nLogLikelihood = ", 
             ToString[
              
              Season`Season`LL[$CellContext`x, 
               12, $CellContext`\[Alpha]$$, $CellContext`\[Gamma]$$]]], 12, 
            TextAlignment -> Left], {80, 5.5}]]]), 
      "Specifications" :> {{{$CellContext`\[Alpha]$$, 10}, 0.1, 
         100}, {{$CellContext`\[Gamma]$$, 10}, 0.1, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{409., {180., 185.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.828491838570834*^9},
 CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
 "If Season is called without smoothing parameters, it computes the optimum \
smoothing parameters by a maximum-likelihood method and returns the list  {{",
 StyleBox["x,y,z,u",
  FontSlant->"Italic"],
 "},{\[Alpha],\[Gamma]},",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]]],
 "}."
}], "MathCaption",
 CellTags->"b:0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", "varU"}], "}"}], "=", 
   RowBox[{"Season", "[", 
    RowBox[{"x", ",", "12"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6955508907978516`*^9, 3.6955509151572266`*^9}, {
   3.6955534494228516`*^9, 3.6955535225478516`*^9}, {3.6955538661210938`*^9, 
   3.6955538896367188`*^9}, 3.8157062802699366`*^9, {3.815709360793313*^9, 
   3.8157093669149833`*^9}},
 CellTags->"b:0",
 CellLabel->"In[7]:="],

Cell[TextData[{
 "Here is a plot of the original time series ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "(red), the trend ",
 StyleBox["y ",
  FontSlant->"Italic"],
 "(blue), and the seasonal component ",
 StyleBox["z ",
  FontSlant->"Italic"],
 "(green). It can be seen that the smoothing parameters are estimated smaller \
than the parameters used in the previous example. In particular, the \
parameter \[Alpha] for the trend is estimated as being quite small, entailing \
a rougher trend."
}], "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], " ", "}"}], ",", "startdate", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue", ",", "Green"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Smoothing parameters: \[Alpha] = \>\"", ",", "\[Alpha]", ",", 
    "\"\<,  \[Gamma] = \>\"", ",", "\[Gamma]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Estimated variances: \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \
\(u\)], \(2\)]\) = \>\"", ",", " ", "varU", ",", " ", 
    "\"\<, \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \(v\)], \(2\)]\) = \
\>\"", ",", 
    RowBox[{"varU", "/", "\[Alpha]"}], ",", 
    "\"\<, \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \(w\)], \(2\)]\) = \
\>\"", ",", 
    RowBox[{"varU", "/", "\[Gamma]"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6954469302646484`*^9, 3.6954470281396484`*^9}, {
   3.6956204562148438`*^9, 3.6956204567773438`*^9}, 3.815706218743595*^9, 
   3.8157063165615697`*^9, 3.8157886877712727`*^9, {3.8157902080610046`*^9, 
   3.815790211458164*^9}, {3.8157968495199366`*^9, 3.8157968711771636`*^9}, {
   3.815797253195962*^9, 3.815797264125989*^9}},
 CellLabel->"In[8]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxVl39wFOUZxxclVdJqVoklsSYspJgwTewSLGiJzl7VVBsrayGOQMcsctiG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     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwl2HtcTPkbB/CJ3FODSCglKiQVihTz0ObOoJBsN4XU1hCplUpL96hIJGtI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     "]]}, 
   {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJwtmHtYzNv3x0cIOWmQyPfIJJUkXTiplFrqJEJDbhVKckm6KRRSEYkwUToJ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{2871676800, 0}, {2.8716768*^9, 0}],
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[2840140800, 2.8401408*^9], 
       FormBox["\"1990\"", TraditionalForm]}, {
       NCache[3155673600, 3.1556736*^9], 
       FormBox["\"2000\"", TraditionalForm]}, {
       NCache[3471292800, 3.4712928*^9], 
       FormBox["\"2010\"", TraditionalForm]}, {
       NCache[3786825600, 3.7868256*^9], 
       FormBox["\"2020\"", TraditionalForm]}, {
       NCache[4102444800, 4.1024448*^9], 
       FormBox["\"2030\"", TraditionalForm]}, {
       NCache[2903212800, 2.9032128*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[2966371200, 2.9663712*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3029443200, 3.0294432*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3092601600, 3.0926016*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3218832000, 3.218832*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3281904000, 3.281904*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3408134400, 3.4081344*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3534364800, 3.5343648*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3597523200, 3.5975232*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3660595200, 3.6605952*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3723753600, 3.7237536*^9], 
       FormBox["\"\"", TraditionalForm]}}, {{
       NCache[2840140800, 2.8401408*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3155673600, 3.1556736*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3471292800, 3.4712928*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3786825600, 3.7868256*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[4102444800, 4.1024448*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[2903212800, 2.9032128*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[2966371200, 2.9663712*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3029443200, 3.0294432*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3092601600, 3.0926016*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3218832000, 3.218832*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3281904000, 3.281904*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3408134400, 3.4081344*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3534364800, 3.5343648*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3597523200, 3.5975232*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3660595200, 3.6605952*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3723753600, 3.7237536*^9], 
       FormBox["\"\"", TraditionalForm]}}}},
  GridLines->NCache[{{{2840140800, 
       GrayLevel[0.8]}, {3155673600, 
       GrayLevel[0.8]}, {3471292800, 
       GrayLevel[0.8]}, {3786825600, 
       GrayLevel[0.8]}, {4102444800, 
       GrayLevel[0.8]}}, None}, {{{2.8401408*^9, 
       GrayLevel[0.8]}, {3.1556736*^9, 
       GrayLevel[0.8]}, {3.4712928*^9, 
       GrayLevel[0.8]}, {3.7868256*^9, 
       GrayLevel[0.8]}, {4.1024448*^9, 
       GrayLevel[0.8]}}, None}],
  PlotRange->{{2.8716768*^9, 3.8104992*^9}, {-0.5287577782312763, 12.7}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{3.8284918526388483`*^9},
 CellLabel->"Out[8]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Smoothing parameters: \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.1830314561859558`", "\[InvisibleSpace]", "\<\",  \[Gamma] = \"\>", 
   "\[InvisibleSpace]", "0.6547227026833051`"}],
  SequenceForm[
  "Smoothing parameters: \[Alpha] = ", 0.1830314561859558, ",  \[Gamma] = ", 
   0.6547227026833051],
  Editable->False]], "Print",
 CellChangeTimes->{3.828491852670123*^9},
 CellLabel->"During evaluation of In[8]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estimated variances: \\!\\(\\*SuperscriptBox[SubscriptBox[\\(\
\[Sigma]\\), \\(u\\)], \\(2\\)]\\) = \"\>", "\[InvisibleSpace]", 
   "0.0010919093397205573`", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SuperscriptBox[SubscriptBox[\\(\
\[Sigma]\\), \\(v\\)], \\(2\\)]\\) = \"\>", "\[InvisibleSpace]", 
   "0.0059656922502501555`", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SuperscriptBox[SubscriptBox[\\(\
\[Sigma]\\), \\(w\\)], \\(2\\)]\\) = \"\>", "\[InvisibleSpace]", 
   "0.0016677432067736364`"}],
  SequenceForm[
  "Estimated variances: \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \
\(u\)], \(2\)]\) = ", 0.0010919093397205573`, 
   ", \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \(v\)], \(2\)]\) = ", 
   0.0059656922502501555`, 
   ", \!\(\*SuperscriptBox[SubscriptBox[\(\[Sigma]\), \(w\)], \(2\)]\) = ", 
   0.0016677432067736364`],
  Editable->False]], "Print",
 CellChangeTimes->{3.828491852670123*^9},
 CellLabel->"During evaluation of In[8]:="]
}, Open  ]],

Cell[TextData[{
 "The option SearchRange \[Rule] {{",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 ", {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 "} permits to select a range over which Season searches for a solution, \
where \[Alpha] is restricted to the interval [",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "] and \[Gamma] is restricted to the interval [",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "]. If a parameter is estimated close to the boundary of the relevant \
interval, a warning is issued.\nThe option may be used estimate one smoothing \
parameter  while keeping the other fixed.\n\n",
 StyleBox["The standard option for the search range is: SearchRange  \[Rule]  \
{{0.1, 1000}, {0.1, 1000}}.", "Commentary"]
}], "DefinitionBox",
 CellChangeTimes->{{3.695611767165039*^9, 3.695611776899414*^9}, {
  3.815706461720521*^9, 3.8157065330764256`*^9}, {3.815795986140876*^9, 
  3.8157960029595313`*^9}},
 CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", " ", "var"}], "}"}],
     "=", 
    RowBox[{"Season", "[", 
     RowBox[{"x", ",", "12", ",", " ", 
      RowBox[{"SearchRange", " ", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.6955552070878906`*^9, 3.6955552384160156`*^9}, {
   3.6955552702285156`*^9, 3.6955552886191406`*^9}, {3.695611790790039*^9, 
   3.695611808805664*^9}, 3.697436220123047*^9, 3.8157063563256445`*^9},
 CellLabel->"In[11]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Season", "::", "cornera"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Estimate \[NoBreak]\\!\\(1.0000000603204902`\\)\[NoBreak] \
of alpha appears to be a corner solution. Try to widen the search \
range.\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8284918668115854`*^9},
 CellLabel->"During evaluation of In[11]:="]
}, Open  ]],

Cell[TextData[{
 "Season calls NMaximize to determine the optimum smoothing parameter. \
NMaximize options can be given to Season to cope with convergency problems \
and other issues. They are handed over to NMaximize. If NMaximize does not \
find a solution, a warning is issued.\n\n",
 StyleBox["Standard options for NMaximize in Season are: Method \[Rule] \
{\"NelderMead\", PostProcess \[Rule] False }. To speed up calculation, use \
AccuracyGoal \[Rule] 3.", "Commentary"]
}], "DefinitionBox",
 CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "\[Gamma]"}], "}"}], ",", " ", "var"}], "}"}],
     "=", 
    RowBox[{"Season", "[", 
     RowBox[{"x", ",", "12", ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "8"}], ",", 
      RowBox[{"MaxIterations", "\[Rule]", "5"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{3.697436228248047*^9},
 CellLabel->"In[12]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NMaximize", "::", "cvmit"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Failed to converge to the requested accuracy or precision \
within \[NoBreak]\\!\\(5\\)\[NoBreak] iterations. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NMaximize\\\", ButtonNote -> \
\\\"NMaximize::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8284918695197988`*^9},
 CellLabel->"During evaluation of In[12]:="],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Season", "::", "maxfail"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Aborting due to problems in numerical maximization \
procedure.\\nConsider fine-tuning NMaximize options. Try the option \
MaxIterations\[Rule]500, for example.\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.828491869627117*^9},
 CellLabel->"During evaluation of In[12]:="],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.828491869627117*^9},
 CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
 "The function LL[",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ",",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", ","}], TraditionalForm]]],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 "] returns the log likelihood of the constellation {",
 StyleBox["x,s",
  FontSlant->"Italic"],
 ",",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", ","}], TraditionalForm]]],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 "}."
}], "DefinitionBox",
 CellChangeTimes->{{3.695534731666992*^9, 3.695534734073242*^9}},
 CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LL", "[", 
  RowBox[{"x", ",", "12", ",", "2", ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{3.695534757026367*^9},
 CellLabel->"In[13]:="],

Cell[BoxData["1741.27647845312`"], "Output",
 CellChangeTimes->{3.8284918699398484`*^9},
 CellLabel->"Out[13]="]
}, Open  ]],

Cell[TextData[{
 "The function LLPlot[x,s,{",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 ", {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", 
     StyleBox["max",
      FontSlant->"Italic"]], "}"}], TraditionalForm]]],
 "] returns a plot of the log likelihood over the range {\[Alpha],\[Gamma]}\
\[Element][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", 
     StyleBox["max",
      FontSlant->"Italic"]], "]"}], TraditionalForm]]],
 "\[Times][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["min",
     FontSlant->"Italic"]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["max",
     FontSlant->"Italic"]], TraditionalForm]]],
 "].\n\n",
 StyleBox["LLPlot calls Plot3D and hands any options over to Plot3D. Be aware \
that the system matrix becomes near-singular for very large or very small \
values of the smoothing parameters, and that irregularities in these regions \
may be computational artifacts.", "Commentary"]
}], "DefinitionBox",
 CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LLPlot", "[", 
  RowBox[{"x", ",", "12", ",", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", "0.3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1.4"}], "}"}], ",", 
   RowBox[{"PlotPoints", " ", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6955553828378906`*^9, 3.6955553890722656`*^9}, 
   3.6955555022910156`*^9, {3.6955558308222656`*^9, 3.6955558418691406`*^9}, {
   3.6955559495410156`*^9, 3.6955559570566406`*^9}, 3.695556310560547*^9, 
   3.695556382888672*^9, {3.695556500779297*^9, 3.695556509529297*^9}, {
   3.6956161581972656`*^9, 3.6956161816660156`*^9}, {3.8157072670625305`*^9, 
   3.815707307716799*^9}, 3.815708382159096*^9, {3.8157092906062965`*^9, 
   3.8157092985694346`*^9}},
 CellLabel->"In[14]:="],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJy0vXk0ld8b/20+5mhAQkpESsbmulWSUkhlKAmVBiWlUpQmaSBzQjJEKVGI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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFnAXYVcXXxe9748S8EoLdgCIiKhaIXWAgimJjIhImCiIKoohgi4nYia00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         "]], Polygon3DBox[CompressedData["
1:eJw1nHfgVuMbxs/7vuec9znn27CFNNDWEhmlzNIyEgklZVMykrKSjEpC9p6J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         "]], Polygon3DBox[CompressedData["
1:eJwt2Hd4VUUaB+CL5CZRRERxV6qE0EINvQWkhd5BKTZgARVQaQJSFBAURYpI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         "]]}]}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1kE1OAkEQhWtoJs7oWhOi/CgJrPQOcAQTOAA7IcETABfgBLoy7DiAJh5E
Xcw4kzEQJJqgByB+lWoXlffqVdXrqj4f3F6PSyLSJBxRPxC5CkROwXYk0oM/
ghk4JKbEM7WU5jwW+QZHaGuwFVmP9u9C479lkRPyDnypOrMV+D38JbbZJ/jd
oUiD2htamfwS/QFcoH+E1qPYR6/Sd8TSlZLtdRyZrv7q0YWfgRt2SrkpAVf4
fjnzv6C2h9e8T+bvapIXzm5PvP8ksHpO3Pg/yDzX+tz3uMje1Z1V13mdKXhv
i+drbH8yQwvAT7Qfdnt35qEz/zfl/g39nxX1NZiwUxiYzx/s1DxO
         "]], Polygon3DBox[CompressedData["
1:eJwtkUFOAkEQRWtoJtPjHhIjBowJrvAOcgQTPYA7MIEbwCVYwYq48wCaeAX3
migiQkI0bsAT+H6qFz9T3b/r1/81JzfDy0HFzBqgCkI0O8/MmoXZ5MDsme8H
99/B7K00y3KzEXwf7KhnvD+kXsEv4VdgEbznid4afBe+RT1Fbwu/hb/l7oX6
HWw4N9K8T+ocbk//D/Wc/k7mnuTtMXrvH2bveP8Q3UsPnFEfobOm7zd4hnvu
ruGuQD26x6/gevIu/iJzj/I6S/k1c5c8SUd68ip98dI4LXy+tDWjHT3jceFn
6bXT/E3ufgV576f3r6XnVe516fO0i27Kq7fKO0771j9YBt+P/s087VcZqtT/
L3A9Ww==
         "]], 
        Polygon3DBox[{{2519, 1002, 992, 281, 2012}, {2520, 1004, 996, 1821, 
         2714}, {1822, 383, 363, 1005, 1826}, {2520, 1824, 1820, 995, 2533}}],
         Polygon3DBox[{{2231, 1507, 1821, 996, 997, 2518}}]}]}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwd0ktLlGEYBuBHHUedUcdztRRUClqpgURCW4mgomW0iIJC0JYFgXbwkKeE
cJ+IuHBb4D8of0JhiClWBB46eCijrtfFPdf9fLwz837v9zXf6r/WVxQRi1Is
qTdKW1nEGZ5nNy/zKm/yDu/zISflsT7LGb7hApe5VRLxviJimzuypu/yu/yQ
j+af/CXr+h6bfXefB7Lh2iFX+Zt/5EhWzH/5T1qs/8xBGy8utReW8AkzfMpn
UqoPMcthlnGEPb57mI0Y46i5Pf0vPzmMcmue6x2ubXJMKlwbZ44TzHOSlZxi
FV/wi6z7jWlOsSCP9M7yiLts5XU28GLaO89yy/2cTHuXD/qOc1zmCvdcW9Lf
6W/TGZrnza/N58y75pfmV+ZtfYID5gfs423e4BVe4gV28TTnrZ+2x4a0lt/M
9fqpTEQdT7A2vRusYT0LrGU1q6SgV6bOPPPMMUePLObS+eluNer8x6y5ibYQ
9zyDXv1rekbmrHWOMjLMpHfTh1s8HtJ7+h/ppk6f
       "]], 
      Line3DBox[{1978, 221, 1995, 241, 261, 2012, 281, 2032, 301, 2052, 321, 
       2070, 341, 2087, 361, 480, 732, 381, 652, 523, 382, 1281, 383, 1822, 
       1022, 1826, 1005, 998, 2534, 997, 996, 1004, 2533, 995, 2523, 1003, 
       994, 1827, 993, 2526, 992, 1002, 2530, 991, 1001, 990, 2522, 1000, 988,
        2528, 989, 1978}]}, {
      Line3DBox[{1830, 2101, 1829, 2535, 2733, 1831, 2536, 2734, 1832, 2537, 
       2735, 1833, 2538, 2736, 1834, 2434, 2439, 2476, 2498, 2475, 2856, 1835,
        2435, 2436, 2305, 2372, 2414, 2371, 1836, 2843, 2329, 2330, 2328, 
       2461, 2460, 1837, 2487, 2488, 2865, 2486, 2415, 1838, 2539, 2737, 1839,
        2540, 2738, 1840, 2541, 2739, 1841, 2102, 1842, 2647, 2103, 1843, 
       2542, 2740, 1844, 2543, 2741, 1845, 2544, 2742, 1846, 2545, 2743, 1847,
        2104, 1848}], 
      Line3DBox[{1850, 2105, 1849, 2648, 2106, 1851, 2546, 2744, 1852, 2547, 
       2745, 1853, 2548, 2746, 1854, 2549, 2747, 1855, 2254, 2306, 2255, 2373,
        2374, 2635, 2832, 2246, 2307, 2247, 2470, 2375, 1856, 2454, 2471, 
       2863, 2256, 2453, 2257, 1857, 2489, 2748, 2643, 1858, 2550, 2749, 1859,
        2551, 2750, 1860, 2107, 1861, 2649, 2108, 1862, 2650, 2109, 1863, 
       2552, 2751, 1864, 2553, 2752, 1865, 2554, 2753, 1866, 2110, 1867}], 
      Line3DBox[{1869, 2111, 1868, 2651, 2112, 1870, 2652, 2113, 1871, 2555, 
       2754, 1872, 2556, 2755, 1873, 2557, 2756, 1874, 2437, 2114, 2438, 2857,
        2248, 2308, 2335, 2463, 2478, 2477, 2258, 2465, 2466, 2464, 2844, 
       2249, 2309, 2418, 2419, 2417, 2416, 2499, 2868, 2115, 1875, 2558, 2757,
        1876, 2559, 2758, 1877, 2116, 1878, 2653, 2117, 1879, 2654, 2118, 
       1880, 2655, 2119, 1881, 2560, 2759, 1882, 2561, 2760, 1883, 2120, 
       1884}], Line3DBox[{1886, 2121, 1885, 2656, 2122, 1887, 2657, 2123, 
       1888, 2658, 2124, 1889, 2562, 2761, 1890, 2563, 2762, 1891, 2125, 1892,
        2834, 2259, 2440, 2441, 2442, 2260, 2336, 2626, 2659, 2310, 2354, 
       2481, 2355, 2482, 2298, 2356, 2500, 2261, 2338, 2846, 2126, 1893, 2490,
        2491, 2866, 2127, 1894, 2564, 2763, 1895, 2128, 1896, 2660, 2129, 
       1897, 2661, 2130, 1898, 2662, 2131, 1899, 2663, 2132, 1900, 2565, 2764,
        1901, 2133, 1902}], 
      Line3DBox[{1904, 2134, 1903, 2664, 2135, 1905, 2665, 2136, 1906, 2666, 
       2137, 1907, 2667, 2138, 1908, 2566, 2765, 1909, 2139, 1910, 2628, 2668,
        2467, 2479, 2140, 2262, 2337, 2845, 2636, 2311, 2357, 2421, 2141, 
       2420, 2358, 2359, 2312, 2853, 2424, 2142, 2423, 2422, 2474, 2864, 2143,
        1911, 2669, 2144, 1912, 2145, 1913, 2670, 2146, 1914, 2671, 2147, 
       1915, 2672, 2148, 1916, 2673, 2149, 1917, 2674, 2150, 1918, 2151, 
       1919}], Line3DBox[{1921, 2152, 1920, 2567, 2766, 1922, 2568, 2767, 
       1923, 2569, 2768, 1924, 2570, 2769, 1925, 2571, 2770, 1926, 2153, 1927,
        2572, 2771, 1928, 2629, 2841, 2313, 2377, 2425, 2376, 1929, 2331, 
       2332, 2314, 2772, 2379, 2378, 1930, 2456, 2457, 2455, 2773, 2630, 1931,
        2492, 2493, 2867, 1932, 2154, 1933, 2675, 2155, 1934, 2573, 2774, 
       1935, 2574, 2775, 1936, 2575, 2776, 1937, 2502, 2777, 2644, 1938, 2503,
        2504, 2380, 2382, 2381, 1939}], Line3DBox[CompressedData["
1:eJwVzDlSQmEQAOExciFxwdDAwjI0Uw5gYCabXIBYQavUQK+BgrjiUiWXwFhR
UjYXjuJH0NX95s0/q6VKvjwVEbu4mI7Yn4mo8vFcxIG+1PN6iJpe4BHqepG/
caWX+AcNXfbumjcTEe+zER+48d3hHTtb5hnds9fgLHJYmeyaJfjX3jZedR4F
rKGFvp0UD3jDrTt96/4bn6GNc6xP/plX7N3ziXuH+kGf6iPd1En9h0e9zGM8
6U83vpB259l3Vw+92eMRF/nF/B9TOy0R
       "]], 
      Line3DBox[{1959, 2162, 1958, 2679, 2163, 1960, 2680, 2164, 1961, 2582, 
       2785, 1962, 2583, 2786, 1963, 2584, 2787, 1964, 2165, 1965, 2681, 2166,
        1966, 2835, 2268, 2443, 2269, 2480, 1967, 2341, 2270, 2316, 2271, 
       2848, 2468, 2390, 2391, 2334, 2469, 2251, 2317, 2252, 2839, 1968, 2272,
        2273, 2836, 1969, 2167, 1970, 2682, 2168, 1971, 2683, 2169, 1972, 
       2684, 2170, 1973, 2585, 2788, 1974, 2586, 2789, 1975, 2274, 2485, 2275,
        2517, 1976}], 
      Line3DBox[{1993, 2183, 1992, 2792, 2590, 1991, 2182, 2693, 1990, 2181, 
       2692, 1989, 2180, 2691, 1988, 2179, 2690, 1987, 2178, 1986, 2837, 2589,
        2393, 2278, 2448, 2300, 2360, 2833, 2637, 2318, 2253, 2342, 2277, 
       2445, 2444, 2858, 2392, 2276, 2299, 2177, 2689, 2632, 1985, 2176, 2688,
        1984, 2175, 1983, 2791, 2588, 1982, 2790, 2587, 1981, 2174, 2687, 
       1980, 2173, 2686, 1979, 2172, 2685, 1977, 2171, 2521}], 
      Line3DBox[{2010, 2200, 2009, 2199, 2704, 2008, 2198, 2703, 2007, 2197, 
       2702, 2006, 2196, 2701, 2005, 2195, 2700, 2004, 2194, 2497, 2496, 2003,
        2838, 2592, 2345, 2362, 2361, 2428, 2193, 2429, 2842, 2638, 2319, 
       2344, 2343, 2447, 2192, 2446, 2859, 2394, 2279, 2511, 2191, 2699, 2645,
        2002, 2190, 2698, 2001, 2189, 2000, 2793, 2591, 1999, 2188, 2697, 
       1998, 2187, 2696, 1997, 2186, 2695, 1996, 2185, 2694, 1994, 2184, 
       2529}], Line3DBox[{2030, 2202, 2029, 2807, 2603, 2028, 2806, 2602, 
       2027, 2805, 2601, 2026, 2804, 2600, 2025, 2803, 2599, 2024, 2281, 2280,
        2023, 2633, 2802, 2321, 2349, 2348, 2022, 2398, 2430, 2855, 2639, 
       2320, 2347, 2346, 2021, 2396, 2397, 2801, 2395, 2514, 2513, 2020, 2512,
        2800, 2646, 2019, 2799, 2598, 2018, 2201, 2017, 2798, 2597, 2016, 
       2797, 2596, 2015, 2796, 2595, 2014, 2795, 2594, 2013, 2794, 2593, 2011,
        2525}], 
      Line3DBox[{2050, 2208, 2049, 2818, 2612, 2048, 2817, 2611, 2047, 2816, 
       2610, 2046, 2815, 2609, 2045, 2207, 2707, 2044, 2284, 2403, 2405, 2404,
        2043, 2849, 2401, 2402, 2323, 2351, 2350, 2042, 2399, 2431, 2400, 
       2814, 2322, 2283, 2041, 2483, 2501, 2484, 2813, 2449, 2282, 2040, 2812,
        2608, 2039, 2206, 2706, 2038, 2205, 2037, 2811, 2607, 2036, 2810, 
       2606, 2035, 2809, 2605, 2034, 2808, 2604, 2033, 2204, 2705, 2031, 
       2531}], Line3DBox[{2068, 2217, 2067, 2825, 2618, 2066, 2824, 2617, 
       2065, 2823, 2616, 2064, 2216, 2713, 2063, 2215, 2712, 2062, 2291, 2408,
        2290, 2409, 2410, 2640, 2851, 2289, 2325, 2288, 2352, 2407, 2406, 
       2850, 2287, 2324, 2286, 2061, 2634, 2822, 2285, 2060, 2214, 2711, 2059,
        2213, 2710, 2058, 2212, 2057, 2821, 2615, 2056, 2820, 2614, 2055, 
       2819, 2613, 2054, 2211, 2709, 2053, 2210, 2532}], 
      Line3DBox[{2085, 2229, 2084, 2829, 2622, 2083, 2828, 2621, 2082, 2228, 
       2722, 2081, 2227, 2721, 2080, 2226, 2720, 2079, 2225, 2412, 2295, 2451,
        2303, 2860, 2365, 2364, 2326, 2294, 2363, 2302, 2450, 2459, 2861, 
       2641, 2411, 2293, 2301, 2224, 2719, 2292, 2078, 2223, 2718, 2077, 2222,
        2717, 2076, 2221, 2075, 2827, 2620, 2074, 2826, 2619, 2073, 2220, 
       2716, 2072, 2219, 2715, 2071, 2527}], 
      Line3DBox[{2100, 2245, 2099, 2831, 2625, 2098, 2244, 2732, 2097, 2243, 
       2731, 2096, 2242, 2730, 2095, 2241, 2297, 2840, 2304, 2240, 2353, 2370,
        2369, 2432, 2847, 2624, 2433, 2368, 2327, 2367, 2366, 2452, 2239, 
       2852, 2642, 2413, 2296, 2516, 2238, 2729, 2515, 2094, 2237, 2728, 2093,
        2236, 2727, 2092, 2235, 2091, 2830, 2623, 2090, 2234, 2726, 2089, 
       2233, 2725, 2088, 2232, 2724, 2524}]}, {
      Line3DBox[{1024, 1294, 1025, 2733, 1307, 1051, 1320, 2648, 1064, 1333, 
       2651, 1077, 1346, 2656, 1090, 1359, 2664, 1103, 1371, 1116, 2766, 1383,
        1130, 1396, 2676, 1143, 1407, 2679, 1156, 1419, 2685, 1170, 1431, 
       2694, 1184, 1443, 1198, 2794, 1455, 1212, 1467, 2705, 1825}], 
      Line3DBox[{1026, 1295, 1027, 2734, 1308, 1052, 2744, 1321, 1065, 1334, 
       2652, 1078, 1347, 2657, 1091, 1360, 2665, 1104, 1372, 1117, 2767, 1384,
        1131, 2778, 1397, 1144, 1408, 2680, 1157, 1420, 2686, 1171, 1432, 
       2695, 1185, 1444, 1199, 2795, 1456, 1213, 2808, 1468, 1225, 1481, 2709,
        1238, 1494, 2715, 1252, 1508, 2724, 1267, 1521, 1828}], 
      Line3DBox[{1028, 1296, 1029, 2735, 1309, 1053, 2745, 1322, 1066, 2754, 
       1335, 1079, 1348, 2658, 1092, 1361, 2666, 1105, 1373, 1118, 2768, 1385,
        1132, 2779, 1398, 1145, 2785, 1409, 1158, 1421, 2687, 1172, 1433, 
       2696, 1186, 1445, 1200, 2796, 1457, 1214, 2809, 1469, 1226, 2819, 1482,
        1239, 1495, 2716, 1253, 1509, 2725, 1268, 1522, 1282}], 
      Line3DBox[{1030, 1297, 1031, 2736, 1310, 1054, 2746, 1323, 1067, 2755, 
       1336, 1080, 2761, 1349, 1093, 1362, 2667, 1106, 1374, 1119, 2769, 1386,
        1133, 2780, 1399, 1146, 2786, 1410, 1159, 2790, 1422, 1173, 1434, 
       2697, 1187, 1446, 1201, 2797, 1458, 1215, 2810, 1470, 1227, 2820, 1483,
        1240, 2826, 1496, 1254, 1510, 2726, 1269, 1523, 1283}], 
      Line3DBox[CompressedData["
1:eJwVzrFKQmEYgOFP0EKPkGRbU2MX0NQ1GOli1lK2peQcBBm01BQNtdRShO15
AUYGNTi5eQVClDRIU9Dj8PC933/O4T8r9VblMBURZbLpiNJcxAkbrPNDg3sO
qLLFchLRNmskfLLHA7tsss0pOxS8nzf3eadOmT5vvLLqnb9MREUvsGgvmB8U
WaKZi5iYX3zP7vTPQ2dN37V0Mh+xNrvLPLafOT/y/Fxf6ra+0bf6Qj/qJ/1s
Tuxd/aJ75pV9oAf6Wo/0SN/psR7rjv7VU53hH945LS4=
       "]], Line3DBox[CompressedData["
1:eJwVzz1OAlEUBtA7oJBAJEFExUDUaG9oWAiKlT+JgJXRNRg7XYBWVkJcgBuQ
0oINkEhNQkEsjAVRD8WZ77vvzeS92b24aV4nEdEit+SRjUhIkaaej3jJRPTp
8cmYFQ7sfckCV5xwyu9yxFRW7f/pHf2QM4IiCe1cRFcecU6KMmkuqfm+JTfI
usumPKZivSK3uFucb69hrbq4l16TH2xTsr4j7/3bntzn1rlP5qJ3V3kw980l
fY03fWatrK8zMM/N7/5lqA/lo3mkj/RnfaJP9Ff9R//WM/wD/o0kyw==
       "]], Line3DBox[CompressedData["
1:eJwV0Dsvg2EYBuBH0oOoicRpkHYggkaEySISSXfxCyy6aP0GQUT8AZOxKXHo
wGSyOhQxNoKBpBMhEUMTV4cr93s/7/e975cvt1JeKnVERJFMIqI3GdEta10R
Weus9aV1Ih2R1/N6JRUxZz2bkXqPXtCH9YL+rvdR5ZAR8yO5bO9DJjjmhFNW
zDfkk3uS8ps1SpyxybO9lPyhzDo1tsiRdcenXKXIBdvtuxnlmnHP3Mh99+3I
MV64ZcLenazY220/yyt17jk335NfvmNSvvHAI53+TUu27E3Jea78j7p3Us6d
1hfaZ5k1zGasF2noB95pmvU7Y4CmWdXsz2xQH+LXLM0/ILI24w==
       "]], Line3DBox[CompressedData["
1:eJwVzrsrxWEYB/BHOY5LlFKKUkfKIKfTiVKHxWQWuyib+12ZJTEYDAazweSS
W2TxHziRy4RSZrczyOcMn77f5/e879svNTzRP14SEaNUl0bUJSJq5EFlREpP
6Zd6Wk/rN3pOz+mJZESfnq2S5r2yiAFzxjxo3jcPmUf0vHuN5jHzpPldbyLt
7KE84pgVu6Ss971bnnDKuu+rspweau2n5DRnrFHBJzPM0uDMefEubXwxxzwX
tNpvyHa+WWCRKzb5888Z+cMSy1yzRZZm93vlLXme/eO2LNDBS/FtZ+7kPR/2
O7KTVx54pMWZgt2u3sUbT8X3+OUfoRc2xQ==
       "]], Line3DBox[CompressedData["
1:eJwVzT8oxHEch/GP4oiBwVl1P0VKbrBeUiI3KcV+sjoZhdtsCiF/L2ysxORP
urJYrpQysPszmZTCy/D0eZ7vvftdZnJmrFgTEQU010ak6yJa3LPGiIQn/Jpn
eZbf8RzP8Xue53k+7k7rCV7gU26qPqKvKaKoZ/VpKqJTz+mSTnSrXtLLukun
9Zre1d26TZf1sX7Vb7jEFU68X3j/9L+9uh83OPde8b7CM//fc1cxgHk8oGJT
tVnnm9hAh+2gu4BHVG1ebLb4DrYxhEX02D65zzYfNnu8jH0M4we/uEW77bvd
t92BPsIhRjCKEr783oA/dG40vQ==
       "]], 
      Line3DBox[{1041, 1302, 1042, 1315, 2647, 1059, 1328, 2649, 1072, 1341, 
       2653, 1085, 1354, 2660, 1098, 1366, 2670, 1111, 1378, 1125, 1391, 2675,
        1138, 1402, 2677, 1151, 1414, 2682, 1165, 1426, 2690, 1179, 1438, 
       2700, 1193, 1450, 1207, 2803, 1462, 1220, 1476, 2707, 1233, 1489, 2712,
        1247, 1502, 2720, 1261, 1590, 1607, 2840, 1591, 1276, 1593, 1609, 
       1594, 1289}], 
      Line3DBox[{1043, 1303, 1044, 2740, 1316, 1060, 1329, 2650, 1073, 1342, 
       2654, 1086, 1355, 2661, 1099, 1367, 2671, 1112, 1379, 1126, 2774, 1392,
        1139, 1403, 2678, 1152, 1415, 2683, 1166, 1427, 2691, 1180, 1439, 
       2701, 1194, 1451, 1208, 2804, 1463, 1221, 2815, 1477, 1234, 1490, 2713,
        1248, 1503, 2721, 1262, 1516, 2730, 1277, 1529, 1290}], 
      Line3DBox[{1045, 1304, 1046, 2741, 1317, 1061, 2751, 1330, 1074, 1343, 
       2655, 1087, 1356, 2662, 1100, 1368, 2672, 1113, 1380, 1127, 2775, 1393,
        1140, 2783, 1404, 1153, 1416, 2684, 1167, 1428, 2692, 1181, 1440, 
       2702, 1195, 1452, 1209, 2805, 1464, 1222, 2816, 1478, 1235, 2823, 1491,
        1249, 1504, 2722, 1263, 1517, 2731, 1278, 1530, 1291}], 
      Line3DBox[{1047, 1305, 1048, 2742, 1318, 1062, 2752, 1331, 1075, 2759, 
       1344, 1088, 1357, 2663, 1101, 1369, 2673, 1114, 1381, 1128, 2776, 1394,
        1141, 2784, 1405, 1154, 2788, 1417, 1168, 1429, 2693, 1182, 1441, 
       2703, 1196, 1453, 1210, 2806, 1465, 1223, 2817, 1479, 1236, 2824, 1492,
        1250, 2828, 1505, 1264, 1518, 2732, 1279, 1531, 1292}], 
      Line3DBox[{1049, 1306, 1050, 2743, 1319, 1063, 2753, 1332, 1076, 2760, 
       1345, 1089, 2764, 1358, 1102, 1370, 2674, 1115, 1382, 1129, 2777, 1801,
        1802, 1395, 1142, 1807, 2871, 1808, 1406, 1155, 2789, 1418, 1169, 
       2792, 1430, 1183, 1442, 2704, 1197, 1454, 1211, 2807, 1466, 1224, 2818,
        1480, 1237, 2825, 1493, 1251, 2829, 1506, 1265, 2831, 1519, 1280, 
       1532, 1293}], 
      Line3DBox[{1284, 1524, 1270, 1511, 2830, 1255, 1497, 2827, 1241, 1484, 
       2821, 1228, 1471, 2811, 1216, 1459, 2798, 1202, 1447, 1188, 1435, 2793,
        1174, 1423, 2791, 1160, 1411, 2787, 1147, 1400, 2781, 1134, 1387, 
       2770, 1120, 1375, 1107, 1363, 2765, 1094, 1350, 2762, 1081, 1337, 2756,
        1068, 1324, 2747, 1055, 1311, 1730, 1788, 2856, 1787, 1032, 1298, 
       1735, 1734, 1546, 1611, 1612, 1610, 1641}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJyst+VTle/3/k0oIgKKCIhKI+YbA6VElqAiBkgooSBIqDQSCkoYNAJKiHR3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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0.1, 0.3}, {0.5, 1.4}, {1790.0746602116983`, 
   1795.7532143340131`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.82849214477402*^9},
 CellLabel->"Out[14]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 StyleBox["\n\n\nReferences\n\n", "SmallText",
  FontSize->12],
 StyleBox["Leser, C. E. V. (1961): 'A Simple Method of Trend Construction.' \
Journal of the Royal Statistical Society Series B (Methodological) Vol. 23, \
pp. 91-107. \n", "Notebook",
  FontFamily->"Arial"],
 "(Online at ",
 ButtonBox["https://www.jstor.org/stable/2983845",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.jstor.org/stable/2983845"], None},
  ButtonNote->"https://www.jstor.org/stable/2983845"],
 ").",
 StyleBox["\n\nLudsteck, Johannes (2005) HPFilter, ", "Notebook",
  FontFamily->"Arial"],
 StyleBox["Mathematica", "Notebook",
  FontFamily->"Arial",
  FontSlant->"Italic"],
 StyleBox[" package, Wolfram Library Archive Mathsource\n(Online at ", 
  "Notebook",
  FontFamily->"Arial"],
 ButtonBox["http://library.wolfram.com/infocenter/Demos/5161/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://library.wolfram.com/infocenter/Demos/5161/"], None},
  ButtonNote->"http://library.wolfram.com/infocenter/Demos/5161/"],
 StyleBox[")\n\nSchlicht, Ekkehart and Pauly, Ralf (1983): 'Descriptive \
Seasonal Adjustment by Minimizing Perturbations.' Empirica No. 1, pp. 15-28.\n\
(Online at ", "Notebook",
  FontFamily->"Arial"],
 ButtonBox["http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/\
schlicht-pauly-perturbations.pdf",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/\
schlicht-pauly-perturbations.pdf"], None},
  ButtonNote->
   "http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/\
schlicht-pauly-perturbations.pdf"],
 StyleBox[")\n\nSchlicht, Ekkehart (1984): 'Seasonal Adjustment in a \
Stochastic Model.' Statistical Papers Vol. 25, pp. 1-12. \n(Online at ", 
  "Notebook",
  FontFamily->"Arial"],
 ButtonBox["http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/\
schlicht_seasonal-adjustment-in-a-stochastic-model.pdf",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/\
schlicht_seasonal-adjustment-in-a-stochastic-model.pdf"], None},
  ButtonNote->
   "http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/\
schlicht_seasonal-adjustment-in-a-stochastic-model.pdf"],
 StyleBox[")\n  \nSchlicht, Ekkehart (2005): \[OpenCurlyQuote] Estimating the \
Smoothing Parameter in the So-called Hodrick-Prescott \
Filter\[CloseCurlyQuote], ", "Notebook",
  FontFamily->"Arial"],
 StyleBox["Journal of the Japan Statistical Society", "Notebook",
  FontFamily->"Arial",
  FontSlant->"Italic"],
 StyleBox[", 35(1), 2005, pp. 99-119. \n(Online at ", "Notebook",
  FontFamily->"Arial"],
 ButtonBox["http://www.scipress.org/journals/jjss/pdf/3501/35010099.pdf",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.scipress.org/journals/jjss/pdf/3501/35010099.pdf"], None},
  ButtonNote->"http://www.scipress.org/journals/jjss/pdf/3501/35010099.pdf"],
 ")",
 StyleBox["\n\nSchlicht, Ekkehart (2009):  \[OpenCurlyQuote]Trend Extraction \
from Time Series With Missing Observations and Structural Breaks, Journal of \
the Japan Statistical Society 2009, 38(2), 285-92.\n(Online at", "Notebook",
  FontFamily->"Arial"],
 ButtonBox[" https://doi.org/10.14490/jjss.38.285",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.14490/jjss.38.285"], None},
  ButtonNote->"https://doi.org/10.14490/jjss.38.285"],
 StyleBox[")", "Notebook",
  FontFamily->"Arial"],
 StyleBox["\n", "SmallText"],
 "\n\n",
 StyleBox["Acknowledgement\n",
  FontSize->12],
 "\nI thank Johannes Ludsteck for helpimg me with expert advice in preparing \
this package. \n\n\nEkkehart Schlicht,\nDepartment of Economics\nUniversity \
of Munich,\nGermany\nwww.semverteilung.vwl.uni-muenchen.de/ekkehart\n\n\
October 2005\nrevised July 2006, February 2017, November 2020.\n\n"
}], "SmallTextSans",
 PageWidth->WindowWidth,
 CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
 CellSize->{499, Inherited},
 CellChangeTimes->{{3.695628239100586*^9, 3.695628263663086*^9}, {
   3.695628298584961*^9, 3.695628398928711*^9}, {3.695628432303711*^9, 
   3.695628518631836*^9}, {3.695628559100586*^9, 3.695628602913086*^9}, {
   3.695628632944336*^9, 3.695628771413086*^9}, {3.6956288339941406`*^9, 
   3.6956289231816406`*^9}, 3.6956291221132812`*^9, {3.695629346584961*^9, 
   3.695629404084961*^9}, {3.695629441772461*^9, 3.695629451788086*^9}, {
   3.6956298540664062`*^9, 3.6956298631914062`*^9}, {3.695632265888672*^9, 
   3.695632274560547*^9}, 3.6956341647018986`*^9, {3.695635207603266*^9, 
   3.695635211353266*^9}, {3.695635253587641*^9, 3.695635269884516*^9}, {
   3.6956353384274845`*^9, 3.6956353781149845`*^9}, {3.6956354170993595`*^9, 
   3.6956354550681095`*^9}, {3.695875096195383*^9, 3.695875096632883*^9}, {
   3.6962130829765625`*^9, 3.6962131017734375`*^9}, {3.815707324683628*^9, 
   3.8157073480453243`*^9}, {3.815707413048156*^9, 3.8157075445204787`*^9}, {
   3.815707666708438*^9, 3.8157077025853033`*^9}, {3.815707739154214*^9, 
   3.8157078523752823`*^9}, {3.815707955818026*^9, 3.8157079739698577`*^9}, {
   3.8157080570011554`*^9, 3.8157080840419197`*^9}, 3.815797109177601*^9, {
   3.8158159681475506`*^9, 3.815816005374747*^9}, {3.815821480069087*^9, 
   3.8158215088838816`*^9}},
 TextJustification->1.,
 CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData["0000"], "Input",
 CellChangeTimes->{{3.8158037449087653`*^9, 3.8158037451583433`*^9}},
 CellLabel->"In[15]:="],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8284921450904813`*^9},
 CellLabel->"Out[15]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1264, 583},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], None, 
   Cell[
    TextData[{"The Season Package for ", 
      StyleBox["Mathematica", FontSlant -> "Italic"], 
      " by Ekkehart Schlicht"}], "PageHeader"]}, {
   Cell[
    TextData[{"The Season Package for ", 
      StyleBox["Mathematica", FontSlant -> "Italic"], 
      " by Ekkehart Schlicht"}], "PageHeader"], None, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792},
"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{50.375, 50.375}, {54, 36}}},
TaggingRules:>{
 "NextIndexingNumber" -> 2, "IndexEntries" -> {{"i:1", "HPFilter"}}},
ImageSize->{288, 288},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"HelpBrowser.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0"->{
  Cell[579, 22, 154, 4, 103, "Title",
   CellTags->"b:0"],
  Cell[736, 28, 358, 10, 55, "Text",
   CellTags->"b:0"],
  Cell[1097, 40, 2388, 60, 127, "Text",
   CellTags->"b:0"],
  Cell[3488, 102, 3033, 108, 188, "DefinitionBox",
   CellTags->{"i:1", "b:0"}],
  Cell[10128, 301, 63, 1, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[10194, 304, 339, 7, 27, "Input",
   CellTags->"b:0"],
  Cell[10536, 313, 237, 5, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[10776, 320, 5765, 86, 308, "Input",
   CellTags->"b:0"],
  Cell[16544, 408, 356, 9, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[16903, 419, 538, 15, 27, "Input",
   CellTags->"b:0"],
  Cell[17444, 436, 390, 14, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[63303, 1314, 369, 11, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[63675, 1327, 624, 16, 27, "Input",
   CellTags->"b:0"],
  Cell[64302, 1345, 563, 16, 55, "MathCaption",
   CellTags->"b:0"],
  Cell[104800, 2077, 1824, 61, 106, "DefinitionBox",
   CellTags->"b:0"],
  Cell[106627, 2140, 92, 2, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[108014, 2184, 516, 9, 90, "DefinitionBox",
   CellTags->"b:0"],
  Cell[108533, 2195, 92, 2, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[110264, 2249, 563, 22, 40, "DefinitionBox",
   CellTags->"b:0"],
  Cell[110830, 2273, 92, 2, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[111242, 2290, 1569, 59, 92, "DefinitionBox",
   CellTags->"b:0"],
  Cell[112814, 2351, 92, 2, 39, "MathCaption",
   CellTags->"b:0"],
  Cell[333321, 5968, 5351, 110, 624, "SmallTextSans",
   CellTags->"b:0"]},
 "i:1"->{
  Cell[3488, 102, 3033, 108, 188, "DefinitionBox",
   CellTags->{"i:1", "b:0"}]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0", 340148, 6131},
 {"i:1", 341711, 6178}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 154, 4, 103, "Title",
 CellTags->"b:0"],
Cell[736, 28, 358, 10, 55, "Text",
 CellTags->"b:0"],
Cell[1097, 40, 2388, 60, 127, "Text",
 CellTags->"b:0"],
Cell[3488, 102, 3033, 108, 188, "DefinitionBox",
 CellTags->{"i:1", "b:0"}],
Cell[6524, 212, 3601, 87, 159, "Text"],
Cell[10128, 301, 63, 1, 39, "MathCaption",
 CellTags->"b:0"],
Cell[10194, 304, 339, 7, 27, "Input",
 CellTags->"b:0"],
Cell[10536, 313, 237, 5, 39, "MathCaption",
 CellTags->"b:0"],
Cell[10776, 320, 5765, 86, 308, "Input",
 CellTags->"b:0"],
Cell[16544, 408, 356, 9, 39, "MathCaption",
 CellTags->"b:0"],
Cell[16903, 419, 538, 15, 27, "Input",
 CellTags->"b:0"],
Cell[17444, 436, 390, 14, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[17859, 454, 493, 11, 27, "Input"],
Cell[18355, 467, 36129, 627, 255, 18539, 336, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54521, 1099, 86, 1, 37, "Subsection"],
Cell[CellGroupData[{
Cell[54632, 1104, 91, 1, 33, "Subsubsection"],
Cell[54726, 1107, 3320, 81, 39, "MathCaption"],
Cell[58049, 1190, 86, 1, 23, "Text"],
Cell[CellGroupData[{
Cell[58160, 1195, 2422, 59, 88, "Input"],
Cell[60585, 1256, 2703, 55, 377, "Output"]
}, Open  ]],
Cell[63303, 1314, 369, 11, 39, "MathCaption",
 CellTags->"b:0"],
Cell[63675, 1327, 624, 16, 27, "Input",
 CellTags->"b:0"],
Cell[64302, 1345, 563, 16, 55, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[64890, 1365, 1403, 32, 70, "Input"],
Cell[66296, 1399, 37007, 641, 255, 18586, 337, "CachedBoxData", "BoxData", \
"Output"],
Cell[103306, 2042, 467, 10, 21, "Print"],
Cell[103776, 2054, 1009, 20, 21, "Print"]
}, Open  ]],
Cell[104800, 2077, 1824, 61, 106, "DefinitionBox",
 CellTags->"b:0"],
Cell[106627, 2140, 92, 2, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[106744, 2146, 879, 24, 48, "Input"],
Cell[107626, 2172, 373, 9, 19, "Message"]
}, Open  ]],
Cell[108014, 2184, 516, 9, 90, "DefinitionBox",
 CellTags->"b:0"],
Cell[108533, 2195, 92, 2, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[108650, 2201, 561, 17, 48, "Input"],
Cell[109214, 2220, 531, 11, 19, "Message"],
Cell[109748, 2233, 397, 9, 37, "Message"],
Cell[110148, 2244, 101, 2, 25, "Output"]
}, Open  ]],
Cell[110264, 2249, 563, 22, 40, "DefinitionBox",
 CellTags->"b:0"],
Cell[110830, 2273, 92, 2, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[110947, 2279, 165, 4, 27, "Input"],
Cell[111115, 2285, 112, 2, 25, "Output"]
}, Open  ]],
Cell[111242, 2290, 1569, 59, 92, "DefinitionBox",
 CellTags->"b:0"],
Cell[112814, 2351, 92, 2, 39, "MathCaption",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[112931, 2357, 766, 15, 27, "Input"],
Cell[113700, 2374, 219606, 3591, 295, 176787, 2887, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[333321, 5968, 5351, 110, 624, "SmallTextSans",
 CellTags->"b:0"],
Cell[CellGroupData[{
Cell[338697, 6082, 124, 2, 27, "Input"],
Cell[338824, 6086, 96, 2, 25, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
