*********************************************************
*EXAMPLE ANALYSIS 1
********************************************************

*1) TRANSITION TO FIRST UNION
***********************************************************

clear all
set mem 300m

	* Set path to directory where you stored Eventhistory.dta:
	global EHDIR "XXXXXXX"

	cd "$EHDIR"
	use "Eventhistory.dta", clear


* Reduce sample to population at risk
*******************************************


	g TEST=0
	stset END, fail(TEST) id (id)
	
	
	sort id
	by id: gen AGE14=168
	g YOUNG=1 if AGEANC==0 & UNIONORDER==1
	sort id
	by id: egen YOUNG_=min(YOUNG)
	stsplit inUNION if YOUNG_==1 , at (0.001) after (time=AGE14)		/// Give respondents that already are in a union when they turn 14 a very short process time to indclude them in the analyses of transition to first union.


	drop if AGEANC==0													/// Only keep episodes after 15th birthday of anchor
						
	drop START END
	rename _t0 START
	rename _t END

*Adjust time variable
		sort id START
		by id: egen TEST02=min(START)
		replace START=START-TEST02
		replace END=END-TEST02
	

 
	sort id START
	by id: g ORDER=_n													/// Generate a variable that facilitates generating time constant frequency distributions

	sort id START END
	
* Mark the last episode (row) before the event occurs
	g EVENT=0
	lab var EVENT "Transition to first union"
			by id: replace EVENT=1 if  UNIONORDER[_n+1]==1 & UNIONORDER==0		
			by id: replace EVENT=1 if  YOUNG_==1
		
		

	*Take forward information and drop all episodes after...
		stset END,f(id==0) time0(START) id(id)
		
		*...the event occurred	
		g UNIT1=1 if EVENT==1
		stfill UNIT1, forward
		by id: drop if UNIT1==1 & UNIT1[_n-1]==1
		
		*...the 2nd union started and thus the person is not at risk anymore to experience the transition to the first union anymore
		* This is of special importance in case the first union episode is missing. 
		* Later, we show that the survival rate is overestimated in these cases. We therefore recommend to drop these cases (see below and chapter 5.2 in Report)
		
		g UNIT2=1 if UNIONORDER>1		 
		stfill UNIT2, forward
		by id: drop if UNIT2==1 
		
		************************************************************************	
	stset END, f(EVENT==1) time0(START) id(id) exit (time 12*10)
	******************************************************

	sts graph, by (sex)
	
	sts list if sex==1, at (0 0.01 (1) 120)
	sts list if sex==2, at (0 0.01 (1) 120)
	
	* >> do a graph in Excel with the respective transition rates.
	
	
	* Does the missing episodes of first unions influence the results?
	tab FLAG_M_UNION if ORDER==1 
	* >> 158 persons have a missing first union episode. They should be dropped for analysis.
	drop if FLAG_M_UNION==1
	
	
	sts graph, by (sex)
	sts list if sex==1, at (0 0.01 (1) 120)
	sts list if sex==2, at (0 0.01 (1) 120)
	
	* >> add respective transition rates to the Excel graphic. 
	
	
	
	
	
	
	
	
