
*---------------------------------------------------------------------------------------
* Wave 			: 1 & 2
* Stata do-file	: biopart1-2.do
* Release 3.1 	: 15/12/2012 
*---------------------------------------------------------------------------------------
* >> content		
*	anchor-partner episodes data set "biopart"
*
* 3 main steps:
* 
* I) 	modifications/corrections wave 1 (release 1.0)
*			random imputation of missing months if year is known
*			anchor's sex (generated version) and generated variable "homosex" part of this data set as well 
* 			variable "indexp*": -4=-3  
* 			generated variables (i.e. "best solution") for sex and date of birth anchor and partner instead of original ones
*
* II) 	adding data from wave 2
*
* III) 	modifications / corrections wave 1 & 2 (release 2.0)
*---------------------------------------------------------------------------------------


version 11
clear all
set mem 300m


*--------------------------------------------------------------------------------------------------*
*--------------------------------------------------------------------------------------------------*
* STEP I) modifications/corrections wave 1 (release 1.0)
*--------------------------------------------------------------------------------------------------*
*--------------------------------------------------------------------------------------------------*

 
**** set path to directory where pairfam data are stored
	*global datapath "X:\pairfam_dta\"
	cd "$w1data_local_v3_1"
	use anchor1.dta, clear 
	label language de


**** values:
	* -77 :	left-censored; originally "Don't know" / "No answer" 
	* -88 :	right-censored; originally "Don't know" / "No answer" 
	* -99 :	right-censored; ongoing episode  		 
	* -3  : Does not apply 
	

**** dates: one variable; month and year combined 



* define data set
	keep id pid  											/// 		/* ID anchor and current partner */
	sex_gen													///			/* anchor's sex (generated version) */
	psex_gen												/// 		/* sex current partner (generated version) */
	sd5e*em sd5e*ey sd5e*bm sd5e*by 						/// 		/* episodes current partner */
	rtr1p*g 												/// 		/* sex previous partners */
	rtr2p*e*bm rtr2p*e*by rtr2p*e*em rtr2p*e*ey rtr4p* 		/// 		/* episodes previous partners (incl. type of break) */
	sd7e1 sd7e2 sd8e*bm sd8e*by sd8e*em sd8e*ey 			/// 		/* cohabitation current partner */
	rtr7p*e*bm rtr7p*e*by rtr7p*e*em rtr7p*e*ey 			/// 		/* cohabitation previous partners */
	sd12m sd12y sd13 										/// 		/* marriage current partner */
	rtr9 rtr10* rtr11* 										/// 		/* current marriage previous partners */
	rtr13p* rtr14p*bm rtr14p*by rtr15p* rtr14p*em rtr14p*ey /// 		/* previous marriages previous partners */
	pa2m pa2y pa3 											/// 		/* meeting current partner */
	dobm_gen doby_gen pdobm_gen pdoby_gen					/// 		/* date of birth anchor and current partner (generated versions) */
	intd intm inty 											/// 		/* date of interview */
	flag5-flag8 flag10 flag11 flag12 flag14					///			/* flag variables  */
	homosex																/* generated variable "Anchor homosexual" */ 

	
* format id 
	format id %12.3g



/*
months with ambiguous season information:
replace random variables with respect to sensible bounds

months with -1 or -2 and valid year: 
1) generate random variable between 1 and 12 for all variables indicating months
2) define adequate bounds if there is more than one relevant episode in the respective year
3) replace random variables with regard to bounds

leave cases with -1 / -2 if year is also -1/-2 

*/

* 1) create random variables
* examine how variables are sorted --> important for generating random variables!
qui desc, varlist
ret li
sort id
set seed 2594

** Create auxilliary vars with random elements on the interval [0;1] 
		
		*** vars with episodes
			forvalues j=1/8 {
				gen r_sd5e`j'bm=runiform() // random var for:	beginning relationship current partner
			}
			forvalues j=1/7 {
				gen r_sd5e`j'em=runiform() // random var for:	end relationship current partner
			}
			foreach z in b e {
				forvalues x=1/12 {
					forvalues j=1/8 {
						gen r_rtr2p`x'e`j'`z'm=runiform()
					}
				}
				forvalues j=1/5  {
					gen r_sd8e`j'`z'm=runiform()
				}
				forvalues x=1/8 {
					forvalues j=1/3 {
						gen r_rtr7p`x'e`j'`z'm=runiform()
					}
				}
				forvalues x=1/8 {
					gen r_rtr14p`x'`z'm=runiform()
				}
			}
			gen r_sd12m=runiform()
			gen r_rtr10m=runiform()
			
		*** vars without episodes
			gen r_pa2m=runiform()
			gen r_pdobm_gen=runiform()
			
			
* 2.a) transfer ambiguous "season" information to regular months
* random imputation within the following bounds:
* 		21: 1-2
*		24: 3-5
*		27: 6-8
*		30: 9-11
*		32: 12
	quietly ds *m pdobm_gen
		foreach var in `r(varlist)' {
			local ding:value label `var'
			if inlist("`ding'","liste10","liste22","liste23","liste86","dobm_genlbl") { 
				gen orig_`var'=`var'
				count if inlist(`var',21,24,27,30,32)
				cap noi gen `var'_help21= 1+int((2 - 1 + 1) * r_`var') // intervall [1;2]
				cap noi gen `var'_help24= 3+int((5 - 3 + 1) * r_`var') // intervall [3;5]
				cap noi gen `var'_help27= 6+int((8 - 6 + 1) * r_`var') // intervall [6;8]
				cap noi gen `var'_help30= 9+int((11 - 9 + 1) * r_`var') // intervall [9;11]
				cap noi gen `var'_help32= 12 // intervall [12;12]
			*** fill in
			foreach x of numlist 21 24 27 30 32 {
				di "`x'"
				replace `var'= `var'_help`x' if `var' ==`x'
			}
			l `var' orig_`var' if orig_`var'==21
			l `var' orig_`var' if orig_`var'==24
			l `var' orig_`var' if orig_`var'==27
			l `var' orig_`var' if orig_`var'==30
			l `var' orig_`var' if orig_`var'==32
			}
		}
	drop *help21 *help24 *help27 *help30 *help32
		
	
/* 

2.b) define upper and lower bounds for months with -1/-2
lower bound: beginning/end has to be at least as high as (after) lower bound  --> maximum of relevant episodes
upper bound: beginning/end has to be at least as low as (before) upper bound  --> minimum of relevant episodes


**** relevant variables
	** current partner
		pdobm_gen: date of birth partner
		sd5ejbm/em: relationship
		pa2m: date of first meeting
		sd8ejbm/em: cohabitation
		sd12m: marriage
	** retro partner
		rtr2pxejbm/em: relationship
		rtr7pxejbm/em: cohabitation 
		rtr10m: current marriage
		rtr14pxbm/em: previous marriage


**** procedure:
a) information current partner (no episodes)
b) relationship episodes
c) cohabitation episodes
d) marriage episodes



a) information current partner (no episodes)
date of birth: no lower or upper bounds possible --> random for all cases
date of first meeting:
- lower bound: 
			month of birth anchor
			month of birth partner
- upper bound: 
			beginning relationship with same partner
			beginning cohabitation with same partner
			beginning marriage with same partner
			month of interview 
*/

* date of birth partner (-7 instead of -1 or -2)

	** show cases to impute and define problem indicator
		l id pdobm* if pdobm_gen==-7 & pdoby_gen  >0  // year has to be known
			* NO CASES!
		gen probl_pdobm=1		if pdobm_gen==-7 & pdoby_gen  >0 
		tab1 probl*, m
		* no cases --> no imputation necessary
	

* date of first meeting

	** show cases to impute and define problem indicator
		l id pa2* if (pa2m==-1 | pa2m==-2) & pa2y  >0  // year has to be known
		gen probl_pa2=1		if (pa2m==-1 | pa2m==-2) & pa2y  >0 
		tab probl_pa2, m
		
	*** 1) month of first meeting
			* unknown: pa2m (=-1 | -2)

	** 1.a) lower bound:
	* help1_*_lb: month of birth anchor
		gen help1_lb=dobm_gen if pa2y==doby_gen & pa2y>0 & (pa2m==-1 | pa2m==-2) 
		tab help1, m
			* NO CASES
	* help2_*_lb: month of birth partner
		gen help2_lb=pdobm_gen if pa2y==pdoby_gen & pa2y>0 & (pa2m==-1 | pa2m==-2) 
		tab help2, m
			* NO CASES
	* define lower boundary
		egen pa2m_lb=rowmax(help1_* help2_*) // NO CASES!
		drop help*
	
	** 1.b) upper bound:
	* help1_*_ub: beginning relationship with same partner
		forvalues j=1/8 {
			cap noi gen help1_`j'_ub=sd5e`j'bm if pa2y==sd5e`j'by & pa2y>0 & (pa2m==-1 | pa2m==-2) & sd5e`j'bm>0 
		}
		tab1 help1*, m
		egen rownonmiss_help1=rownonmiss(help1*)
		tab rownonmiss_help1, m
		l pa2* sd5* help* if rownonmiss_help1>0
	* help2_*_ub: beginning cohabitation with same partner
		forvalues j=1/8 {
			cap noi gen help2_`j'_ub=sd8e`j'bm if pa2y==sd8e`j'by & pa2y>0 & (pa2m==-1 | pa2m==-2) & sd8e`j'bm>0 
		}
		tab1 help2*, m
		egen rownonmiss_help2=rownonmiss(help2*)
		tab rownonmiss_help2, m
		l pa2* sd8* help* if rownonmiss_help2>0
	* help3_*_ub: beginning marriage to same partner
		gen help3_ub=sd12m if pa2y==sd12y & pa2y>0 & (pa2m==-1 | pa2m==-2) & sd12m>0 
		tab1 help3*, m
		egen rownonmiss_help3=rownonmiss(help3*)
		tab rownonmiss_help3, m
		l pa2* sd12* help* if rownonmiss_help3>0
	* help4_*_ub: month of interview
		gen help4_ub=intm if pa2y==inty & pa2y>0 & (pa2m==-1 | pa2m==-2) 
		tab help4, m
		egen rownonmiss_help4=rownonmiss(help4*)
		tab rownonmiss_help4, m
		l pa2* int* help* if rownonmiss_help4>0
	* define upper boundary
		egen pa2m_ub=rowmin(help1_* help2_* help3_* help4_*) 
		tab pa2m_ub, m
		l pa2* help* if pa2m_ub!=. 
		drop help*
		drop rownonmiss*
		
	*** 3) fill in random months as boundaries if necessary 
	* define 12 as upper boundary and 1 as lower boundary if no special boundary has been defined
		recode pa2m_ub .=12
		tab pa2m_ub, m
		recode pa2m_lb .=1
		tab pa2m_lb, m
	* replace with random variable:
		gen help=  pa2m_lb+int((pa2m_ub  - pa2m_lb + 1) * r_pa2m)
		replace pa2m=help  if probl_pa2==1 // replace beginning with random variable
		drop help
	* check
		l pa2m orig_pa2m pa2m_lb pa2m_ub if probl_pa2==1
			
/*
b) relationship: 
- lower bound beginning:	
			end relationship with same partner (different partner okay) 
- upper bound beginning:
			beginning cohabitation with same partner 
			beginning marriage to same partner
			end same episode
			month of interview
- lower bound end: 
			beginning same episode
- upper bound end:	
			beginning relationship with same partner 					
			beginning cohabitation with different partner (assumption: cohabitation means having relationship with respective partner as well)
			beginning marriage to different partner
			month of interview
*/	
	
	
* relationship current partner:
	
	** show cases to impute and define problem indicator
		* beginning
		for num 1/8: cap noi l id sd5eXbm sd5eXby sd5eXem sd5eXey if (sd5eXbm==-1 | sd5eXbm==-2) & sd5eXby  >0  // year has to be known
		for num 1/8: cap noi gen probl_sd5b_X=1		if (sd5eXbm==-1 | sd5eXbm==-2) & sd5eXby  >0 
			* relevant ids:
			for num 1/8: cap noi l id if (sd5eXbm==-1 | sd5eXbm==-2) & sd5eXby  >0  // year has to be known
		* end
		for num 1/8: cap noi l id sd5eXbm sd5eXby sd5eXem sd5eXey	if (sd5eXem==-1 | sd5eXem==-2) & sd5eXey  >0  // year has to be known
		for num 1/8: cap noi gen probl_sd5e_X=1		if (sd5eXem==-1 | sd5eXem==-2) & sd5eXey  >0 
			* relevant ids:
			for num 1/8: cap noi l id 	if (sd5eXem==-1 | sd5eXem==-2) & sd5eXey  >0  // year has to be known
		tab1 probl*, m
		
	*** 1) beginning relationship
			* unknown: sd5e`j'bm (=-1 | -2)

	** 1.a) lower bound beginning: end relationship with same partner --> relevant for beginning 
	* help1_*_lb: end of different episode in same year as beginning
		forvalues j= 1/8 {
			forvalues i=1/8 {
				cap noi gen help1_`j'_`i'_lb=sd5e`i'em if sd5e`j'by==sd5e`i'ey & sd5e`j'by>0 & (sd5e`j'bm==-1 | sd5e`j'bm==-2) & `j'!=`i' & sd5e`i'em>0
			}
		}
		tab1 help*, m
		egen rownonmiss_help1=rownonmiss(help*)
		tab rownonmiss_help1, m
		l sd5* help* if rownonmiss_help1>0
			* NO CASES!
	* define lower boundary
		forvalues j= 1/8 {
			cap noi egen sd5e`j'bm_lb=rowmax(help1_`j'_*) // NO CASES!
		}
		drop help*
		drop rownonmiss*
	
	** 1.b)  upper bound beginning: 
	* help1_*_ub: beginning cohabitation with same partner in same year as beginning relationship
		forvalues j=1/8 {
			forvalues i=1/8 {
				cap noi gen help1_`j'_`i'_ub=sd8e`i'bm if sd5e`j'by==sd8e`i'by & sd5e`j'by>0 & (sd5e`j'bm==-1 | sd5e`j'bm==-2) & sd8e`i'bm>0
			}
		}
		tab1 help1*, m
		egen rownonmiss_help1=rownonmiss(help1*)
		tab rownonmiss_help1, m
		l sd5* sd8* help* if rownonmiss_help1>0
	* help2_*_ub: beginning marriage to same partner in same year as beginning relationship
		forvalues j=1/8 {
			cap noi gen help2_`j'_ub=sd12m if sd5e`j'by==sd12y & sd5e`j'by>0 & (sd5e`j'bm==-1 | sd5e`j'bm==-2) & sd12m>0
		}
		tab1 help2*, m
		egen rownonmiss_help2=rownonmiss(help2*)
		tab rownonmiss_help2, m
		l sd5* sd12* help* if rownonmiss_help2>0
	* help3_*_ub: end same episode 
		forvalues j=1/8 {
			cap noi gen help3_`j'_ub=sd5e`j'em if sd5e`j'by==sd5e`j'ey & (sd5e`j'bm==-1 | sd5e`j'bm==-2) & sd5e`j'em>0 
		}
		tab1 help3*, m
		egen rownonmiss_help3=rownonmiss(help3*)
		tab rownonmiss_help3, m
		l sd5* help* if rownonmiss_help3>0
	* help4_*_ub: month of interview
		forvalues j=1/8 {
			cap noi gen help4_`j'_ub=intm if inty==sd5e`j'by & (sd5e`j'bm==-1 | sd5e`j'bm==-2)
		}
		tab1 help4*, m
		egen rownonmiss_help4=rownonmiss(help4*)
		tab rownonmiss_help4, m
		l sd5* help* if rownonmiss_help4>0, ab(20)
	* define upper boundary
		forvalues j= 1/8 {
			cap noi egen sd5e`j'bm_ub=rowmin(help1_`j'_* help2_`j'_* help3_`j'_* help4_`j'_*) 
		}
		tab1 sd5*bm_ub, m
		l sd5* help* if sd5e1bm_ub!=. 
		drop help*
		drop rownonmiss*
		
	*** 2) end relationship
			* unknown: sd5e`j'em (=-1 | -2)

	** 2.a) lower bound end: beginning same episode  
		forvalues j= 1/8 {
			cap noi gen sd5e`j'em_lb=sd5e`j'bm if sd5e`j'by==sd5e`j'ey & (sd5e`j'em==-1 | sd5e`j'em==-2) & sd5e`j'bm>0
		}
		tab1 sd5*em_lb, m
		l sd5* if sd5e1em_lb!=.
		
	** 2.b) upper bound end: look at beginnings --> relevant for ends
	* help1_*_ub: beginning relationship with same partner (same variable)
		forvalues j= 1/8 {
			forvalues i=1/8 {
				cap noi gen help1_`j'_`i'_ub=sd5e`i'bm if sd5e`j'ey==sd5e`i'by & sd5e`j'ey>0 & (sd5e`j'em==-1 | sd5e`j'em==-2) & `j'!=`i' & sd5e`i'bm>0
			}
		}
		tab1 help1*, m
		egen rownonmiss_help1=rownonmiss(help1*)
		tab rownonmiss_help1, m
		l sd5* help1* if rownonmiss_help1>0
	* help2_*_ub: beginning cohabitation with different partner  (rtr7pxeibm)
		forvalues j= 1/15 {
			forvalues x=1/8 {
				forvalues i=1/3 {
					cap noi gen help2_`j'_`x'_`i'_ub=rtr7p`x'e`i'bm if sd5e`j'ey==rtr7p`x'e`i'by & rtr7p`x'e`i'by>0 & (sd5e`j'em==-1 | sd5e`j'em==-2) & rtr7p`x'e`i'bm>0
				}
			}
		}
		tab1 help2*, m
		egen rownonmiss_help2=rownonmiss(help2*)
			* NO CASES
	* help3_*_ub: beginning marriage to different partner (rtr14pxbm / rtr10m)
		forvalues j= 1/15 {
			forvalues x=1/8 {
				cap noi gen help3_1_`j'_`x'_ub=rtr14p`x'bm if sd5e`j'ey==rtr14p`x'by & rtr14p`x'by>0 & (sd5e`j'em==-1 | sd5e`j'em==-2) & rtr14p`x'bm>0
			}
		}
		forvalues j= 1/15 {
			forvalues x=1/8 {
				cap noi gen help3_2_`j'_`x'_ub=rtr10m if sd5e`j'ey==rtr10y & rtr10y>0 & (sd5e`j'em==-1 | sd5e`j'em==-2) & rtr10m>0
			}
		}
		tab1 help3*, m
		egen rownonmiss_help3_1=rownonmiss(help3_1*)
		egen rownonmiss_help3_2=rownonmiss(help3_2*)
		tab1 rownonmiss_help3*, m
			* NO CASES
	* help4_*_ub: month of interview
		forvalues j=1/8 {
			cap noi gen help4_`j'_ub=intm if inty==sd5e`j'ey & (sd5e`j'em==-1 | sd5e`j'em==-2)
		}
		tab1 help4*, m
		egen rownonmiss_help4=rownonmiss(help4*)
		tab rownonmiss_help4, m
			* NO CASES
	* define upper boundary
		forvalues j= 1/8 {
			cap noi egen sd5e`j'em_ub=rowmin(help1_`j'_* help2_1_`j'_* help2_2_`j'_* help3_1_`j'_* help3_2_`j'_* help4_`j'_*) 
		}
		tab1 sd5*_ub, m
		l sd5* if sd5e1em_ub!=.
	
	** test
		forvalues j=1/8 {
			l sd5* probl* if probl_sd5b_`j'==1 // beginning
		}
		forvalues j=1/8 {
			cap noi l sd5* probl* if probl_sd5e_`j'==1 // end
		}
	
	*** 3) fill in random months as boundaries if necessary 
	* check if there are cases with lb>ub
		forvalues j=1/8 {
			cap noi l id sd5* int* if sd5e`j'bm_lb>sd5e`j'bm_ub & sd5e`j'bm_lb!=. & sd5e`j'bm_ub!=., ab(20) // beginning
		}
				* no case
		forvalues j=1/8 {
			cap noi l id sd5* int* if sd5e`j'em_lb>sd5e`j'em_ub & sd5e`j'em_lb!=. & sd5e`j'em_ub!=., ab(20) // end
		}
				* no case
	* define 12 as upper boundary and 1 as lower boundary if no special boundary has been defined
		ds sd5*bm_ub sd5*em_ub 
		foreach var in `r(varlist)' {
			recode `var' .=12
		}
		tab1 sd5*ub, m
		ds sd5*bm_lb sd5*em_lb
		foreach var in `r(varlist)' {
			recode `var' .=1
		}
		tab1 sd5*lb, m
	* replace with random variable:
		** beginning
		drop help* 
		gen sd5e8bm_ub=12 // generate this variable (so far not existing)
		forvalues j=1/8 {
			cap noi gen help`j'=  sd5e`j'bm_lb+int((sd5e`j'bm_ub  - sd5e`j'bm_lb + 1) * r_sd5e`j'bm)
			cap noi replace sd5e`j'bm=help`j'  if probl_sd5b_`j'==1 // replace beginning with random variable
		}
		** end
		drop help* 
		forvalues j=1/7 {
			cap noi gen help`j'=  sd5e`j'em_lb+int((sd5e`j'em_ub  - sd5e`j'em_lb + 1) * r_sd5e`j'em)
			cap noi replace sd5e`j'em=help`j'  if probl_sd5e_`j'==1 // replace end with random variable
		} 
		drop help*
	* check:
	l id sd5* probl* if probl_sd5b_1==1, ab(20) // beginning
	* problematic cases bec. of multiple imputations: 
		* 365509000  
		replace sd5e2bm_lb=4 if id==365509000  // not same month; higher! 
		gen help=  sd5e2bm_lb+int((sd5e2bm_ub  - sd5e2bm_lb + 1) * r_sd5e2bm) if id==365509000 
		replace sd5e2bm=help  if id==365509000  // replace beginning with random variable
		l sd5* probl* if id==365509000  		
		drop help
		* 712668000 (end before beginning) --> beginning as lower bound for end
		replace sd5e1em_lb=sd5e1bm if id==712668000 
		gen help=  sd5e1em_lb+int((sd5e1em_ub  - sd5e1em_lb + 1) * r_sd5e1em) if id==712668000
		replace sd5e1em=help  if id==712668000 // replace beginning with random variable
		l sd5* probl* if id==712668000
		drop help
		* 742646000 --> end1 as lower bound for beg2 
		replace sd5e2bm_lb=sd5e1em if id==742646000
		gen help=  sd5e2bm_lb+int((sd5e2bm_ub  - sd5e2bm_lb + 1) * r_sd5e2bm) if id==742646000
		replace sd5e2bm=help  if id==742646000 // replace beginning with random variable
		l sd5* probl* if id==742646000
		drop help
	l id sd5* probl* orig_sd5* if probl_sd5b_2==1, ab(20) // beginning
		* end1 as lower bound for beg2
		foreach num of numlist  49346000 309631000 314508000 387717000 432025000 514138000 603689000 663682000 694420000 {
			replace sd5e2bm_lb=sd5e1em if id==`num'
			gen help=  sd5e2bm_lb+int((sd5e2bm_ub  - sd5e2bm_lb + 1) * r_sd5e2bm) if id==`num'
			replace sd5e2bm=help  if id==`num' // replace beginning with random variable
			l sd5* probl* if id==`num'
			drop help
		}
	l id sd5* probl* rtr7* rtr14* if probl_sd5e_1==1 // end
		* okay	
	l id sd5* probl* rtr7* rtr14*  if probl_sd5e_2==1 // end
		* okay


		
		
	
	
* relationship previous partner (rtr2pxejbm/em):
	
	** show cases to impute and define problem indicator
		* beginning
		forvalues x=1/12 {
			for num 1/5: cap noi l id rtr2p`x'eXbm rtr2p`x'eXby rtr2p`x'eXem rtr2p`x'eXey if (rtr2p`x'eXbm==-1 | rtr2p`x'eXbm==-2) & rtr2p`x'eXby >0  // year has to be known
			for num 1/5: cap noi gen probl_rtr2b_p`x'_X=1		if (rtr2p`x'eXbm==-1 | rtr2p`x'eXbm==-2) & rtr2p`x'eXby >0
		}
		* end
		forvalues x=1/12 {
			for num 1/5: cap noi l id rtr2p`x'eXbm rtr2p`x'eXby rtr2p`x'eXem rtr2p`x'eXey if (rtr2p`x'eXem==-1 | rtr2p`x'eXem==-2) & rtr2p`x'eXey >0  // year has to be known
			for num 1/5: cap noi gen probl_rtr2e_p`x'_X=1		if (rtr2p`x'eXem==-1 | rtr2p`x'eXem==-2) & rtr2p`x'eXey >0
		}
		tab1 probl_rtr2*, m

	
	*** 1) beginning relationship
			* unknown: rtr2pxejbm (=-1 | -2)

	** 1.a) lower bound beginning: end relationship with same partner --> relevant for beginning 
	* help1_*_lb: end of different episode in same year as beginning
		forvalues x=1/12 {
			forvalues j= 1/5 {
				forvalues i=1/5 {
					cap noi gen help1p`x'_`j'_`i'_lb=rtr2p`x'e`i'em if rtr2p`x'e`j'by==rtr2p`x'e`i'ey & rtr2p`x'e`j'by>0 & ///
																	(rtr2p`x'e`j'bm==-1 | rtr2p`x'e`j'bm==-2) & `j'!=`i' & rtr2p`x'e`i'em>0
				}
			}
		}
		tab1 help*, m
		drop rownonmiss*
		forvalues x=1/12 {
			egen rownonmiss_help1_p`x'=rownonmiss(help1p`x'*)
		}
		tab1 rownonmiss_help1*, m
		l rtr2* help* if rownonmiss_help1_p1>0, ab(20)
		l rtr2* help* if rownonmiss_help1_p3>0, ab(20)
		l rtr2* help* if rownonmiss_help1_p4>0, ab(20)
	* define lower boundary
		forvalues x=1/12 {
			forvalues j= 1/5 {
				cap noi egen rtr2p`x'e`j'bm_lb=rowmax(help1p`x'_`j'_*) 
			}
		}
		l rtr2* help* rtr2*_lb if rownonmiss_help1_p1>0, ab(20)
		l rtr2* help* rtr2*_lb if rownonmiss_help1_p3>0, ab(20)
		l rtr2* help* rtr2*_lb if rownonmiss_help1_p4>0, ab(20)
		drop help*
		drop rownonmiss*
		
		
	** 1.b)  upper bound beginning: 
	* help1_*_ub: beginning cohabitation with same partner in same year as beginning relationship
		forvalues x=1/12 {
			forvalues j=1/8 {
				forvalues i=1/8 {
					cap noi gen help1p`x'_`j'_`i'_ub=rtr7p`x'e`i'bm if rtr2p`x'e`j'by==rtr7p`x'e`i'by & rtr2p`x'e`j'by>0 & ///
																	(rtr2p`x'e`j'bm==-1 | rtr2p`x'e`j'bm==-2) & rtr7p`x'e`i'bm>0
				}
			}
		}
		tab1 help1*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help1_p`x'=rownonmiss(help1p`x'*)
		}
		tab1 rownonmiss_help1*, m
		forvalues x=1/6 {
			l rtr2* rtr7* help* if rownonmiss_help1_p`x'>0, ab(20)
		}
	* help2_*_ub: beginning marriage with same partner in same year as beginning relationship
		* case 1: current marriage
		forvalues x=1/12 {
			forvalues j=1/8 {
				forvalues i=1/8 {
					cap noi gen help2_1p`x'_`j'_`i'_ub=rtr10m if rtr9==`x' & rtr2p`x'e`j'by==rtr10y & rtr2p`x'e`j'by>0 & ///
																	(rtr2p`x'e`j'bm==-1 | rtr2p`x'e`j'bm==-2) & rtr10m>0
				}
			}
		}
		* case 2: previous marriage 
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi gen help2_2p`x'_`j'_`i'_ub=rtr14p`x'bm if rtr2p`x'e`j'by==rtr14p`x'by & rtr2p`x'e`j'by>0 & ///
																	(rtr2p`x'e`j'bm==-1 | rtr2p`x'e`j'bm==-2) & rtr14p`x'bm>0
			}
		}
		tab1 help2*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help2_p`x'=rownonmiss(help2_1p`x'* help2_2p`x'*)
		}
		tab1 rownonmiss_help2*, m
		forvalues x=1/4 {
			l rtr2* rtr10* rtr14* help* if rownonmiss_help2_p`x'>0, ab(20)
		}
	* help3_*_ub: end same episode 
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi gen help3p`x'_`j'_ub=rtr2p`x'e`j'em if rtr2p`x'e`j'by==rtr2p`x'e`j'ey & ///
																	(rtr2p`x'e`j'bm==-1 | rtr2p`x'e`j'bm==-2) & rtr2p`x'e`j'em>0 
			}
		}
		tab1 help3*, m
		forvalues x=1/12 {
			egen rownonmiss_help3_p`x'=rownonmiss(help3p`x'*)
		}
		tab1 rownonmiss_help3*, m
		forvalues x=1/3  {
			l rtr2* help* if rownonmiss_help3_p`x'>0, ab(20)
		}
	* help4_*_ub: month of interview
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi gen help4p`x'_`j'_ub=intm if inty==rtr2p`x'e`j'by & (rtr2p`x'e`j'bm==-1 | rtr2p`x'e`j'bm==-2) 
			}
		}
		tab1 help4*, m
		forvalues x=1/12 {
			egen rownonmiss_help4_p`x'=rownonmiss(help4p`x'*)
		}
		tab1 rownonmiss_help4*, m
		forvalues x=1/3  {
			l rtr2* help* if rownonmiss_help4_p`x'>0, ab(20)
		}
	* define upper boundary
		tab1 help*p1*, m
		forvalues x=1/12 {
			forvalues j= 1/8 {
				cap noi egen rtr2p`x'e`j'bm_ub=rowmin(help1p`x'_`j'_* help2_1p`x'_`j'_* help2_2p`x'_`j'_* help3p`x'_`j'_* help4p`x'_`j'_*) 
			}
		}
		tab1 rtr2*bm_ub, m
		l rtr2* help* if rownonmiss_help1_p1>0, ab(20)
		drop help*
		drop rownonmiss*	
		
		
	*** 2) end relationship
			* unknown: rtr2p`x'e`j'em (=-1 | -2)

	** 2.a) lower bound end: beginning same episode  
		forvalues x=1/12 {
			forvalues j= 1/8 {
				cap noi gen rtr2p`x'e`j'em_lb=rtr2p`x'e`j'bm if rtr2p`x'e`j'by==rtr2p`x'e`j'ey & ///
																	(rtr2p`x'e`j'em==-1 | rtr2p`x'e`j'em==-2) & rtr2p`x'e`j'bm>0
			}
		}
		tab1 rtr2p*em_lb, m
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi l rtr2p* if rtr2p`x'e`j'em_lb!=., ab(20)
			}
		}
		
	** 2.b) upper bound end: look at beginnings --> relevant for ends
	* help1_*_ub: beginning relationship with same partner (same variable)
		forvalues x=1/12 {
			forvalues j= 1/8 {
				forvalues i=1/8 {
					cap noi gen help1p`x'_`j'_`i'_ub=rtr2p`x'e`i'bm if rtr2p`x'e`j'ey==rtr2p`x'e`i'by & rtr2p`x'e`j'ey>0 & ///
																	(rtr2p`x'e`j'em==-1 | rtr2p`x'e`j'em==-2) & `j'!=`i' & rtr2p`x'e`i'bm>0
				}
			}
		}
		tab1 help1*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help1_p`x'=rownonmiss(help1p`x'*)
		}
		tab1 rownonmiss_help1*, m
			* NO CASES!
	* help2_*_ub: beginning cohabitation with different partner  (rtr7pxeibm / sd8)
		forvalues x=1/12 {
			forvalues y=1/12 { // different partner
				forvalues j= 1/5 {
					forvalues i=1/5 {
						cap noi gen help2_1p`x'_`j'_p`y'_`i'_ub=rtr7p`y'e`i'bm if rtr2p`x'e`j'ey==rtr7p`y'e`i'by & rtr7p`y'e`i'by>0 & ///
																	(rtr2p`x'e`j'em==-1 | rtr2p`x'e`j'em==-2) & `x'!=`y' & rtr7p`y'e`i'bm>0
					}
				}
			}
		}
		forvalues x=1/12 {
			forvalues j= 1/5 {
				forvalues i=1/5 {
					cap noi gen help2_2p`x'_`j'_`i'_ub=sd8e`i'bm if rtr2p`x'e`j'ey==sd8e`i'by & sd8e`i'by>0 & ///
																(rtr2p`x'e`j'em==-1 | rtr2p`x'e`j'em==-2) & sd8e`i'bm>0
				}
			}
		}
		tab1 help2*, m
		forvalues x=1/12 {
			egen rownonmiss_help2_1_p`x'=rownonmiss(help2_1p`x'*)
			egen rownonmiss_help2_2_p`x'=rownonmiss(help2_2p`x'*)
		}
		tab1 rownonmiss_help2*, m 
		l rtr2* rtr7* help2* if rownonmiss_help2_1_p1>0, ab(20)
		l rtr2* sd8* help2_2* if rownonmiss_help2_2_p1>0, ab(20)
		l rtr2* rtr7* help2* if rownonmiss_help2_1_p2>0, ab(20)
		l rtr2* sd8* help2_2* if rownonmiss_help2_2_p2>0, ab(20)
		l rtr2* sd8* help2_2* if rownonmiss_help2_2_p3>0, ab(20)
		l rtr2* sd8* help2_2* if rownonmiss_help2_2_p4>0, ab(20)
		l rtr2* sd8* help2_2* if rownonmiss_help2_2_p5>0, ab(20)
	* help3_*_ub: beginning marriage to different partner (rtr14pxbm / rtr10m / sd12m)
		forvalues x=1/12 {
			forvalues y=1/12 { // different partner
				forvalues j= 1/5 {
						cap noi gen help3_1p`x'_`j'_p`y'_`i'_ub=rtr14p`y'bm if rtr2p`x'e`j'ey==rtr14p`y'by & rtr14p`y'by>0 & ///
																	(rtr2p`x'e`j'em==-1 | rtr2p`x'e`j'em==-2) & `x'!=`y' & rtr14p`y'bm>0
				}
			}
		}
		forvalues x=1/12 {
				forvalues j= 1/5 {
						cap noi gen help3_2p`x'_`j'_p`y'_`i'_ub=rtr10m if rtr2p`x'e`j'ey==rtr10y & rtr10y>0 & ///
																	(rtr2p`x'e`j'em==-1 | rtr2p`x'e`j'em==-2) & rtr9!=`x' & rtr10m>0 
				}
		}
		forvalues x=1/12 {
				forvalues j= 1/5 {
						cap noi gen help3_3p`x'_`j'_p`y'_`i'_ub=sd12m if rtr2p`x'e`j'ey==sd12m & sd12y>0 & ///
																	(rtr2p`x'e`j'em==-1 | rtr2p`x'e`j'em==-2) & sd12m>0 
				}
		}
		tab1 help3*, m
		forvalues x=1/12 {
			egen rownonmiss_help3_1_p`x'=rownonmiss(help3_1p`x'*)
			egen rownonmiss_help3_2_p`x'=rownonmiss(help3_2p`x'*)
			egen rownonmiss_help3_3_p`x'=rownonmiss(help3_3p`x'*)
		}
		tab1 rownonmiss_help3*, m // 1 case
		l rtr2* rtr10* rtr14* help3* if rownonmiss_help3_1_p2>0, ab(20)
	* help4_*_ub: month of interview
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi gen help4p`x'_`j'_ub=intm if inty==rtr2p`x'e`j'ey & (rtr2p`x'e`j'em==-1 | rtr2p`x'e`j'em==-2) 
			}
		}
		tab1 help4*, m
		forvalues x=1/12 {
			egen rownonmiss_help4_p`x'=rownonmiss(help4p`x'*)
		}
		tab1 rownonmiss_help4*, m
		forvalues x=1/12  {
			l rtr2* help* if rownonmiss_help4_p`x'>0, ab(20)
		}
	* define upper boundary
		forvalues x=1/12 {
			forvalues j= 1/8 {
				cap noi egen rtr2p`x'e`j'em_ub=rowmin(help1p`x'_`j'_* help2_1p`x'_`j'_* help2_2p`x'_`j'_* help3_1p`x'_`j'_* ///
									help3_2p`x'_`j'_* help3_3p`x'_`j'_* help4p`x'_`j'_*) 
			}
		}
		tab1 rtr2*em_ub, m
		l rtr2* if rtr2p1e1em_ub!=., ab(20)
		l rtr2* if rtr2p2e1em_ub!=., ab(20)
		drop rownonmiss*	
	
	** test
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi l rtr2* probl* if probl_rtr2b_p`x'_`j'==1, ab(20) // beginning
			}
		}
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi l rtr2* probl* if probl_rtr2e_p`x'_`j'==1, ab(20) // end
			}
		}
		
	*** 3) fill in random months as boundaries if necessary 
	* check if there are cases with lb>ub
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi l id rtr2* int* if rtr2p`x'e`j'bm_lb>rtr2p`x'e`j'bm_ub & rtr2p`x'e`j'bm_lb!=. & rtr2p`x'e`j'bm_ub!=., ab(20) // beginning
			}
		}
			* no case
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi l id rtr2* int* if rtr2p`x'e`j'em_lb>rtr2p`x'e`j'em_ub & rtr2p`x'e`j'em_lb!=. & rtr2p`x'e`j'em_ub!=., ab(20) // beginning
			}
		}
			* no case
	* define 12 as upper boundary and 1 as lower boundary if no special boundary has been defined
		tab1 rtr2*_ub, m
		gen rtr2p7e1bm_ub=.  // generate missing variable
		ds rtr2*bm_ub rtr2*em_ub 
		foreach var in `r(varlist)' {
			recode `var' .=12
		}
		tab1 rtr2*ub, m
		ds rtr2*bm_lb rtr2*em_lb
		foreach var in `r(varlist)' {
			recode `var' .=1
		}
		tab1 rtr2*lb, m
		* replace with random variable:
		** beginning
		drop help* 
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi gen helpp`x'_`j'=  rtr2p`x'e`j'bm_lb+int((rtr2p`x'e`j'bm_ub  - rtr2p`x'e`j'bm_lb + 1) * r_rtr2p`x'e`j'bm)
				cap noi replace rtr2p`x'e`j'bm=helpp`x'_`j'  if probl_rtr2b_p`x'_`j'==1 // replace beginning with random variable
			}
		}
		** end
		drop help* 
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi gen helpp`x'_`j'=  rtr2p`x'e`j'em_lb+int((rtr2p`x'e`j'em_ub  - rtr2p`x'e`j'em_lb + 1) * r_rtr2p`x'e`j'em)
				cap noi replace rtr2p`x'e`j'em=helpp`x'_`j'  if probl_rtr2e_p`x'_`j'==1 // replace end with random variable
			}
		}
		drop help*
	
	** check cases with multiple imputations:
		tab1 probl_rtr2*, m
		* same episode: beginning and end random; beginning month larger than end month
		forvalues x=1/12 { // mark and count these cases
			forvalues j=1/8 {
				cap noi gen mark_p`x'_e`j'=1 if probl_rtr2b_p`x'_`j'==1 & probl_rtr2e_p`x'_`j'==1 & rtr2p`x'e`j'by==rtr2p`x'e`j'ey & ///
														rtr2p`x'e`j'bm>rtr2p`x'e`j'em
				cap noi count if mark_p`x'_e`j'==1
			}
		}
		tab1 mark*, m
		forvalues x=1/12 {  // define imputed beginning as lower boundary for end
			forvalues j=1/8 {
				cap noi replace rtr2p`x'e`j'em_lb=rtr2p`x'e`j'bm if mark_p`x'_e`j'==1
				cap noi gen help_p`x'_e`j'= rtr2p`x'e`j'em_lb+int((rtr2p`x'e`j'em_ub  - rtr2p`x'e`j'em_lb + 1) * r_rtr2p`x'e`j'em) if mark_p`x'_e`j'==1
				cap noi replace rtr2p`x'e`j'em=help_p`x'_e`j'  if mark_p`x'_e`j'==1 // replace beginning with random variable
			}
		}
		drop help*
		l mark* rtr2* if mark_p1_e1==1, ab(20)
		l mark* rtr2* if mark_p1_e2==1, ab(20)
		l mark* rtr2* if mark_p2_e1==1, ab(20)
		l mark* rtr2* if mark_p2_e2==1, ab(20)
		l mark* rtr2* if mark_p3_e1==1, ab(20)
		l mark* rtr2* if mark_p4_e1==1, ab(20)
		l mark* rtr2* if mark_p6_e1==1, ab(20)
		drop mark*	
		* different episodes: beginning of following episode before end of previous episode; same partner 
					* (overlapping relationships with different partners not unplausible)
			* first: bm episode i < em episode j (episodes not ordered!)
		forvalues x=1/12 { // mark and count these cases
			forvalues j=1/8 {
				forvalues i=1/8 {
					cap noi gen mark_p`x'_e`j'_e`i'=1 if probl_rtr2b_p`x'_`j'==1 & probl_rtr2e_p`x'_`i'==1 & rtr2p`x'e`i'by==rtr2p`x'e`j'ey & ///
														rtr2p`x'e`i'bm<rtr2p`x'e`j'em & `i'!=`j'
					cap noi count if mark_p`x'_e`j'_e`i'==1
				}
			}
		}
		tab1 mark*, m // no case
			* second: bm episode i > em episode j (episodes not ordered!)
		drop mark*
		forvalues x=1/12 { // mark and count these cases
			forvalues j=1/8 {
				forvalues i=1/8 {
					cap noi gen mark_p`x'_e`j'_e`i'=1 if probl_rtr2b_p`x'_`j'==1 & probl_rtr2e_p`x'_`i'==1 & rtr2p`x'e`i'by==rtr2p`x'e`j'ey & ///
														rtr2p`x'e`i'bm>rtr2p`x'e`j'em & `i'!=`j'
					cap noi count if mark_p`x'_e`j'_e`i'==1
				}
			}
		}
		tab1 mark*, m 
		l id mark* rtr2* if mark_p2_e1_e2==1, ab(20) // okay
	
		* check if all months have valid answers
		tab1 rtr2*p*bm, m
		forvalues x=1/12 {
			forvalues j=1/8 {
				cap noi l rtr2* r_rtr2p* if (rtr2p`x'e`j'bm==-1 | rtr2p`x'e`j'bm==-2) & probl_rtr2b_p`x'_`j'==1, ab(20)
			}
		}
	
	

/*	
c) cohabitation: 
- lower bound beginning:
			end cohabitation with same partner 
			end cohabitation with different partner
			end relationship with different partner
			beginning relationship to same partner (usually beginning relationship before cohabitation)
- upper bound beginning:
			end same episode
			month of interview
- lower bound end:
			beginning same episode
- upper bound end:	
			beginning cohabitation with same partner
			beginning cohabitation with different partner
			beginning marriage to different partner
			month of interview
*/	
	

* cohabitation current partner:
	
	** show cases to impute and define problem indicator
		* beginning
		tab1 sd8e*, m // 5 episodes max.
		* beginning
		for num 1/5: cap noi l id sd8eXbm sd8eXby sd8eXem sd8eXey if (sd8eXbm==-1 | sd8eXbm==-2) & sd8eXby  >0  // year has to be known
		for num 1/5: cap noi gen probl_sd8b_X=1		if (sd8eXbm==-1 | sd8eXbm==-2) & sd8eXby  >0 
			* relevant ids:
			for num 1/5: cap noi l id if (sd8eXbm==-1 | sd8eXbm==-2) & sd8eXby  >0  // year has to be known
		* end
		for num 1/5: cap noi l id sd8eXbm sd8eXby sd8eXem sd8eXey	if (sd8eXem==-1 | sd8eXem==-2) & sd8eXey  >0  // year has to be known
		for num 1/5: cap noi gen probl_sd8e_X=1		if (sd8eXem==-1 | sd8eXem==-2) & sd8eXey  >0 
			* relevant ids:
			for num 1/5: cap noi l id 	if (sd8eXem==-1 | sd8eXem==-2) & sd8eXey  >0  // year has to be known
		tab1 probl_sd8*, m
		

	*** 1) beginning cohabitation
			* unknown: sd8e`j'bm (=-1 | -2)

	** 1.a) lower bound beginning: 
	* help1_*_lb: end of different episode of cohabitation with same partner in same year as beginning
		forvalues j= 1/5 {
			forvalues i=1/5 {
				cap noi gen help1_`j'_`i'_lb=sd8e`i'em if sd8e`j'by==sd8e`i'ey & sd8e`j'by>0 & (sd8e`j'bm==-1 | sd8e`j'bm==-2) & `j'!=`i' & sd8e`i'em>0
			}
		}
		tab1 help*, m
		egen rownonmiss_help1=rownonmiss(help1*)
		tab rownonmiss_help1, m
		l id sd8* help* if rownonmiss_help1>0
			* 1 case		
	* help2_*_lb: end of cohabitation with different partner (rtr7px)
		forvalues x=1/12 {
			forvalues j= 1/5 {
				forvalues i=1/5 {
					cap noi gen help2_`j'_`x'_`i'_lb=rtr7p`x'e`i'em if sd8e`j'by==rtr7p`x'e`i'ey & sd8e`j'by>0 & (sd8e`j'bm==-1 | sd8e`j'bm==-2) & rtr7p`x'e`i'em>0
				}
			}
		}
		tab1 help*, m
		egen rownonmiss_help2=rownonmiss(help2*)
		tab rownonmiss_help2, m
			* NO CASES!
	* help3_*_lb: end of relationship with different partner (rtr2px)
		forvalues x=1/12 {
			forvalues j= 1/5 {
				forvalues i=1/5 {
					cap noi gen help3_`j'_`x'_`i'_lb=rtr2p`x'e`i'em if sd8e`j'by==rtr2p`x'e`i'ey & sd8e`j'by>0 & (sd8e`j'bm==-1 | sd8e`j'bm==-2) & rtr2p`x'e`i'em>0
				}
			}
		}
		tab1 help3*, m
		egen rownonmiss_help3=rownonmiss(help3*)
		tab rownonmiss_help3, m
			* 2 cases
	* help4_*_lb: beginning relationship with same partner 
		forvalues j= 1/5 {
			forvalues i=1/8 {
				cap noi gen help4_`j'_`i'_lb=sd5e`i'bm if sd8e`j'by==sd5e`i'by & sd8e`j'by>0 & (sd8e`j'bm==-1 | sd8e`j'bm==-2) & sd5e`i'bm>0
			}
		}
		tab1 help4*, m
		egen rownonmiss_help4=rownonmiss(help4*)
		tab rownonmiss_help4, m
		l id sd8* sd5* help4* if rownonmiss_help4>0, ab(20)
			* 33 cases
		* check: if additional episode with this partner in same year, no boundary
			replace help4_1_2_lb=. if id==49346000
			replace	help4_2_2_lb=. if id==663682000 
			replace help4_1_2_lb=. if id==742646000
	* define lower boundary
		forvalues j= 1/5 {
			cap noi egen sd8e`j'bm_lb=rowmax(help1_`j'_* help2_`j'_* help3_`j'_* help4_`j'_*) 
		}
		drop help*
		drop rownonmiss*
	
	** 1.b)  upper bound beginning: 
	* help1_*_ub: end same episode 
		forvalues j=1/5 {
			cap noi gen help1_`j'_ub=sd8e`j'em if sd8e`j'by==sd8e`j'ey & (sd8e`j'bm==-1 | sd8e`j'bm==-2) & sd8e`j'em>0 
		}
		tab1 help1*, m
		egen rownonmiss_help1=rownonmiss(help1*)
		tab rownonmiss_help1, m
		l sd8* help* if rownonmiss_help1>0
			* 1 case
	* help2_*_ub: month of interview
		forvalues j=1/5 {
			cap noi gen help2_`j'_ub=intm if inty==sd8e`j'by & (sd8e`j'bm==-1 | sd8e`j'bm==-2) 
		}
		tab1 help2*, m
		egen rownonmiss_help2=rownonmiss(help2*)
		tab rownonmiss_help2*, m
			* NO CASE
	* define upper boundary
		forvalues j= 1/5 {
			cap noi egen sd8e`j'bm_ub=rowmin(help1_`j'_* help2_`j'_*) 
		}
		tab1 sd8*bm_ub, m
		drop help*
		drop rownonmiss*
		
	*** 2) end cohabitation
			* unknown: sd8e`j'em (=-1 | -2)
	** 2.a) lower bound end: beginning same episode  
		forvalues j= 1/5 {
			cap noi gen sd8e`j'em_lb=sd8e`j'bm if sd8e`j'by==sd8e`j'ey & (sd8e`j'em==-1 | sd8e`j'em==-2) & sd8e`j'bm>0
		}
		tab1 sd8*em_lb, m
			* NO CASES
	** 2.b) upper bound end: look at beginnings --> relevant for ends
	* help1_*_ub: beginning cohabitation with same partner (same variable)
		forvalues j= 1/5 {
			forvalues i=1/5 {
				cap noi gen help1_`j'_`i'_ub=sd8e`i'bm if sd8e`j'ey==sd8e`i'by & sd8e`j'ey>0 & (sd8e`j'em==-1 | sd8e`j'em==-2) & `j'!=`i' & sd8e`i'bm>0
			}
		}
		tab1 help1*, m
		egen rownonmiss_help1=rownonmiss(help1*)
		tab rownonmiss_help1, m
			* NO CASES
	* help2_*_ub: beginning cohabitation with different partner  (rtr7pxeibm)
		forvalues j= 1/5 {
			forvalues x=1/8 {
				forvalues i=1/5 {
					cap noi gen help2_`j'_`x'_`i'_ub=rtr7p`x'e`i'bm if sd8e`j'ey==rtr7p`x'e`i'by & rtr7p`x'e`i'by>0 & (sd8e`j'em==-1 | sd8e`j'em==-2) & rtr7p`x'e`i'bm>0
				}
			}
		}
		tab1 help2*, m
		egen rownonmiss_help2=rownonmiss(help2*)
		tab rownonmiss_help2, m
			* 1 case
		l sd8* rtr7* help2* if rownonmiss_help2>0, ab(20)
	* help3_*_ub: beginning marriage to different partner (rtr14pxbm / rtr10m)
		forvalues j= 1/5 {
			forvalues x=1/8 {
				cap noi gen help3_1_`j'_`x'_ub=rtr14p`x'bm if sd8e`j'ey==rtr14p`x'by & rtr14p`x'by>0 & (sd8e`j'em==-1 | sd8e`j'em==-2) & rtr14p`x'bm>0
			}
		}
		forvalues j= 1/5 {
			forvalues x=1/8 {
				cap noi gen help3_2_`j'_`x'_ub=rtr10m if sd8e`j'ey==rtr10y & rtr10y>0 & (sd8e`j'em==-1 | sd8e`j'em==-2) & rtr10m>0
			}
		}
		tab1 help3*, m
		egen rownonmiss_help3_1=rownonmiss(help3_1*)
		egen rownonmiss_help3_2=rownonmiss(help3_2*)
		tab1 rownonmiss_help3*, m
			* NO CASES
	* help_*_ub: month of interview
		forvalues j=1/5 {
			cap noi gen help4_`j'_ub=intm if inty==sd8e`j'ey & (sd8e`j'em==-1 | sd8e`j'em==-2) 
		}
		tab1 help4*, m
		egen rownonmiss_help4=rownonmiss(help4*)
		tab rownonmiss_help4*, m
			* NO CASES
	* define upper boundary
		forvalues j= 1/5 {
			cap noi egen sd8e`j'em_ub=rowmin(help1_`j'_* help2_`j'_* help3_1_`j'_* help3_2_`j'_* help4_`j'_*) 
		}
		tab1 sd8*_ub, m
		l sd8* if sd8e2em_ub!=.
	
	** test
		forvalues j=1/8 {
			cap noi l sd8* probl_sd8* if probl_sd8b_`j'==1 // beginning
		}
		forvalues j=1/8 {
			cap noi l sd8* probl_sd8* if probl_sd8e_`j'==1 // end
		}
	*** 3) fill in random months as boundaries if necessary 
	* check if there are cases with lb>ub
		forvalues j=1/8 {
			cap noi l id sd8* int* if sd8e`j'bm_lb>sd8e`j'bm_ub & sd8e`j'bm_lb!=. & sd8e`j'bm_ub!=., ab(20) // beginning
		}
			* no case
		forvalues j=1/8 {
			cap noi l id sd8* int* if sd8e`j'em_lb>sd8e`j'em_ub & sd8e`j'em_lb!=. & sd8e`j'em_ub!=., ab(20) // end
		}
			* no case
	* define 12 as upper boundary and 1 as lower boundary if no special boundary has been defined
		tab1 sd8*_ub, m
		tab1 sd8*_lb, m
		* generate missing variables
		gen sd8e1bm_ub=.
		ds sd8*bm_ub sd8*em_ub 
		foreach var in `r(varlist)' {
			recode `var' .=12
		}
		ds sd8*bm_lb sd8*em_lb
		foreach var in `r(varlist)' {
			recode `var' .=1
		}
		tab1 sd8*lb, m
		tab1 sd8*ub, m
	* replace with random variable:
		** beginning
		drop help* 
		forvalues j=1/5 {
			cap noi gen help`j'=  sd8e`j'bm_lb+int((sd8e`j'bm_ub  - sd8e`j'bm_lb + 1) * r_sd8e`j'bm)
			cap noi replace sd8e`j'bm=help`j'  if probl_sd8b_`j'==1 // replace beginning with random variable
		}
		** end
		drop help* 
		forvalues j=1/5 {
			cap noi gen help`j'=  sd8e`j'em_lb+int((sd8e`j'em_ub  - sd8e`j'em_lb + 1) * r_sd8e`j'em)
			cap noi replace sd8e`j'em=help`j'  if probl_sd8e_`j'==1 // replace end with random variable
		} 
		drop help*
		drop rownonmiss*
		
	** check:
	l id sd8* probl_sd8* if probl_sd8b_1==1, ab(20)
		* problematic case: 503511000
		l id sd8* probl_sd8* if id==503511000
		replace sd8e2bm=sd8e2em if id==503511000 // replace beginning and end episode 2
		replace sd8e2em=6 if id==503511000
	l id sd8* probl_sd8* if probl_sd8b_2==1, ab(20)
	l id sd8* probl_sd8* if probl_sd8b_3==1, ab(20)
	l id sd8* probl_sd8* if probl_sd8b_4==1, ab(20)
	l id sd8* probl_sd8* if probl_sd8b_5==1, ab(20)
	l id sd8* probl_sd8* if probl_sd8e_2==1, ab(20)
	l id sd8* probl_sd8* if probl_sd8e_3==1, ab(20)
	l id sd8* probl_sd8* if probl_sd8e_4==1, ab(20)
	l id sd8* probl_sd8* if probl_sd8e_5==1, ab(20)
		
	
	
* cohabitation previous partner (rtr7pxejbm/em):
	
	** show cases to impute and define problem indicator
		* beginning
		forvalues x=1/8 {
			for num 1/3: cap noi l id rtr7p`x'eXbm rtr7p`x'eXby rtr7p`x'eXem rtr7p`x'eXey if (rtr7p`x'eXbm==-1 | rtr7p`x'eXbm==-2) & rtr7p`x'eXby >0  // year has to be known
			for num 1/3: cap noi gen probl_rtr7b_p`x'_X=1		if (rtr7p`x'eXbm==-1 | rtr7p`x'eXbm==-2) & rtr7p`x'eXby >0
		}
		* end
		forvalues x=1/8 {
			for num 1/3: cap noi l id rtr7p`x'eXbm rtr7p`x'eXby rtr7p`x'eXem rtr7p`x'eXey if (rtr7p`x'eXem==-1 | rtr7p`x'eXem==-2) & rtr7p`x'eXey >0  // year has to be known
			for num 1/3: cap noi gen probl_rtr7e_p`x'_X=1		if (rtr7p`x'eXem==-1 | rtr7p`x'eXem==-2) & rtr7p`x'eXey >0
		}
		tab1 probl_rtr7*, m	
		
	
	*** 1) beginning cohabitation
			* unknown: rtr7p`x'e`j'bm (=-1 | -2)

	** 1.a) lower bound beginning: 
	* help1_*_lb: end of different episode of cohabitation with same partner in same year as beginning
		forvalues x=1/8 {
			forvalues j= 1/3 {
				forvalues i=1/3 {
					cap noi gen help1p`x'_`j'_`i'_lb=rtr7p`x'e`i'em if rtr7p`x'e`j'by==rtr7p`x'e`i'ey & rtr7p`x'e`j'by>0 & ///
								(rtr7p`x'e`j'bm==-1 | rtr7p`x'e`j'bm==-2) & `j'!=`i' & rtr7p`x'e`i'em>0
				}
			}
		}
		tab1 help1*, m
		forvalues x=1/8 {
			cap noi egen rownonmiss_help1_p`x'=rownonmiss(help1p`x'*)
		}
		tab1 rownonmiss_help1*, m
			* NO CASES
	* help2_*_lb: end of cohabitation with different partner (rtr7pxeiem / sd8eiem)
		forvalues x=1/8 {
			forvalues y=1/8 {
				forvalues j= 1/3 {
					forvalues i=1/3 {
						cap noi gen help2_1p`x'_`j'_p`y'_`i'_lb=rtr7p`y'e`i'em if rtr7p`x'e`j'by==rtr7p`y'e`i'ey & rtr7p`x'e`j'by>0 & ///
								(rtr7p`x'e`j'bm==-1 | rtr7p`x'e`j'bm==-2) & `x'!=`y' & rtr7p`y'e`i'em>0  // previous partner
					}
				}
			}
		}
		forvalues x=1/8 {
			forvalues j= 1/3 {
				forvalues i=1/3 {
					cap noi gen help2_2p`x'_`j'_`i'_lb=sd8e`i'em if rtr7p`x'e`j'by==sd8e`i'ey & rtr7p`x'e`j'by>0 & ///
								(rtr7p`x'e`j'bm==-1 | rtr7p`x'e`j'bm==-2) & sd8e`i'em>0  // current partner
				}
			}
		}
		tab1 help2*, m
		forvalues x=1/8 {
			cap noi egen rownonmiss_help2_1_p`x'=rownonmiss(help2_1p`x'*)
			cap noi egen rownonmiss_help2_2_p`x'=rownonmiss(help2_2p`x'*)
		}
		tab1 rownonmiss_help2_1*, m
		tab1 rownonmiss_help2_2*, m
			* 3 cases
	* help3_*_lb: end of relationship with different partner (rtr2pxeiem / sd5eiem)
		forvalues x=1/12 {
			forvalues y=1/12 {
				forvalues j= 1/5 {
					forvalues i=1/5 {
						cap noi gen help3_1p`x'_`j'_p`y'_`i'_lb=rtr2p`y'e`i'em if rtr7p`x'e`j'by==rtr2p`y'e`i'ey & rtr7p`x'e`j'by>0 & ///
									(rtr7p`x'e`j'bm==-1 | rtr7p`x'e`j'bm==-2) & `x'!=`y' & rtr2p`y'e`i'em>0
					}
				}
			}
		}
		forvalues x=1/12 {
			forvalues j= 1/5 {
				forvalues i=1/5 {
					cap noi gen help3_2p`x'_`j'_`i'_lb=sd5e`i'em if rtr7p`x'e`j'by==sd5e`i'ey & rtr7p`x'e`j'by>0 & ///
									(rtr7p`x'e`j'bm==-1 | rtr7p`x'e`j'bm==-2) & sd5e`i'em>0
				}
			}
		}
		tab1 help3*, m
		forvalues x=1/8 {
			egen rownonmiss_help3_1_p`x'=rownonmiss(help3_1p`x'*)
			egen rownonmiss_help3_2_p`x'=rownonmiss(help3_2p`x'*)
		}
		tab1 rownonmiss_help3*, m
	* help4_*_lb: beginning relationship with same partner (rtr2pxeibm)
		forvalues x=1/12 {
			forvalues j= 1/5 {
				forvalues i=1/5 {
					cap noi gen help4p`x'_`j'_`i'_lb=rtr2p`x'e`i'bm if rtr7p`x'e`j'by==rtr2p`x'e`i'by & rtr7p`x'e`j'by>0 & ///
									(rtr7p`x'e`j'bm==-1 | rtr7p`x'e`j'bm==-2) & rtr2p`x'e`i'bm>0
				}
			}
		}
		tab1 help4*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help4_p`x'=rownonmiss(help4p`x'*)
		}
		tab1 rownonmiss_help4*, m
		l id rtr7* rtr2* help4* if rownonmiss_help4_p1>0, ab(20)
		l id rtr7* rtr2* help4* if rownonmiss_help4_p2>0, ab(20)
		l id rtr7* rtr2* help4* if rownonmiss_help4_p3>0, ab(20)
		l id rtr7* rtr2* help4* if rownonmiss_help4_p4>0, ab(20)
		l id rtr7* rtr2* help4* if rownonmiss_help4_p5>0, ab(20)
	* define lower boundary
		forvalues x=1/8 {
			forvalues j= 1/3 {
				cap noi egen rtr7p`x'e`j'bm_lb=rowmax(help1p`x'_`j'_* help2_1p`x'_`j'_* help2_2p`x'_`j'_* help3_1p`x'_`j'_* ///
												help3_2p`x'_`j'_* help4p`x'_`j'_*) 
			}
		}
		drop help*
		drop rownonmiss*
	
	** 1.b)  upper bound beginning: 
	* help1_*_ub: end same episode 
		forvalues x=1/8 {
			forvalues j=1/3 {
				cap noi gen help1p`x'_`j'_ub=rtr7p`x'e`j'em if rtr7p`x'e`j'by==rtr7p`x'e`j'ey & ///
									(rtr7p`x'e`j'bm==-1 | rtr7p`x'e`j'bm==-2) & rtr7p`x'e`j'em>0 
			}
		}
		tab1 help1*, m
		forvalues x=1/8 {
			cap noi egen rownonmiss_help1_p`x'=rownonmiss(help1p`x'*)
		}
		tab1 rownonmiss_help1*, m
		l id rtr7* help* if rownonmiss_help1_p1>0, ab(20)
		l id rtr7* help* if rownonmiss_help1_p2>0, ab(20)
	* help2_*_ub: month of interview
		forvalues x=1/8 {
			forvalues j=1/3 {
				cap noi gen help2p`x'_`j'_ub=intm if inty==rtr7p`x'e`j'by & (rtr7p`x'e`j'bm==-1 | rtr7p`x'e`j'bm==-2) 
			}
		}
		tab1 help2*, m
		forvalues x=1/8 {
			cap noi egen rownonmiss_help2_p`x'=rownonmiss(help2p`x'*)
		}
		tab1 rownonmiss_help2*, m
			* NO CASES
	* define upper boundary
		forvalues x=1/8 {
			forvalues j= 1/3 {
				cap noi egen rtr7p`x'e`j'bm_ub=rowmin(help1p`x'_`j'_* help2p`x'_`j'_*) 
			}
		}
		drop help*
		drop rownonmiss*

	
	*** 2) end cohabitation
		* unknown: rtr7p`x'e`j'em (=-1 | -2)

	** 2.a) lower bound end: beginning same episode  
		forvalues x=1/8 {
			forvalues j= 1/3 {
				cap noi gen rtr7p`x'e`j'em_lb=rtr7p`x'e`j'bm if rtr7p`x'e`j'by==rtr7p`x'e`j'ey & ///
													(rtr7p`x'e`j'em==-1 | rtr7p`x'e`j'em==-2) & rtr7p`x'e`j'bm>0
			}
		}
		tab1 rtr7*em_lb, m
			* 1 case
			
	
	** 2.b) upper bound end: look at beginnings --> relevant for ends
	* help1_*_ub: beginning cohabitation with same partner (same variable)
		forvalues x=1/8 {
			forvalues j= 1/3 {
				forvalues i=1/3 {
					cap noi gen help1p`x'_`j'_`i'_ub=rtr7p`x'e`i'bm if rtr7p`x'e`j'ey==rtr7p`x'e`i'by & rtr7p`x'e`j'ey>0 & ///
													(rtr7p`x'e`j'em==-1 | rtr7p`x'e`j'em==-2) & `j'!=`i' & rtr7p`x'e`i'bm>0
				}
			}
		}
		tab1 help1*, m
		forvalues x=1/8 {
			egen rownonmiss_help1_p`x'=rownonmiss(help1p`x'*)
		}
		tab1 rownonmiss_help1*, m
			* NO CASES
	* help2_*_ub: beginning cohabitation with different partner  (rtr7pxeibm / sd8eim)
		forvalues j= 1/5 {
			forvalues x=1/8 {
				forvalues y=1/8 {
					forvalues i=1/5 {
						cap noi gen help2_1p`x'_`j'_p`y'_`i'_ub=rtr7p`y'e`i'bm if rtr7p`x'e`j'ey==rtr7p`y'e`i'by & rtr7p`y'e`i'by>0 & ///
													(rtr7p`x'e`j'em==-1 | rtr7p`x'e`j'em==-2) & `x'!=`y' & rtr7p`y'e`i'bm>0
					}
				}
			}
		}
		forvalues j= 1/5 {
			forvalues x=1/8 {
				forvalues i=1/5 {
					cap noi gen help2_2p`x'_`j'_p`y'_`i'_ub=sd8e`i'bm if rtr7p`x'e`j'ey==sd8e`i'by & sd8e`i'by>0 & ///
													(rtr7p`x'e`j'em==-1 | rtr7p`x'e`j'em==-2) & sd8e`i'bm>0
				}
			}
		}
		tab1 help2*, m
		forvalues x=1/8 {
			egen rownonmiss_help2_1p`x'=rownonmiss(help2_1p`x'*)
			egen rownonmiss_help2_2p`x'=rownonmiss(help2_2p`x'*)
		}
		tab1 rownonmiss_help2_1*, m
			l id rtr7* help2_1* if rownonmiss_help2_1p2>0, ab(20)
		tab1 rownonmiss_help2_2*, m
			l id rtr7* sd8* help2_2* if rownonmiss_help2_2p1>0, ab(20)
	* help3_*_ub: beginning marriage to different partner (rtr14pxbm / rtr10m / sd12m)
		forvalues x=1/8 {
			forvalues y=1/8 {
				forvalues j= 1/5 {
					cap noi gen help3_1p`x'_`j'_`y'_ub=rtr14p`y'bm if rtr7p`x'e`j'ey==rtr14p`y'by & rtr14p`y'by>0 & ///
													(rtr7p`x'e`j'em==-1 | rtr7p`x'e`j'em==-2) & `x'!=`y' & rtr14p`y'bm>0
				}
			}
		}
		forvalues x=1/8 {
			forvalues j= 1/5 {
				cap noi gen help3_2p`x'_`j'_ub=rtr10m if rtr7p`x'e`j'ey==rtr10y & rtr10y>0 & ///
													(rtr7p`x'e`j'em==-1 | rtr7p`x'e`j'em==-2) & rtr10m>0
			}
		}
		forvalues x=1/8 {
			forvalues j= 1/5 {
				cap noi gen help3_3p`x'_`j'_ub=sd12m if rtr7p`x'e`j'ey==sd12y & sd12y>0 & ///
													(rtr7p`x'e`j'em==-1 | rtr7p`x'e`j'em==-2) & sd12m>0
			}
		}
		tab1 help3*, m
		forvalues x=1/8 {
			egen rownonmiss_help3_1p`x'=rownonmiss(help3_1p`x'*)
			egen rownonmiss_help3_2p`x'=rownonmiss(help3_2p`x'*)
			egen rownonmiss_help3_3p`x'=rownonmiss(help3_3p`x'*)
		}
		tab1 rownonmiss_help3*, m
			* NO CASES
	* help4_*_ub: month of interview
		forvalues x=1/8 {
			forvalues j=1/3 {
				cap noi gen help4p`x'_`j'_ub=intm if inty==rtr7p`x'e`j'ey & (rtr7p`x'e`j'em==-1 | rtr7p`x'e`j'em==-2) 
			}
		}
		tab1 help4*, m
		forvalues x=1/8 {
			cap noi egen rownonmiss_help4_p`x'=rownonmiss(help4p`x'*)
		}
		tab1 rownonmiss_help4*, m
			* NO CASES
	* define upper boundary
		forvalues x=1/8 {
			forvalues j= 1/5 {
				cap noi egen rtr7p`x'e`j'em_ub=rowmin(help1p`x'_`j'_* help2_1p`x'_`j'_* help2_2p`x'_`j'_* help3_1p`x'_`j'_* ///
													help3_2p`x'_`j'_* help3_3p`x'_`j'_* help4p`x'_`j'_*) 
			}
		}
		tab1 rtr7*em_ub, m
		l rtr7* if rtr7p1e1em_ub!=., ab(20)
			
	*** 3) fill in random months as boundaries if necessary 
	* check if there are cases with lb>ub
		forvalues x=1/8 {
			forvalues j=1/5 {
				cap noi l id rtr7* rtr2* sd5* rtr14* rtr10* sd12* int* if rtr7p`x'e`j'bm_lb>rtr7p`x'e`j'bm_ub & rtr7p`x'e`j'bm_lb!=. ///
										& rtr7p`x'e`j'bm_ub!=., ab(20) // beginning
			}
		}
			* 1 case
			* solution:
				replace rtr7p2e1bm_lb=.  if id==163951000 // end of same episode more important than beginning of relationship
		forvalues x=1/8 {
			forvalues j=1/5 {
				cap noi l id rtr7*  rtr2* sd5* rtr14* rtr10* sd12* int* if rtr7p`x'e`j'em_lb>rtr7p`x'e`j'em_ub & rtr7p`x'e`j'em_lb!=. ///
										& rtr7p`x'e`j'em_ub!=., ab(20) // end
			}
		}
			* no case
	* define 12 as upper boundary and 1 as lower boundary if no special boundary has been defined
		tab1 rtr7*_ub, m
		ds rtr7*bm_ub rtr7*em_ub 
		foreach var in `r(varlist)' {
			recode `var' .=12
		}
		tab1 rtr7*ub, m
		tab1 rtr7*_lb, m
		ds rtr7*bm_lb rtr7*em_lb
		foreach var in `r(varlist)' {
			recode `var' .=1
		}
		tab1 rtr7*lb, m
		* replace with random variable:
		** beginning
		drop help* 
		forvalues x=1/8 {
			forvalues j=1/5 {
				cap noi gen helpp`x'_`j'=  rtr7p`x'e`j'bm_lb+int((rtr7p`x'e`j'bm_ub  - rtr7p`x'e`j'bm_lb + 1) * r_rtr7p`x'e`j'bm)
				cap noi replace rtr7p`x'e`j'bm=helpp`x'_`j'  if probl_rtr7b_p`x'_`j'==1 // replace beginning with random variable
			}
		}
		** end
		drop help* 
		forvalues x=1/8 {
			forvalues j=1/5 {
				cap noi gen helpp`x'_`j'=  rtr7p`x'e`j'em_lb+int((rtr7p`x'e`j'em_ub  - rtr7p`x'e`j'em_lb + 1) * r_rtr7p`x'e`j'em)
				cap noi replace rtr7p`x'e`j'em=helpp`x'_`j'  if probl_rtr7e_p`x'_`j'==1 // replace end with random variable
			}
		}
		drop help*	
	* check cases with multiple imputations:
		tab1 probl_rtr7*, m
		* same episode: beginning and end random; beginning month larger than end month
		drop mark*
		forvalues x=1/8 { // mark and count these cases
			forvalues j=1/3 {
				cap noi gen mark_p`x'_e`j'=1 if probl_rtr7b_p`x'_`j'==1 & probl_rtr7e_p`x'_`j'==1 & rtr7p`x'e`j'by==rtr7p`x'e`j'ey & ///
														rtr7p`x'e`j'bm>rtr7p`x'e`j'em
				cap noi count if mark_p`x'_e`j'==1
			}
		}
		tab1 mark*, m
		forvalues x=1/8 {  // define imputed beginning as lower boundary for end
			forvalues j=1/5 {
				cap noi replace rtr7p`x'e`j'em_lb=rtr7p`x'e`j'bm if mark_p`x'_e`j'==1
				cap noi gen help_p`x'_e`j'= rtr7p`x'e`j'em_lb+int((rtr7p`x'e`j'em_ub  - rtr7p`x'e`j'em_lb + 1) * r_rtr7p`x'e`j'em) if mark_p`x'_e`j'==1
				cap noi replace rtr7p`x'e`j'em=help_p`x'_e`j'  if mark_p`x'_e`j'==1 // replace beginning with random variable
			}
		}
		drop help*
		l mark* rtr7* if mark_p1_e1==1, ab(20)
		l mark* rtr7* if mark_p1_e2==1, ab(20)
		l mark* rtr7* if mark_p2_e1==1, ab(20)
		l mark* rtr7* if mark_p2_e2==1, ab(20)
		l mark* rtr7* if mark_p3_e1==1, ab(20)
		l mark* rtr7* if mark_p4_e1==1, ab(20)
		l mark* rtr7* if mark_p6_e1==1, ab(20)
		drop mark*	
		* different episodes: beginning of following episode before end of previous episode; same or different partner 
			* first: bm episode i < em episode j (episodes not ordered!)
				* same partner
		forvalues x=1/8 { // mark and count these cases
			forvalues j=1/3 {
				forvalues i=1/3 {
					cap noi gen mark_p`x'_e`j'_e`i'=1 if probl_rtr7b_p`x'_`j'==1 & probl_rtr7e_p`x'_`i'==1 & rtr7p`x'e`i'by==rtr7p`x'e`j'ey & ///
														rtr7p`x'e`i'bm<rtr7p`x'e`j'em & `i'!=`j'
					cap noi count if mark_p`x'_e`j'_e`i'==1
				}
			}
		}
		tab1 mark*, m // no case
		drop mark*
				* different partner
		forvalues x=1/8 { // mark and count these cases
			forvalues y=1/8 {
				forvalues j=1/3 {
					forvalues i=1/3 {
						cap noi gen mark_p`x'_e`j'_p`y'_e`i'=1 if probl_rtr7b_p`x'_`j'==1 & probl_rtr7e_p`y'_`i'==1 & rtr7p`y'e`i'by==rtr7p`x'e`j'ey & ///
															rtr7p`y'e`i'bm<rtr7p`x'e`j'em & `x'!=`y'
						cap noi count if mark_p`x'_e`j'_p`y'_e`i'==1
					}
				}
			}
		}
		tab1 mark*, m // no case
			* second: bm episode i > em episode j (episodes not ordered!)
				* same partner
		drop mark*
		forvalues x=1/8 { // mark and count these cases
			forvalues j=1/5 {
				forvalues i=1/5 {
					cap noi gen mark_p`x'_e`j'_e`i'=1 if probl_rtr7b_p`x'_`j'==1 & probl_rtr7e_p`x'_`i'==1 & rtr7p`x'e`i'by==rtr7p`x'e`j'ey & ///
														rtr7p`x'e`i'bm>rtr7p`x'e`j'em & `i'!=`j'
					cap noi count if mark_p`x'_e`j'_e`i'==1
				}
			}
		}
		tab1 mark*, m // no case
				* different partner
		drop mark*
		forvalues x=1/8 { // mark and count these cases
			forvalues y=1/8 {
				forvalues j=1/5 {
					forvalues i=1/5 {
						cap noi gen mark_p`x'_e`j'_p`y'_e`i'=1 if probl_rtr7b_p`x'_`j'==1 & probl_rtr7e_p`y'_`i'==1 & rtr7p`y'e`i'by==rtr7p`x'e`j'ey & ///
														rtr7p`y'e`i'bm>rtr7p`x'e`j'em & `x'!=`y'
						cap noi count if mark_p`x'_e`j'_p`y'_e`i'==1
					}
				}	
			}
		}
		tab1 mark*, m 
		l id mark* rtr7* probl* if mark_p2_e1_p3_e1==1, ab(20) // okay
		l id mark* rtr7* probl* if mark_p3_e1_p2_e1==1, ab(20) // okay
		l id mark* rtr7* probl* if mark_p3_e1_p2_e2==1, ab(20) // okay
		
		

		
	
/*	
d) marriage:
- lower bound beginning:
			end relationship with different partner
			end cohabitation with different partner
			end marriage to different partner
			beginning relationship to same partner (usually beginning relationship before marriage)
- upper bound beginning:
			end same episode
			month interview if beginning marriage in same year as interview
- lower bound end: 
			beginning same episode
- upper bound end:	
			beginning marriage to same partner  
			beginning marriage to different partner
			month interview if end marriage in same year as interview


** current partner
sd12m: marriage (ONLY BEGINNING!)

** retro partner
rtr10m: current marriage (ONLY BEGINNING!)
rtr14pxbm/em: previous marriage	
*/



* marriage current partner (only beginning!):

	** show cases to impute and define problem indicator
		* beginning
		tab sd12m, m 
		* beginning
		l id sd12m sd12y if (sd12m==-1 | sd12m==-2) & sd12y  >0  // year has to be known
		gen probl_sd12=1		if (sd12m==-1 | sd12m==-2) & sd12y  >0 
			* relevant ids:
			l id if (sd12m==-1 | sd12m==-2) & sd12y  >0  // year has to be known
		
	*** 1) beginning marriage
			* unknown: sd12m (=-1 | -2)

	** 1.a) lower bound beginning: 
	* help1_*_lb: end of relationship with different partner (rtr2px)
		forvalues x=1/12 {
			forvalues i=1/5 {
				cap noi gen help1_`x'_`i'_lb=rtr2p`x'e`i'em if sd12y==rtr2p`x'e`i'ey & sd12y>0 & (sd12m==-1 | sd12m==-2) & rtr2p`x'e`i'em>0
			}
		}
		tab1 help1*, m
		egen rownonmiss_help1=rownonmiss(help1*)
		tab rownonmiss_help1, m
			* NO CASES
	* help2_*_lb: end of cohabitation with different partner (rtr7px)
		forvalues x=1/12 {
			forvalues i=1/5 {
				cap noi gen help2_`x'_`i'_lb=rtr7p`x'e`i'em if sd12y==rtr7p`x'e`i'ey & sd12y>0 & (sd12m==-1 | sd12m==-2) & rtr7p`x'e`i'em>0
			}
		}
		tab1 help2*, m
		egen rownonmiss_help2=rownonmiss(help2*)
		tab rownonmiss_help2, m
			* NO CASES!
	* help3_*_lb: end of marriage to different partner (only rtr14px; rtr10 does not have ends)
		forvalues x=1/12 {
			cap noi gen help3_`x'_lb=rtr14p`x'em if sd12y==rtr14p`x'ey & sd12y>0 & (sd12m==-1 | sd12m==-2) & rtr14p`x'em>0
		}
		tab1 help3*, m
			* NO CASES!
	* help4_*_lb: beginning relationship with same partner 
		forvalues i=1/8 {
			cap noi gen help4_`i'_lb=sd5e`i'bm if sd12y==sd5e`i'by & sd12y>0 & (sd12m==-1 | sd12m==-2) & sd5e`i'bm>0
		}
		tab1 help4*, m
		egen rownonmiss_help4=rownonmiss(help4*)
		tab rownonmiss_help4, m
		l id sd12* sd5* help4* if rownonmiss_help4>0, ab(20)
			* 4 cases
	* define lower boundary
		egen sd12m_lb=rowmax(help1_* help2_* help3_* help4_*) 
		drop help*
		drop rownonmiss*		


	** 1.b)  upper bound beginning: 
	* help1_*_ub: month of interview
		gen help1_ub=intm if inty==sd12y & (sd12m==-1 | sd12m==-2)  
		tab1 help1*, m
			* NO CASES
	* define upper boundary
		egen sd12m_ub=rowmin(help1*) 
		drop help*
	
	*** 3) fill in random months as boundaries if necessary 
	* check if there are cases with lb>ub
		l id sd12* if sd12m_lb>sd12m_ub & sd12m_lb!=. & sd12m_ub!=., ab(20) // beginning
			* no case
	* define 12 as upper boundary and 1 as lower boundary if no special boundary has been defined
		tab1 sd12*_ub, m // no cases
		tab1 sd12*_lb, m // 4 cases
		recode sd12m_ub .=12
		recode sd12m_lb .=1
	* replace with random variable:
		** beginning
		gen help=  sd12m_lb+int((sd12m_ub  - sd12m_lb + 1) * r_sd12m)
		replace sd12m=help  if probl_sd12==1 // replace beginning with random variable
		drop help*
		
	** check:
	l id sd12* probl_sd12* if probl_sd12==1, ab(20) // okay
		

		
* current marriage previous partner (only beginning!):

	** show cases to impute and define problem indicator
		* beginning
		tab rtr10m, m 
		* only 2 cases with -2 --> look at them individually
		l rtr10* rtr9 sd12* rtr14* rtr2* rtr7* sd5* if (rtr10m==-1 | rtr10m==-2) & rtr10y>0, ab(20) // only one case
			* no hint --> no special boundaries
		gen probl_rtr10=1		if (rtr10m==-1 | rtr10m==-2) & rtr10y  >0 
		
	*** 3) fill in random months as boundaries if necessary 
	* define 12 as upper boundary and 1 as lower boundary if no special boundary has been defined
		gen rtr10m_lb=1
		gen rtr10m_ub=12
	* replace with random variable:	
		gen help=  rtr10m_lb+int((rtr10m_ub  - rtr10m_lb + 1) * r_rtr10m)
		replace rtr10m=help  if probl_rtr10==1 // replace beginning with random variable
		drop help*
		
	** check:
	l id rtr10* if probl_rtr10==1, ab(20) // okay
	
	
		
* previous marriage previous partner

	** show cases to impute and define problem indicator
		* beginning
		forvalues x=1/8 {
			cap noi l id rtr14p`x'bm rtr14p`x'by rtr14p`x'em rtr14p`x'ey if (rtr14p`x'bm==-1 | rtr14p`x'bm==-2) & rtr14p`x'by >0 // year has to be known
			cap noi gen probl_rtr14b_p`x'=1		if (rtr14p`x'bm==-1 | rtr14p`x'bm==-2) & rtr14p`x'by >0
		}
		* end
		forvalues x=1/8 {
			cap noi l id rtr14p`x'bm rtr14p`x'by rtr14p`x'em rtr14p`x'ey if (rtr14p`x'em==-1 | rtr14p`x'em==-2) & rtr14p`x'ey >0 // year has to be known
			cap noi gen probl_rtr14e_p`x'=1		if (rtr14p`x'em==-1 | rtr14p`x'em==-2) & rtr14p`x'ey >0
		}
		tab1 probl_rtr14*, m	
		
	*** 1) beginning marriage
			* unknown: rtr14pxm (=-1 | -2)

	** 1.a) lower bound beginning: 
	* help1_*_lb: end of relationship with different partner (rtr2px / sd5)
		forvalues x=1/12 {
			forvalues y=1/12 {
				forvalues i=1/5 {
					cap noi gen help1_1p`x'_`y'_`i'_lb=rtr2p`y'e`i'em if rtr14p`x'by==rtr2p`y'e`i'ey & rtr14p`x'by>0 & ///
															(rtr14p`x'bm==-1 | rtr14p`x'bm==-2) & `x'!=`y' & rtr2p`y'e`i'em>0
				}
			}
		}
		forvalues x=1/12 {
			forvalues i=1/5 {
				cap noi gen help1_2p`x'_`y'_`i'_lb=sd5e`i'em if rtr14p`x'by==sd5e`i'ey & rtr14p`x'by>0 & ///
															(rtr14p`x'bm==-1 | rtr14p`x'bm==-2) & sd5e`i'em>0
			}
		}
		tab1 help1*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help1_1_p`x'=rownonmiss(help1_1p`x'*)
			cap noi egen rownonmiss_help1_2_p`x'=rownonmiss(help1_2p`x'*)
		}
		tab1 rownonmiss_help1*, m
			* 3 cases
		l id rtr14* rtr2* sd5* help* if rownonmiss_help1_1_p2==1, ab(20)
		l id rtr14* rtr2* sd5* help* if rownonmiss_help1_1_p3==1, ab(20)
		l id rtr14* rtr2* sd5* help* if rownonmiss_help1_2_p2==1, ab(20)
	* help2_*_lb: end of cohabitation with different partner (rtr7px / sd8)
		forvalues x=1/12 {
			forvalues y=1/12 {
				forvalues i=1/5 {
					cap noi gen help2_1p`x'_`y'_`i'_lb=rtr7p`y'e`i'em if rtr14p`x'by==rtr7p`y'e`i'ey & rtr14p`x'by>0 & ///
															(rtr14p`x'bm==-1 | rtr14p`x'bm==-2) & `x'!=`y' & rtr7p`y'e`i'em>0
				}
			}
		}
		forvalues x=1/12 {
			forvalues i=1/5 {
				cap noi gen help2_2p`x'_`y'_`i'_lb=sd8e`i'em if rtr14p`x'by==sd8e`i'ey & rtr14p`x'by>0 & ///
															(rtr14p`x'bm==-1 | rtr14p`x'bm==-2) & sd8e`i'em>0
			}
		}
		tab1 help2*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help2_1_p`x'=rownonmiss(help2_1p`x'*)
			cap noi egen rownonmiss_help2_2_p`x'=rownonmiss(help2_2p`x'*)
		}
		tab1 rownonmiss_help2*, m
			* 1 case
		l id rtr14* rtr7* sd8* help* if rownonmiss_help2_2_p2==1, ab(20)
	* help3_*_lb: end of marriage to different partner: here not possible, other marriage variables don't have ends
	* help4_*_lb: beginning relationship with same partner 
		forvalues x=1/12 {
			forvalues i=1/8 {
				cap noi gen help4p`x'_`i'_lb=rtr2p`x'e`i'bm if rtr14p`x'by==rtr2p`x'e`i'by & rtr14p`x'by>0 & ///
															(rtr14p`x'bm==-1 | rtr14p`x'bm==-2) & rtr2p`x'e`i'bm>0
			}
		}
		tab1 help4*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help4_p`x'=rownonmiss(help4p`x'*)
		}
		tab1 rownonmiss_help4*, m
		l id rtr14* rtr2* help4* if rownonmiss_help4_p1>0, ab(20)
		l id rtr14* rtr2* help4* if rownonmiss_help4_p2>0, ab(20)
		l id rtr14* rtr2* help4* if rownonmiss_help4_p3>0, ab(20)
		l id rtr14* rtr2* help4* if rownonmiss_help4_p4>0, ab(20)
	* define lower boundary
		forvalues x=1/12 {
			cap noi egen rtr14p`x'bm_lb=rowmax(help1_1p`x'* help1_2p`x'* help2_1p`x'* help2_2p`x'* help4p`x'*) 
		}
		drop help*
		drop rownonmiss*

	** 1.b)  upper bound beginning: 
	* help1_*_ub: month of interview
		forvalues x=1/12 {
			cap noi gen help1p`x'_ub=intm if inty==rtr14p`x'by & (rtr14p`x'bm==-1 | rtr14p`x'bm==-2)
		}
		tab1 help1*, m
			* NO CASES
	* help2_*_ub: end same episode
		forvalues x=1/12 {
			cap noi gen help2p`x'_ub=rtr14p`x'em if rtr14p`x'by==rtr14p`x'ey & ///
									(rtr14p`x'bm==-1 | rtr14p`x'bm==-2) & rtr14p`x'em>0 
		}
		tab1 help2*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help2_p`x'=rownonmiss(help2p`x'*)
		}
		tab1 rownonmiss_help2*, m
			* NO CASES
	* define upper boundary
		forvalues x=1/12 {
			cap noi egen rtr14p`x'bm_ub=rowmin(help1p`x'* help2p`x'*) 
		}
		drop help*
	
	
	*** 2) end marriage
			* unknown: rtr14p`x'e`j'em (=-1 | -2)
			
	** 2.a) lower bound end: beginning same episode  
		forvalues x=1/12 {
			cap noi gen help1p`x'_lb=rtr14p`x'bm if rtr14p`x'by==rtr14p`x'ey & ///
									(rtr14p`x'em==-1 | rtr14p`x'em==-2) & rtr14p`x'bm>0 
		}
		tab1 help1*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help1_p`x'=rownonmiss(help1p`x'*)
		}
		tab1 rownonmiss_help1*, m
			* NO CASES
	* define lower boundary
		forvalues x=1/12 {
			cap noi egen rtr14p`x'em_lb=rowmin(help1p`x'*) 
		}
		drop help*
		drop rownonmiss*
	
	** 2.b) upper bound end: 
	* help1_*_ub: beginning marriage to different partner (sd12 / rtr10)
		forvalues x= 1/12 {
			cap noi gen help1_1p`x'_ub=sd12m if sd12y==rtr14p`x'ey & rtr14p`x'ey>0 & (rtr14p`x'em==-1 | rtr14p`x'em==-2) & sd12m>0
		}
		forvalues x= 1/12 {
			cap noi gen help1_2p`x'_ub=rtr10m if rtr10y==rtr14p`x'ey & rtr14p`x'ey>0 & (rtr14p`x'em==-1 | rtr14p`x'em==-2) & rtr10m>0
		}
		tab1 help1*, m
		forvalues x=1/12 {
			cap noi egen rownonmiss_help1_1_p`x'=rownonmiss(help1_1p`x'*)
			cap noi egen rownonmiss_help1_2_p`x'=rownonmiss(help1_2p`x'*)
		}
		tab1 rownonmiss_help1*, m
	* help2_*_ub: month of interview
		forvalues x=1/12 {
			cap noi gen help2p`x'_ub=intm if inty==rtr14p`x'ey & (rtr14p`x'em==-1 | rtr14p`x'em==-2)
		}
		tab1 help2*, m
	* define upper boundary
		forvalues x=1/12 {
			cap noi egen rtr14p`x'em_ub=rowmin(help1_1p`x'* help1_2p`x'* help2p`x'*) 
		}
		tab1 rtr14*em_ub, m

	*** 3) fill in random months as boundaries if necessary 
	* check if there are cases with lb>ub
		forvalues x=1/12 {
			cap noi l id rtr14* if rtr14p`x'bm_lb>rtr14p`x'bm_ub & rtr14p`x'bm_lb!=. & rtr14p`x'bm_ub!=., ab(20) // beginning
		}
			* no case
		forvalues x=1/12 {
			cap noi l id rtr14* if rtr14p`x'em_lb>rtr14p`x'em_ub & rtr14p`x'em_lb!=. & rtr14p`x'em_ub!=., ab(20) // end
		}
			* no case
	* define 12 as upper boundary and 1 as lower boundary if no special boundary has been defined
		tab1 rtr14*_ub, m
		tab1 rtr14*_lb, m
		ds rtr14*bm_ub rtr14*em_ub 
		foreach var in `r(varlist)' {
			recode `var' .=12
		}
		ds rtr14*bm_lb rtr14*em_lb
		foreach var in `r(varlist)' {
			recode `var' .=1
		}
		tab1 rtr14*lb, m
		tab1 rtr14*ub, m
	* replace with random variable:
		** beginning
		drop help* 
		forvalues x=1/12 {
			cap noi gen help`x'=  rtr14p`x'bm_lb+int((rtr14p`x'bm_ub  - rtr14p`x'bm_lb + 1) * r_rtr14p`x'bm)
			cap noi replace rtr14p`x'bm=help`x'  if probl_rtr14b_p`x'==1 // replace beginning with random variable
		}
		** end
		drop help* 
		forvalues x=1/12 {
			cap noi gen help`x'=  rtr14p`x'em_lb+int((rtr14p`x'em_ub  - rtr14p`x'em_lb + 1) * r_rtr14p`x'em)
			cap noi replace rtr14p`x'em=help`x'  if probl_rtr14e_p`x'==1 // replace beginning with random variable
		}
		drop help*
		drop rownonmiss*
		
	** check:
		tab1 probl_rtr14b*, m
		l id rtr14* probl_rtr14* if probl_rtr14b_p1==1, ab(20)
		l id rtr14* probl_rtr14* if probl_rtr14b_p2==1, ab(20)
			* problematic case: 488913000
			l id rtr14* probl_rtr14* if id==488913000
			replace rtr14p2bm=rtr14p2em if id==488913000 // replace beginning and end partner 2
			replace rtr14p2em=12 if id==488913000
		l id rtr14* probl_rtr14* if probl_rtr14b_p3==1, ab(20)
		l id rtr14* probl_rtr14* if probl_rtr14b_p4==1, ab(20)
			* problematic case: 501551000
			l id rtr14* probl_rtr14* if id==501551000
			replace rtr14p4bm=rtr14p4em if id==501551000 // replace beginning and end partner 4
			replace rtr14p4em=11 if id==501551000
		l id rtr14* probl_rtr14* if probl_rtr14b_p5==1, ab(20)
		tab1 probl_rtr14e*, m
		l id rtr14* probl_rtr14* if probl_rtr14e_p1==1, ab(20)
		l id rtr14* probl_rtr14* if probl_rtr14e_p2==1, ab(20)
		l id rtr14* probl_rtr14* if probl_rtr14e_p3==1, ab(20)
		l id rtr14* probl_rtr14* if probl_rtr14e_p4==1, ab(20)



* delete auxiliary variables (just keep probl_* to identify these cases later on)
drop *_ub *_lb mark_* r_*





**************************************
* GENERAL INFORMATION
**************************************
		
* generate combined date of interview
	gen intdat=ym(inty, intm)
	lab var intdat "Date of interview"

* label id & pid
	lab var id "Person number anchor"
	lab var pid "Person number current partner"
		recode pid .=-3

* generate combined date of birth (anchor)
	tab1 doby_gen dobm_gen, m
	gen dob=ym(doby_gen, dobm_gen)
	lab var dob "Date of birth anchor" 
	tab dob, m

* sex anchor
	gen sex=sex_gen
	lab var sex "Sex anchor"

*--------------------------------------------------------------------------------------------------*


**************************************
* RELATIONSHIP HISTORY
**************************************


**************************************
**************************************
*** current relationship 
**************************************
**************************************


**************************************
* date of birth current partner
**************************************

tab1 pdobm_gen pdoby_gen, m

** inconsistent cases: see flag12
	l pdob* flag12 if flag12>0

** generate combined date	
	gen dobp0=ym(pdoby_gen, pdobm_gen) 
	replace dobp0=dobp0-ym(1900,1)	
	
** missing values
	forvalues i=-7/-1 {
		replace dobp0=`i' if (pdoby_gen==`i' & pdobm_gen==`i') |  pdoby_gen==`i'
	}
	tab dobp0, m	

* label	
	lab var dobp0 "Date of birth current partner"
		
	
	
**************************************
* sex current partner
**************************************

* generate new variable
	gen sexp0=psex_gen
	

* label
	lab var sexp0 "Sex current partner"


**************************************
* beginning and end current relationship
**************************************

* date beginning
	tab1 sd5e1by sd5e1bm, m
	gen begp0=ym(sd5e1by, sd5e1bm)
	tab begp0, m
	forvalues i=-5/-1 {
		replace begp0=`i' if sd5e1by==`i' & sd5e1bm==`i' 
	}
	tab begp0, m

* date end
	gen endp0=-99 
	replace endp0=-3 if begp0==-3

* labels
	lab var begp0 "Beginning relationship current partner"
	lab var endp0 "End relationship current partner"

	
**************************************
* date of meeting current partner
**************************************

* date
	gen meetp0=ym(pa2y, pa2m)
	forvalues i=-5/-1 {
		capture replace meetp0=`i' if pa2y==`i' & pa2m==`i'
	}	

* label
	lab var meetp0 "First meeting current partner"




**************************************
* way of meeting current partner
**************************************

gen waymeetp0=pa3 

* label
	lab var waymeetp0 "Way of meeting current partner"
	

**************************************
* breaks current relationship: beginning and end
**************************************

* interchange beginning and end (breaks)
	forvalues x=1/15 {
		foreach ding of any "b" "e" {
			if "`ding'"=="b" {
				local dong="e"
				local y=`x'
			}
			else {
				local dong="b"
				local y=`x'+1
			}
		capture gen b`x'p0`ding'm=sd5e`y'`dong'm
		capture gen b`x'p0`ding'y=sd5e`y'`dong'y
		capture gen b`x'p0beg=ym(b`x'p0by, b`x'p0bm)
		capture gen b`x'p0end=ym(b`x'p0ey, b`x'p0em)
		forvalues i=-5/-1 {
			capture replace b`x'p0beg=`i' if b`x'p0by==`i' & b`x'p0bm==`i'
			capture replace b`x'p0end=`i' if b`x'p0ey==`i' & b`x'p0em==`i'
		}	
	}
	}


	
*******************
*** check for inconsistencies
*******************

* check1: begp0 earliest date?
	gen m1=0
	
	* begp0 later than any end of separation?
		forvalues x=1/20 {
			capture replace m1=1 if (begp0>-1 & b`x'p0end>-1 & begp0>b`x'p0end) 
		}
		count if m1==1
			* 1 case
		list id sd5* orig*sd5* b*p0em b*p0ey begp0 b*p0beg b*p0end if m1==1
		* solution: change month slightly	
			* ID=655031000: sd5e1bm=27, sd5e1em=6 --> sd5e1bm=6 instead of 8
			replace begp0=b1p0beg if id==655031000 
			
	* begp0 later than any beginning of separation? 
		forvalues x=1/20 {
			capture replace m1=2 if (begp0>-1 & b`x'p0beg>-1 & begp0>b`x'p0beg) 
		}
		count if m1==2
			* no case
					
	* begp0 later than date of meeting?
		replace m1=3 if meetp0>begp0 & begp0>0 & meetp0>0
		count if m1==3
			* 107 cases 
		list id sd5* orig*sd5* b*p0em b*p0ey begp0 endp0 pa2y pa2m orig*pa2* b*p0beg b*p0end if m1==3
		tab orig_pa2m if m1==3, m
		tab orig_sd5e1bm if m1==3, m
		* assumption: pa2m=sd5e1bm if orig_pa2m -1/-2 or 21-30
			replace meetp0=begp0 if m1==3 & (orig_pa2m<0 | orig_pa2m>12) // 78 changes
		* assumption: sd5e1bm=pa2m if orig_sd5e1bm -1/-2 or 21-30
			replace begp0=meetp0 if m1==3 & (orig_sd5e1bm<0 | orig_sd5e1bm>12) & orig_pa2m>0 & orig_pa2m<20 // 29 changes
		list id sd5* orig*sd5* b*p0em b*p0ey begp0 endp0 pa2y pa2m orig*pa2* b*p0beg b*p0end if m1==3 & meetp0!=begp0 // okay


* check2: negative durations relationship episodes 
	gen m2=0
		forvalues x=1/10 {
			local y=`x'+1 
			capture replace m2=1 if (b`x'p0end>-1 & b`y'p0beg>-1 & b`x'p0end>b`y'p0beg) 
		}
		count if m2==1
			* 5 cases
		list m2 id sd5* b*p0beg b*p0end if m2==1
		* solution: correct order of breaks (beginning with earliest separation) 
		* save interim dataset
		* keep id and break variables
		* reshape in long format
		* sort in correct order according to beginning and end time
		* reshape in wide format in new order
		* erase interim files
		order b*p0beg, last
		order b*p0end, last
		quietly ds b1p0beg-b7p0end
		foreach var in `r(varlist)' {
			gen orig_`var'=`var' 
		}
		capture erase z1.dta
		capture erase z2.dta
		capture erase z3.dta
		save z1.dta, replace
		keep id b1p0beg-b7p0end m2
		save z2.dta, replace
		use z1.dta, clear
		drop b1p0beg-b7p0end m2
		save z3.dta, replace
		use z2.dta, clear
		reshape long b@p0beg b@p0end , i(id) j(episode)
		
		* indicator variable "yes" and "test1"
		gen yes=(bp0beg==-3)
		bysort id (yes bp0beg episode): gen test1=_n
		replace episode=test1 if m2==1
		drop test1
		drop yes
		reshape wide b@p0beg b@p0end , i(id) j(episode)
		merge id using z3.dta, sort
		* noisily tab _merge
		* all is fine
		drop _merge
		order b1p0beg-b7p0end, last
		forvalues x=1/15 {
			capture label var b`x'p0beg "Beginning break `x' relationship current partner"
			capture label var b`x'p0end "End break `x' relationship current partner"
		}
		capture erase z1.dta
		capture erase z2.dta
		capture erase z3.dta

	* check cases where beginning and end of second+ episodes are -1/-2 
	* cause problems when generating beginning / end
		forvalues j=1/7 {
			capture gen helpm2`j'=0
			capture replace helpm2`j'=1 if (b`j'p0beg==-1 | b`j'p0beg==-2) & (b`j'p0end==-1 | b`j'p0end==-2)
		}
		tab1 helpm2*, m
			* 37 cases
		l id begp* endp* b*p0beg b*p0end if helpm21==1
		l id begp* endp* b*p0beg b*p0end if helpm22==1
		* solution: delete these cases (-5); provide no information
			forvalues j=1/7 {
				foreach ding of any "beg" "end" {
					capture replace b`j'p0`ding'=-5 if helpm2`j'==1
				}
			}
			drop helpm2*

	* check if further problems due to -1/-2 (order not correct)
		list m2 id sd5* b*p0beg b*p0end orig_b*p0beg orig_b*p0end if m2==1, ab(20) 
			* 1 case left where changes are possible
		* change order
			foreach ding of any "beg" "end" {
				replace b2p0`ding'=b1p0`ding' if id==542823000	
				replace b1p0`ding'=b3p0`ding' if id==542823000
				replace b3p0`ding'=-5 if id==542823000
			}



* check3: negative durations separations
	gen m3=0
		forvalues x=1/10 {
			capture replace m3=1 if (b`x'p0beg>-1 & b`x'p0end>-1 & b`x'p0beg>b`x'p0end)
		}
		count if m3==1
			* 12 cases
		l id sd5* orig*sd5* begp0 b*p0beg b*p0end orig_b*p0beg orig_b*p0end if m3==1
		* originally ambiguous season information for month --> solution: interchange beginning and end (2 months apart)
			replace b1p0beg=b1p0end if id==15941000 | id==74703000 | id==78902000 | id==291345000
			replace b1p0end=b1p0beg+2 if id==15941000 | id==74703000 | id==78902000 | id==291345000
		* originally ambiguous season information for month --> solution: interchange beginning and end (1 month apart)
			replace b1p0beg=b1p0end if id==147577000 | id==242553000 | id==259502000 | id==264725000 | id==348646000 | id==382184000 ///
					| id==670244000 | id==693985000 
			replace b1p0end=b1p0beg+1 if id==147577000  | id==242553000 | id==259502000 | id==264725000 | id==348646000 | id==382184000 ///
					| id==670244000 | id==693985000 
	
			

			
* check4: inconsistencies across breaks 
	gen m4=0
		forvalues x=1/7 {
			local a=`x'+1
			forvalues b=`a'/7 {
				/* subsequent episode (beginning and end) before beginning and end of preceding episode */
				replace m4=1 if (b`x'p0beg>0 & b`b'p0beg>0 & b`x'p0end>0 & b`b'p0end>0 & b`b'p0beg<=b`x'p0beg & b`b'p0end<=b`b'p0end)
				/* subsequent episode (beginning and end) between beginning and end of preceding episode */
				replace m4=1 if (b`x'p0beg>0 & b`b'p0beg>0 & b`x'p0end>0 & b`b'p0end>0 & b`x'p0beg<=b`b'p0beg & b`x'p0end>=b`b'p0end)
				/* (only) beginning of subsequent episode before beginning of preceding episode */
				replace m4=1 if (b`x'p0beg>0 & b`b'p0beg>0 & b`b'p0beg<=b`x'p0beg)
				/* (only) beginning of subsequent episode before end of preceding episode */
				replace m4=1 if (b`x'p0end>0 & b`b'p0beg>0 & b`b'p0beg<=b`x'p0end)
				/* (only) end of subsequent episode before beginning of preceding episode */
				replace m4=1 if (b`x'p0beg>0 & b`b'p0end>0 & b`b'p0end<=b`x'p0beg)
				/* (only) end of subsequent episode before end of preceding episode */
				replace m4=1 if (b`x'p0end>0 & b`b'p0end>0 & b`b'p0end<=b`x'p0end)
				/* beginning and end of two episodes idntical */
				replace m4=1 if (b`x'p0beg>0 & b`b'p0beg>0 & b`x'p0end>0 & b`b'p0end>0 & b`b'p0beg==b`x'p0beg & b`b'p0end==b`b'p0end)
			}		
		}
		count if m4==1
		* no such case




**************************************
**************************************
*** previous relationships 
**************************************
**************************************

**************************************
* sex previous partners
**************************************

* new labels
	forvalues j=1/15 {
		capture gen sexp`j'=rtr1p`j'g 
	}
	tab1 sexp*, m

* 6/7 --> -3
	forvalues j=1/15 {
		capture replace sexp`j'=-3 if (sexp`j'==6 | sexp`j'==7)
	}
	tab1 sexp*, m	

	drop sexp13
	
* label
	forvalues j=1/12 {
		lab var sexp`j' "Sex partner `j'"
	}
	
	
**************************************
* beginning and end previous relationships
**************************************

************
*** beginning
************

* generate combined variable for date (for all episodes)
	forvalues x=1/12 {
		forvalues j=1/5 {
			forvalues i=-5/-1 {
				capture gen rtr2p`x'e`j'beg =ym(rtr2p`x'e`j'by, rtr2p`x'e`j'bm)
				capture replace rtr2p`x'e`j'beg=`i' if rtr2p`x'e`j'by==`i' & rtr2p`x'e`j'bm==`i'
			}
		}
	}

* check
	tab1 rtr2p*e*beg, m
	
* [note: earliest beginning for each partner identified after checking for inconsistencies!]


************
*** end
************

* generate combined variable for date (for all episodes)
	forvalues x=1/12 {
		forvalues j=1/5 {
			forvalues i=-5/-1 {
				capture gen rtr2p`x'e`j'end =ym(rtr2p`x'e`j'ey, rtr2p`x'e`j'em)
				capture replace rtr2p`x'e`j'end=`i' if rtr2p`x'e`j'ey==`i' & rtr2p`x'e`j'em==`i'
			}
		}
	}

* check
	tab1 rtr2p*e*end, m
	
* [note: latest end for each partner identified after checking for inconsistencies!]



*******************
*** check for inconsistencies
*******************

* check5: negative durations
	gen m5=0
	forvalues x=1/12 {
		forvalues j=1/5 {
			capture replace m5=1 if (rtr2p`x'e`j'beg>0 & rtr2p`x'e`j'end>0 & rtr2p`x'e`j'beg>rtr2p`x'e`j'end)	
	}
	}
	count if m5==1
		* 27 cases
	l id rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m5==1, ab(20)
		* problems due to -1/-2 for month
			* originally ambiguous season information for month --> solution: interchange beginning and end (1 month apart)
				replace rtr2p4e1beg=rtr2p4e1end if id==32927000 
				replace rtr2p4e1end=rtr2p4e1beg+1 if id==32927000 
				replace rtr2p1e1beg=rtr2p1e1end if id==71152000 | id==291499000 | id==342113000 | id==360576000 | id==405805000 ///
							| id==422762000 | id==463084000 | id==549280000 | id==563751000 | id==564998000 | id==628525000
				replace rtr2p1e1end=rtr2p1e1beg+1 if id==71152000 | id==291499000 | id==342113000 | id==360576000 | id==405805000 ///
							| id==422762000 | id==463084000 | id==549280000 | id==563751000 | id==564998000 | id==628525000
				replace rtr2p2e1beg=rtr2p2e1end if id==80766000 | id==157333000 | id==278575000 | id==362718000 | id==450207000 ///
							| id==660436000 | id==687904000
				replace rtr2p2e1end=rtr2p2e1beg+1 if id==80766000 | id==157333000 | id==278575000 | id==362718000 | id==450207000 ///
							| id==660436000 | id==687904000
				replace rtr2p3e2beg=rtr2p3e2end if id==139968000
				replace rtr2p3e2end=rtr2p3e2beg+1 if id==139968000
				replace rtr2p3e1beg=rtr2p3e1end if id==355898000
				replace rtr2p3e1end=rtr2p3e1beg+1 if id==355898000
				replace rtr2p1e2beg=rtr2p1e2end if id==653208000
				replace rtr2p1e2end=rtr2p1e2beg+1 if id==653208000
			* originally ambiguous season information for month --> solution: interchange beginning and end (2 months apart)	
				replace rtr2p3e1beg=rtr2p3e1end if id==32927000 
				replace rtr2p3e1end=rtr2p3e1beg+1 if id==32927000 
				replace rtr2p3e1beg=rtr2p3e1end if id==143990000 | id==305785000
				replace rtr2p3e1end=rtr2p3e1beg+2 if id==143990000 | id==305785000
				replace rtr2p2e2beg=rtr2p2e2end if id==235516000 | id==546667000
				replace rtr2p2e2end=rtr2p2e2beg+2 if id==235516000  | id==546667000
				replace rtr2p1e2beg=rtr2p1e2end if id==409394000
				replace rtr2p1e2end=rtr2p1e2beg+2 if id==409394000
	l id rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m5==1, ab(20)
	
		

**************************************
* separations previous relationships
**************************************

* generate variable: any break (at least 2 episodes)? k --> shows with which previous partner
	forvalues k=1/12 {
		capture gen break`k'=0
		capture replace break`k'=1 if rtr2p`k'e2bm!=-3 
	}
	tab1 break*, m



	
*******************
*** check for inconsistencies
*******************

* check6a-6h: inconsistencies across breaks

	* m6a: beginning and end of subsequent episode before beginning and end of preceding episode 
	gen m6a=0
		forvalues x=1/12 {
			forvalues j=1/5 {
				local a=`j'+1
				forvalues b=`a'/5 {
					capture replace m6a=1 if (rtr2p`x'e`j'beg>0 & rtr2p`x'e`b'beg>0 & rtr2p`x'e`b'beg<rtr2p`x'e`j'beg)	///
					& (rtr2p`x'e`j'end>0 & rtr2p`x'e`b'end>0 & rtr2p`x'e`b'end<rtr2p`x'e`j'end) 
				}
			}
		}
	count if m6a==1
		* 32 cases
	l id rtr2*beg rtr2*end if m6a==1
	* solution: correct order of these 32 cases (beginning with earliest break)
	* description of procedure see above
		order rtr2p*beg, last
		order rtr2p*end, last
		quietly ds rtr2p1e1beg-rtr2p12e1end
		foreach var in `r(varlist)' {
			gen orig_`var'=`var' 
		}
		capture erase z1.dta
		capture erase z2.dta
		capture erase z3.dta
		save z1.dta, replace
		keep id rtr2p1e1beg-rtr2p12e1end m6a
		save z2.dta, replace
		use z1.dta, clear
		drop rtr2p1e1beg-rtr2p12e1end m6a
		save z3.dta, replace
		use z2.dta, clear
		reshape long rtr2p@e1beg rtr2p@e2beg rtr2p@e3beg rtr2p@e4beg rtr2p@e5beg rtr2p@e1end rtr2p@e2end rtr2p@e3end rtr2p@e4end rtr2p@e5end , i(id) j(partner)
		reshape long rtr2pe@beg rtr2pe@end  , i(id partner) j(episode)
		gen yes=(rtr2pebeg<=-3)
		bysort id  partner (yes rtr2pebeg episode): gen test1=_n
		replace episode=test1 if m6a==1
		drop test1
		drop yes
		reshape wide rtr2pe@beg rtr2pe@end   , i(id partner) j(episode)
		reshape wide rtr2p@e1beg rtr2p@e2beg rtr2p@e3beg rtr2p@e4beg rtr2p@e5beg rtr2p@e1end rtr2p@e2end rtr2p@e3end rtr2p@e4end rtr2p@e5end , i(id) j(partner)
		
		* delete empty variables 
		foreach var of varlist rtr2p1e1beg- rtr2p12e5end {
			count if `var' ==. | `var' ==-3
			if r(N) == _N drop `var'
		}
		foreach var of varlist rtr2p1e1beg- rtr2p12e1end {
			recode `var' .=-3
		}
		merge id using z3.dta, sort
		noisily tab _merge
		drop _merge
		order rtr2p1e1beg- rtr2p12e1end, last
		capture erase z1.dta
		capture erase z2.dta
		capture erase z3.dta
	
		* check cases where beginning and end of second+ episodes are -1/-2 
		* may cause problems when generating beginning / end
			forvalues x=1/12 {
				forvalues j=2/5 {
					capture gen help`x'm6a`j'=0
					capture replace help`x'm6a`j'=1 if (rtr2p`x'e`j'beg==-1 | rtr2p`x'e`j'beg==-2) & (rtr2p`x'e`j'end==-1 | rtr2p`x'e`j'end==-2)
				}
			}
			tab1 help*m6*, m
			l id rtr2*beg rtr2*end if help1m6a2==1, ab(20)
			l id rtr2*beg rtr2*end if help2m6a2==1
			l id rtr2*beg rtr2*end if help2m6a3==1
			l id rtr2*beg rtr2*end if help3m6a2==1
			l id rtr2*beg rtr2*end if help4m6a2==1
			* solution: delete these cases (-5)
				forvalues x=1/12 {
					forvalues j=2/5 {
						foreach ding of any "beg" "end" {
							capture replace rtr2p`x'e`j'`ding'=-5 if help`x'm6a`j'==1
						}
					}
				}
			drop help*m6*

		* check if further problems due to -1/-2 (order not correct)
			l id rtr2*beg rtr2*end if m6a==1 
			* 1 case
				foreach ding of any "beg" "end" {
					replace rtr2p2e1`ding'=rtr2p2e2`ding' if id==610690000
					replace rtr2p2e2`ding'=-5 if id==610690000
				}


	* m6b: subsequent episode (beginning and end) between beginning and end of preceding episode
		gen m6b=0
			forvalues x=1/12 {
				forvalues j=1/5 {
					local a=`j'+1
					forvalues b=`a'/5 {
						capture replace m6b=1 if (rtr2p`x'e`j'beg>0 & rtr2p`x'e`b'beg>0 & rtr2p`x'e`j'end>0 & rtr2p`x'e`b'end>0 & ///
						rtr2p`x'e`j'beg<rtr2p`x'e`b'beg & rtr2p`x'e`j'end>rtr2p`x'e`b'end) 
					}
				}
			}
		count if m6b==1
			* 2 cases
		l id rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m6b==1
		* solution: second episode to -5 
			foreach ding of any "beg" "end" {
				replace rtr2p1e2`ding'=-5 if id==494550000  | id==336484000
			}

	* m6c: beginning and end of two episodes identical -> check if due to -1/-2 for month
		gen m6c=0
			forvalues x=1/12 {
				forvalues j=1/5 {
					local a=`j'+1
					forvalues b=`a'/5 {
						capture replace m6c=1 if (rtr2p`x'e`j'beg>0 & rtr2p`x'e`b'beg>0 & rtr2p`x'e`b'beg==rtr2p`x'e`j'beg)	///
						& (rtr2p`x'e`j'end>0 & rtr2p`x'e`b'end>0 & rtr2p`x'e`b'end==rtr2p`x'e`j'end) 
					}
				}
			}
			count if m6c==1
				* 3 cases
			l id rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m6c==1, ab(20)
			* ID=157696000, 166372000, 451727000: 2 identical episodes provided --> 2nd episode to -5
				foreach ding of any "beg" "end" {
					replace rtr2p3e2`ding'=-5 if id==157696000 
					replace rtr2p1e2`ding'=-5 if id==166372000
					replace rtr2p4e2`ding'=-5 if id==451727000
				}


	* m6d: (only) beginning of subsequent episode before beginning of preceding episode 
		gen m6d=0
			forvalues x=1/12 {
				forvalues j=1/5 {
					local a=`j'+1
					forvalues b=`a'/5 {
						capture replace m6d=1 if (rtr2p`x'e`j'beg>0 & rtr2p`x'e`b'beg>0 & rtr2p`x'e`b'beg<rtr2p`x'e`j'beg)				
					}
				}
			}
			count if m6d==1
				* 4 cases
			l id m6* rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m6d==1, ab(20)
			* ID=136701000: wrong order due to -1 for end of episode
				replace rtr2p1e1beg=536 if id==136701000
				replace rtr2p1e1end=-1 if id==136701000
				replace rtr2p1e2beg=570 if id==136701000
				replace rtr2p1e2end=580 if id==136701000
			* ID=277867000: 2nd episode probably identical to 1st --> 1st to -5, then sort
				foreach ding of any "beg" "end" {
					replace rtr2p3e1`ding'=rtr2p3e2`ding' if id==277867000
					replace rtr2p3e2`ding'=-5 if id==277867000
				}
			* ID=386610000: 2nd episode probably identical to 1st --> 1st to -5, then sort
				foreach ding of any "beg" "end" {
					replace rtr2p1e1`ding'=rtr2p1e2`ding' if id==386610000
					replace rtr2p1e2`ding'=-5 if id==386610000
				}
			* ID=544571000: probably beginning of 2nd episode "end of year / winter" instead of "beginning of year/winter" 
			*			--> change to 12 instead of 1
				replace rtr2p2e2bm=12 if id==544571000
				replace rtr2p2e2beg =ym(rtr2p2e2by, rtr2p2e2bm) if id==544571000
			* check changes
			l id rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m6d==1


	* m6e: (only) beginning of subsequent episode before end of preceding episode  	
		gen m6e=0
			forvalues x=1/12 {
				forvalues j=1/5 {
					local a=`j'+1
					forvalues b=`a'/5 {
						capture replace m6e=1 if (rtr2p`x'e`j'beg>0 & rtr2p`x'e`b'beg>0 & rtr2p`x'e`b'beg<rtr2p`x'e`j'end)	
					
					}
				}
			}
		count if m6e==1
			* 10 cases
		l id m6* rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m6e==1, ab(20) 
		* 9 cases: 2nd episode to -5 (is part of 1st episode)
		foreach ding of any "beg" "end" {
			replace rtr2p2e2`ding'=-5 if id==101706000
			replace rtr2p3e2`ding'=-5 if id==138256000
			replace rtr2p2e2`ding'=-5 if id==427866000
			replace rtr2p2e2`ding'=-5 if id==434597000
			replace rtr2p2e3`ding'=-5 if id==473328000
			replace rtr2p2e2`ding'=-5 if id==554334000
			replace rtr2p1e2`ding'=-5 if id==686032000
		}
		* 3 cases: combine to one episode; end of 2nd episode
		replace rtr2p3e1end=rtr2p3e2end if id==504092000
		foreach ding of any "beg" "end" {
			replace rtr2p3e2`ding'=-5 if id==504092000
		}
		replace rtr2p5e1end=rtr2p5e2end if id==564030000
		foreach ding of any "beg" "end" {
			replace rtr2p5e2`ding'=-5 if id==564030000
		}
		replace rtr2p1e1end=rtr2p1e2end if id==610690000
		foreach ding of any "beg" "end" {
			replace rtr2p1e2`ding'=-5 if id==610690000
		}
		l id m6* rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m6e==1, ab(20) 


	* m6f: (only) end of subsequent episode before end of preceding episode
		gen m6f=0
			forvalues x=1/12 {
				forvalues j=1/5 {
					local a=`j'+1
					forvalues b=`a'/5 {
						capture replace m6f=1 if (rtr2p`x'e`j'end>0 & rtr2p`x'e`b'end>0 & rtr2p`x'e`b'end<rtr2p`x'e`j'end)
					}
				}
			}
			count if m6f==1
				* 1 case
			l id m6* rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m orig*rtr2*beg orig*rtr2*end if m6f==1, ab(20)			
			* interchange episodes
				replace rtr2p1e1beg=orig_rtr2p1e2beg if id==423139000
				replace rtr2p1e1end=orig_rtr2p1e2end if id==423139000	
				replace rtr2p1e2beg=orig_rtr2p1e1beg if id==423139000
				replace rtr2p1e2end=orig_rtr2p1e1end if id==423139000	
				
		
	* m6g: end of subsequent episode before beginning of preceding episode; beginning of subsequent episode after beginning of preceding episode
		gen m6g=0
			forvalues x=1/12 {
				forvalues j=1/5 {
					local a=`j'+1
					forvalues b=`a'/5 {
						capture replace m6g=1 if (rtr2p`x'e`j'beg>0 & rtr2p`x'e`b'end>0 & rtr2p`x'e`b'end<rtr2p`x'e`j'beg)	///
						& (rtr2p`x'e`j'beg>0 & rtr2p`x'e`b'beg>0 & rtr2p`x'e`b'beg>rtr2p`x'e`j'beg) 
					}
				}
			}
			count if m6g==1
				* no such case

				
				
	* m6h: beginning or end of preceding episode -1/-2
		gen m6h=0
			forvalues x=1/12 {
				forvalues j=1/5 {
					local a=`j'+1
					forvalues b=`a'/5 {
						capture replace m6h=1 if rtr2p`x'e`j'end<0 & rtr2p`x'e`b'end>0 
						capture replace m6h=1 if rtr2p`x'e`j'beg<0 & rtr2p`x'e`b'beg>0 
					}
				}
			}
			count if m6h==1
				* 5 cases
			l id m6* rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m6h==1, ab(20)
			* ID=136701000: okay
			* beginning and end of 1st episode partner 2 = -2 --> change order and delete this episode (-5)
				foreach ding of any "beg" "end" {
					replace rtr2p2e1`ding'=rtr2p2e2`ding' if id==138307000
					replace rtr2p2e2`ding'=-5 if id==138307000
				}
			* beginning and end of 1st episode partner 3 = -1 --> change order and delete this episode (-5)
				foreach ding of any "beg" "end" {
					replace rtr2p3e1`ding'=rtr2p3e2`ding' if id==178808000
					replace rtr2p3e2`ding'=-5 if id==178808000
				}
			* ID=393417000: okay
			* end of 1st episode and beginning of 2nd episode partner 1 = -2 --> combine to one episode
				replace rtr2p1e1end=rtr2p1e2end if id==533835000
				foreach ding of any "beg" "end" {
					replace rtr2p1e2`ding'=-5 if id==533835000
				} 


 
 
 
**************************************
* separations previous relationship: beginning and end
**************************************

* interchange beginning and end (breaks)
	forvalues x=1/15 {
		forvalues k=1/12 {
			foreach ding of any "beg" "end" {
				if "`ding'"=="beg" {
					local dong="end"
					local y=`x'
				}
				else {
					local dong="beg"
					local y=`x'+1
				}
			capture gen b`x'p`k'`ding'=rtr2p`k'e`y'`dong' if break`k'==1 
			capture label var b`x'p`k'beg "Beginning break `x' partner `k'"
			capture label var b`x'p`k'end "End break `x' partner `k'"
			capture recode b`x'p`k'beg .=-3
			capture recode b`x'p`k'end .=-3
			}
		}
	}




**************************************
* beginning and end previous relationships
**************************************

* generate earliest beginning for each partner 
	forvalues x=1/12 {
		capture noi egen begp`x'=rowfirst(rtr2p`x'e*beg)
		recode begp`x' .=-3 
		lab var begp`x' "Beginning relationship partner `x'"
	}

* new variable, no missings 
	forvalues x=1/12 {
		forvalues j=1/5 {	
			capture gen rtr2p`x'e`j'end_new=rtr2p`x'e`j'end if (rtr2p`x'e`j'end!=-3 & rtr2p`x'e`j'end!=-5) 
			capture replace rtr2p`x'e`j'end_new=-5 if (rtr2p`x'e`j'end==-5 & rtr2p`x'e`j'beg!=-5)
		}
	}

* generate latest end for each partner
	forvalues x=1/12 {
		capture egen endp`x' =rowlast(rtr2p`x'e*end_new)
	}
	forvalues x=1/12 {	
		recode endp`x' .=-3 
		lab var endp`x' "End relationship partner `x'"
	}	
	

	
**************************************
* correct separations previous relationships
**************************************
		
* end of relationship: no additional beginning
	** no such episodes at all
	forvalues k=1/12 {
		capture replace b1p`k'beg=-3 if `k'==6 | `k'==7 | `k'==8 | `k'==9 | `k'==10 | `k'==11 | `k'==12
		capture replace b2p`k'beg=-3 if `k'==3
		capture replace b3p`k'beg=-3 if `k'==2
		capture replace b4p`k'beg=-3 if `k'==1 | `k'==5
		capture replace b5p`k'beg=-3 if `k'==4
	}
	forvalues k=1/12 {
		forvalues m=1/12 {
			capture noisily replace b`m'p`k'beg=-3 if b`m'p`k'beg==endp`k' & endp`k'!=-5 & b`m'p`k'end==-3
		}
	}
	

* delete cases with -3 everywhere
	foreach var of varlist b1p1beg-b5p4beg {
		count if `var' == -3
		if r(N) == _N drop `var'
	}

* check separations with -1/-2 
	gen help=0
		forvalues k=1/12 {
			forvalues m=1/12 {
				capture replace help=1 if (b`m'p`k'beg==-1 | b`m'p`k'beg==-2) & b`m'p`k'end<0
				capture replace help=1 if (b`m'p`k'beg==-1 | b`m'p`k'beg==-2) & b`m'p`k'end>0
			}
		}
	count if help==1
		* 13 cases --> will be dealt with later on (censoring)
	drop help



	
	
*******************
*** check for inconsistencies
*******************
	
* check7: current partner mistakenly provided as previous partner as well; interviewer's note
	* relationship with partner 1: still ongoing
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==410457000
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==268330000
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==316305000
	* relationship with partner 1: still ongoing --> no rtr4p1
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==548350000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==85919000
		replace begp4=-5 if id==85919000
		replace endp4=-5 if id==85919000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==139467000
		replace begp1=-5 if id==139467000
		replace endp1=-5 if id==139467000
	l id m* intdat begp* b*p*beg endp* b*p*end sd5e1bm sd5e1by rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==157696000
		replace begp4=-5 if id==157696000
		replace endp4=-5 if id==157696000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==221318000
		replace begp4=-5 if id==221318000
		replace endp4=-5 if id==221318000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==306878000
		replace begp2=-5 if id==306878000
		replace endp2=-5 if id==306878000
		replace b1p2beg=-5 if id==306878000
		replace b1p2end=-5 if id==306878000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==334288000
		replace begp5=-5 if id==334288000
		replace endp5=-5 if id==334288000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==346447000 
		replace begp1=-5 if id==346447000 	// was typing error in wave 1
		replace endp1=-5 if id==346447000 	// was typing error in wave 1
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==376439000
		replace begp2=-5 if id==376439000
		replace endp2=-5 if id==376439000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==532055000
		replace begp4=-5 if id==532055000
		replace endp4=-5 if id==532055000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==533125000
		replace begp4=-5 if id==533125000
		replace endp4=-5 if id==533125000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==555433000
		replace begp2=-5 if id==555433000
		replace endp2=-5 if id==555433000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==656738000
		replace begp2=-5 if id==656738000
		replace endp2=-5 if id==656738000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==678434000
		replace begp1=-5 if id==678434000
		replace endp1=-5 if id==678434000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==698444000
		replace begp1=-5 if id==698444000
		replace endp1=-5 if id==698444000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==735827000
		replace begp2=-5 if id==735827000
		replace endp2=-5 if id==735827000
	l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==53122000
		replace begp4=-5 if id==53122000
		replace endp4=-5 if id==53122000
		replace b1p4beg=-5 if id==53122000
		replace b1p4end=-5 if id==53122000



* check8: beginning current relationship = beginning previous relationship = date of interview
	gen m8=0
		forvalues k=1/12 {
			replace m8=1 if begp0==begp`k' & begp0!=-3 & begp`k'==intdat
		}
		count if m8==1
			* 3 cases
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if m8==1, ab(20)
		* 1377000: different names of partners and no note by interviewer (according to non-anonymized data) --> no change
		* name previous partner = name current partner --> previous partner to -5
			replace begp1=-5 if id==396313000
			replace endp1=-5 if id==396313000
			replace begp2=-5 if id==503847000
			replace endp2=-5 if id==503847000



* check9: beginning current relationship = beginning previous relationship; end of previous relationship = -1/-2
	gen m9=0
		forvalues k=1/12 {
			replace m9=1 if begp0==begp`k' & begp0!=-3 & (endp`k'==-1 | endp`k'==-2)
		}
		count if m9==1
			* 51 cases
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end if m9==1, ab(20)
		* compare names of partners using the non-anonymized data set

		* name previous partner = name current partner --> previous relationship = -5
			*** 1st partner
			foreach num of numlist 907000 43319000 80527000 98570000 157821000 207387000 258425000 394059000 426685000 445922000 ///
				502668000 574132000 588297000 622181000 623252000 667434000 674284000 683938000 743466000 747564000 146714000 676549000 {
				replace begp1=-5 if id==`num' & m9==1
				replace endp1=-5 if id==`num' & m9==1
			}
			* 		21 cases changed
			*** 2nd partner
			foreach num of numlist 70003000  111513000 206046000 252269000 385062000  412020000 509930000 529722000 628934000 746888000 {
				replace begp2=-5 if id==`num' & m9==1
				replace endp2=-5 if id==`num' & m9==1
			}
			* 		10 cases changed
			*** 3rd partner
			foreach num of numlist 104123000 114298000 116036000 123742000 185201000 217666000 314335000 328508000 517699000 543064000 585501000 ///
				659102000 697279000 {
				replace begp3=-5 if id==`num' & m9==1
				replace endp3=-5 if id==`num' & m9==1
			}
			*		12 cases
			*** 4th partner
			foreach num of numlist 14902000 81289000 530393000 590733000 627537000 {
				replace begp4=-5 if id==`num' & m9==1
				replace endp4=-5 if id==`num' & m9==1
			}
			*		5 cases
			*** 5th partner
			foreach num of numlist 328508000 {
				replace begp5=-5 if id==`num' & m9==1
				replace endp5=-5 if id==`num' & m9==1
			}
			* 		1 case
			* 214936000: 3rd partner is - according to name - current partner --> correct beginning current partner; 3rd partner to -5
			replace begp0=begp3 if id==214936000 & m9==1
			replace begp3=-5 if id==214936000 & m9==1
			replace endp3=-5 if id==214936000 & m9==1
			*		1 case
		* any more cases?
		drop m9
		gen m9=0
		forvalues k=1/12 {
			replace m9=1 if begp0==begp`k' & begp0!=-3 & (endp`k'==-1 | endp`k'==-2)
		}
		count if m9==1
			* 3 cases left
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end if m9==1
		* 152788000: beginning and end -2; current partner's name not provided 
		* 130234000: beginning and end -2; different names
		* 96140000: beginning and end -1; partner 1 and partner 2 same name, but no further indication 



* check10: beginning current relationship = beginning previous relationship --> delete previous relationship if names identical
	gen m10=0
		forvalues k=1/12 {
			replace m10=1 if begp0==begp`k' & begp0!=-3 & begp0!=-5
		}
		count if m10==1
			* 65 cases
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end if m10==1 
		*** 1st Partner
		foreach num of numlist 4789000 58322000 80930000 106175000  230609000 250363000 259896000 261079000 261405000 306531000 ///
			319758000  344772000 367010000 405844000 448205000 455185000  471800000    515043000 517966000  ///
			567128000 595718000 622011000 647994000 683648000 689386000 303647000	{
			replace begp1=-5 if id==`num' & m10==1
			replace endp1=-5 if id==`num' & m10==1
		}
		*** 2nd Partner
		foreach num of numlist 138307000 275442000 337074000 360640000 364063000 389259000   446485000 487348000 509930000 ///
			522261000 529268000 560686000 684328000 548875000	 {
			replace begp2=-5 if id==`num' & m10==1
			replace endp2=-5 if id==`num' & m10==1
		}
		*** 3rd Partner
		foreach num of numlist  133823000 138256000  224118000  262123000 328508000  471800000   548843000 ///
			691439000 704930000 742720000	{
			replace begp3=-5 if id==`num' & m10==1
			replace endp3=-5 if id==`num' & m10==1
		}
		*** 4th Partner
		foreach num of numlist 36175000  48366000 79416000 231837000 283971000 724215000 	{
			replace begp4=-5 if id==`num' & m10==1
			replace endp4=-5 if id==`num' & m10==1
		}
		*** 5th Partner
		foreach num of numlist 389259000 552176000 	{
			replace begp5=-5 if id==`num' & m10==1
			replace endp5=-5 if id==`num' & m10==1
		}
		* separations to -5 as well
			replace b1p3beg=-5 if (id==138256000 | id==328508000 | id==504092000) & m10==1
			replace b1p3end=-5 if (id==138256000 | id==328508000 | id==504092000) & m10==1
		* any more cases?
		drop m10
		gen m10=0
		forvalues k=1/12 {
			replace m10=1 if begp0==begp`k' & begp0!=-3 & begp0!=-5
		}
		count if m10==1
			* 13 cases left
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end if m10==1
		* all of these cases: partners' names not identical --> no further changes



* check11: beginning previous relationship=intdat
	gen m11=0
		forvalues k=1/12 {
			replace m11=1 if begp`k'==intdat 
		}
		count if m11==1
			* 6 cases
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end if m11==1
		*** 4th partner
		foreach num of numlist 542823000	{
			replace begp4=-5 if id==`num'
			replace endp4=-5 if id==`num'
		}
		* no additional changes possible
		
	

* check12: end previous relationship=intdat; current relationship existing --> delete previous relationship if names identical
	gen m12=0
		forvalues k=1/12 {
			replace m12=1 if endp`k'==intdat & begp0!=-3
		}
		count if m12==1
			* 29 cases 
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end orig_sd5e1bm sd5e1by orig_rtr2p* rtr2*y if m12==1	
		*** 1st Partner
		foreach num of numlist 191816000 291499000 430543000 458533000  490787000  492777000 513548000 553272000 664607000 {
			replace begp1=-5 if id==`num' 
			replace endp1=-5 if id==`num'
		}
		*** 2nd Partner
		foreach num of numlist 118416000 246951000  349358000  405703000 420161000 442153000 536704000 {
			replace begp2=-5 if id==`num'
			replace endp2=-5 if id==`num'
		}
		*** 3rd Partner
		foreach num of numlist 185131000 490787000 504092000 712668000 {
			replace begp3=-5 if id==`num'
			replace endp3=-5 if id==`num'
		}
		*** 4th Partner
		foreach num of numlist 262825000 {
			replace begp4=-5 if id==`num'
			replace endp4=-5 if id==`num'
		}
		* breaks and corrections
		replace b1p1beg=-5 if id==291499000 | id==458533000 | id==490787000
		replace b1p1end=-5 if id==291499000 | id==458533000 | id==490787000
		replace begp0=360 if id==291499000
		replace begp0=363 if id==458533000 
		replace b1p0beg=371 if id==458533000
		replace b1p0end=379 if id==458533000
		replace begp0=438 if id==490787000
		replace b1p0end=558 if id==490787000
		replace b1p3beg=-5 if id==712668000
		replace b1p3end=-5 if id==712668000
		* any more cases?
		drop m12
		gen m12=0
		forvalues k=1/12 {
			replace m12=1 if endp`k'==intdat & begp0!=-3
		}
		count if m12==1
			* 9 cases left
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end orig_sd5e1bm sd5e1by orig_rtr2p* rtr2*y if m12==1 
		* 473328000: begp0 = partner's date of birth; name current partner = name partner 2 --> beginning current partner = beginning partner 2 
		replace begp0=begp2 if id==473328000
		replace begp2=-5 if id==473328000
		replace endp2=-5 if id==473328000
		* no further corrections possible (no identical names)




* check13: search for identical names (current and previous partners) and only slightly different dates in non-anonymized data set
* (identical name alone not sufficient)

	* 1st partner
		replace begp0=begp1 if id==718037000
		foreach num of numlist 427314000 718037000 172722000 504252000 {
			replace begp1=-5 if id==`num'
			replace endp1=-5 if id==`num'
		}
		replace begp0=begp1 if id==707569000
		replace begp1=-5 if id==707569000
		replace endp1=-5 if id==707569000
		
	* 2nd partner
	foreach num of numlist 737428000 273768000 {
		replace begp2=-5 if id==`num'
		replace endp2=-5 if id==`num'
	}
	foreach num of numlist 273768000  {
		replace begp4=-5 if id==`num'
		replace endp4=-5 if id==`num'
	}

	* 3rd partner
	replace begp0=begp3 if id==257283000
	replace begp0=begp3 if id==503381000
	foreach num of numlist 257283000 503381000 151355000 311906000 432784000 {
		replace begp3=-5 if id==`num'
		replace endp3=-5 if id==`num'
	}

	* 4th partner
	foreach num of numlist 62494000 531488000 {
		replace begp4=-5 if id==`num'
		replace endp4=-5 if id==`num'
	}
	replace b1p4beg=-5 if id==531488000
	replace b1p4end=-5 if id==531488000

	* 5th partner
	foreach num of numlist 52154000 610681000 {
		replace begp5=-5 if id==`num'
		replace endp5=-5 if id==`num'
	}

	* 6th partner
	* no cases

	* 7th partner
	foreach num of numlist 240420000 {
		replace begp7=-5 if id==`num'
		replace endp7=-5 if id==`num'
	}

	* 8th - 11th partner: no cases

	

* check14: any breaks if beg=-5? --> -5 as well
	gen m14=0
		forvalues k=1/12 {
			forvalues x=1/5 {
				capture replace m14=1 if begp`k'==-5 & b`x'p`k'beg!=-5  & b`x'p`k'beg!=-3
			}
		}
	count if m14==1
		* 11 cases
	l id b*p*beg  b*p*end begp* endp* if m14==1
	forvalues k=1/12 {
		forvalues x=1/5 {
			capture replace b`x'p`k'beg=-5 if begp`k'==-5 & b`x'p`k'beg!=-3
			capture replace b`x'p`k'end=-5 if endp`k'==-5 & b`x'p`k'end!=-3
		}
	}
	l id b*p*beg  b*p*end begp* endp* if m14==1
	* any cases left?
	drop m14
	gen m14=0
	forvalues k=1/12 {
		forvalues x=1/5 {
			capture replace m14=1 if begp`k'==-5 & b`x'p`k'beg!=-5  & b`x'p`k'beg!=-3
		}
	}
	count if m14==1
	* 0 cases left


* check15: end = -1/-2 and current relationship existing; check partners' names (non-anonymized data set)
	gen m15=0
		forvalues x=1/12 {
				capture replace m15=1 if (endp`x'==-1 | endp`x'==-2) & begp0!=-3 & begp`x'>0
		}
		count if m15==1
			* 38 cases
		l id m* begp* endp* b*beg b*beg if m15==1 
		* suspicious: 532055000, 390487000, 364063000, 294424000, 136558000, 76467000, 76058000
			l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==532055000
				* partner 4 already -5
			l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==390487000
				* partner 2 is "wife" --> -5
					replace begp2=-5 if id==390487000
					replace endp2=-5 if id==390487000
			l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==364063000
				* partner 2 already -5
			l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==294424000
				* partner 1 is most probably current partner --> -5
					replace begp1=-5 if id==294424000
					replace endp1=-5 if id==294424000
			l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==136558000
				* partner 1 is most probably current partner --> -5
					replace begp1=-5 if id==136558000
					replace endp1=-5 if id==136558000
			l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==76467000
				* partner 1 is most probably current partner --> -5
					replace begp1=-5 if id==76467000
					replace endp1=-5 if id==76467000
			l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==76058000
				* partner 3 and 5 identical and most probably current partner --> -5
					replace begp3=-5 if id==76058000
					replace endp3=-5 if id==76058000
					replace begp5=-5 if id==76058000
					replace endp5=-5 if id==76058000
		


* check16a-16h: repeat checks for inconsistencies across breaks	(also see check6a-h)

	* m16a: beginning and end subsequent episode before beginning and end preceding episode 
	gen m16a=0
		forvalues x=0/12 {
			forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m16a=1 if (b`j'p`x'beg>0 & b`b'begp`x'>0 & b`b'p`x'beg<b`j'p`x'beg)	///
					& (b`j'p`x'end>0 & b`b'p`x'end>0 & b`b'p`x'beg<b`j'p`x'end) 
			}
		}
		}
		count if m16a==1
			* 0 cases
		
				
	* m16b: subsequent episode (beginning and end) between beginning and end of preceding episode
	gen m16b=0
		forvalues x=0/12 {
			forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m16b=1 if (b`j'p`x'beg>0 & b`b'p`x'beg>0 & b`j'p`x'end>0 & b`b'p`x'beg>0 & ///
								b`j'p`x'beg<b`b'p`x'beg & b`j'p`x'end>b`b'p`x'end) 
			}
		}
		}
		count if m16b==1
			* 0 cases
		list id begp* endp* b*p*beg b*p*end if m16b==1	
			

	* m16c: beginning and end of two episodes identical -> check if due to -1/-2 for month
	gen m16c=0
		forvalues x=0/12 {
			forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m16c=1 if (b`j'p`x'beg>0 & b`b'begp`x'>0 & b`b'begp`x'==b`j'p`x'beg)	///
					& (b`j'p`x'end>0 & b`b'p`x'end>0 & b`b'p`x'end==b`j'p`x'end) 
			}
		}
		}
		count if m16c==1
			* 0 cases


	* m16d: (only) beginning of subsequent episode before beginning of preceding episode 
	gen m16d=0
		forvalues x=0/12 {
			forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m16d=1 if (b`j'p`x'beg>0 & b`b'begp`x'>0 & b`b'begp`x'<b`j'p`x'beg)				
			}
		}
		}
		count if m16d==1
			* 0 cases



	* m16e: (only) beginning of subsequent episode before end of preceding episode  
	gen m16e=0
		forvalues x=0/12 {
			forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m16e=1 if (b`j'p`x'end>0 & b`b'begp`x'>0 & b`b'begp`x'<b`j'p`x'end)	
					
			}
		}
		}
		count if m16e==1
			* 0 cases


	* m16f: (only) end of subsequent episode before end of preceding episode 
	gen m16f=0
		forvalues x=0/12 {
			forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m16f=1 if (b`j'p`x'end>0 & b`b'p`x'end>0 & b`b'p`x'end<b`j'p`x'end)
			}
		}
		}
		count if m16f==1
			* 0 cases


	* m16g: end of subsequent episode before beginning of preceding episode; beginning of subsequent episode after beginning of preceding episode
	gen m16g=0
		forvalues x=0/12 {
			forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m16g=1 if (b`j'p`x'beg>0 & b`b'p`x'end>0 & b`b'p`x'end<b`j'p`x'beg)	///
					& (b`j'p`x'beg>0 & b`b'begp`x'>0 & b`b'begp`x'>b`j'p`x'beg) 
			}
		}
		}
		count if m16g==1
			* 0 cases


	* m16h: beginning or end of preceding episode -1/-2
	gen m16h=0
		forvalues x=0/12 {
			forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m16h=1 if b`j'p`x'end<0 & b`b'p`x'end>0 
				capture replace m16h=1 if b`j'p`x'beg<0 & b`b'begp`x'>0 
			}
		}
		}
		count if m16h==1
			* 1 case
		list id begp* endp* b*p*beg b*p*end if m16h==1
			* okay, no changes
		



* check17a-b: episodes with beginning=end --> maybe problems due to -1/-2 (month)

	* m17a: relationship episodes
	forvalues x=0/12 {
		gen m17a`x'=0
	}	
		forvalues x=1/12 {
			forvalues j=1/5 {
				* current partner beginning and end
					capture replace m17a0=1 if begp0==endp0 & begp0>0 
				* former partners beginning and end
					capture replace m17a`x'=1 if begp`x'==endp`x' & begp`x'>0 & ///
								(orig_rtr2p`x'e`j'em==-1 | orig_rtr2p`x'e`j'em==-2) & (orig_rtr2p`x'e`j'bm==-1 | orig_rtr2p`x'e`j'bm==-2) 
			}
		}
		count if m17a0==1
			* 0 cases
		forvalues x=1/12 {
			count if m17a`x'==1
		}
			* 25 cases (more than one case for each individual possible)
		l id intdat begp* b*p*beg endp* b*p*end orig_rtr2p* rtr2p*y if m17a1==1, ab(20) 
		l id intdat begp* b*p*beg endp* b*p*end orig_rtr2p* rtr2p*y if m17a2==1 
		l id intdat begp* b*p*beg endp* b*p*end orig_rtr2p* rtr2p*y if m17a3==1 
		l id intdat begp* b*p*beg endp* b*p*end orig_rtr2p* rtr2p*y if m17a4==1
		l id intdat begp* b*p*beg endp* b*p*end orig_rtr2p* rtr2p*y if m17a6==1
		l id intdat begp* b*p*beg endp* b*p*end orig_rtr2p* rtr2p*y if m17a7==1
		* no changes since months have been imputed randomly
	
	* m17b: breaks 
		forvalues x=0/12 {
			forvalues j=1/7 {
			gen m17b`x'e`j'=0
		}		
		}
		forvalues x=1/12 {
			forvalues j=1/7 {
			local k=`j'+1
			* current partner beginning and end
			capture replace m17b0e`j'=1 if b`j'p0beg==b`j'p0end & b`j'p0beg>0  & ///
											(orig_sd5e`j'em==-1 | orig_sd5e`j'em==-2) & (orig_sd5e`k'bm==-1 | orig_sd5e`k'bm==-2)
			* previous partners beginning and end
			capture replace m17b`x'e`j'=1 if b`j'p`x'beg==b`j'p`x'end & b`j'p`x'beg>0  & ///
											(orig_rtr2p`x'e`j'em==-1 | orig_rtr2p`x'e`j'em==-2) & (orig_rtr2p`x'e`k'bm==-1 | orig_rtr2p`x'e`k'bm==-2)
			}
		}
		forvalues j=1/7 {
			count if m17b0e`j'==1
		}
			* 6 cases
		l id intdat begp0 b*p0beg endp0 b*p0end orig_sd5* sd5*y* if m17b0e1==1
		forvalues x=1/12 {
			forvalues j=1/7 {
				count if m17b`x'e`j'==1
			}
		}
			* 0 cases
		
		* no changes since months have been imputed randomly
		
		* check if - after these changes - any beginning or end after date of interview
		gen help=0
		forvalues x=0/12 {
			forvalues j=1/7 {
			capture replace help=1 if b`j'p`x'beg>intdat
			capture replace help=2 if b`j'p`x'end>intdat
			}
		}
		tab help, m	
		* 0 cases

		* check if - after these changes - any beginning of break before beginning of relationship or end of break after end of relationship
		drop help
		gen help=0
		forvalues x=0/12 {
			forvalues j=1/7 {
			capture replace help=1 if b`j'p`x'beg<begp`x' & b`j'p`x'beg>0 & begp`x'>0
			capture replace help=2 if b`j'p`x'end>endp`x' & b`j'p`x'end>0 & endp`x'>0
			}
		}
		tab help, m
		* 0 cases


* check18: identical names previous partners; use non-anonymized data set

/* This part is put in comment to guarantee usability for users

use "...\6_final_valuelabels.dta", clear // non-anonymised
		tostring hhid, gen(id)
		replace id=id+"000"
		destring id, replace
		format %12.0f id
		
	* partner names
	ds rtr1p*n
	
	* auxiliary variable: 
		** for doubles in names: 1: double, 0: no double
			gen m18_1=0 
		** for doubles in beginning of relationship 1: double, 0: no double
			gen m18_2=0
	
	forvalues j=1(1)12 {
		local a=`j'-1
		local k=0
		forvalues i=1(1)`a' {
				di "`j' ___`i'" // displaying the combinations (math.)
				bysort id: replace m18_1=1 if rtr1p`j'n==rtr1p`i'n & /* same names*/ ///
				( 	rtr1p`j'n!="-1 Wei nicht" & /// 
					rtr1p`j'n!="-3 Trifft nicht zu" & ///
					rtr1p`j'n!="-6 Offene Angabe nicht lesbar" & ///
					rtr1p`j'n!="-2 Keine Angabe" & ///
					rtr1p`j'n!="7 Kein weiterer Partner" )
				capture noisily bysort id: replace m18_2=1 if  ///
						(rtr2p`j'e1bm==rtr2p`i'e1bm) & (rtr2p`j'e1by==rtr2p`i'e1by) & ///
						( 	rtr2p`j'e1bm!=-3  & ///
							rtr2p`j'e1bm!=-6  & ///
							rtr2p`j'e1bm!=-2  & ///
							rtr2p`j'e1bm!=-1  & ///
							///
							rtr2p`j'e1by!=-3 & ///
							rtr2p`j'e1by!=-6 & ///
							rtr2p`j'e1by!=-2 & ///
							rtr2p`j'e1by!=-1 )

				
			}	
	}

	* same names & same beginning of 1st episode
		count if m18_1==1 & m18_2==1
			* 0 cases
			
	* same names
		count if m18_1==1
			* 70 cases
		l id azh2n sd5e*bm sd5e*by sd5e*em sd5e*ey rtr1p*n rtr2*bm rtr2*by rtr2*em rtr2*ey if m18_1==1 
		l id if m18_1==1
*/
	
* changes	(derived from part above)
	* 480999000: name partner 1 and 2 identical; end of both identical; beginning nearly (one "-1") --> partner 2 dropped
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==480999000
		replace begp1=begp2 if id==480999000
		replace begp2=-5 if id==480999000
		replace endp2=-5 if id==480999000
	* 375816000: partner 1 and partner 3 identical (names, beginning and end, breaks) --> partner 3 dropped
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==375816000
		replace begp3=-5 if id==375816000
		replace endp3=-5 if id==375816000
	* 280610000: partner 1 and partner 4 identical (partner 4 = second episode partner 1) --> partner 4 dropped 
		l id m* intdat begp* b*p*beg endp* b*p*end rtr2*beg rtr2*end rtr2*y rtr2*m orig*rtr2*m if id==280610000
		replace begp4=-5 if id==280610000
		replace endp4=-5 if id==280610000
			
		
		
		
		
**************************************
* previous relationships: reason end
**************************************

forvalues j=1/15 {
	capture gen reasendp`j'=rtr4p`j' 
}

* -3 if begp*=-5 and endp*=-5
forvalues j=1/15 {
	capture replace reasendp`j'=-3 if begp`j'==-5 & endp`j'==-5
}

* labels
forvalues j=1/15 {
	capture lab var reasendp`j' "Reason end relationship partner `j'"
}



*****************************************
* list all relationships which have been changed to -5 and will be dropped
*****************************************

forvalues x=0/12 {
	gen dropp`x'=0
	replace dropp`x'=1 if begp`x'==-5 & endp`x'==-5
}
tab1 dropp*, m



*****************************************
* correct episodes of cohabitation and marriage
*****************************************

* if beginning and end -5 --> cohabitation and marriage -3

	* cohabitation
	drop help
	gen help=0
		forvalues x=1/8 {
				capture noisily replace help=1 if rtr7p`x'e1by>0 & begp`x'==-5 & endp`x'==-5
			}
		count if help==1		
			* 26 cases
			* generate combined variables
			forvalues j=1/5 {
				forvalues i=-5/-1 {
					capture gen sd8e`j'beg =ym(sd8e`j'by, sd8e`j'bm)
					capture replace sd8e`j'beg=`i' if sd8e`j'by==`i' & sd8e`j'bm==`i'
					capture gen sd8e`j'end =ym(sd8e`j'ey, sd8e`j'em)
					capture replace sd8e`j'end=`i' if sd8e`j'ey==`i' & sd8e`j'em==`i'
				}
			}
			forvalues x=1/8 {
				forvalues j=1/3 {
					forvalues i=-5/-1 {
					capture gen rtr7p`x'e`j'beg =ym(rtr7p`x'e`j'by, rtr7p`x'e`j'bm)
					capture replace rtr7p`x'e`j'beg=`i' if rtr7p`x'e`j'by==`i' & rtr7p`x'e`j'bm==`i'
					capture gen rtr7p`x'e`j'end =ym(rtr7p`x'e`j'ey, rtr7p`x'e`j'em)
					capture replace rtr7p`x'e`j'end=`i' if rtr7p`x'e`j'ey==`i' & rtr7p`x'e`j'em==`i'
					}
				}
			}
		l id intdat rtr7p*e*beg rtr7p*e*end sd8*beg sd8*end begp* endp* if help==1
		forvalues x=1/8 {
			foreach ding of any "by" "bm" "ey" "em" {
				forvalues  j=1/3 {
					capture noisily replace rtr7p`x'e`j'`ding'=-3 if begp`x'==-5 & endp`x'==-5
				} 
			}
		}
		l id intdat rtr7p*bm rtr7p*by rtr7p*em rtr7p*ey sd8*beg sd8*end begp* endp* if help==1
		drop sd8e*beg sd8e*end rtr7*beg rtr7*end
				
	* marriage
	drop help
	gen help=0
		forvalues x=1/8 {
				* current marriage
					capture noisily replace help=1 if rtr9==`x' & begp`x'==-5 & endp`x'==-5
				* previous marriage
					capture noisily replace help=1 if rtr13p`x'==1 & begp`x'==-5 & endp`x'==-5
			}
		count if help==1
			* 7 cases
		l id intdat sd12* rtr9 rtr10* rtr13p* rtr14p* begp* endp* if help==1
	* 133823000, 138256000, 185131000: current marriage, partner 3, but: partner 3 = current partner (m10) --> married to current partner
	* 207387000: current marriage, partner 1, but: partner 1 = current partner (m9) --> married to current partner
	foreach num of numlist 133823000 138256000 185131000 207387000 {
		replace sd12m=rtr10m if id==`num'
		replace sd12y=rtr10y if id==`num'
		replace rtr10m=-3 if id==`num'
		replace rtr10y=-3 if id==`num'
	}
	* 490787000: current marriage and three previous marriages; partner 1 and 3 = current marriage 
		* --> delete marriage partner 3 (same date as current marriage), problem: how to deal with marriage previous partner 1 --> ?!
		replace rtr13p3=0 if id==490787000
		foreach ding of any "by" "bm" "ey" "em" {
			replace rtr14p3`ding'=-3 if id==490787000
		}
	* 533125000: previous marriage, partner 4, but: partner 4 = current partner and end of previous marriage "-2" --> probably current marriage current p.
		* problem: no variable for previous marriages with current partner --> ?!
	* 707569000: previous marriage, partner 1, but: partner 1 = current partner --> ?!
		* problem: no variable for previous marriages with current partner

	
		
*****************************************
** censoring 
*****************************************

* beginning and end relationships

	** cases with -5 for beginning and end --> -3
		forvalues x=0/12 {
			gen x`x'=0
		}
		forvalues x=0/12 {
			replace x`x'=1 if begp`x'==-5 & endp`x'==-5
		}
		forvalues x=0/12 {
			count if begp`x'==-5 & endp`x'==-5
		}
			* 170 inconsistent cases
		forvalues x=0/12 {
			replace begp`x'=-3 if x`x'==1
			replace endp`x'=-3 if x`x'==1
		}
		drop x0-x12
		forvalues x=0/12 {
			count if begp`x'==-5 & endp`x'==-5
		}
			* no such cases left
		
	** cases with -5 for beginning and -3 for end --> -3 beginning
		forvalues x=0/12 {
			count if begp`x'==-5 & endp`x'==-3
		}
			* 0 cases
			
	** cases with -3 for beginning and -5 for end --> -3 end
		forvalues x=0/12 {
			count if begp`x'==-3 & endp`x'==-5
		}
			* 0 cases

	** current relationship: beginning left-censored (-77) if -1 / -2 / -5 for month and year
		count if (begp0==-1 | begp0==-2) & endp0==-99
			* 52 cases
		count if begp0==-5 & endp0==-99
			* 33 cases
		replace begp0=-77 if (begp0==-1 | begp0==-2 | begp0==-5) & endp0==-99

	** previous relationships: : beginning left-censored (-77), if -1 / -2 / -5 for month and year and valid end
		forvalues x=1/12 {
			count if (begp`x'==-1 | begp`x'==-2) & endp`x'!=-3 & endp`x'!=-5
		}
			* 639 cases
		forvalues x=1/12 {
			count if begp`x'==-5 & endp`x'!=-3 & endp`x'!=-5
		}
			* 0 cases
		forvalues x=1/12 {
			replace begp`x'=-77 if (begp`x'==-1 | begp`x'==-2 | begp`x'==-5) & endp`x'!=-3 & endp`x'!=-5
		}
	
	tab1 begp*, m
	forvalues x=0/12 {
			l id begp`x' endp`x' if begp`x'==-3 & endp`x'<0 & endp`x'!=-3
	}
			
	** current relationship: end already right-censored (-99) or -3 (if currently no relationship)

	** previous relationships: end right-censored (-88) if -1/-2/-5
		forvalues x=1/12 {
			count if endp`x'==-1 | endp`x'==-2 | endp`x'==-5
		}
			* 609 cases
		forvalues x=1/12 {
			replace endp`x'=-88 if endp`x'==-1 | endp`x'==-2 | endp`x'==-5
		}

	** previous relationships: How many cases with beginning=-77 and end=-88 
		forvalues x=1/12 {
			count if begp`x'==-77 & endp`x'==-88
		}
			* 542 cases
			
	tab1 endp*, m
	forvalues x=0/12 {
			l id begp`x' endp`x' if endp`x'==-3 & begp`x'<0 & begp`x'!=-3
	}
	

* beginning and end separations
		
	** cases with -5 for beginning and end --> -3
		forvalues x=0/12 {
			forvalues j=1/7 {
				gen x`x'y`j'=0
			}
		}
		forvalues x=0/12 {
			forvalues j=1/7 {
				capture replace x`x'y`j'=1 if b`j'p`x'beg==-5 & b`j'p`x'end==-5
			}
		}
		tab1 x*y*, m
			* 59 inconsistent cases
		forvalues x=0/12 {
			forvalues j=1/7 {
				capture noisily replace b`j'p`x'beg=-3 if x`x'y`j'==1
				capture noisily replace b`j'p`x'end=-3 if x`x'y`j'==1
			}
		}
		drop x0y1-x12y7
					
	** cases with -5 for beginning and -3 for end --> -3 beginning
		forvalues x=0/12 {
			forvalues j=1/7 {
				gen x`x'y`j'=0
			}
		}
		forvalues x=0/12 {
			forvalues j=1/7 {
				capture replace x`x'y`j'=1 if b`j'p`x'beg==-5 & b`j'p`x'end==-3
			}
		}
		tab1 x*y*, m
			* 40 cases
		forvalues x=0/12 {
			forvalues j=1/7 {
				capture noisily replace b`j'p`x'beg=-3 if x`x'y`j'==1
			}
		}
		drop x0y1-x12y7
					
	** cases with -3 for beginning and -5 for end --> -3 end
		forvalues x=0/12 {
			forvalues j=1/7 {
				gen x`x'y`j'=0
			}
		}
		forvalues x=0/12 {
			forvalues j=1/7 {
				capture replace x`x'y`j'=1 if b`j'p`x'beg==-3 & b`j'p`x'end==-5
			}
		}
		tab1 x*y*, m
			* 0 cases
		forvalues x=0/12 {
			forvalues j=1/7 {
				capture noisily replace b`j'p`x'end=-3 if x`x'y`j'==1
			}
		}
		drop x0y1-x12y7
		
	** separations current relationship: beginning left-censored (-77) if -1 / -2 / -5 and valid end
		forvalues j=1/7 {
			replace b`j'p0beg=-77 if (b`j'p0beg==-1 | b`j'p0beg==-2 | b`j'p0beg==-5) & b`j'p0end!=-3 
		}

	** separations previous relationships: beginning left-censored (-77) if -1 / -2 / -5 and valid end
		forvalues x=1/12 {
			forvalues j=1/5 {
				capture replace b`j'p`x'beg=-77 if (b`j'p`x'beg==-1 | b`j'p`x'beg==-2 | b`j'p`x'beg==-5) & b`j'p`x'end!=-3 
			}
		}
				
	tab1 b*p*beg, m
	
	** separations current relationship: end right-censored (-88) if beginning valid or -77
		forvalues j=1/7 {
			replace b`j'p0end=-88 if (b`j'p0end==-1 | b`j'p0end==-2 | b`j'p0end==-5) & b`j'p0beg!=-3 
		}

	** separations previous relationship: end right-censored (-88) if beginning valid or -77
		forvalues x=1/8 {
			forvalues j=1/3 {
			capture noisily replace b`j'p`x'end=-88  if (b`j'p`x'end==-1 | b`j'p`x'end==-2 | b`j'p`x'end==-5) & b`j'p`x'beg!=-3 
			}
		}

	tab1 b*p*end, m
	
	
	** separations current relationship: delete (-3) if beginning and end are censored (-77 and -88)
		gen x=0
		forvalues j=1/7 {
			replace x=1 if b`j'p0beg==-77 & b`j'p0end==-88
		}
		count if x==1
			* 0 cases
		drop x 
	  
	** separations previous relationships: delete (-3) if beginning and end are censored (-77 and -88)
		forvalues x=1/8 {
			forvalues j=1/5 {
				gen x`j'y`x'=0
			}
		}
		forvalues x=1/8 {
			forvalues j=1/5 {
			capture replace x`j'y`x'=1 if b`j'p`x'beg==-77 & b`j'p`x'end==-88 
		}
		}
		tab1 x*y*, m
			* 9 cases
		forvalues x=1/8 {
			forvalues j=1/5 {
				capture replace b`j'p`x'beg=-3 if x`j'y`x'==1
				capture replace b`j'p`x'end=-3 if x`j'y`x'==1
			}
		}
		drop x1y1- x5y8






**************************************
* COHABITATION
**************************************

**************************************
**************************************
*** cohabitation current partner
**************************************
**************************************

**************************************
* beginning and end 
**************************************

* second+ episode with beginning -1/-2
	forvalues x=2/5 {
		gen n`x'=0
		capture replace n`x'=1 if (sd8e`x'by==-1 | sd8e`x'by==-2) & (sd8e`x'bm==-1 |  sd8e`x'bm==-2)
	} 
	forvalues x=2/5 {
		count if n`x'==1
	}
		* 12 cases
			
	* replace -1/-2 to -3 (breaks with -1/-2 for beginning and end)
	forvalues x=2/5 {
		foreach ding of any "by" "bm" "ey" "em" {
		capture replace sd8e`x'`ding'=-3 if n`x'==1
	} 
	}
	
* only first episode with beginning -1/-2
	gen n=0
	replace n=2 if (sd8e1bm==-1 | sd8e1bm==-2) & (sd8e1by==-1 | sd8e1by==-2) & sd8e2by==-3 & sd8e3by==-3 & sd8e4by==-3 & sd8e5by==-3
	count if n==2
		* 25 cases
	l id sd8* sd7* if n==2
		* no changes

* one episode with beginning -1/-2, but additional episodes
	replace n=3 if (sd8e1bm==-1 | sd8e1bm==-2) & (sd8e1by==-1 | sd8e1by==-2) & sd8e2by!=-3 
	count if n==3
		* 0 cases
	
* correct order of episodes of cohabitation
	* description of procedure see above
	quietly ds sd8e1by sd8e2by sd8e3by sd8e4by sd8e5by sd8e2ey sd8e3ey sd8e4ey sd8e5ey
	foreach var in `r(varlist)' {
	 gen orig_`var'=`var' 
	}
	capture erase z1.dta
	capture erase z2.dta
	capture erase z3.dta
	save z1.dta, replace
	keep id sd8e1bm-sd8e5ey n
	save z2.dta, replace
	use z1.dta, clear
	drop sd8e1bm-sd8e5ey n 
	save z3.dta, replace
	use z2.dta, clear
	reshape long sd8e@bm sd8e@by sd8e@em sd8e@ey , i(id) j(episode)
	
	gen yes=(sd8eby==-3)
	bysort id (yes sd8eby sd8ebm episode): gen test1=_n
	replace episode=test1 if n!=2
	drop test1
	drop yes
	reshape wide sd8e@bm sd8e@by sd8e@em sd8e@ey , i(id) j(episode)
	merge id using z3.dta, sort
	noisily tab _merge
	drop _merge
	capture erase z1.dta
	capture erase z2.dta
	capture erase z3.dta

	order sd8e1bm-sd8e5ey, before(sd12m)

	forvalues x=1/5 {
		recode sd8e`x'bm .=-3
		recode sd8e`x'by .=-3
		recode sd8e`x'em .=-3
		recode sd8e`x'ey .=-3
	}

* generate combined variable for beginning (for all episodes)
	forvalues j=1/5 {
		forvalues i=-5/-1 {
			capture gen sd8e`j'beg =ym(sd8e`j'by, sd8e`j'bm)
			capture replace sd8e`j'beg=`i' if sd8e`j'by==`i' & sd8e`j'bm==`i'
		}
	}

* generate combined variable for end (for all episodes)
	forvalues j=1/5 {
		forvalues i=-5/-1 {
			capture gen sd8e`j'end =ym(sd8e`j'ey, sd8e`j'em)
			capture noi replace sd8e`j'end=`i' if sd8e`j'ey==`i' & sd8e`j'em==`i'
		}
	}

* check cases where beginning and end of second+ episodes are -1/-2 
* may cause problems when generating beginning / end
	forvalues j=2/5 {
		capture gen helpn2`j'=0
		capture noisily replace helpn2`j'=1 if (sd8e`j'beg==-1 | sd8e`j'beg==-2) & (sd8e`j'end==-1 | sd8e`j'end==-2)
	}
	tab1 helpn2*, m
		* 0 cases
	drop helpn2*

* check if further problems due to -1/-2 (order not correct)
	list id n sd7e1 intdat sd8e*beg sd8e*end if n!=0 
		* no problems



*******************
*** check for inconsistencies
*******************

* check19: negative durations
	gen m19=0
	forvalues j=1/5 {
			capture replace m19=1 if (sd8e`j'beg>0 & sd8e`j'end>0 & sd8e`j'beg>sd8e`j'end)	
	}
	count if m19==1
		* 1 case
	l id sd8*beg sd8*end orig_sd8* if m19==1
	* originally ambiguous season information --> interchange beginning and end
		replace sd8e1beg=sd8e1end if id==4972000
		replace sd8e1end=sd8e1beg+1 if id==4972000
	l id sd8*beg sd8*end orig_sd8* if m19==1



**************************************
* breaks
**************************************

* generate variable: any break?
	gen breakcohp0=0
	replace breakcohp0=1 if sd8e2beg!=-3
	tab1 breakcohp0, m
		* 123 cases with separations


		
*******************
*** check for inconsistencies
*******************

* check20a-h: inconsistencies across breaks

* m20a: beginning and end subsequent episode before beginning and end preceding episode 
	gen m20a=0
		forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m20a=1 if (sd8e`j'beg>0 & sd8e`b'beg>0 & sd8e`b'beg<sd8e`j'beg)	///
					& (sd8e`j'end>0 & sd8e`b'end>0 & sd8e`b'end<sd8e`j'end) 
			}
		}
		count if m20a==1
			* 0 cases


* m20b: subsequent episode (beginning and end) between beginning and end of preceding episode
	gen m20b=0
		forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m20b=1 if (sd8e`j'beg>0 & sd8e`b'beg>0 & sd8e`j'end>0 & sd8e`b'end>0 & ///
								sd8e`j'beg<sd8e`b'beg & sd8e`j'end>sd8e`b'end) 
			}
		}
		count if m20b==1
			* 1 case
		l id intdat sd8* sd7* orig_sd8* pa2m pa2y begp0 b*p0* if m20b==1
		* solution: 1st episode to -5 
		foreach ding of any "beg" "end" {
			replace sd8e1`ding'=sd8e2`ding' if id==299034000
			replace sd8e2`ding'=sd8e3`ding' if id==299034000
			replace sd8e3beg=-5 if id==299034000
		}
		l id intdat sd8* sd7* orig_sd8* pa2m pa2y begp0 b*p0* if m20b==1



* m20c: beginning and end of two episodes identical -> check if due to -1/-2 for month
	gen m20c=0
		forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m20c=1 if (sd8e`j'beg>0 & sd8e`b'beg>0 & sd8e`b'beg==sd8e`j'beg)	///
					& (sd8e`j'end>0 & sd8e`b'end>0 & sd8e`b'end==sd8e`j'end) 
			}
		}
		count if m20c==1
			* 0 cases


* m20d: (only) beginning of subsequent episode before beginning of preceding episode 
	gen m20d=0
		forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m20d=1 if (sd8e`j'beg>0 & sd8e`b'beg>0 & sd8e`b'beg<sd8e`j'beg)				
			}
		}
		count if m20d==1
		

* m20e: (only) beginning of subsequent episode before end of preceding episode 		
	gen m20e=0
		forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m20e=1 if (sd8e`j'beg>0 & sd8e`b'beg>0 & sd8e`b'beg<sd8e`j'end)	
			}
		}
		count if m20e==1
			* 7 cases
		l id intdat sd8* sd7* orig_sd8* pa2m pa2y begp0 b*p0* if m20e==1, ab(20)
		* problem due to ambiguous season information --> change slightly
		replace sd8e2beg=sd8e1end if id==198452000
		* 2nd episode part of 1st episode --> -5
		foreach num of numlist 275920000 500528000 742538000 {
			replace sd8e2beg=-5 if id==`num'
			replace sd8e1end=-5 if id==`num'
		}
		* 2nd and 3rd episode part of 1st episode --> -5
		replace sd8e2beg=sd8e3beg if id==306531000
		replace sd8e3beg=-5 if id==306531000
		replace sd8e2end=-5 if id==306531000
		foreach ding of any "beg" "end" {
			replace sd8e2beg=-5 if id==747536000
			replace sd8e1end=-5 if id==747536000
			replace sd8e3`ding'=-5 if id==747536000
		}
		* delete 3rd episode
		replace sd8e3beg=-5 if id==363572000
	* check: 
		l id intdat sd8* sd7* orig_sd8* pa2m pa2y begp0 b*p0* if m20e==1

		
* m20f: (only) end of subsequent episode before end of preceding episode 
	gen m20f=0
		forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m20f=1 if (sd8e`j'end>0 & sd8e`b'end>0 & sd8e`b'end<sd8e`j'end)
			}
		}
		count if m20f==1
			* 0 cases


* m20g: end of subsequent episode before beginning of preceding episode; beginning of subsequent episode after beginning of preceding episode
	gen m20g=0
		forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m20g=1 if (sd8e`j'beg>0 & sd8e`b'end>0 & sd8e`b'end<sd8e`j'beg)	///
					& (sd8e`j'beg>0 & sd8e`b'beg>0 & sd8e`b'beg>sd8e`j'beg) 
			}
		}
		count if m20g==1
			* 0 cases

			
* m20h: beginning or end of preceding episode -1/-2
	gen m20h=0
		forvalues j=1/5 {
			local a=`j'+1
			forvalues b=`a'/5 {
				capture replace m20h=1 if sd8e`j'end<0 & sd8e`b'end>0 
				capture replace m20h=1 if sd8e`j'beg<0 & sd8e`b'beg>0 
			}
		}
		count if m20h==1
			* 3 cases
		l id intdat sd8* sd7* orig_sd8* pa2m pa2y begp0 b*p0* if m20h==1
		* 2nd episode part of 1st episode --> -5
		foreach num of numlist 526264000 556618000 688956000 {
			foreach ding of any "beg" "end" {
			replace sd8e2`ding'=-5 if id==`num'
			}
		}
		



**************************************
* breaks cohabitation current partner
**************************************

* interchange beginning and end (breaks)
	forvalues x=1/5 {
		foreach ding of any "beg" "end" {
			if "`ding'"=="beg" {
				local dong="end"
			    local y=`x'
			}
			else {
				local dong="beg"
				local y=`x'+1
			}
			capture gen b`x'cohp0`ding'=sd8e`y'`dong' if breakcohp0==1 
			capture label var b`x'cohp0beg "Beginning break `x' cohabtiation current partner"
			capture label var b`x'cohp0end "End break `x' cohabitation current partner"
			capture recode b`x'cohp0beg .=-3
			capture recode b`x'cohp0end .=-3
			}
	}

* check: beginning = end
	forvalues x=1/5 {
		l id intdat sd7* sd8*beg sd8*end b*cohp0* orig_sd8* pa2m pa2y begp0 b*p0* if sd8e`x'beg==sd8e`x'end & sd8e`x'beg>0
	}
			* 1 case
		* okay (cohabitation 1 month)


		
*******************
*** check episodes with breaks
*******************

* generate variable: any break?
	drop breakcohp0
	gen breakcohp0=0
	forvalues x=1/5 {
		replace breakcohp0=1 if b`x'cohp0beg!=-3 & b`x'cohp0beg!=-5
	}
	tab1 breakcohp0, m
		* 116 cases with breaks

* examine these cases
	l id intdat sd7* sd8*beg sd8*end b*cohp0* orig_sd8* if breakcohp0==1 
	* strange cases: end of second episode "Don't know"; beginning probably same as beginning of 1st episode --> no additional episode --> -5
	foreach num of numlist 429426000 150674000 132022000 {
		replace b1cohp0beg=-5 if id==`num'
		replace b1cohp0end=-5 if id==`num'
		replace b2cohp0beg=-5 if id==`num' 
		replace sd8e2beg=-5 if id==`num' 
	}
	* cases with -1/-2: 44528000, 335686000, 357489000 --> will be left-censored

* any end of break = date of interview?
	forvalues x=1/4 {
		l id intdat sd7* sd8*beg sd8*end b*cohp0* orig_sd8*  if b`x'cohp0end==intdat
	}
	* 1 case, okay



**************************************
* cohabitation current partner: beginning and end
**************************************

************
*** beginning
************

gen cohp0beg=sd8e1beg
tab cohp0beg, m
lab var cohp0beg "Beginning cohabitation current partner"
tab cohp0beg, m


************
*** end
************

* new variable, no missings
	forvalues j=1/5 {
		capture gen sd8e`j'end_new=sd8e`j'end if sd8e`j'end>-3
	}
	tab1 sd8e*end_new, m

	
* generate latest end 
	** if currently not cohabiting, but in the past with breaks: end=end of last episode 
		egen cohp0end=rowlast(sd8e1end_new sd8e2end_new sd8e3end_new sd8e4end_new sd8e5end_new)
		recode cohp0end .=-3 
	** if currently not cohabiting, but in the past without any breaks: end= end of first (and only) episode 
		replace cohp0end=sd8e1end if sd7e1!=1 & sd7e2==1 & breakcohp0==0
	** if currently cohabiting: end=-99
		replace cohp0end=-99 if sd7e1==1 
	** if currently no relationship: end=-3
		replace cohp0end=-3 if begp0==-3 | begp0==-5
	** if currently not and never cohabiting: end=-3
		replace cohp0end=-3 if sd7e1!=1 & sd7e2!=1

lab var cohp0end "End cohabitation current partner"
tab cohp0end, m



**************************************
* correct breaks
**************************************
		
* end of relationship: no additional beginning
	forvalues j=1/5 {
	  capture replace b`j'cohp0beg=-3 if b`j'cohp0beg==cohp0end & cohp0end>-3
	}

* delete cases with -3 everywhere
foreach var of varlist b1cohp0beg-b5cohp0beg {
	count if `var' == -3
	if r(N) == _N drop `var'
}





**************************************
**************************************
*** cohabitation previous partners
**************************************
**************************************

**************************************
* beginning and end 
**************************************

* second+ episode with beginning -1/-2
	drop n*
	gen n=0
	forvalues x=1/8 {
		forvalues j=2/3 {
			capture replace n=1 if (rtr7p`x'e`j'by==-1 | rtr7p`x'e`j'by==-2) & (rtr7p`x'e`j'bm==-1 |  rtr7p`x'e`j'bm==-2)
		} 
	}
	count if n==1
		* 1 case
	l id rtr7* if n==1
	* double episode --> second one to -5
	replace rtr7p1e2bm=-5 if id==68649000
	replace rtr7p1e2by=-5 if id==68649000
	replace rtr7p1e2em=-5 if id==68649000
	replace rtr7p1e2ey=-5 if id==68649000


	
* only first episode with beginning -1/-2
	forvalues x=1/8 {
		capture replace n=2 if rtr7p`x'e1by==-1 & rtr7p`x'e1bm==-1 & (rtr7p`x'e2by==-3 | rtr7p`x'e2by==-5)
		capture replace n=2 if rtr7p`x'e1by==-2 & rtr7p`x'e1bm==-2 & (rtr7p`x'e2by==-3 | rtr7p`x'e2by==-5)
	}
	count if n==2
		* 120 cases
	l id rtr7* if n==2
		* no changes (will be censored later on)


* correct order of episodes of cohabitation
	* description of procedure see above
	quietly ds  rtr7p1e1by-rtr7p8e1by  rtr7p1e1ey- rtr7p8e1ey
	foreach var in `r(varlist)' {
	 gen orig_`var'=`var' 
	}
	capture erase z1.dta
	capture erase z2.dta
	capture erase z3.dta
	save z1.dta, replace
	keep id  rtr7p1e1bm-rtr7p8e1ey n
	save z2.dta, replace
	use z1.dta, clear
	drop rtr7p1e1bm-rtr7p8e1ey n 
	save z3.dta, replace
	use z2.dta, clear
	reshape long rtr7p@e1bm rtr7p@e2bm rtr7p@e3bm rtr7p@e1by rtr7p@e2by rtr7p@e3by rtr7p@e1em rtr7p@e2em rtr7p@e3em rtr7p@e1ey rtr7p@e2ey rtr7p@e3ey , i(id) j(partner)
	reshape long rtr7pe@bm rtr7pe@by rtr7pe@em rtr7pe@ey  , i(id partner) j(episode)
	gen yes=(rtr7peby<=-3)
	bysort id  partner (yes rtr7peby rtr7pebm episode): gen test1=_n
	replace episode=test1 if n!=2
		drop test1
		drop yes
	reshape wide rtr7pe@bm rtr7pe@by rtr7pe@em rtr7pe@ey  , i(id partner) j(episode)
	reshape wide rtr7p@e1bm rtr7p@e2bm rtr7p@e3bm rtr7p@e1by rtr7p@e2by rtr7p@e3by rtr7p@e1em rtr7p@e2em rtr7p@e3em rtr7p@e1ey rtr7p@e2ey rtr7p@e3ey , i(id) j(partner)
	* delete empty variables
	foreach num of numlist 1 3/8 {
		foreach ding of any "bm" "by" "em" "ey" {
		drop rtr7p`num'e3`ding'
		capture drop rtr7p6e2`ding'
		capture drop rtr7p7e2`ding'
		capture drop rtr7p8e2`ding'
	}
	}
	merge id using z3.dta, sort
	noisily tab _merge
	drop _merge
	capture erase z1.dta
	capture erase z2.dta
	capture erase z3.dta
	
	order rtr7p1e1bm-rtr7p8e1ey, before(rtr13p1)

	forvalues x=1/8 {
		forvalues j=1/3 {
		capture recode rtr7p`x'e`j'bm .=-3
		capture recode rtr7p`x'e`j'by .=-3
		capture recode rtr7p`x'e`j'em .=-3
		capture recode rtr7p`x'e`j'ey .=-3
	}
	}


* end=-3 if beginning=-3 
	forvalues x=1/8 {
		forvalues j=1/3 {
			capture replace rtr7p`x'e`j'ey=-3 if rtr7p`x'e`j'by==-3 
			capture replace rtr7p`x'e`j'em=-3 if rtr7p`x'e`j'by==-3 
		}
	}

	
* generate combined variable for beginning (for all episodes)
	forvalues x=1/8 {
		forvalues j=1/3 {
			forvalues i=-5/-1 {
			capture gen rtr7p`x'e`j'beg =ym(rtr7p`x'e`j'by, rtr7p`x'e`j'bm)
			capture noi replace rtr7p`x'e`j'beg=`i' if rtr7p`x'e`j'by==`i' & rtr7p`x'e`j'bm==`i'
			}
		}
	}
	tab1 rtr7*beg, m
	
	
* generate combined variable for end (for all episodes)
	forvalues x=1/8 {
		forvalues j=1/3 {
			forvalues i=-5/-1 {
			capture gen rtr7p`x'e`j'end =ym(rtr7p`x'e`j'ey, rtr7p`x'e`j'em)
			capture noi replace rtr7p`x'e`j'end=`i' if rtr7p`x'e`j'ey==`i' & rtr7p`x'e`j'em==`i'
			}
		}
	}
	tab1 rtr7*end, m

	
*******************
*** check for inconsistencies
*******************

* check21: negative durations
	gen m21=0
	forvalues x=1/8 {
		forvalues j=1/3 {
			capture replace m21=1 if (rtr7p`x'e`j'beg>0 & rtr7p`x'e`j'end>0 & rtr7p`x'e`j'beg>rtr7p`x'e`j'end)	
		}
	}
	count if m21==1
		* 2 cases
	l id rtr7* orig_rtr7* if m21==1 , ab(20)
	* both cases: originally ambiguous season information --> interchange beginning and end
		replace rtr7p4e1beg=rtr7p4e1end if id==31368000
		replace rtr7p4e1end=rtr7p4e1beg+2 if id==31368000
		replace rtr7p2e1beg=rtr7p2e1end if id==646580000
		replace rtr7p2e1end=rtr7p2e1beg+2 if id==646580000


**************************************
* breaks
**************************************

* generate variable: any break?
	forvalues x=1/8 {
		forvalues j=2/3 {
			capture gen breakcohp`x'=0
			capture	replace breakcohp`x'=1 if rtr7p`x'e1by>-3 & rtr7p`x'e`j'by>-3
		}
	}
	tab1 breakcohp*, m
		* 137 cases with breaks

		
		
*******************
*** check for inconsistencies
*******************

* check22a-h: inconsistencies across breaks 

* m22a: beginning and end subsequent episode before beginning and end preceding episode 
	gen m22a=0
		forvalues x=1/8 {
			forvalues j=1/3 {
				local a=`j'+1
				forvalues b=`a'/3 {
					capture replace m22a=1 if (rtr7p`x'e`j'beg>0 & rtr7p`x'e`b'beg>0 & rtr7p`x'e`b'beg<rtr7p`x'e`j'beg)	///
						& (rtr7p`x'e`j'end>0 & rtr7p`x'e`b'end>0 & rtr7p`x'e`b'end<rtr7p`x'e`j'end) 
				}
			}
		}
		count if m22a==1
			* 0 cases


* m22b: subsequent episode (beginning and end) between beginning and end of preceding episode
	gen m22b=0
		forvalues x=1/8 {
			forvalues j=1/3 {
				local a=`j'+1
				forvalues b=`a'/3 {
					capture replace m22b=1 if (rtr7p`x'e`j'beg>0 & rtr7p`x'e`b'beg>0 & rtr7p`x'e`j'end>0 & rtr7p`x'e`b'end>0 & ///
									rtr7p`x'e`j'beg<rtr7p`x'e`b'beg & rtr7p`x'e`j'end>rtr7p`x'e`b'end) 
				}
			}
		}
		count if m22b==1
			* 0 cases


* m22c: beginning and end of two episodes identical -> check if due to -1/-2 for month
	gen m22c=0
		forvalues x=1/8 {
			forvalues j=1/3 {
				local a=`j'+1
				forvalues b=`a'/3 {
					capture replace m22c=1 if (rtr7p`x'e`j'beg>0 & rtr7p`x'e`b'beg>0 & rtr7p`x'e`b'beg==rtr7p`x'e`j'beg)	///
						& (rtr7p`x'e`j'end>0 & rtr7p`x'e`b'end>0 & rtr7p`x'e`b'end==rtr7p`x'e`j'end) 
				}
			}
		}
		count if m22c==1
			* 1 case
		l id intdat rtr7* orig_rtr7* if m22c==1
		* delete double episode
		replace rtr7p1e2beg=-5 if id==482840000
		replace rtr7p1e2end=-5 if id==482840000



* m22d: (only) beginning of subsequent episode before beginning of preceding episode 
	gen m22d=0
		forvalues x=1/8 {
			forvalues j=1/3 {
				local a=`j'+1
				forvalues b=`a'/3 {
					capture replace m22d=1 if (rtr7p`x'e`j'beg>0 & rtr7p`x'e`b'beg>0 & rtr7p`x'e`b'beg<rtr7p`x'e`j'beg)				
				}
			}
		}
		count if m22d==1
			* 0 cases


* m22e: (only) beginning of subsequent episode before end of preceding episode 
	gen m22e=0
		forvalues x=1/8 {
			forvalues j=1/3 {
				local a=`j'+1
				forvalues b=`a'/3 {
					capture replace m22e=1 if (rtr7p`x'e`j'beg>0 & rtr7p`x'e`b'beg>0 & rtr7p`x'e`b'beg<rtr7p`x'e`j'end)	
				}
			}
		}
		count if m22e==1
			* 1 case
		l id intdat rtr7* orig_rtr7* if m22e==1
		* 2nd episode part of 1st episode --> delete 2nd one
		foreach ding of any "beg" "end" {
			replace rtr7p1e2`ding'=-5 if id==76034000
		}


* m22f: (only) end of subsequent episode before end of preceding episode 
	gen m22f=0
		forvalues x=1/8 {
			forvalues j=1/3 {
				local a=`j'+1
				forvalues b=`a'/3 {
					capture replace m22f=1 if (rtr7p`x'e`j'end>0 & rtr7p`x'e`b'end>0 & rtr7p`x'e`b'end<rtr7p`x'e`j'end)
				}
			}
		}
		count if m22f==1
			* 0 cases



* m22g: end of subsequent episode before beginning of preceding episode; beginning of subsequent episode after beginning of preceding episode
	gen m22g=0
		forvalues x=1/8 {
			forvalues j=1/3 {
				local a=`j'+1
				forvalues b=`a'/3 {
					capture replace m22g=1 if (rtr7p`x'e`j'beg>0 & rtr7p`x'e`b'end>0 & rtr7p`x'e`b'end<rtr7p`x'e`j'beg)	///
						& (rtr7p`x'e`j'beg>0 & rtr7p`x'e`b'beg>0 & rtr7p`x'e`b'beg>rtr7p`x'e`j'beg) 
				}
			}
		}
		count if m22g==1
			* 0 cases

		
* m22h: beginning or end of preceding episode -1/-2
	gen m22h=0
		forvalues x=1/8 {
			forvalues j=1/3 {
				local a=`j'+1
				forvalues b=`a'/3 {
					capture replace m22h=1 if rtr7p`x'e`j'end<0 & rtr7p`x'e`b'end>0 
					capture replace m22h=1 if rtr7p`x'e`j'beg<0 & rtr7p`x'e`b'beg>0 
				}
			}
		}
		count if m22h==1
			* 1 case
		l id intdat rtr7*beg rtr7*end orig_rtr7*  if m22h==1
		* no change


		

			


			
**************************************
* breaks cohabitation previous partners
**************************************

* interchange beginning and end (breaks)
	forvalues j=1/8 {
		forvalues x=1/3 {
		foreach ding of any "beg" "end" {
			if "`ding'"=="beg" {
			local dong="end"
			local y=`x'
		}
		else {
			local dong="beg"
			local y=`x'+1
		}
		capture gen b`x'cohp`j'`ding'=rtr7p`j'e`y'`dong' if breakcohp`j'==1 
		capture label var b`x'cohp`j'beg "Beginning break `x' cohabitation partner `j'"
		capture label var b`x'cohp`j'end "End break `x' cohabitation partner `j'"
		capture recode b`x'cohp`j'beg .=-3
		capture recode b`x'cohp`j'end .=-3
		}
		}
	}



*******************
*** check episodes with breaks
*******************

* generate variable: any break?
	drop breakcohp*
	forvalues x=1/8 {
		forvalues j=2/3 {
		capture gen breakcohp`x'=0
		capture	replace breakcohp`x'=1 if b`j'cohp`x'beg!=-3 & b`j'cohp`x'beg!=-5
	}
	}
	tab1 breakcohp*, m
		* 19 cases with breaks
	
* examine these cases
	l id rtr7*beg rtr7*end b*coh*beg b*coh*end if breakcohp1==1
	l id rtr7*beg rtr7*end b*coh*beg b*coh*end if breakcohp2==1  
	l id rtr7*beg rtr7*end b*coh*beg b*coh*end if breakcohp3==1 
	l id rtr7*beg rtr7*end b*coh*beg b*coh*end if breakcohp4==1 
	l id rtr7*beg rtr7*end b*coh*beg b*coh*end if breakcohp5==1 
		

* check23: any end of break = date of interview?
	gen m23=0
		forvalues x=1/8 {
			forvalues j=1/3 {
			capture noisily replace m23=1 if b`j'cohp`x'end==intdat
		}
		}
		count if m23==1
			* 0 cases



**************************************
* cohabitation previous partners: beginning and end
**************************************

************
*** beginning
************

forvalues x=1/8 {
	capture gen cohp`x'beg=rtr7p`x'e1beg
}
tab1 cohp*beg, m


************
*** end
************

* new variable, no missings
	forvalues x=1/8 {
		forvalues j=1/3 {
			capture gen rtr7p`x'e`j'end_new=rtr7p`x'e`j'end if rtr7p`x'e`j'end>-3
		}
	}
	tab1 rtr7p*e*end_new, m

	
* generate latest end for each partner
	** if any breaks: end=end of last episode
		* 1 episode
		foreach x of numlist 6 7 8 {
			capture gen cohp`x'end=rtr7p`x'e1end_new
		}
		* 2 episodes
		foreach x of numlist 1 3 4 5 {
			capture egen cohp`x'end=rowlast(rtr7p`x'e1end_new rtr7p`x'e2end_new)
		}
		* 3 episodes
		egen cohp2end=rowlast(rtr7p2e1end_new rtr7p2e2end_new rtr7p2e3end_new)

	** if no breaks: end=end of 1st episode
	forvalues x=1/8 {
		capture replace cohp`x'end=rtr7p`x'e1end_new if breakcohp`x'==0
	}

order cohp2end, after(cohp1end)

forvalues x=1/8 {
	capture recode cohp`x'end .=-3
	lab var cohp`x'beg "Beginning cohabitation partner `x'"
	lab var cohp`x'end "End cohabitation partner `x'"
}
tab1 cohp*beg, m
tab1 cohp*end, m


**************************************
* correct breaks
**************************************
		
* end of relationship: no additional beginning
	forvalues x=1/8 {
		forvalues j=1/3 {
			capture replace b`j'cohp`x'beg=-3 if b`j'cohp`x'beg==cohp`x'end & cohp`x'end>-3 & breakcohp`x'==1
		}
	}
	l id cohp*beg cohp*end b*coh*beg b*coh*end rtr7*beg rtr7*end if cohp1beg>-3 & breakcohp1==1
	l id cohp*beg cohp*end b*coh*beg b*coh*end rtr7*beg rtr7*end if cohp2beg>-3 & breakcohp2==1
	l id cohp*beg cohp*end b*coh*beg b*coh*end rtr7*beg rtr7*end if cohp3beg>-3 & breakcohp3==1
	l id cohp*beg cohp*end b*coh*beg b*coh*end rtr7*beg rtr7*end if cohp4beg>-3 & breakcohp4==1
	l id cohp*beg cohp*end b*coh*beg b*coh*end rtr7*beg rtr7*end if cohp5beg>-3 & breakcohp5==1
	l id cohp*beg cohp*end b*coh*beg b*coh*end rtr7*beg rtr7*end orig_rtr7*bm orig_rtr7*by orig_rtr7*em orig_rtr7*ey if id==531488000 
	tab1 b*coh*beg, m
	tab1 b*coh*end, m

* delete cases with -3 everywhere
foreach var of varlist b1cohp1beg-b1cohp8beg {
	count if `var' == -3
	if r(N) == _N drop `var'
}



*****************************************
** censoring 
*****************************************

* beginning and end cohabitation
	tab1 cohp*beg, m
	tab1 cohp*end, m

	** beginning left-censored (-77) if -1 / -2 and valid end
		replace cohp0beg=-77 if cohp0beg==-1 | cohp0beg==-2
		forvalues x=1/8 {
			capture replace cohp`x'beg=-77 if (cohp`x'beg==-1 | cohp`x'beg==-2) & cohp`x'end>-3
		}
		
	** end right-censored (-88) if beginning valid or -77
	forvalues x=0/8 {
		list id cohp*beg cohp*end b*coh*beg b*coh*end  if (cohp`x'end==-1 | cohp`x'end==-2) & cohp`x'beg!=-3 & cohp`x'beg!=-5
	}
	forvalues x=0/8 {
		replace cohp`x'end=-88  if (cohp`x'end==-1 | cohp`x'end==-2) & cohp`x'beg!=-3 & cohp`x'beg!=-5
	}
	forvalues x=0/8 {
		list id cohp*beg cohp*end b*coh*beg b*coh*end  if cohp`x'end==-88
	}

	
* beginning and end breaks
	tab1 b*cohp*beg, m
	tab1 b*cohp*end, m

	** cases with -5 for beginning and end --> -3
		forvalues x=0/8 {
			forvalues j=1/3 {
				gen x`x'y`j'=0
			}
		}
		forvalues x=0/8 {
			forvalues j=1/3 {
				capture replace x`x'y`j'=1 if b`j'cohp`x'beg==-5 & b`j'cohp`x'end==-5
			}
		}
		tab1 x*y*, m
			* 8 inconsistent cases
		forvalues x=0/8 {
			forvalues j=1/3 {
				capture noisily replace b`j'cohp`x'beg=-3 if x`x'y`j'==1
				capture noisily replace b`j'cohp`x'end=-3 if x`x'y`j'==1
			}
		}
		drop x0y1-x8y3
	
	** cases with -5 for beginning and -3 for end --> -3 beginning
		forvalues x=0/8 {
			forvalues j=1/3 {
				gen x`x'y`j'=0
			}
		}
		forvalues x=0/8 {
			forvalues j=1/3 {
				capture replace x`x'y`j'=1 if b`j'cohp`x'beg==-5 & b`j'cohp`x'end==-3
			}
		}
		tab1 x*y*, m
			* 7 cases
		forvalues x=0/8 {
			forvalues j=1/3 {
				capture noisily replace b`j'cohp`x'beg=-3 if x`x'y`j'==1
			}
		}
		drop x0y1-x8y3
				
	** cases with -3 for beginning and -5 for end --> -3 end
		forvalues x=0/8 {
			forvalues j=1/3 {
				gen x`x'y`j'=0
			}
		}
		forvalues x=0/8 {
			forvalues j=1/3 {
				capture replace x`x'y`j'=1 if b`j'cohp`x'beg==-3 & b`j'cohp`x'end==-5
			}
		}
		tab1 x*y*, m
			* 5 cases
		forvalues x=0/8 {
			forvalues j=1/3 {
				capture noisily replace b`j'cohp`x'end=-3 if x`x'y`j'==1
			}
		}
		drop x0y1-x8y3
	
	** beginning left-censored (-77) if -1/-2 and valid end
	forvalues x=0/8 {
		forvalues j=1/3 {
			capture replace b`j'cohp`x'beg=-77 if (b`j'cohp`x'beg==-1 | b`j'cohp`x'beg==-2 | b`j'cohp`x'beg==-5) & b`j'cohp`x'end!=-3 
		}
	}
	tab1 b*cohp*beg, m
		** examine cases with -5
		l id cohp*beg cohp*end b*coh*beg b*coh*end  if b2cohp1beg==-5
		drop b2cohp1beg
		
	
	** end right-censored (-88) if beginning valid or -77
	forvalues x=1/8 {
		forvalues j=1/3 {
			capture replace b`j'cohp`x'end=-88  if (b`j'cohp`x'end==-1 | b`j'cohp`x'end==-2 | b`j'cohp`x'end==-5) & b`j'cohp`x'beg!=-3 
		}
	}
	tab1 b*cohp*end, m 
	
	
	
*****************************************
** generate additional "empty" variables
*****************************************	

* add variables for cohabitation with partners 9-12 to avoid confusion (only for beginning and end, not so for breaks)
	forvalues x=9/12 {
		gen cohp`x'beg=-3
		gen cohp`x'end=-3
	}

* labels
	forvalues x=9/12 {
		lab var cohp`x'beg "Beginning cohabitation partner `x'"
		lab var cohp`x'end "End cohabitation partner `x'"	
	}







**************************************
* MARRIAGE HISTORY
**************************************


**************************************
**************************************
*** current marriage current partner 
**************************************
**************************************

**************************************
* beginning and end current marriage
**************************************

* date beginning
	gen marp0beg=ym(sd12y, sd12m)
	forvalues i=-5/-1 {
		capture replace marp0beg=`i' if sd12y==`i' & sd12m==`i'
	}
	tab marp0beg, m

* beginning left-censored (-77) if -1 / -2 
	replace marp0beg=-77 if marp0beg==-1 | marp0beg==-2	
	
* date end: -99 (ongoing)
	gen marp0end=0
	replace marp0end=-99 if marp0beg>-3 | marp0beg==-77
	replace marp0end=-3 if marp0beg<=-3 & marp0beg!=-77
	tab marp0end, m	
		
* labels
	lab var marp0beg "Beginning marriage current partner"
	lab var marp0end "End marriage current partner"

tab marp0beg, m
tab marp0end, m




*******************
*** check for inconsistencies
*******************		

* check24: first meeting and marriage
	gen m24=1 if meetp0>marp0beg & marp0beg>0 & meetp0>0
		count if m24==1
			* 10 cases
		l meetp0 marp0beg flag5 if m24==1		
		* no changes possible
		

* check25: beginning of relationship and marriage --> also see flag5
	gen m25=1 if begp0>marp0beg & marp0beg>0 & begp0>0
		count if m25==1
			* 52 cases 
		l id flag5 meetp0 begp0 marp0beg pa2* orig_pa2* sd5e1b* orig_sd5e1b*  sd12* orig_sd12* if m25==1, ab(20) 		
		* problems due to ambiguous seasons information (e.g. 27):
 			* solution: change months (-1 or -2)
				replace begp0=begp0-1 if id==390487000 | id==489270000 | id==736844000	| id==690856000
				replace begp0=begp0-2 if id==5559000 | id==207387000 | id==361806000 | id==370040000 | id==453910000
				replace meetp0=meetp0-1 if id==442846000
		* no further changes possible 

				
**************************************
* marriage ceremony
**************************************

gen marp0cer=sd13

* labels
	lab var marp0cer "Marriage ceremony current partner"

tab marp0cer, m

	

		
**************************************
**************************************
*** current marriage previous partner 
**************************************
**************************************

**************************************
* beginning and end current marriage
**************************************

* date beginning
	forvalues x=1/8 {
		gen marp`x'beg=ym(rtr10y, rtr10m) if rtr9==`x'
	}
	forvalues x=1/8 {
		forvalues i=-5/-1 {
			capture replace marp`x'beg=`i' if rtr10y==`i' & rtr10m==`i' & rtr9==`x'
		}
	}
	forvalues x=1/8 {
		recode marp`x'beg . =-3
	}
	tab1 marp*beg, m

* beginning left-censored (-77) if -1 / -2 
	forvalues x=1/8 {
		replace marp`x'beg=-77 if marp`x'beg==-1 | marp`x'beg==-2
	}

* date end: -99 (ongoing)
	forvalues x=1/8 {
		gen marp`x'end=0
		replace marp`x'end=-99 if marp`x'beg>-3 | marp`x'beg==-77
		replace marp`x'end=-3 if marp`x'beg<=-3 & marp`x'beg!=-77
	}
	tab1 marp*end, m	
	
* labels
	forvalues x=1/8 {
		lab var marp`x'beg "Beginning marriage partner `x'"
		lab var marp`x'end "End marriage partner `x'"	
	}

	
*******************
*** check for inconsistencies
*******************		
	
* check26: beginning of relationship and marriage
	gen m26=0
		forvalues x=1/8 {
			replace m26=1 if begp`x'>marp`x'beg & marp`x'beg>0 & begp`x'>0
		}
		count if m26==1
			* 2 cases
		list id flag* begp* marp*beg rtr2p* orig_rtr2* rtr10* orig_rtr10* if m26==1 
		* no changes adequate


		
**************************************
* marriage ceremony
**************************************
		
forvalues x=1/8 {
	gen marp`x'cer=rtr11 if rtr9==`x'
}
forvalues x=1/8 {
	recode marp`x'cer . =-3
}
tab1 mar*cer, m




**************************************
**************************************
*** previous marrriages 
**************************************
**************************************

* date beginning
	forvalues x=1/8 {
		capture replace marp`x'beg=ym(rtr14p`x'by, rtr14p`x'bm) if rtr13p`x'==1
	}
	forvalues x=1/8 {
		forvalues i=-5/-1 {
			capture replace marp`x'beg=`i' if rtr14p`x'by==`i' & rtr14p`x'bm==`i' & rtr13p`x'==1
		}
	}
	forvalues x=1/8 {
		capture recode marp`x'beg . =-3
	}
	tab1 marp*beg, m
	

* beginning left-censored (-77) if -1 / -2
	forvalues x=1/8 {
		capture replace marp`x'beg=-77 if marp`x'beg==-1 | marp`x'beg==-2
	}

* date end
	forvalues x=1/8 {
		capture replace marp`x'end=ym(rtr14p`x'ey, rtr14p`x'em) if rtr13p`x'==1
	}
	forvalues x=1/8 {
		forvalues i=-5/-1 {
			capture replace marp`x'end=`i' if rtr14p`x'ey==`i' & rtr14p`x'em==`i' & rtr13p`x'==1
		}
	}
	forvalues x=1/8 {
		capture recode marp`x'end . =-3
	}

* end right-censored (-88) if -1 / -2 
	forvalues x=1/8 {
		capture replace marp`x'end=-88 if marp`x'end==-1 | marp`x'end==-2
	}
	tab1 marp*end, m




*******************
*** check for inconsistencies
*******************	

* check27: marriage with same partner currently and in the past?
	forvalues x=1/8 {
		capture gen m27=1 if rtr9==`x' & rtr13p`x'==1
	}
	count if m27==1
		* 0 cases; no breaks


* check28: beginning of relationship after marriage
	forvalues x=1/8 {
		gen m28`x'=1 if begp`x'>marp`x'beg & marp`x'beg>0 & begp`x'>0
	}
	tab1 m28*, m
		* 17 cases
	l id  begp* endp* marp*beg marp*end rtr2p* orig_rtr2* rtr14* orig_rtr14*  rtr10* orig_rtr10* flag* if m281==1, ab(20)
	* problems due to ambiguous season information --> change months slightly
		replace marp1beg=marp1beg+1 if id==71722000
		replace begp1=begp1-2 if id==441361000
	* no other changes possible


* check29: end of relationship before beginning of marriage
	forvalues x=1/8 {
		gen m29`x'end=1 if endp`x'<marp`x'beg & marp`x'beg>0 & endp`x'>0
	}
	tab1 m29*, m
		* 9 cases
	l id  begp* endp* marp*beg marp*end rtr2p* orig_rtr2* rtr14* orig_rtr14*  rtr10* orig_rtr10* flag* if m291==1, ab(20)
	l id  begp* endp* marp*beg marp*end rtr2p* orig_rtr2* rtr14* orig_rtr14*  rtr10* orig_rtr10* flag* if m292==1, ab(20)
	l id  begp* endp* marp*beg marp*end rtr2p* orig_rtr2* rtr14* orig_rtr14*  rtr10* orig_rtr10* flag* if m294==1, ab(20)
	* no changes possible

		
* check30 (see flag8): end of previous marriage after beginning of current marriage
	forvalues x=1/8 {
		l id flag8 marp`x'end marp0beg rtr14* orig_rtr14* sd12* orig_sd12* if marp`x'end>marp0beg & marp0beg!=-3 & marp`x'end!=-3
	}
	* no changes possible (due to diverging years)


	
**************************************
* marriage ceremony
**************************************

* generate variable for 7th partner (empty, but confusing if missing)
gen rtr15p7=-3

* previous marriages: rtr15px
forvalues x=1/8 {
	capture replace marp`x'cer=rtr15p`x' if rtr13p`x'==1
}
forvalues x=1/8 {
	recode marp`x'cer . =-3
}


* labels
	forvalues x=1/8 {
		lab var marp`x'cer "Marriage ceremony partner `x'"
	}
tab1 mar*cer, m



*****************************************
** generate additional "empty" variables
*****************************************	

* add variables for marriage with partners 9-12 to avoid the assumption that these episodes have been forgotten
* (only for beginning and end, not so for breaks)
	forvalues x=9/12 {
		gen marp`x'beg=-3
		gen marp`x'end=-3
		gen marp`x'cer=-3
	}

* labels
	forvalues x=9/12 {
		lab var marp`x'beg "Beginning marriage partner `x'"
		lab var marp`x'end "End marriage partner `x'"	
		lab var marp`x'cer "Marriage ceremony partner `x'"
	}



**************************************
* DROP ORIGINAL AND AUXILIARY VARIABLES
**************************************

drop 																				///
sex_gen psex_gen																	/// 		
sd5e*em sd5e*ey sd5e*bm sd5e*by 													/// 		
rtr1p*g 																			/// 		
rtr2p* rtr4p*																		///
sd7e1 sd7e2 sd8*																	/// 		
rtr7*																				/// 		
sd12m sd12y sd13 																	/// 		
rtr9 rtr10* rtr11* 																	/// 		
rtr13p* rtr14p*bm rtr14p*by rtr15p* rtr14p*em rtr14p*ey 							/// 		
pa2m pa2y pa3 																		/// 		
dobm_gen doby_gen pdobm_gen pdoby_gen												/// 		
intd intm inty 																		/// 		
m1 m2 m3 m4 m5-m6h m6a m8-m17b12e7 m19 m20* m21-m22h m23 m24 m25 m26 m27- m298end 	///
n* orig_* b*bm b*by b*em b*ey break* help probl_*			 		




**************************************
* INDEX FOR ORDER OF RELATIONSHIPS (current and previous)
**************************************

* check30: wrong order of relationships (not ascending)
	gen m30=0
	forvalues x=0/20 {
		local a=`x'+1
			forvalues b=`a'/20 {
			capture replace m30=1 if begp`x'>begp`b' & begp`x'>0 & begp`b'>0 
		}
	}
	count if m30==1
		* 3937 cases (no -77); mostly because of begp0
	

* generate variable "index" to indicate correct (ascending) order of relationships
	* similar to procedure above	
	* generate duplicates of begp0-begp12
	forvalues x=0/12 {
		gen nbegp`x'=begp`x'
	}
	quietly ds nbegp0-nbegp12
	save z1.dta, replace
	keep id nbegp0-nbegp12 m30
	save z2.dta, replace
	use z1.dta, clear
	drop nbegp0-nbegp12 m30
	save z3.dta, replace
	use z2.dta, clear
	reshape long nbegp@  , i(id) j(partner)
	gen yes=(nbegp==-3)
	bysort id (yes nbegp partner): gen test=_n
	drop yes		
	replace test=-3 if nbegp==-3
	reshape wide nbegp@ test@ , i(id) j(partner)
	merge id using z3.dta, sort
	noisily tab _merge
	drop _merge
	capture erase z1.dta
	capture erase z2.dta
	capture erase z3.dta
	drop nbeg*
	
* generate variable "indexp"	
	forvalues x=0/12 {
		gen indexp`x'= test`x'
	}
	drop test*	
	
	
* differentiate cases with begpx=-77:	
	gen mis=.
		* bla=number of -77/-3 previous partners
	forvalues x=1/12 {
		gen help`x'=(begp`x'==-77 | begp`x'==-3)  
	}
	egen bla=rsum(help*)
	
	* if begpx=-77 or -3 for all previous partners and no current partner --> no problem (no matter if current partner existing) --> mis=0
	replace mis=0 if bla==12 & begp0==-3
	
	* if begpx=-77 or -3 for all previous partners and current partner existing --> no problem --> mis=1
	replace mis=1 if bla==12 & begp0!=-3	
	count if mis==1
		* 3370 cases 
		
	* if begpx=-77 for at least one previous partner and additional previous partners & begp0 not -77 --> maybe problem --> mis=2
	forvalues x=1/12 {
		replace mis=2 if begp`x'==-77 & bla<12 & begp0!=-77
	}
	count if mis==2	
		* 168 cases
	l id begp* indexp* if mis==2
	
	* if begp1=-77 & no other additional partner -77 & begp0 not -77 --> no problem --> mis=3
	drop help*
	forvalues x=1/12 {
		gen help`x'=(begp`x'==-77) 
	}
	egen bla2=rsum(help*)	
	forvalues x=1/12 {
		replace mis=3 if begp1==-77 & bla2==1 & begp0!=-77
	}
	count if mis==3	
		* 244 cases
	count if mis==2
		* 86 cases left
	
	* if begp0=-77 & at least one previous partner --> mis=4
	drop help*
	forvalues x=1/12 {
		gen help`x'=(begp`x'==-77 | begp`x'>0) 
	}
	egen bla3=rsum(help*)
	replace indexp0=bla3+1 if begp0==-77
	forvalues x=1/12 {
		replace mis=4 if begp0==-77 & indexp`x'>0
	}	
	count if mis==4
		* 34 cases
	forvalues x=1/12 {
		replace indexp`x'=indexp`x'-1 if mis==4
	}	
	l id begp* indexp* if begp0==-77
	
	* problematic: mis=2 
	count if mis==2	
		* 86 cases 
	* mis=2:			
	l id bla3 begp* indexp* if mis==2 
	* change order for the following anchors; keep original order as provided by the anchor:
	forvalues x=1/12 {
		replace indexp`x'=`x' if `x'<=bla3 & begp`x'!=-3 & mis==2
	}
	* order not correct: 704989000, 480999000, 418988000, 252566000, 191511000, 178808000, 160089000, 155404000, 143990000  
	forvalues x=1/12 {
		replace indexp3=4 if id==704989000
		replace indexp4=3 if id==704989000
		replace indexp3=2 if id==480999000
		replace indexp0=4 if id==418988000
		replace indexp2=1 if id==252566000
		replace indexp3=2 if id==252566000
		replace indexp4=3 if id==252566000
		replace indexp1=5 if id==252566000
		replace indexp4=6 if id==191511000
		replace indexp6=4 if id==191511000
		replace indexp3=4 if id==178808000
		replace indexp4=3 if id==178808000
		replace indexp3=4 if id==160089000
		replace indexp4=3 if id==160089000
		replace indexp1=3 if id==155404000
		replace indexp3=1 if id==155404000
		replace indexp6=5 if id==143990000
		replace indexp5=6 if id==143990000
	}	
	l id bla begp* indexp* if mis==2 
	
* any -3 in between: 
	forvalues x=1/12 {
		replace mis=5 if begp`x'==-3 & `x'<=bla3
	}		
	l id begp* indexp* if mis==5
	* no changes necessary

	
* indexpx: -4 = -3	
	forvalues x=1/12 {
		replace indexp`x'=-3 if indexp`x'==-4
	}
	
	
	
* label new variable
	lab var indexp0 "Correct order of relationships: Number current partner"
	lab var indexp1 "Correct order of relationships: Number partner 1"
	lab var indexp2 "Correct order of relationships: Number partner 2" 
	lab var indexp3 "Correct order of relationships: Number partner 3"
	forvalues x=4/12 {
		lab var indexp`x' "Correct order of relationships: Number partner `x'"
	}
	tab1 indexp*, m
	l id begp* indexp* if mis==2 

drop mis
drop bla*
drop help*
drop m30





**************************************
* ORDER OF VARIABLES
**************************************
order index*, sequential
order drop*, sequential
order marp*cer, sequential
order marp*end, sequential
order marp*beg, sequential
order b1cohp*end b2cohp*end b3cohp*end, sequential
order b1cohp*beg b2cohp*beg b3cohp*beg, sequential
order cohp*end, sequential
order cohp*beg, sequential
order reasendp*, sequential
order b1p*end b2p*end b3p*end b4p*end b5p*end b6p*end b7p*end , sequential
order b1p*beg b2p*beg b3p*beg b4p*beg b5p*beg b6p*beg b7p*beg, sequential 
order begp* endp*, sequential
order sexp*, sequential
order id intdat sex dob pid dobp0 meetp0 waymeetp0, first



**************************************
* VALUES DATES
**************************************

* change baseline date from January 1960 (default in Stata) to January 1900

replace intdat=intdat-ym(1900,1)
replace dob=dob-ym(1900,1) if dob>0
* dobp0: already transformed; see above
replace meetp0=meetp0-ym(1900,1) if meetp0>0

forvalues x=0/12 {
	replace begp`x'=begp`x'-ym(1900,1) if begp`x'>0 
	replace endp`x'=endp`x'-ym(1900,1) if endp`x'>0
	capture noisily replace cohp`x'beg=cohp`x'beg-ym(1900,1) if cohp`x'beg>0
	capture noisily replace cohp`x'end=cohp`x'end-ym(1900,1) if cohp`x'end>0
	capture noisily replace marp`x'beg=marp`x'beg-ym(1900,1) if marp`x'beg>0
	capture noisily replace marp`x'end=marp`x'end-ym(1900,1) if marp`x'end>0
}
	
forvalues x=0/12 {
	forvalues k=1/7 {
		capture noisily replace b`k'p`x'beg=b`k'p`x'beg-ym(1900,1) if b`k'p`x'beg>0
		capture noisily replace b`k'p`x'end=b`k'p`x'end-ym(1900,1) if  b`k'p`x'end>0
		capture noisily replace b`k'cohp`x'beg=b`k'cohp`x'beg-ym(1900,1) if b`k'cohp`x'beg>0
		capture noisily replace b`k'cohp`x'end=b`k'cohp`x'end-ym(1900,1) if b`k'cohp`x'end>0
	}
}
	

	

**************************************
* VARIABLE AND VALUE LABELS
**************************************

lab var dropp0 "Current partner dropped"

forvalues x=1/12 {
	forvalues k=1/7 {
		lab var dropp`x' "Partner `x' dropped"
	}
}

* value labels
	* dates episodes
		lab def date1 -77 "-77 Don't know/No answer" -88 "-88 Don't know/No answer" ///
						-99 "-99 Ongoing" -3 "-3 Does not apply" 
		lab val b* date1
		lab val end* date1
		lab val coh* date1
		lab val mar*beg date1
		lab val mar*end date1
	* dates events
		lab def date2 -3 "-3 Does not apply" -2 "-2 No answer" -1 "-1 Don't know"
		lab val dob date2
		lab val meetp0 date2
	* date of birth current partner
		lab def dobp0 -7 "-7 Inconsistent value" -3 "-3 Does not apply" -2 "-2 No answer" -1 "-1 Don't know"
		lab val dobp0 dobp0
	* way of meeting
		lab def waymeet -3 "-3 Does not apply" -2 "-2 No answer" -1 "-1 Don't know" ///
				1 "1 Through school, training, work" 2 "2 Hobby, club, sport" 3 "3 Bar, disco" 4 "4 Through friends or acquaintances" ///
				5 "5 Through relatives" 6 "6 Through a personal ad" 7 "7 Via the internet" 8 "8 Vacation" 9 "9 Other"
		lab val waymeetp0 waymeet 
		tab waymeetp0, m
	* sex, sexp* 
		lab def sex -3 "-3 Does not apply" -2 "-2 No answer" -1 "-1 Don't know" 1 "1 Male" 2 "2 Female"
		lab val sexp* sex
		lab val sex sex
		tab1 sex, m
		tab1 sexp*, m
	* reasendp*
		lab def reasend -3 "-3 Does not apply" -2 "-2 No answer" -1 "-1 Don't know" ///
						1 "1 Through separation" 2 "2 Through divorce" 3 "3 Through passing away of partner"
		lab val reasendp* reasend
		tab1 reasend*, m
	* marp*cer
		lab def marcer 	-3 "-3 Does not apply" -2 "-2 No answer" -1 "-1 Don't know" ///
						1 "1 Only a civil ceremony" 2 "2 A civil and a religious ceremony" 3 "3 Only a religious ceremony"
		lab val marp*cer marcer
		tab1 marp*cer, m
	* indexp*
		lab def index	-3 "-3 Does not apply" 1 "1st partner" 2 "2nd partner" 3 "3rd partner" 4 "4th partner" 5 "5th partner" ///
						6 "6th partner" 7 "7th partner" 8 "8th partner" 9 "9th partner" 10 "10th partner" 11 "11th partner" 12 "12th partner" ///
						13 "13th partner"
		lab val indexp* index
	* dropp*
		lab def drop 0 "0 Partner not dropped" 1 "1 Partner dropped; inconsistent"
	

compress
datasignature set, reset

cd "$w2data_local_v2_1"
save biopart1_v2.dta, replace












*--------------------------------------------------------------------------------------------------*
*--------------------------------------------------------------------------------------------------*
* STEP II) adding data from wave 2
*--------------------------------------------------------------------------------------------------*
*--------------------------------------------------------------------------------------------------*


*******************************	
*******************************	
** Data from biopart wave 1
*******************************	
*******************************	


* load biopart from wave 1, version 2.0 
	cd "$w2data_local_v2_1"
	use biopart1_v2.dta, clear




*******************************	
* reshape this data to long format 
*******************************	

	reshape long dobp@ meetp@ waymeetp@ sexp@ begp@ endp@ b1p@beg b2p@beg b3p@beg b4p@beg ///
		b5p@beg b6p@beg b7p@beg b1p@end b2p@end b3p@end b4p@end b5p@end b6p@end b7p@end ///
		reasendp@ cohp@beg b1cohp@beg b2cohp@beg b3cohp@beg b1cohp@end b2cohp@end b3cohp@end ///
		cohp@end marp@beg marp@end marp@cer dropp@ indexp@ , i(id) j(partner)
	


	
*******************************	
**** modifications / corrections data wave 1
*******************************	

* reasendp current partner: .=-3 (did not exist in biopart wave 1)
	recode reasendp .=-3

* format
	format %12.0f id

* droppx: -3 if partner does not exist
	** will be solved when deleting empty variables

* delete cases with sexp =-2 or -1 and everything else -3
	count if sexp==-1
	count if sexp==-2
	*list sexp begp endp cohpbeg cohpend marpbeg marpend flag* if sexp==-2 | sexp==-1
* If partner's sex is "-1" or "-2", no additional questions regarding this partner (see filter) 
* Assumption: Partner does not exist --> -3
	gen help=0
	foreach var of varlist begp-marpend {
		bysort id: replace help=help+1 if `var'==-3
	}
	tab sexp, m
	l id if (sexp==-2 | sexp==-1) & help==7
	replace sexp=-3 if (sexp==-2 | sexp==-1) & help==7
	drop help
	
* drop partners who have been identified as inconsistencies in wave 1 (see variable "dropp")
	tab dropp, m
	drop if dropp==1
	drop dropp

* delete empty variables 
	gen help=0
	foreach var of varlist sexp-marpend {
		bysort id: replace help=help+1 if `var'==-3
	}
	tab help, m
	drop if help==8
	drop help

* missing values: -3 instead of .
	foreach var of varlist dobp meetp waymeetp b1pbeg-b3cohpend {
		recode `var' .=-3
	}	
	
* pid: only if current partner, else -3 	
	replace pid=-3 if partner!=0
	
* marpcer: 4 cases without information regarding marriage ceremony despite of marriage 	
	l if marpbeg!=-3 & marpcer==-3
	* reason: wrong partner number; see data set "anchor1"
	replace marpcer=1 if id==133823000 & indexp==3
	replace marpcer=-2 if id==138256000 & indexp==3
	replace marpcer=-2 if id==185131000 & indexp==3
	replace marpcer=3 if id==207387000 & indexp==1 // partner 1 has been dropped due to consistency checks
	l if id==133823000 | id==138256000 | id==185131000 | id==207387000


*******************************	
**** generate new variables, data wave 1
*******************************	

* current partner wave 1: currw1
	gen currw1=0
	replace currw1=1 if partner==0
	tab currw1 partner, m

* rename "partner" --> "pnow1"
	rename partner pnow1
	
* dodp (see reasendp)
	tab reasendp, m
	l if reasendp==3
	gen dodp=-3
	egen end=rowmax(endp cohpend marpend) if reasendp==3
	tab end, m
	l if end<0
	recode end -3=-88
	l if end<0
	replace dodp=end if reasendp==3
	count if end==endp & reasendp==3 
	count if end==cohpend & reasendp==3
	count if end==marpend & reasendp==3
	foreach var of varlist endp cohpend marpend {
		replace `var'=-66 if reasendp==3 & end==`var'
	}
	l if reasendp==3
	drop end
	drop reasendp
	

*******************************	
**** modifications of variables, data wave 1
*******************************	

* no "p" as part of variable labels (exceptions: sexp and dobp to distinguish from anchor)
	foreach var in beg end {
		rename `var'p `var'
		rename cohp`var' coh`var'
		rename marp`var' mar`var'
		foreach num of numlist 1/7 {
			capture noisily rename b`num'p`var' b`num'`var'
			capture noisily rename b`num'cohp`var' b`num'coh`var'
		}
	}		
	rename marpcer marcer
	rename indexp index
	rename intdat intdatw1
	
* delete variables which won't be included in "biopart" any more
	drop meetp
 	drop waymeetp
	drop flag5-flag14

* order of variables
	order id sex dob intdatw1 index pid pnow1 sexp dobp dodp beg end b1beg-b7end cohbeg cohend b1cohbeg-b3cohend ///
	marbeg marend marcer currw1 homosex

* label variables when label is missing
	lab var intdatw1 "Date of interview wave 1"
	lab var index "Correct order of relationships: Number partner"
	lab var pnow1 "Number partner in wave 1"
	lab var sexp "Sex partner"
	lab var dobp "Date of birth partner"
	lab var dodp "Date of death partner"
	lab var beg "Beginning relationship"
	lab var end "End relationship"
	lab var cohbeg "Beginning cohabitation"
	lab var cohend "End cohabitation"
	lab var marbeg "Beginning marriage"
	lab var marend "End marriage"
	lab var marcer "Marriage ceremony"
	foreach num of numlist 1/7 {
		capture noisily lab var b`num'beg "Beginning break `num' relationship"
		capture noisily lab var b`num'end "End break `num' relationship"
		capture noisily lab var b`num'cohbeg "Beginning break `num' cohabitation"
		capture noisily lab var b`num'cohend "End break `num' cohabitation"
	}
	lab var currw1 "Current partner in wave 1"

* value labels when label is missing
	label list
	lab def dobp0 -66 "-66 Death partner", modify
	lab def date1 -66 "-66 Death partner", modify
	lab val dobp dobp0
	lab val pid date2
	lab val dodp end cohend marend b*beg b*end date1
	lab val currw1 yesno

* sort
	sort id index
	by id: l id if beg[_n+1]<beg & beg[_n+1]>0

	
* any partners who are not p0 and end==-99? 
	l pnow1 beg end if end==-99 & pnow1!=0
		* no such cases

	
*******************************	
**** save reshaped version of biopart wave 1
*******************************	
	compress
	*datasignature set, reset

	cd "$w2data_local_v2_1"
	save biopart1_v2_reshaped.dta, replace




	
*----------------------------------------------------------------------------------------------------------------------*	
*----------------------------------------------------------------------------------------------------------------------*	
	
	
	
*******************************	
*******************************	
** Wave 2 data for biopart wave 2
*******************************	
*******************************	

cd "$w2data_local_v2_1"
use anchor2.dta, clear


* define data set 
keep id pid  											/// 		/* ID anchor and current partner 
sex_gen 												///			/* Anchor's sex (generated version) */
ehc1p*g													/// 		/* sex current partner & previous partners */
psex_gen												///			/* sex current partner (generated version)
ehc2p*													/// 		/* relationship */
ehc3p*													/// 		/* cohabitation */
ehc4p*	ehc5p*											/// 		/* marriage & mariage ceremony*/
ehc6p*													///			/* partner dead? date of death partner*/
dobm_gen doby_gen	 									///			/* date of birth anchor (generated version) */
pdobm_gen pdoby_gen										/// 		/* date of current partner (generated version) */
intd intm inty 											/// 		/* date of interview */
d8 d9	  												///  		/* name & sex partner w1 */
d11 d12													///  		/* cohabitation & married to current partner */
homosex													///			/* generated variable "Anchor homosexual" */
ehcid flag_ehc wavedist									///			/* EHC information */
flag5 flag7* flag12 flag20 flag21 flag22							


capture drop ehc2*m19 


* variables indicating months:
	tab dobm_gen, m  // NO problematic values
	tab1 ehc6p*m, m  // NO problematic values
	tab1 intm, m // NO problematic values
	tab1 pdob*, m // problematic value -7; equals don't know, no answer and season information --> random imputation if year is known!
		l id pdobm_gen pdoby_gen if  (pdobm_gen==-7 | pdobm_gen>12) & pdoby_gen>0


* 1) create random variable for date of birth partner
	* examine how variables are sorted --> important for generating random variables!
	qui desc, varlist
	ret li
	sort id
	set seed 6527
	* create auxilliary vars with random elements on the interval [0;1] 
		gen r_pdobm=runiform() 

	* generate problem indicator
		gen probl=1 if (pdobm_gen==-7 | pdobm_gen>12) & pdoby_gen>0

* 2) transfer ambiguous "season" information to regular months
	* random imputation within the following bounds:
	* 		21: 1-2
	*		24: 3-5
	*		27: 6-8
	*		30: 9-11
	*		32: 12
		gen orig_pdobmgen=pdobm_gen
		count if inlist(pdobm_gen,21,24,27,30,32)
		cap noi gen pdobmgen_help21= 1+int((2 - 1 + 1) * r_pdobm) // intervall [1;2]
		cap noi gen pdobmgen_help24= 3+int((5 - 3 + 1) * r_pdobm) // intervall [3;5]
		cap noi gen pdobmgen_help27= 6+int((8 - 6 + 1) * r_pdobm) // intervall [6;8]
		cap noi gen pdobmgen_help30= 9+int((11 - 9 + 1) * r_pdobm) // intervall [9;11]
		cap noi gen pdobmgen_help32= 12 // intervall [12;12]
		*** fill in
			foreach x of numlist 21 24 27 30 32 {
				di "`x'"
				replace pdobm_gen= pdobmgen_help`x' if pdobm_gen ==`x'
			}
		l pdobm_gen orig_pdobmgen if orig_pdobmgen==21
		l pdobm_gen orig_pdobmgen if orig_pdobmgen==24
		l pdobm_gen orig_pdobmgen if orig_pdobmgen==27
		l pdobm_gen orig_pdobmgen if orig_pdobmgen==30
		l pdobm_gen orig_pdobmgen if orig_pdobmgen==32
	drop *help21 *help24 *help27 *help30 *help32		
		
* 3) random imputation for month=-7 
	* define 12 as upper boundary and 1 as lower boundary 
		gen pdobm_ub=12
		gen pdobm_lb=1
	* replace with random variable:
		gen help=  pdobm_lb+int((pdobm_ub  - pdobm_lb + 1) * r_pdobm)
		replace pdobm_gen=help  if pdobm_gen==-7 & pdoby_gen>0 // replace beginning with random variable
	drop pdobm_lb pdobm_ub	
		
	drop probl
	drop orig_pdobmgen

	
*******************************	
* generate number of breaks wave 1 --> important for merging data wave 2
*******************************	
	
* merge with new version of biopart wave 1
	merge 1:1 id using biopart1_v2.dta, keepusing(b*beg b*end intdat)  
	tab _merge, m
	keep if _merge==3
	drop _merge
	ren intdat intdatw1


** relationship
	forvalues x=0/5 {
		forvalues y=1/7 { // y = number of breaks per partner
			capture noisily recode b`y'p`x'beg -3=.
		}
	}	
	egen brelatnump0=rownonmiss(b1p0beg b2p0beg b3p0beg b4p0beg b5p0beg b6p0beg b7p0beg)
	egen brelatnump1=rownonmiss(b1p1beg b2p1beg b3p1beg)
	egen brelatnump2=rownonmiss(b1p2beg b2p2beg)
	egen brelatnump3=rownonmiss(b1p3beg)
	egen brelatnump4=rownonmiss(b1p4beg b2p4beg b3p4beg b4p4beg)
	egen brelatnump5=rownonmiss(b1p5beg b2p5beg b3p5beg)
	tab1 brelatnum*, m	
	l brelatnump0 b*p0beg if brelatnump0>1
	l brelatnump1 b*p1beg if brelatnump1>1


** cohabitation
	forvalues x=0/5 {
		forvalues y=1/3 { // y = number of breaks per partner
			capture noisily recode b`y'cohp`x'beg -3=.
		}
	}	
	egen bcohnump0=rownonmiss(b1cohp0beg b2cohp0beg b3cohp0beg)
	egen bcohnump1=rownonmiss(b1cohp1beg)
	egen bcohnump2=rownonmiss(b1cohp2beg b2cohp2beg)
	egen bcohnump3=rownonmiss(b1cohp3beg)
	egen bcohnump4=rownonmiss(b1cohp4beg)
	egen bcohnump5=rownonmiss(b1cohp5beg)
	tab1 bcohnum*, m	
	l bcohnump0 b*cohp0beg if bcohnump0>1
	l bcohnump1 b*cohp1beg if bcohnump1>1

	drop b*beg b*end




**************************************
* GENERAL INFORMATION
**************************************
		
* generate combined date of interview
	tab1 inty intm, m
	gen intdatw2=ym(inty, intm)
	lab var intdatw2 "Date of interview"
	tab intdatw2, m
	drop inty intm
	** new baseline date January 1900
	replace intdatw2=intdatw2-ym(1900,1)
	
* label id & pid
	lab var id "Person number anchor"
	lab var pid "Person number current partner"
	recode pid .=-3

* generate combined date of birth: Anchor (wave 2)
	tab1 doby_gen dobm_gen, m
	gen dob_gen=ym(doby_gen, dobm_gen)
	lab var dob_gen "Date of birth anchor" 
	tab dob_gen, m
	drop doby_gen dobm_gen
	** new baseline date January 1900
	replace dob_gen=dob_gen-ym(1900,1) 

* generate combined date of birth: current partner
	tab1 pdobm_gen pdoby_gen, m
	** generate combined date
		gen dobp=ym(pdoby_gen, pdobm_gen)
	** new baseline date January 1900
		replace dobp=dobp-ym(1900,1) 
	** missing values
		replace dobp=-7 if pdoby_gen==-7
		forvalues i=-7/-1 {
			replace dobp=`i' if pdoby_gen==`i' & pdobm_gen==`i' 
		}
		lab var dobp "Date of birth current partner"
		tab dobp, m		
		drop pdobm_gen pdoby_gen
		
		
**************************************
* adjust cases which have been identified using non-anonymized data
**************************************

* all of these cases: partner 2 wave 2 --> partner 1 wave 2; also see 3_ehc_partner.do for additional such cases

	local p2p1list "203394000,338609000,355861000,516298000,595569000"
	replace ehc1p1g=ehc1p2g if inlist(id,`p2p1list')
	replace ehc1p2g=-3 if inlist(id,`p2p1list')
	forvalues t=2/4 {
		replace ehc`t'p1=ehc`t'p2 if inlist(id,`p2p1list')
		replace ehc`t'p2=-3 if inlist(id,`p2p1list')
		forvalues m=1/18 {
			replace ehc`t'p1m`m'=ehc`t'p2m`m' if inlist(id,`p2p1list')
			replace ehc`t'p2m`m'=-3 if inlist(id,`p2p1list')
		}
	}
	replace ehc5p1=ehc5p2 if inlist(id,`p2p1list')
	replace ehc5p2=-3 if inlist(id,`p2p1list')
	replace ehc6p1=ehc6p2 if inlist(id,`p2p1list')
	replace ehc6p2=-3 if inlist(id,`p2p1list')
	replace ehc6p1m=ehc6p2m if inlist(id,`p2p1list')
	replace ehc6p2m=-3 if inlist(id,`p2p1list')
	replace ehc6p1y=ehc6p2y if inlist(id,`p2p1list')
	replace ehc6p2y=-3 if inlist(id,`p2p1list')
	tab1 ehc6* if inlist(id,`p2p1list')

	

**************************************
* reshape data
**************************************

	reshape long ehc1p@g ehc2p@ ehc3p@ ehc4p@ ehc5p@ ehc6p@ ehc6p@m ehc6p@y orig_ehc6p@m ///
		ehc2p@m1 ehc2p@m2 ehc2p@m3 ehc2p@m4 ehc2p@m5 ehc2p@m6 ehc2p@m7 ehc2p@m8 ehc2p@m9 ehc2p@m10 ehc2p@m11 ehc2p@m12 ehc2p@m13 ehc2p@m14 ///
		ehc2p@m15 ehc2p@m16 ehc2p@m17 ehc2p@m18 ///
		ehc3p@m1 ehc3p@m2 ehc3p@m3 ehc3p@m4 ehc3p@m5 ehc3p@m6 ehc3p@m7 ehc3p@m8 ehc3p@m9 ehc3p@m10 ehc3p@m11 ehc3p@m12 ehc3p@m13 ehc3p@m14 ///
		ehc3p@m15 ehc3p@m16 ehc3p@m17 ehc3p@m18 ///
		ehc4p@m1 ehc4p@m2 ehc4p@m3 ehc4p@m4 ehc4p@m5 ehc4p@m6 ehc4p@m7 ehc4p@m8 ehc4p@m9 ehc4p@m10 ehc4p@m11 ehc4p@m12 ehc4p@m13 ehc4p@m14 ///
		ehc4p@m15 ehc4p@m16 ehc4p@m17 ehc4p@m18 , i(id) j(partner)


	
**************************************
* generate month 19 = now (to facilitate later procedures)
**************************************

* month 19 = now (time of interview) for relationship, cohabitation, marriage
	
	gen ehc2pm19=ehc2p	// month 19 = now
	gen ehc3pm19=ehc3p	// month 19 = now
	gen ehc4pm19=ehc4p	// month 19 = now

	


**************************************
* convert single months to "beginning" and "end"
**************************************

* count changes 0 to 1 and extract months of beginning and end

** relationship
	forvalues y=1/5 { // y = number of episodes per partner
		gen relatbeg`y'=-3
		gen relatend`y'=-3
	}
	gen countrelat=0
	foreach x of numlist 2/19 { // x = months; month 1 not included (see flag_ehc)
		local minus=`x'-1
		capture noisily replace countrelat=countrelat+1 if ehc2pm`x'==1 & ///
																(ehc2pm`minus'==0 | ehc2pm`minus'==-3 | ehc2pm`minus'==-4)
		forvalues y=1/5 { // y = number of episodes per partner
			* beginning: 
			capture noisily replace relatbeg`y'=`x' if ehc2pm`x'==1 & (ehc2pm`minus'==0 | ehc2pm`minus'==-3) & `y'==countrelat
			capture noisily replace relatbeg`y'=-77 if ehc2pm`x'==1 & ehcid==`x' & partner==1  & `y'==countrelat // only current partner!
			** problematic cases indicated by flag_ehc:
					// flag_ehc=1: no information for month 1 which is month of interview wave 1; wavedist=17
			capture noisily replace relatbeg`y'=-77 if ehc2pm2==1 & ehc2pm1==-4  & flag_ehc==1 & `y'==countrelat ///
															& partner==1 & `y'==1 // partner 1; m1=-4; first beginning 
			capture noisily replace relatbeg`y'=2 	if ehc2pm2==1 & ehc2pm1==-4 & flag_ehc==1 & `y'==countrelat ///
															& partner!=1 & `y'==1 // partners 2-5; leave preload month (m1); first beginning
																				  // assumption: beginning in month following interview wave 1
					// flag_ehc=2: no information for month 1 and month 0 (month 0 is month of interview wave 1); wavedist=18 
			capture noisily replace relatbeg`y'=-77 if  ehc2pm2==1 & flag_ehc==2 & `y'==countrelat ///
															& partner==1 & `y'==1 // partner 1; m1=-4; first beginning
			capture noisily replace relatbeg`y'=1  	if  ehc2pm2==1 & flag_ehc==2 & `y'==countrelat ///
															& partner!=1 & `y'==1 // partners 2-5; leave preload month (m2); first beginning
																				  // assumption: beginning in month following interview wave 1
					// flag_ehc=4: no information for month of interview wave 1; varying wavedist
			capture noisily replace relatbeg`y'=-77 if ehc2pm`x'==1 & ehc2pm`minus'==-4 & flag_ehc==4  & `y'==countrelat ///
															 & partner==1 & `y'==1 // only current partner! 
			capture noisily replace relatbeg`y'=`x' if ehc2pm`x'==1 & ehc2pm`minus'==-4 & flag_ehc==4  & `y'==countrelat ///
															 & partner!=1 & `y'==1 // partners 2-5
					// flag_ehc=5: information for month "minus" too much --> treat this month as -3
			capture noisily replace relatbeg`y'=`x' if ehc2pm`x'==1 & ehc2pm`minus'==-4 & flag_ehc==5	& `y'==countrelat
			* end: 				
			capture noisily replace relatend`y'=`minus' if ehc2pm`minus'==1 & (ehc2pm`x'==0 | ehc2pm`x'==-3) & `y'==countrelat
			capture noisily replace relatend`y'=-99 if ehc2pm19==1 & relatend`y'==-3 & `y'==countrelat
		}
	}
	tab1 countrelat, m
	tab1 relatbeg*, m
	tab1 relatend*, m
	* maximum number of episodes per partner: 3
	

** cohabitation
	forvalues y=1/5 { // y = number of episodes per partner
		gen cohbeg`y'=-3
		gen cohend`y'=-3
	}
	gen countcoh=0
	foreach x of numlist 2/19 { // x = months; month 1 not included (see flag_ehc)
		local minus=`x'-1
		capture noisily replace countcoh=countcoh+1 if ehc3pm`x'==1 & ///
																(ehc3pm`minus'==0 | ehc3pm`minus'==-3 | ehc3pm`minus'==-4)
		forvalues y=1/5 { // y = number of episodes per partner
			* beginning: 
			capture noisily replace cohbeg`y'=`x' if ehc3pm`x'==1 & (ehc3pm`minus'==0 | ehc3pm`minus'==-3) & `y'==countcoh
			capture noisily replace cohbeg`y'=-77 if ehc3pm`x'==1 & ehcid==`x' & partner==1  & `y'==countcoh // only current partner!
			** problematic cases indicated by flag_ehc:
					// flag_ehc=1: no information for month 1 which is month of interview wave 1; wavedist=17
			capture noisily replace cohbeg`y'=-77 if ehc3pm2==1 & ehc3pm1==-4  & flag_ehc==1 & `y'==countcoh ///
															& partner==1 & `y'==1 // partner 1; m1=-4; first beginning 
			capture noisily replace cohbeg`y'=2 	if ehc3pm2==1 & ehc3pm1==-4 & flag_ehc==1 & `y'==countcoh ///
															& partner!=1 & `y'==1 // partners 2-5; leave preload month (m1); first beginning 
																				  // assumption: beginning in month following interview wave 1
					// flag_ehc=2: no information for month 1 and month 0 (month 0 is month of interview wave 1); wavedist=18 
			capture noisily replace cohbeg`y'=-77 if  ehc3pm2==1 & flag_ehc==2 & `y'==countcoh ///
															& partner==1 & `y'==1 // partner 1; m1=-4; first beginning
			capture noisily replace cohbeg`y'=1  	if  ehc3pm2==1 & flag_ehc==2 & `y'==countcoh ///
															& partner!=1 & `y'==1 // partners 2-5; leave preload month (m2); first beginning
																				  // assumption: beginning in month following interview wave 1
					// flag_ehc=4: no information for month of interview wave 1; varying wavedist
			capture noisily replace cohbeg`y'=-77 if ehc3pm`x'==1 & ehc3pm`minus'==-4 & flag_ehc==4  & `y'==countcoh ///
															 & partner==1 & `y'==1 // only current partner! 
			capture noisily replace cohbeg`y'=`x' if ehc3pm`x'==1 & ehc3pm`minus'==-4 & flag_ehc==4  & `y'==countcoh ///
															 & partner!=1 & `y'==1 // partners 2-5
					// flag_ehc=5: information for month "minus" too much --> treat this month as -3
			capture noisily replace cohbeg`y'=`x' if ehc3pm`x'==1 & ehc3pm`minus'==-4 & flag_ehc==5	& `y'==countcoh
			* end: 				
			capture noisily replace cohend`y'=`minus' if ehc3pm`minus'==1 & (ehc3pm`x'==0 | ehc3pm`x'==-3) & `y'==countcoh
			capture noisily replace cohend`y'=-99 if ehc3pm19==1 & cohend`y'==-3 & `y'==countcoh
		}
	}
	tab1 countcoh, m
	tab1 cohbeg*, m
	tab1 cohend*, m
	* maximum number of episodes per partner: 3
	

** marriage
	forvalues y=1/5 { // y = number of episodes per partner
		gen marbeg`y'=-3
		gen marend`y'=-3
	}
	gen countmar=0
	foreach x of numlist 2/19 { // x = months; month 1 not included (see flag_ehc)
		local minus=`x'-1
		capture noisily replace countmar=countmar+1 if ehc4pm`x'==1 & ///
																(ehc4pm`minus'==0 | ehc4pm`minus'==-3 | ehc4pm`minus'==-4)
		forvalues y=1/5 { // y = number of episodes per partner
			* beginning: 
			capture noisily replace marbeg`y'=`x' if ehc4pm`x'==1 & (ehc4pm`minus'==0 | ehc4pm`minus'==-3) & `y'==countmar
			capture noisily replace marbeg`y'=-77 if ehc4pm`x'==1 & ehcid==`x' & partner==1  & `y'==countmar // only current partner!
			** problematic cases indicated by flag_ehc:
					// flag_ehc=1: no information for month 1 which is month of interview wave 1; wavedist=17
			capture noisily replace marbeg`y'=-77 if ehc4pm2==1 & ehc4pm1==-4  & flag_ehc==1 & `y'==countmar ///
															& partner==1 & `y'==1 // partner 1; m1=-4; first beginning 
			capture noisily replace marbeg`y'=2 	if ehc4pm2==1 & ehc4pm1==-4 & flag_ehc==1 & `y'==countmar ///
															& partner!=1 & `y'==1 // partners 2-5; leave preload month (m1); first beginning 
																				// assumption: beginning in month following interview wave 1
					// flag_ehc=2: no information for month 1 and month 0 (month 0 is month of interview wave 1); wavedist=18 
			capture noisily replace marbeg`y'=-77 if  ehc4pm2==1 & flag_ehc==2 & `y'==countmar ///
															& partner==1 & `y'==1 // partner 1; m1=-4; first beginning
			capture noisily replace marbeg`y'=1  	if  ehc4pm2==1 & flag_ehc==2 & `y'==countmar ///
															& partner!=1 & `y'==1 // partners 2-5; leave preload month (m2); first beginning
																				  // assumption: beginning in month following interview wave 1
					// flag_ehc=4: no information for month of interview wave 1; varying wavedist
			capture noisily replace marbeg`y'=-77 if ehc4pm`x'==1 & ehc4pm`minus'==-4 & flag_ehc==4  & `y'==countmar ///
															 & partner==1 & `y'==1 // only current partner! 
			capture noisily replace marbeg`y'=`x' if ehc4pm`x'==1 & ehc4pm`minus'==-4 & flag_ehc==4  & `y'==countmar ///
															 & partner!=1 & `y'==1 // partners 2-5
					// flag_ehc=5: information for month "minus" too much --> treat this month as -3
			capture noisily replace marbeg`y'=`x' if ehc4pm`x'==1 & ehc4pm`minus'==-4 & flag_ehc==5	& `y'==countmar
			* end: 				
			capture noisily replace marend`y'=`minus' if ehc4pm`minus'==1 & (ehc4pm`x'==0 | ehc4pm`x'==-3) & `y'==countmar
			capture noisily replace marend`y'=-99 if ehc4pm19==1 & marend`y'==-3 & `y'==countmar
		}
	}
	tab1 countmar, m
	tab1 marbeg*, m
	tab1 marend*, m
	


* check whether all cases with last end=-99 really have relationship, cohabitation, marriage according to ehc.. (for "now") 
	forvalues i=1/5 {
		l partner ehc2p countrelat if relatend`i'==-99 & `i'==countrelat 
	}
	forvalues i=1/5 {
		l partner ehc3p countcoh if cohend`i'==-99 & `i'==countcoh
	}
	forvalues i=1/5 {
		l partner ehc4p countmar if marend`i'==-99 & `i'==countmar
	}




**************************************
* manually change m19 (now) to month18	for relationship, cohabitation, marriage
**************************************

	forvalues y=1/5 {
		foreach t in relat coh mar {
			replace `t'beg`y'=18 if `t'beg`y'==19
			replace `t'end`y'=18 if `t'end`y'==19
		}
	}
	* "now" (i.e. month 19) has more "weight" than month 18; okay



**************************************
* generate beginning and end 
**************************************

* generate first beginning for all cases

	foreach t in relat coh mar {
		forvalues y=1/5 { // y = number of episodes per partner
			recode `t'beg`y' -3=.
		}
		egen `t'begmin=rowfirst(`t'beg*) 
		recode `t'begmin .=-3
		forvalues y=1/5 {
			recode `t'beg`y' .=-3
		}
	}
	tab1 *begmin, m
	* Checks: 
	l relatbeg* if partner==1 & relatbegmin!=-3 & relatbegmin!=-77
	l relatbeg* if countrelat>1
	l relatbeg* if partner==5 & relatbegmin!=-3 
	l cohbeg* if partner==1 & cohbegmin!=-3 & cohbegmin!=-77
	l cohbeg* if countcoh>1
	l cohbeg* if partner==5 & cohbegmin!=-3 
	l marbeg* if partner==1 & marbegmin!=-3 & marbegmin!=-77
	l marbeg* if countmar>1
	l marbeg* if partner==5 & marbegmin!=-3 
	tab relatbeg1 if partner!=1
	tab relatbegmin if partner!=1
		* no -77
	tab relatbeg1 if partner==1
		* why three cases unequal to -77?
	l ehc2p* if relatbeg1>0 & partner==1
		* okay, break at seam


* generate last end for all cases

	foreach t in relat coh mar {
		forvalues y=1/5 { // y = number of episodes per partner
			recode `t'end`y' -3=.
		}
		egen `t'endmax=rowlast(`t'end*) 
		recode `t'endmax .=-3
		forvalues y=1/5 {
			recode `t'end`y' .=-3
		}
	}
	tab1 *endmax, m
	* Checks: 
	l relatend* if partner==1 & relatendmax!=-3 & relatendmax!=-99
	l relatend* if countrelat>1
	l relatend* if partner==5 & relatendmax!=-3 
	l cohend* if partner==1 & cohendmax!=-3 & cohendmax!=-99
	l cohend* if countcoh>1
	l cohend* if partner==5 & cohendmax!=-3 
	l marend* if partner==1 & marendmax!=-3 & marendmax!=-99
	l marend* if countmar>1
	l marend* if partner==5 & marendmax!=-3 



	

**************************************
* generate breaks
**************************************
	
* breaks exist if countrelat/countcoh/countmar>1
	
	foreach t in relat coh mar {
		forvalues y=1/5 {
			gen b`y'`t'beg=-3
			gen b`y'`t'end=-3
		}
	}
	foreach t in relat coh mar {
		forvalues y=1/5 {
			local plus=`y'+1
			replace b`y'`t'beg=`t'end`y' if count`t'>1
			capture noisily replace b`y'`t'end=`t'beg`plus' if count`t'>1
		}
	}
	foreach t in relat coh mar {
		forvalues y=1/5 {
			replace b`y'`t'beg=-3 if `y'==count`t'
		}
	}
	foreach t in relat coh mar {
		forvalues y=1/5 {
			count if b`y'`t'beg!=-3 & b`y'`t'end==-3
		}
	}

	
* assign correct number of breaks for partner 1 (= partner 0 in wave 1)
		
	tab1 b*nump0, m // wave 1: max. # breaks relationship: 4, max. # breaks cohabitation: 3 (partner 0)
	tab1 b*beg b*end if partner==1, m // wave 2: max. # breaks relationship: 2, max. # breaks cohabitation: 2 (partner 1)
	lookfor beg end

	* relationship: generate break 6 (does not exist so far)
	foreach t in relat coh {
		foreach v in beg end {
			gen b6`t'`v'=-3
		}
	}
		
	* generate copies of relevant variables to facilitate checks afterwards
	foreach t in relat coh {
		forvalues y=1/6 {
			gen b`y'`t'beg_c=b`y'`t'beg  
			gen b`y'`t'end_c=b`y'`t'end  
		}
	}
	* assign value of break to correct break number 
	foreach t in relat coh {
		forvalues y=1/6 {
			forvalues z=1/6 {
				replace b`z'`t'beg_c=b`y'`t'beg if partner==1 & b`t'nump0>0  & b1`t'beg!=-3 & `z'==b`t'nump0+`y'
				replace b`z'`t'end_c=b`y'`t'end if partner==1 & b`t'nump0>0  & b1`t'end!=-3 & `z'==b`t'nump0+`y'
			}
		}
	}
	
	* checks:
	l id b*relatbeg b*relatbeg_c brelatnump0 if partner==1 & brelatnump0>0 & b1relatbeg!=-3, ab(20)
	l id b*relatbeg b*relatbeg_c brelatnump0 if partner==1 & brelatnump0>0 & b2relatbeg!=-3, ab(20)
	l id b*relatbeg b*relatbeg_c brelatnump0 if partner==1 & brelatnump0>0 & b3relatbeg!=-3 // 2 is maximum
	l id b*relatend b*relatend_c brelatnump0 if partner==1 & brelatnump0>0 & b1relatend!=-3
	l id b*cohbeg b*cohbeg_c bcohnump0 if partner==1 & bcohnump0>0 & b1cohbeg!=-3
	l id b*cohend b*cohend_c bcohnump0 if partner==1 & bcohnump0>0 & b1cohend!=-3
	l id b*cohbeg b*cohbeg_c bcohnump0 if partner==1 & bcohnump0>0 & b2cohbeg!=-3 // 1 is maximum

	* correct variable label
	foreach t in relat coh {
		forvalues z=1/6 {
			replace b`z'`t'beg=b`z'`t'beg_c if partner==1 & b`t'nump0>0  & b1`t'beg!=-3
			replace b`z'`t'end=b`z'`t'end_c if partner==1 & b`t'nump0>0  & b1`t'end!=-3
		}
	}
	
	* code for breaks happening in wave 1
	foreach t in relat coh {
		forvalues y=1/6 {
				replace b`y'`t'beg=-100 if partner==1 & b`t'nump0>0 & b1`t'beg!=-3 & `y'<=b`t'nump0   
				replace b`y'`t'end=-100 if partner==1 & b`t'nump0>0 & b1`t'beg!=-3 & `y'<=b`t'nump0   
			}
	}
	
	l id b*relatbeg b*relatbeg_c b*beg brelatnump0 if partner==1 & brelatnump0>0 & b1relatbeg!=-3, ab(20)	
	l id b*relatend brelatnump0 if partner==1 & brelatnump0>0 & b1relatend!=-3
	l id b*cohbeg bcohnump0 if partner==1 & bcohnump0>0 & b1cohbeg!=-3
	l id b*cohend bcohnump0 if partner==1 & bcohnump0>0 & b1cohend!=-3
	
	* drop copies
	lookfor _c
	drop *_c
		
	* drop empty variables
	drop b6*
	

**************************************
* generate currw2
**************************************
	
	gen currw2=.
	replace currw2=1 if relatendmax==-99
	
	* multiple current partners?
	by id: egen count=count(currw2)
	tab count, m
	l id if count>1
	* one person with more than one current partner: id=350320000; also see above
	l if id==350320000
	* partner 2 is defined as "current partner" 
	replace currw2=. if id==350320000 & partner==4
	* check:
	drop count
	by id: egen count=count(currw2)
	tab count, m

	recode currw2 .=0	
	tab currw2, m
	
	
**************************************
* generate currw1 (to merge these partners later on)
**************************************

	gen currw1=1 if partner==1
	
	recode currw1 .=0
	tab currw1, m

	
**************************************
* assign dobp to current partner number
**************************************

* only valid value if current partner in w2
	replace dobp=-3 if currw2!=1
	
* check:
	tab dobp, m
	l dobp if id==350320000
	l id dobp currw2 partner
	tab dobp if partner==1, m
	tab dobp if partner==2
	
	* partner 3, 4, 5: dob should be -3
	tab dobp if partner>2, m
		* okay



**************************************
* generate date of death partner 
**************************************
	
	tab1 ehc6p*, m
	recode ehc6p .=-3
	recode ehc6pm .=-3
	recode ehc6py .=-3

	** generate combined date	
	gen dodp=ym(ehc6py, ehc6pm) 

	** new baseline date January 1900
	replace dodp=dodp-ym(1900,1) 
	
	** missing values
	forvalues i=-4/-1 {
		replace dodp=`i' if ehc6py==`i' & ehc6pm==`i' 
	}
	lab var dodp "Date of death partner"
	tab dodp, m
	
	* ...end=-66 if end and death of death partner in same month
	l dodp *end* if dodp>0
	* generate last end (whether it's relatendmax, cohendmax or marendmax...)
	egen lastend=rowmax(relatendmax cohendmax marendmax)
	replace lastend=-99 if relatendmax==-99 | cohendmax==-99 | marendmax==-99
	tab lastend, m
	l relatendmax cohendmax marendmax lastend if lastend!=-3 & lastend!=-99
	foreach t in relat coh mar {
		replace `t'endmax=-66 if `t'endmax==lastend & dodp>0
	}
	l dodp *end* if dodp>0



**************************************
* rename relevant variables 
**************************************	
	
	ren partner pnow2
	
	ren ehc1pg sexpw2

	* use generated version of partner's sex (=best solution) if it is current partner in w2
	replace sexpw2=psex_gen if currw2==1
	
	ren ehc5p marcerw2	
	
	ren homosex homosexw2

	foreach num of numlist 5 7 12 20 21 22 {
		ren flag`num' flag`num'w2
	}

	
**************************************
* keep only relevant variables
**************************************

	drop ehc2p* ehc3p* ehc4p* ehc6p* d8-d12 count* orig_* relatbeg1-marend5 lastend intd psex_gen


	
**************************************
* generate real dates instead of months 1-18
**************************************

l ehcid wavedist flag_ehc

	* copy variables
	foreach t in relat coh mar {
		gen `t'begmin_c=`t'begmin
		gen `t'endmax_c=`t'endmax
		forvalues y=1/5 { 			
			gen b`y'`t'beg_c=b`y'`t'beg
			gen b`y'`t'end_c=b`y'`t'end
		}	
	}
	
	* real dates; starting date: date of interview wave 1; use wavedist, not ehcid
	foreach t in relat coh mar {
			replace `t'begmin=intdatw1 + `t'begmin - (18-wavedist) if `t'begmin>0
			replace `t'endmax=intdatw1 + `t'endmax - (18-wavedist) if `t'endmax>0
			forvalues y=1/5 { 			
				replace b`y'`t'beg=intdatw1 + b`y'`t'beg - (18-wavedist) if b`y'`t'beg>0
				replace b`y'`t'end=intdatw1 + b`y'`t'end - (18-wavedist) if b`y'`t'end>0
			}	
	}
	* note: ehcid is equal to intdatw1 
	
	* checks
	tab1 *beg* *end*, m
	* l relat* intdatw1 ehcid wavedist if relatbegmin>0
	* l relat* intdatw1 ehcid wavedist if relatendmax>0
	* l coh* intdatw1 ehcid wavedist if cohbegmin>0
	* l coh* intdatw1 ehcid wavedist if cohendmax>0
	* l relat* intdatw1 ehcid wavedist if relatbegmin-18>=intdatw1 & relatbegmin>0
	* check cases with flag_ehc!=0
	*l id relatbegmin relatbegmin_c ehcid intdatw1 flag_ehc wavedist pnow2 if flag_ehc==2 & pnow2>1

	* drop redundant variables
	drop *_c
	

		
**************************************
* drop empty variables
**************************************

	foreach var of varlist id-currw1 {
			count if `var' ==-3
			if r(N) == _N drop `var'
	}


**************************************
* drop empty partners (i.e. empty rows)
**************************************
	
	tab1 sexp relatbegmin relatendmax, m
	egen empty_3=anycount(sexp relatbegmin relatendmax cohbegmin cohendmax marbegmin marendmax),values(-3)
	tab empty_3, m 
	egen empty_4=anycount(sexp relatbegmin relatendmax cohbegmin cohendmax marbegmin marendmax),values(-4)
	tab empty_4, m	
	drop if empty_3==7
	l id flag_ehc if empty_4==1 // all of these cases: ehc missing completely
	foreach var of varlist relatbegmin relatendmax cohbegmin cohendmax marbegmin marendmax b*relatbeg b*relatend b*cohbeg b*cohend dobp dodp {
		replace `var'=-4 if empty_4==1
	}
	tab1 relat*, m
	* br if relatbegmin==-3
	tab1 coh*, m
	* br if cohbegmin==-3 & relatbegmin==-3
	drop empty*
	
	
**************************************
* order of variables
**************************************

	order id sex_gen dob_gen intdatw1 intdatw2 pid pnow2 sexpw2 dobp dodp relatbegmin relatendmax b*relat* cohbegmin cohendmax b*coh* ///
		marbegmin marendmax marcerw2 currw1 currw2 homosexw2

		
**************************************
* rename and add indicator for w2 to variable names
**************************************	
	
	ren pid pidw2
	ren dobp dobpw2
	ren dodp dodpw2
	ren relatbegmin begw2
	ren relatendmax endw2
	foreach t in beg end {
		forvalues x=1/3 {
			ren b`x'relat`t' b`x'`t'w2
		}
	}
	ren cohbegmin cohbegw2
	ren cohendmax cohendw2
	foreach t in beg end {
		forvalues x=1/2 {
			ren b`x'coh`t' b`x'coh`t'w2
		}
	}
	ren marbegmin marbegw2
	ren marendmax marendw2
	

**************************************
* include indicator for participation in wave 2
**************************************	
	
	gen respw2=1

	
**************************************
* keep valid pid only if it is current partner 
**************************************		
	
	replace pidw2=-3 if currw2!=1
	l pidw2 currw2
	* one case: partner survey exists --> pid necessary to merge with partner data
		l if id==307529000
		replace pid=307529101 if id==307529000 & pnow2==1


*******************************	
**** save this data set
*******************************	

	cd "$w2data_local_v2_1"
	save biopart_w2.dta, replace

	

**************************************
* save a separate data set including only partner 1 (partner 0 in wave 1)
**************************************
	
	use biopart_w2.dta, clear
	keep if pnow2==1 
	
	datasignature set, reset
	save biopart_w2_p1.dta, replace
	

	
**************************************
* save a separate data set including only partners 2+ (NOT partner 1)
**************************************
	
	use biopart_w2.dta, clear
	keep if pnow2>1 
	
	datasignature set, reset
	save biopart_w2_p2ff.dta, replace
	




*----------------------------------------------------------------------------------------------------------------------*	
*----------------------------------------------------------------------------------------------------------------------*	


clear 
set mem 300m
set more on


*-----------------------------------------------
* FIRST STEP: PARTNER 0 WAVE 1 and PARTNER 1 WAVE 2
*-----------------------------------------------

**************************************
* merge biopart w1 (reshaped) and partner 1 from wave 2
**************************************

	cd "$w2data_local_v2_1"
	use biopart1_v2_reshaped.dta, clear // wave 1 data; ALL partners (current and previous)
	
	merge m:1 id currw1 using biopart_w2_p1.dta // wave 2 data; ONLY partner 1 (current and same as in wave 1)
	tab _merge, m

	l if _merge==2
	drop if _merge==2
	
	drop _merge

	
**************************************
* order of variables
**************************************

	order id dob dob_gen intdatw1 intdatw2 index pid pidw2 pnow1 pnow2 sexp* dobp* dodp* beg* end* b1beg-b7end b1begw2-b3endw2 ///
		cohbeg* cohend* b1cohbeg- b3cohend b1cohbegw2-b2cohendw2 marbeg* marend* marcer* currw1 currw2 respw2 brelatnum* bcohnum* homosex*

		
**************************************
* compare time-constant variables w1 and w2
**************************************

** date of birth anchor (dob: "best solution" for w1; dob_gen: "best solution" for w2)
	l if dob!=dob_gen & dob_gen!=.  // no differences --> use dob (includes respondents without w2 interview)
	drop dob_gen

	
** sex anchor (sex: "best solution" for w1; sex_gen: "best solution" for w2)
	l sex sex_gen if sex!=sex_gen & sex_gen!=. // no differences --> use sex (includes respondents without w2 interview)
	drop sex_gen
	
	
** sex partner 0 (w1) and partner 1 (w2) (sexp: "best solution" for w1; sexpw2: "best solution" for w2) 
	l sexp* if sexp!=sexpw2 & sexpw2!=.
	replace sexp=sexpw2 if sexpw2>0 &  sexpw2!=. & sexp!=sexpw2
	replace sexpw2=-3 // only partner 1 (w2)
	* don't drop sexpw2 --> will be used later on
	
	
** pid partner 0 (w1) and partner 1 (w2)
	count if pid!=pidw2 & pidw2!=-3 & pidw2!=. 
	l id pid pidw2 pno* curr* if pid!=pidw2 & pidw2!=-3 & pidw2!=.
	l if id==355861000	
	l if id==516298000
	l if id==595569000
		* all of these cases: partner 2 wave 2 --> partner 1 wave 2
	replace pidw2=pid if inlist(id,355861000,516298000,595569000) & pidw2!=-3 & pidw2!=.
	count if pid!=pidw2 & pidw2!=-3 & pidw2!=. 
	replace pidw2=-3 // only partner 1 (w2)
	
	
* date of birth partner 0 (w1) and partner 1 (w2) (dobp: "best solution" for wave 1; dobpw2: "best solution" for wave 2)
	l id dobp dobpw2 if pnow1==0 & pnow2==1 & dobp!=dobpw2
	replace dobp=dobpw2 if dobpw2>0 & dobpw2!=. & pnow1==0 & pnow2==1 & dobp!=dobpw2
	replace dobpw2=-3 // only partner 1 (w2)
	

* date of death partner
	tab dodp, m
	tab dodpw2, m
	replace dodp=dodpw2 if dodpw2>0 & dodpw2!=.
	replace dodpw2=-3 // only partner 1 (w2)
	
 	

	
**************************************
* checks and adaptation of beg, end, cohbeg, cohend, marbeg, marend
**************************************


***** relationship

* check beginning relationship: beginning relationship should be mentioned in wave 1, not in wave 2
	tab begw2, m	
	l if begw2>-77 & begw2<.
	l id if begw2>-77 & begw2<.
	** 8 cases; these partners have been checked already (change at seam)
		* 162140000: see 3_partner_ehc (p2 -> p1); beginning break=interview wave 1; end break=begw2; end=ongoing
			l if id==162140000
			replace b1beg=intdatw1 if id==162140000 & pnow1==0
			replace b1end=begw2 if id==162140000 & pnow1==0
		* 241451000: checked using non-anonymized data; end=interview wave 1; no episodes in wave 2  
		    l if id==241451000
			replace end=intdatw1 if id==241451000 & pnow1==0
		* 307529000: flag_ehc=3 --> special case
			l if id==307529000 
		* 509134000: flag_ehc=3 --> special case
			l if id==509134000
		* 513776000: checked using non-anonymized data; end=interview wave 1; no episodes in wave 2 
			l if id==513776000
			replace end=intdatw1 if id==513776000 & pnow1==0
		* 643415000: checked using non-anonymized data; different name but no other hints; 
			* beginning break=interview wave 1; end break=begw2; end=ongoing
			l if id==643415000
			replace b1beg=intdatw1 if id==643415000 & pnow1==0
			replace b1end=begw2 if id==643415000 & pnow1==0
		* 667104000: checked using non-anonymized data; beginning break=interview wave 1; end break=begw2; end=ongoing
			l if id==667104000
			replace b2beg=intdatw1 if id==667104000 & pnow1==0
			replace b2end=begw2 if id==667104000 & pnow1==0
		* 744361000: see 3_partner_ehc (no change); end=interview wave 1; no episodes in wave 2 
			l if id==744361000
			replace end=intdatw1 if id==744361000 & pnow1==0

	tab end, m // no cases with -3 any more
	
* adapt beginning relationship: begw2 --> -3
	tab begw2, m
	replace begw2=-3 
	tab beg, m
	tab begw2, m
		
* adapt end relationship partner w2: end=endw2, endw2 --> -3	
	l respw2 end endw2 pnow2 if respw2==1
	l id respw2 if end==-99 & pnow1==0 & endw2==. // cases who did not participate in wave 2
	l end endw2 respw2
	replace end=endw2 if respw2==1
	replace endw2=-3 
	tab end, m
	tab endw2, m
	
	l id intdatw1 coh* b*coh* if id==197565000 | id==409521000 | id==667104000	

	
***** cohabitation	

	* check beginning and end cohabitation; can be mentioned in all waves!
		tab cohbeg, m
		tab cohbegw2, m   //cohbegw3: -77 means that cohabitation already in first month after interview previous wave --> cohabitation should have started in prev. wave
		tab cohend, m
		tab cohendw2, m

		
	** different cases (if valid episodes in wave 2, i.e. cohbegw2>0 & cohbegw2!=.):

	**		1) no cohabitation so far (in previous wave, i.e. cohbeg=-3 & cohend=-3)

	**			1a) ... and cohbegw2!=-77 & cohbegw2!=-3
	**						--> cohbeg=cohbegw2, cohend=cohendw2
					gen coh_1a=1 if (cohbeg==-3 & cohend==-3) & (cohbegw2>0 & cohbegw2!=.)	
					count if coh_1a==1 // 126 cases
					l id coh* b*coh* if coh_1a==1
					replace cohbeg=cohbegw2 if coh_1a==1
					replace cohend=cohendw2 if coh_1a==1
					
	**			1b) ... and cohbegw2==-77
	**						--> cohbeg=intdatw1, cohend=cohendw2
					gen coh_1b=1 if (cohbeg==-3 & cohend==-3) & cohbegw2==-77 & coh_1a==.	
					count if coh_1b==1 // 140 cases
					l id coh* b*coh* if coh_1b==1
					replace cohbeg=intdatw1 if coh_1b==1
					replace cohend=cohendw2 if coh_1b==1

					
	**		2) cohabitation so far (in previous wave)
	
	**			2a) ... and cohbegw2==-77 and cohend==-99
	**						--> cohend=cohendw2 (no change for cohbeg)
					gen coh_2a=1 if cohend==-99 & cohbegw2==-77 & coh_1a==. & coh_1b==.	
					count if coh_2a==1 // 3397 cases
					l id coh* b*coh* if coh_2a==1
					replace cohend=cohendw2 if coh_2a==1

	**			2b) ... and cohbegw2==-77 and cohend!=-99 & cohend!=-3
	**						--> breaks: bXcohbegw2=cohend, bXcohendw2=intdatw1, cohend=cohendw2 (no change for cohbeg)
					gen coh_2b=1 if (cohend!=-99 & cohend!=-3) & cohbegw2==-77 & coh_1a==. & coh_1b==.	& coh_2a==.
					count if coh_2b==1 // 8 cases
					l id coh* b*coh* if coh_2b==1
					tab1 b1cohbegw2 b1cohendw2 if coh_2b==1, m		// b1...w2 "free" for all cases
					replace b1cohbegw2=cohend if coh_2b==1
					replace b1cohendw2=intdatw1 if coh_2b==1
					replace cohend=cohendw2 if coh_2b==1

	**			2c) ... and cohbegw2!=-77 & cohbegw2!=-3 and cohend!=-99  & cohend!=-3
	**						--> breaks: bXcohbegw2=cohend, bXcohendw2=cohbegw2, cohend=cohendw2 (no change for cohbeg) 	
					gen coh_2c=1 if (cohend!=-99 & cohend!=-3) & (cohbegw2>0 & cohbegw2!=.) & coh_1a==. & coh_1b==.	& coh_2a==. & coh_2b==.
					count if coh_2c==1 // 9 cases
					l id coh* b*coh* if coh_2c==1
					tab1 b1cohbegw2 b1cohendw2 if coh_2c==1, m		// b1...w2 "free" for all cases
					replace b1cohbegw2=cohend if coh_2c==1
					replace b1cohendw2=cohbegw2 if coh_2c==1
					replace cohend=cohendw2 if coh_2c==1

	**			2d) ... and cohbegw2!=-77 & cohbegw2!=-3 and cohend==-99 
	**						--> breaks: bXcohbegw2=intdat_prev, bXcohendw2=cohbegw2, cohend=cohendw2 (no change for cohbeg)	
					gen coh_2d=1 if cohend==-99 & (cohbegw2>0 & cohbegw2!=.) & coh_1a==. & coh_1b==. & coh_2a==. & coh_2b==. & coh_2c==.
					count if coh_2d==1 // 8 cases
					l id coh* b*coh* if coh_2d==1
					tab1 b1cohbegw2 b1cohendw2 if coh_2d==1, m		// b1...w2 NOT "free" for all cases (3 special cases) --> differentiate!
					
					replace b2cohbegw2=b1cohbegw2 if coh_2d==1 & b1cohbegw2!=-3
					replace b2cohendw2=b1cohendw2 if coh_2d==1 & b1cohbegw2!=-3
					replace b1cohbegw2=intdatw1 if coh_2d==1 & b1cohbegw2!=-3
					replace b1cohendw2=cohbegw2 if coh_2d==1 & b1cohbegw2!=-3
					
					replace b1cohbegw2=intdatw1 if coh_2d==1 & b1cohbegw2==-3
					replace b1cohendw2=cohbegw2 if coh_2d==1 & b1cohbegw2==-3
						
					replace cohend=cohendw2 if coh_2d==1 
	
	**			2e)	... and cohbegw2==-3 & cohendw2==-3 and cohend==-99	
	**					--> cohend=intdatw1 (no cohabitation episodes in wave 2) 
					gen coh_2e=1 if cohbegw2==-3 & cohendw2==-3 & cohend==-99	
					count if coh_2e==1	// 10 cases
					l id coh* intdatw* if coh_2e==1
					replace cohend=intdatw1 if coh_2e==1	
			
				
	** 		3) flag_ehc==3 (ehc missing completely)
					gen coh_3=1 if flag_ehc==3		// 2 cases
					
					replace cohend=cohendw2 if coh_3==1
					
	
	** any cases with beginning / end wave 2 < beginning / end previous wave?
		l id coh* if cohbegw2<cohbeg & cohbegw2>0 & cohbegw2!=. 	// okay, no such case
		l id coh* if cohendw2<cohend & cohendw2>0 & cohendw2!=. 	// okay, no such case

	drop coh_*
	
	
***** marriage
	
* check beginning and end marriage; can be mentioned in all waves!
	tab marbeg, m
	tab marbegw2, m   // marbegw2: -77 means that already married in first month after interview previous wave --> marriage should have started in prev. wave
	tab marend, m
	tab marendw2, m

	** different cases (if valid episodes in wave 2, i.e. cohbegw2>0 & cohbegw2!=.):

	**		1) no marriage so far (in previous wave, i.e. marbeg=-3 & marend=-3)

	**			1a) ... and marbegw2!=-77 & marbegw2!=-3
	**						--> marbeg=marbegw2, marend=marendw2
					gen mar_1a=1 if (marbeg==-3 & marend==-3) & (marbegw2>0 & marbegw2!=.)	
					count if mar_1a==1 // 137 cases
					l id mar* if mar_1a==1
					replace marbeg=marbegw2 if mar_1a==1
					replace marend=marendw2 if mar_1a==1
					
	**			1b) ... and marbegw2==-77
	**						--> marbeg=intdatw1, marend=marendw2
					gen mar_1b=1 if (marbeg==-3 & marend==-3) & marbegw2==-77 & mar_1a==.	
					count if mar_1b==1 // 50 cases
					l id mar* if mar_1b==1
					replace marbeg=intdatw1 if mar_1b==1
					replace marend=marendw2 if mar_1b==1

					
	**		2) marriage so far (in previous wave)
	
	**			2a) ... and marbegw2==-77 and marend==-99
	**						--> marend=marendw2 (no change for marbeg)
					gen mar_2a=1 if marend==-99 & marbegw2==-77 & mar_1a==. & mar_1b==.	
					count if mar_2a==1 // 2403 cases
					l id mar* if mar_2a==1
					replace marend=marendw2 if mar_2a==1

	**			2b) ... and marbegw2==-77 and marend!=-99 & marend!=-3
	**						--> marend=marendw2 (no change for marbeg)
					gen mar_2b=1 if (marend!=-99 & marend!=-3) & marbegw2==-77 & mar_1a==. & mar_1b==.	& mar_2a==.
					count if mar_2b==1 // 0 cases
					
	**			2c) ... and marbegw2!=-77 & marbegw2!=-3 and marend!=-99  & marend!=-3
					gen mar_2c=1 if (marend!=-99 & marend!=-3) & (marbegw2>0 & marbegw2!=.) & mar_1a==. & mar_1b==.	& mar_2a==. & mar_2b==.
					count if mar_2c==1 // 0 cases
					
	**			2d) ... and marbegw2!=-77 & marbegw2!=-3 and marend==-99 
					gen mar_2d=1 if marend==-99 & (marbegw2>0 & marbegw2!=.) & mar_1a==. & mar_1b==. & mar_2a==. & mar_2b==. & mar_2c==.
					count if mar_2d==1 // 6 cases
					l id mar* intdatw* if mar_2d==1  // assumption: no break; ongoing marriages --> no change necessary
		
					** 138256000: has been changed when generating "biopart wave 1" --> use answer from wave 2
						l pno* mar* if id==138256000
						replace marbeg=marbegw2 if id==138256000 & pnow1==0
						replace marend=marendw2 if id==138256000 & pnow1==0
					** 185131000: has been changed when generating "biopart wave 1" --> use answer from wave 2
						l pno* mar* if id==185131000
						replace marbeg=marbegw2 if id==185131000 & pnow1==0
						replace marend=marendw2 if id==185131000 & pnow1==0
						replace marcer=marcerw2 if id==185131000 & pnow1==0
		
	**			2e)	... and marbegw2==-3 & marendw2==-3 and marend==-99	
	**					--> marend=intdatw1 (no marriage episodes in wave 2) 
					gen mar_2e=1 if marbegw2==-3 & marendw2==-3 & marend==-99	
					count if mar_2e==1	// 1 case
					l id mar* intdatw* if mar_2e==1
					replace marend=intdatw1 if mar_2e==1
					
	** 		3) flag_ehc==3 (ehc missing completely)
					gen mar_3=1 if flag_ehc==3		// 2 cases
					l id mar* intdatw* if mar_3==1  
					
					replace marbeg=marbegw2 if mar_3==1 & id==307529000 
					replace marend=marendw2 if mar_3==1
					replace marcer=marcerw2 if mar_3==1 & id==307529000 
					
					
			
	** any cases with beginning / end wave 2 < beginning / end previous wave?
		l id mar* if marbegw2<marbeg & marbegw2>0 & marbegw2!=. 	// okay, no such case
		l id mar* if marendw2<marend & marendw2>0 & marendw2!=. 	// okay, no such case
	
	
* check marriage ceremony: can be mentioned only in one wave
	tab1 marcer marcerw2, m
	tab marcer marcerw2, m
	l id mar* if marcer!=. & marcer!=-3 & marcerw2!=. & marcerw2!=-3
		

* adapt marriage ceremony	
	tab marcer, m
	tab marcerw2, m
	tab marcer marcerw2, m
	l id mar* if marcer!=. & marcer!=-3 & marcerw2!=. & marcerw2!=-3
		* one case: valid information in wave 2 only --> replace
			replace marcer=marcerw2 if id==185131000 & mar_2d==1
		* all other cases have been dealt with already; no differences in marriage ceremony between waves	
	l marcer marcerw2 if marcerw2>0 & marcerw2!=.
	l marcer* if marcerw2>0 & marcerw2!=. & marcer==-3		// new marriages
		replace marcer=marcerw2 if marcerw2>0 & marcerw2!=. & marcer==-3  
	tab marcer, m
		

	drop mar_*

	
**************************************
* adapt breaks  
**************************************

* check cases with end not ongoing and breaks
	l id beg end b*beg b*begw2 b*end b*endw2 if end!=-99 & b1begw2!=-3 & b1begw2!=. 	
	* --> these are cases with a one-month episode during the month of the interview (checked using non-anonymized data)
	l id beg end b*beg b*begw2 b*end b*endw2 if end!=-99 & b2begw2!=-3 & b2begw2!=. 	// no cases
	l id cohbeg cohend b*cohbeg b*cohbegw2 b*cohend b*cohendw2 if cohend!=-99 & b1cohbegw2!=-3 & b1cohbegw2!=. 	// no cases

* number of breaks in wave 1 --> brelatnum, bcohnum! only partner 0 relevant here!
* caution: these variables are only defined if anchor participated in wave 2
	tab brelatnump0, m
	tab bcohnump0, m
	
* breaks for relationship and cohabitation
	tab1 b*beg*, m
	tab1 b*end*, m

* replace breaks wave 1 with breaks wave 2; breaks wave 2: -100 if there is a break from wave 1
	foreach ding in beg end cohbeg cohend {
		forvalues x=1/7 {
			cap noi replace b`x'`ding'=b`x'`ding'w2 if b`x'`ding'w2>0 & b`x'`ding'w2!=. // cases with -100 not included (see b`x'begw2>0)
		}
	}

* checks
	l id b*beg b*end b*begw2 b*endw2 brelatnump0  if brelatnump0==0 & b1begw2>0 & b1begw2!=.
	l id b*cohbeg b*cohend b*cohbegw2 b*cohendw2 bcohnump0  if bcohnump0==0 & b1cohbegw2>0 & b1cohbegw2!=., ab(20)
	l id b*beg b*end b*begw2 b*endw2 brelatnump0  if brelatnump0>0 & brelatnump0!=.
	l id b*beg b*end b*begw2 b*endw2 brelatnump0  if brelatnump0>0 & b2begw2>0 & b2begw2!=.
	l id b*cohbeg b*cohend b*cohbegw2 b*cohendw2 bcohnump0  if bcohnump0>0 & bcohnump0!=.		
	

* if valid values for beginning in both waves and beginning wave 2 later than beginning wave 1: begw2 will be end of break
* 			end wave 1 will be beginning of break
	l id beg end b*beg b*begw2 b*end b*endw2 if end!=-99 & b1begw2!=-3 & b1begw2!=. 	


* check cases with flag_ehc!=0	
	tab flag_ehc, m
	l if flag_ehc==1 & flag_ehc!=., ab(20)	
	l if flag_ehc==2 & flag_ehc!=., ab(20)
	l if flag_ehc==3 & flag_ehc!=., ab(20)	
	l if flag_ehc==4 & flag_ehc!=., ab(20) // no cases
	l if flag_ehc==5 & flag_ehc!=., ab(20)
	* okay

	
**************************************
* consistency checks (esp. across the waves)
**************************************

* order of breaks not correct?
	l if b1beg>b2beg & b2beg!=. & b2beg>0 & b1beg>0 // no cases



	
*-----------------------------------------------
* NEW PARTNERS WAVE 2
*-----------------------------------------------

	
**************************************
* append additional partners from wave 2 (partners 2-5)
**************************************

	append using biopart_w2_p2ff.dta, generate(filename) // filename=0 for master data (without appendix), =1 for using dataset (p2ff.)
	sort id
	

	
**************************************
* fill in information from w2 if adequate
**************************************

* sex anchor (fill in)
	tab sex if filename==1, m
	bysort id: egen sex_h=max(sex_gen)
	tab sex_h if filename==1, m
	replace sex=sex_h if filename==1
	drop sex_h

* date of birth anchor (fill in)
	tab dob if filename==1, m
	bysort id: egen dob_h=max(dob_gen)
	tab dob_h if filename==1, m
	replace dob=dob_h if filename==1
	drop dob_h

* sex partner 0 (w1) and partner 1 (w2) 
	tab sexp if filename==1, m
	tab sexpw2 if filename==1, m
	replace sexp=sexpw2 if sexp==. & filename==1
	tab sexp, m
		
* pid partner 0 (w1) and partner 1 (w2)
	tab pid if filename==1, m
	tab pidw2 if filename==1, m
	replace pid=pidw2 if pid==. & filename==1
	tab pid, m 

* date of birth partner 0 (w1) and partner 1 (w2)
	tab dobp if filename==1, m
	tab dobpw2 if filename==1, m
	replace dobp=dobpw2 if dobp==. & filename==1
	tab dobp, m 
		
* date of interview wave 2
	recode intdatw2 .=-3
	gsort id +intdatw2
	bysort id: replace intdatw2=intdatw2[_N] if intdatw2==-3
	tab intdatw2, m
	
* respondent in wave 2
	tab respw2, m
	recode respw2 .=-3 
	gsort id respw2
	bysort id: replace respw2=respw2[_N] if respw2==-3
	recode respw2 -3=0
	
* date of death partner
	tab dodp if filename==1, m
	tab dodpw2 if filename==1, m
	replace dodp=dodpw2 if dodp==. & filename==1
	l if dodp==. 

* beginning, end relationship
	foreach ding in beg end {
		replace `ding'=`ding'w2 if `ding'==. & filename==1
	}
	tab beg, m
	tab end, m
	l end pno* respw2 if currw1==1 & currw2!=1
		
* beginning, end cohabitation and marriage
	foreach dong in coh mar {
		foreach ding in beg end {
			replace `dong'`ding'=`dong'`ding'w2 if `dong'`ding'==. & filename==1
		}
	}
	tab cohbeg, m
	tab cohend, m
	tab marbeg, m
	tab marend, m
		
* breaks relationship
	forvalues x=1/3 { // maximum of 3 in wave 2
		foreach ding in beg end {
			cap noi replace b`x'`ding'=b`x'`ding'w2 if b`x'`ding'==. & filename==1
		}
	}
	tab1 b1beg b2beg b3beg, m
	tab1 b1end b2end b3end, m
	
* breaks cohabitation
	forvalues x=1/2 { // maximum of 2 in wave 2
		foreach ding in beg end {
			cap noi replace b`x'coh`ding'=b`x'coh`ding'w2 if b`x'coh`ding'==. & filename==1
		}
	}
	tab1 b*cohbeg, m
	tab1 b*cohend, m
	
	
	
* marriage ceremony
	tab marcer if filename==1, m
	tab marcerw2 if filename==1, m
	replace marcer=marcerw2 if marcer==. 
	tab marcer, m
	

		

**************************************
* cases with complete ehc missing in wave 2
**************************************

	l if flag_ehc==3	

	*br if id==265912000 // no partner in w1, -4 in w2 --> drop complete case
		drop if id==265912000
		
	*br if id==307529000 // 3 partners in w1, -4 in w2 --> drop cases without index (i.e. w2 cases)
		drop if id==307529000 & index==.

	*br if id==395508000 // 2 partners in w1, -4 in w2 --> drop cases with index (i.e. w2 cases)
		drop if id==395508000 & index==.
	
	*br if id==509134000 // 1 partner in w1, -4 in w2 --> drop cases with no index (i.e. w2 cases)
		drop if id==509134000 & index==.
	
	*br if id==546712000 // no partner in w1, -4 in w2 --> drop complete case
		drop if id==546712000
	


	
**************************************
* generate variable "index" for cases from w2
**************************************

	* generate maximum number of index from wave 1
		by id: egen maxindex=max(index)
		recode maxindex .=0
	
	* correct order of new partners (within w2); criterion: first beginning of relationship
		tab pnow2, m
		l id beg end pnow2 index if pnow2!=.
		sort id index
		gen yes=(begw2==-3)
		bysort id (yes beg): gen test1=_n if pnow2>1 & yes==0
		l id beg end begw2 endw2 pnow1 pnow2  test1 index maxindex if pnow2!=.
		* cases without relationship episode, but cohabitation or marriage? (checked using non-anonymized data)
		l if beg==-3 & cohbeg!=-3 // 2 cases
			l if id==106854000
				replace test1=1 if pnow2==2 & id==106854000
			l if id==633836000
				replace test1=2 if pnow2==3 & id==633836000
				replace test1=3 if pnow2==4 & id==633836000
		l if beg==-3 & marbeg!=-3 // 1 case
			l if id==328298000
				replace test1=1 if pnow2==2 & id==328298000
			
	* adapt variable "index"	
		replace index=maxindex+test1 if index==.
		tab index, m 
		l if index==.
		l id beg end begw2 endw2 pnow1 pnow2  test1 index maxindex if pnow2!=.
		

	


**************************************
* get rid of . 
**************************************		
		
	recode currw2 .=0
	recode b*beg b*end (.=-3)	

	tab1 b*beg, m


**************************************
* cases with currw2=0 --> end / cohend / marend still -99?			NEW: not necessarily currw1=1 
**************************************			

* relationship
	
	l id beg end cohbeg cohend marbeg marend currw1 currw2 respw2 intdat* if currw2==0 & intdatw2!=-3 & end<0
	
	* if end=-99 --> replace with interview date wave 1
		* generate problem indicator
			gen prob_relat1=1 if currw2==0 & intdatw2!=-3 & end==-99
			count if prob_relat==1 // 84 cases
			l id beg end cohbeg cohend marbeg marend currw* respw* intdat* if prob_relat1==1
				* all cases: preloaded partners deleted; exception: id=350320000 (two current partners) 
			replace end=intdatw1 if prob_relat1==1 & id!=350320000 // end relationship						NEW: INTDATW1
			replace cohend=intdatw1 if prob_relat1==1 & cohend==-99 & id!=350320000 // end cohabitation 	NEW: INTDATW1
			replace marend=intdatw1 if prob_relat1==1 & marend==-99 & id!=350320000 // end marriage			NEW: INTDATW1
			
	* if end=-3 --> replace with interview date wave 1
		* generate problem indicator 
			gen prob_relat2=1 if currw2==0 & intdatw2!=-3 & end==-3
			count if prob_relat2==1 // 6 cases
			l id beg end cohbeg cohend marbeg marend currw* respw* intdat* if prob_relat2==1
				* three cases: end=intdatw1, three cases: no relationship episodes at all (beg=-3) --> no change
			
			replace end=intdatw1 if prob_relat2==1 & beg!=-3		// NEW: INTDATW1
			l id beg end cohbeg cohend marbeg marend currw1 currw2 respw2 intdat* flag_ehc prob_relat* if prob_relat2==1 & cohbeg!=-3 & cohend==-3  
									// no case	
			replace cohend=intdatw1 if prob_relat2==1 & cohend==-3						// NEW: INTDATW1
			l id beg end cohbeg cohend marbeg marend currw1 currw2 respw2 intdat* flag_ehc prob_relat* if prob_relat2==1 & marbeg!=-3 & marend==-3  
									// no case
			
		

* cohabitation

	l id beg end cohbeg cohend currw1 currw2 respw2 intdat* flag_ehc if currw2==0 & cohend==-99 & intdatw2!=-3 
					// okay, really still cohabiting with this partner, exception: id=241451000
			replace cohend=intdatw1 if id==241451000 & currw1==1 & currw2==0 & cohend==-99 & intdatw2!=-3 
	
	
* marriage	
	
	*br id beg end marbeg marend currw1 currw2 respw2 intdat* flag_ehc if currw2==0 & marend==-99 & intdatw2!=-3 
										// okay, really still married to this partner
	l id if currw2==0 & marend==-99 & intdatw2!=-3 

	* one case: marbeg=-3 since no marriage in wave 1 --> replace with interview date wave 1
			*br id beg end marbeg marend currw1 currw2 respw2 intdat* pno* flag_ehc if id==342223000
			replace marbeg=intdatw1 if id==342223000 & pnow1==0
			replace marend=-88 		if id==342223000 & pnow1==1 // incomplete information
	
	* 28004000 111513000 173962000 218456000 221318000 257362000 273748000 280610000 283141000 286639000 298206000 303921000 
	* 333960000 342223000 404493000 424407000 469862000 505286000 560686000 563887000 613710000 621558000 672948000 675690000 721925000:
	* unclear if and - if so - when marriage ended (partner not preloaded) --> marend=-7
	foreach x of numlist 28004000 111513000 173962000 218456000 221318000 257362000 273748000 280610000 283141000 286639000 298206000 303921000 ///
	333960000 342223000 404493000 424407000 469862000 505286000 560686000 563887000 613710000 621558000 672948000 675690000 721925000 {	
			replace marend=-7 if currw2==0 & marend==-99 & intdatw2!=-3  & id==`x'
	}
	
	* 55140000, 233679000, 595569000: see later
	

**************************************
* check: beginning/end exisiting if end/beginning existing?
**************************************			

	tab beg if end!=-3 // okay
	tab end if beg!=-3 // okay
	
	tab cohbeg if cohend!=-3  // okay
	tab cohend if cohbeg!=-3  // okay
	
	tab marbeg if marend!=-3  // okay
	tab marend if marbeg!=-3 // okay
	
	l id beg end cohbeg cohend currw1 currw2 respw2 intdat* flag_ehc  if cohbeg==-3 & cohend==-99

	

**************************************
* check: double index?
**************************************			
	
	sort id index
	forvalues x=1/12 {
		l id index beg end cohbeg cohend currw1 currw2 respw2 intdat* flag_ehc if id==id[_n+`x'] & index==index[_n+`x']
		l id index beg end cohbeg cohend currw1 currw2 respw2 intdat* flag_ehc if id==id[_n-`x'] & index==index[_n-`x']
	}
	
	* one problematic case: two times index=5
	replace index=4 if beg==1119 & end==1185 & id==252566000
	

	
**************************************
* check: first new partner really later than partner from wave 1? see "index"
**************************************			
	
	sort id index
	l id index beg end cohbeg cohend currw1 currw2 respw2 intdat* flag_ehc if id==id[_n+1] & beg>beg[_n+1] & beg>0 & beg[_n+1]>0
		l id index beg end cohbeg cohend currw1 currw2 respw2 intdat* flag_ehc if id==252566000
		
	l id index beg end cohbeg cohend currw1 currw2 respw2 intdat* flag_ehc if id==id[_n+1] & pnow2!=. & pnow2[_n+1]==. 
	l id if id==id[_n+1] & pnow2!=. & pnow2[_n+1]==. 
	* okay
	
	
**************************************
* drop w2 information (included in w1 variables)
**************************************			
	
	drop sexpw2  dobpw2 dodpw2 *begw2 *endw2 marcerw2 pidw2
	
	
	
**************************************
* recode pid to avoid problems when merging
**************************************		
	
	recode pid -3=.
	

	
**************************************
* drop auxiliary variables
**************************************			
	
	drop b*nump* wavedist ehcid test* help r_* filename maxindex yes prob_relat*


	
**************************************
* recode -1, -2, -4, -5, -6, -77 and -88 to -7 
**************************************			
	
	recode dodp -88=-7
	
	recode dobp marcer (-1 -2 -4 -5 -6=-7) 
	
	recode *beg *end (-4 -5 -6 -77 -88=-7)
	
	
	
**************************************
* variable and value labels etc. 
**************************************			
	
	lab var intdatw2 "Date of interview wave 2"
	lab var pnow2 "Number partner in wave 2"
	lab var currw2 "Current partner in wave 2"
	lab var respw2 "Respondent in wave 2"
	
	recode pnow1 pnow2  (.=-3)
	
	lab val currw2 yesno
	
	recode respw2 .=0
	lab val respw2 yesno
	
	recode flag_ehc .=-3
	
	format %12.0f pid
	
	* labels for -3 & -7
	lab def marcer -7 "-7 Incomplete data", modify
	lab val marcer marcer
	lab def notapply -3 "-3 Does not apply"
	lab val intdatw2 notapply
	lab val pnow* notapply
	lab def dobp0 -7 "-7 Incomplete data", modify
	lab val dobp dobp0
	lab val dodp dobp0
	lab def date1 -7 "-7 Incomplete data", modify
	lab val beg end date1

	
**************************************
* check if multiple partners with end=-99 / cohend==-99 / marend==-99
**************************************			
	
	gen end_c=end
	replace end_c=. if end_c!=-99
	by id: egen doublerelat=count(end_c)
	l id if doublerelat>1  // 1 case (ID=350320000)--> correct, two parallel relationships
	
	gen cohend_c=cohend
	replace cohend_c=. if cohend!=-99
	by id: egen doublecoh=count(cohend_c)
	l id if doublecoh>1 // no case
	
	gen marend_c=marend
	replace marend_c=. if marend_c!=-99
	by id: egen doublemar=count(marend_c)
	l id if doublemar>1

	* ID=55140000: previous partner 3 wave 1 = partner 2 wave 2 (same name in non-anonymized data set)
		*br if id==55140000 
		replace pnow2=2 if id==55140000 & index==3
		replace b1beg=end if id==55140000 & index==3
		replace b1end=1306 if id==55140000 & index==3
		replace end=1306 if id==55140000 & index==3
		drop if id==55140000 & index==4
		forvalues x=5/7 {
			replace index=`x'-1 if index==`x' & id==55140000
		}
	* ID=233679000: previous partner 2 wave 1 = partner 2 wave 2 (same name in non-anonymized data set)
		*br if id==233679000
		replace pid=233679102 if id==233679000 & index==2
		replace dobp=840 if id==233679000 & index==2
		replace pnow2=2 if id==233679000 & index==2
		replace b1beg=end if id==233679000 & index==2
		replace b1end=1314 if id==233679000 & index==2
		replace end=-99 if id==233679000 & index==2
		replace b1cohbeg=cohend if id==233679000 & index==2
		replace b1cohend=1317 if id==233679000 & index==2
		replace cohend=-99 if id==233679000 & index==2
		replace currw2=1 if id==233679000 & index==2
		foreach num of numlist 5 7 12 20 21 22 {
			replace flag`num'w2=flag`num'w2[_n+1] if id==233679000 & id[_n+1]==233679000 & index==2 & index[_n+1]==3
		}
		drop if id==233679000 & index==3
	* ID=595569000: not clear when marriage with partner 2 ended --> set end to -7
		*br if id==595569000
		replace marend=-7 if id==595569000 & index==2
		
	l id if marend==-99


		

	
*-----------------------------------------------
* THIRD STEP: RESPONDENTS FROM WAVE 2 WITHOUT PARTNERS IN WAVE 2, BUT WITH PARTNER IN WAVE 1: fill in intdatw2 and respw2
*-----------------------------------------------
	
	cd "$w2data_local_v2_1"
	merge m:1 id using anchor2, keepusing(intm inty) 	
	tab _merge, m 
	drop if _merge==2 // only keep respondents with observation in biopart (i.e. at least one partner) who participated in wave 2

	drop _merge
	
	gen help=1 if (intdatw2==. | intdatw2==-3) & intm!=.
	replace intdatw2=ym(inty, intm) if help==1
	replace intdatw2=intdatw2-ym(1900,1) if help==1
	
	replace respw2=1 if help==1
	
	drop intm inty help

* homosex (homosexw2: update of homosex from wave 1 --> just one variable)
	tab homosex, m
	bysort id: egen homosex1_h=max(homosex)
	tab homosexw2, m
	bysort id: egen homosex2_h=max(homosexw2)
	replace homosex=homosex1_h if homosex==. & homosex1_h!=.
	replace homosexw2=homosex2_h if homosexw2==. & homosex2_h!=.
	drop homosex2_h homosex1_h
	* generate one variable
	replace homosex=homosexw2 if homosexw2!=.
	l id sex sexp pnow* homosex* respw2* if homosex==1
	drop homosexw2


	

	
*-----------------------------------------------
* CHECK INCONSISTENCIES (flags from wave 1 and wave 2; generate new "biopartflags"
*-----------------------------------------------

	* flags wave 1
	merge m:1 id using biopart1_v2.dta, keepusing(flag* dropp*)
	tab _merge, m
	drop if _merge==2 // drop if only in biopart wave 1
	drop _merge


	* droppx: check if all cases which have been dropped for biopart wave 1 really not part of this data set any more
		l id pnow1 pnow2 if dropp1==1
		l id pnow1 pnow2  if dropp2==1
		l id pnow1 pnow2  if dropp3==1  
		l id pnow1 pnow2  if dropp4==1 
		l id pnow1 pnow2  if dropp5==1 
		l id pnow1 pnow2  if dropp6==1 
		l id pnow1 pnow2  if dropp7==1 
		l id pnow1 pnow2  if dropp8==1 
		l id pnow1 pnow2  if dropp9==1 
		l id pnow1 pnow2  if dropp10==1 
		l id pnow1 pnow2  if dropp11==1 
		l id pnow1 pnow2  if dropp12==1 
		* no problems
	
	
	* negative durations? (end before beginning)
		* relationship episodes
		gen durneg_relat=.
		replace durneg_relat=1 if beg>0 & end>0 & beg>end
		forvalues x=1/10 {
			local y=`x'+1 
			capture replace durneg_relat=1 if (b`x'end>-1 & b`y'beg>-1 & b`x'end>b`y'beg) 
		}
		count if durneg_relat==1 // no cases
		* cohabitation episodes
		gen durneg_coh=.
		replace durneg_coh=1 if cohbeg>0 & cohend>0 & cohbeg>cohend
		forvalues x=1/10 {
			local y=`x'+1 
			capture replace durneg_coh=1 if (b`x'cohend>-1 & b`y'cohbeg>-1 & b`x'cohend>b`y'cohbeg) 
		}
		count if durneg_coh==1 // no cases
		* marriage 
		gen durneg_mar=.
		replace durneg_mar=1 if marbeg>0 & marend>0 & marbeg>marend
		count if durneg_mar==1 // no cases
		drop durneg*
	
	* flag5 & flag5w2: marriage earlier than beginning of relationship (wave 1 and wave 2) --> biopartflag1
		l id flag5* beg marbeg currw* if flag5==1 & marbeg!=-3
		l id flag5* beg marbeg currw* if flag5w2==1  
			** 1 case, but not problematic; still: maybe additional cases
		
		** new variable biopartflag1
			gen biopartflag1=1 if marbeg<beg & beg>0 & marbeg>0
			l id beg marbeg flag5* respw2 pno* if biopartflag1==1
			tab biopartflag1, m
			tab flag5 biopartflag1, m
			recode biopartflag1 .=0
			lab var biopartflag1 "Inconsistency biopart: Marriage earlier than beginning of relationship"
			lab def biopartflag 0 "0 No inconsistency" 1 "1 Inconsistency"
			lab val biopartflag1 biopartflag
			
		
	* flag6: overlap cohabitation with same partner (only wave 1)
		l id pno* flag6* cohbeg b*cohbeg if flag6==1
			* all of these cases solved when generating biopart 1: 275920000 500528000 556618000 688956000 742538000
		l id pno* flag6* cohbeg b*cohbeg if flag6==2
			* all of these cases solved when generating biopart 1: 299034000 363572000
		l id pno* flag6* cohbeg b*cohbeg if flag6==21
			* this one case solved when generating biopart 1:  747536000
		** this inconsistency does not exist any more --> no biopartflag necessary	 

		
	* flag7 and flag7*w2: overlap cohabitation with different partners (wave 1 and wave 2) --> biopartflag2
		tab1 flag7*, m
			* no cases with overlap in at least two consecutive months in wave 2! --> only inspect flag7 from wave 1!
		l id respw2 pno* flag7* cohbeg b*cohbeg cohend if flag7!=0
			* inconsistency still exists: 18723000 55835000 67011000 99669000 145021000 148601000 281262000 283783000 388147000 401893000 ///
			*			408803000 418988000 509854000 631307000 637568000 728559000 734838000 
			*  48366000: partner 4 w1 deleted for biopart w1 --> no inconsistency possible
			* 138256000: partner 3 w1 deleted for biopart w1 --> no inconsistency possible
			* 151355000: partner 3 w1 deleted for biopart w1 --> no inconsistency possible
			* 306878000: partner 2 w1 deleted for biopart w1 --> no inconsistency possible
			* 405703000: partner 2 w1 deleted for biopart w1 --> no inconsistency possible
			* 430543000: partner 1 w1 deleted for biopart w1 --> no inconsistency possible
			* 473328000: partner 2 w1 deleted for biopart w1 --> no inconsistency possible
			* 490787000: still inconsistency, but partner 1 & 3 deleted
			* 548843000: partner 3 w1 deleted for biopart w1 --> no inconsistency possible
			* 683648000: Partner 1 w1 deleted for biopart w1 --> no inconsistency possible
		
		** new variable biopartflag2 (overlap of at least one month)
			* auxiliary variable: number of partners with whom anchor cohabitated /cohabitates 
			gen cohbeg_c=cohbeg
			mvdecode cohbeg_c, mv(-7/-1)
			bysort id: egen help=count(cohbeg_c)
			tab help, m
		
			* aux. variable: generate number of breaks for each partner
			forvalues x=1/3 {
				gen b`x'cohbeg_c=b`x'cohbeg
			}
			mvdecode b*cohbeg_c, mv(-7/-1)
			egen numbr=rownonmiss(b1cohbeg_c b2cohbeg_c b3cohbeg_c) 
			
			* auxiliary variables: generate analog variables for beginning/end and breaks
				gen cohbeg1=cohbeg 
				gen cohbeg2=b1cohend
				gen cohbeg3=b2cohend
				gen cohbeg4=b3cohend
				gen cohend1=b1cohbeg if numbr>=1
				replace cohend1=cohend if numbr==0
				gen cohend2=b2cohbeg if numbr>=2
				replace cohend2=cohend if numbr==1
				gen cohend3=b3cohbeg if numbr>=3
				replace cohend3=cohend if numbr==2
				gen cohend4=cohend if numbr==3
				
			
			gen partflag2_hg=0
			* beginning2 before end1, end2 after end1
			forvalues x=1/13 { // index
				forvalues y=1/4 { // episodes of cohabitation
					forvalues z=1/4 {
						replace partflag2_h=1 if cohbeg`y'>0 & cohbeg`z'[_n+`x']>0 & cohend`y'>0 & cohbeg`z'[_n+`x']<cohend`y' & ///
								cohbeg`z'[_n+`x']>=cohbeg`y' & id==id[_n+`x']
					}
				}
			}
			forvalues x=1/13 { // index
				forvalues y=1/4 { // episodes of cohabitation
					forvalues z=1/4 {
						replace partflag2_h=1 if cohbeg`y'>0 & cohbeg`z'[_n-`x']>0 & cohend`y'>0 & cohbeg`z'[_n-`x']<cohend`y' & ///
								cohbeg`z'[_n-`x']>=cohbeg`y' & id==id[_n-`x']
					}
				}
			}
			* beginning2 before end1, end2 before or same as end1
			forvalues x=1/13 { // index
				forvalues y=1/4 { // episodes of cohabitation
					forvalues z=1/4 {
						replace partflag2_h=1 if cohbeg`y'>0 & cohbeg`z'[_n+`x']>0 & cohend`z'[_n+`x']>0 & cohbeg`z'[_n+`x']<cohend`y' ///
								& cohend`z'[_n+`x']<=cohend`y' & cohbeg`z'[_n+`x']>=cohbeg`y' & id==id[_n+`x']
					}
				}
			}
			forvalues x=1/13 { // index
				forvalues y=1/4 { // episodes of cohabitation
					forvalues z=1/4 {
						replace partflag2_h=1 if cohbeg`y'>0 & cohbeg`z'[_n-`x']>0 & cohend`z'[_n-`x']>0 & cohbeg`z'[_n-`x']<cohend`y' ///
								& cohend`z'[_n-`x']<=cohend`y' & cohbeg`z'[_n-`x']>=cohbeg`y' & id==id[_n-`x']
					}
				}
			}
			* beide Enden -99
			forvalues x=1/13 {
				replace partflag2_h=1 if cohend==-99 & cohend[_n+`x']==-99 & id==id[_n+`x']
			}
			forvalues x=1/13 {
				replace partflag2_h=1 if cohend==-99 & cohend[_n-`x']==-99 & id==id[_n-`x']
			}
			* exactly same beginning and end 
			forvalues x=1/13 {
				forvalues y=1/4 { // episodes of cohabitation
					forvalues z=1/4 {
						replace partflag2_h=1 if cohbeg`y'>0 & cohbeg`z'[_n+`x']>0 & cohbeg`y'==cohbeg`z'[_n+`x'] & ///
						cohend`z'[_n+`x']==cohend`y' & id==id[_n+`x']
					}
				}
			}
			forvalues x=1/13 {
				forvalues y=1/4 { // episodes of cohabitation
					forvalues z=1/4 {
						replace partflag2_h=1 if cohbeg`y'>0 & cohbeg`z'[_n-`x']>0 & cohbeg`y'==cohbeg`z'[_n-`x'] & ///
						cohend`z'[_n-`x']==cohend`y' & id==id[_n-`x']
					}
				}
			}
			
			bysort id: egen biopartflag2=max(partflag2_h)
			tab biopartflag2, m
			lab var biopartflag2 "Inconsistency biopart: Overlapping cohabitation episodes with different partners"
			lab val biopartflag2 biopartflag


	* flag8: Beginning current and end previous marriage --> biopartflag3
		tab1 flag8*, m
		l id respw2 pno* flag8* mar* if flag8!=0
		gen partflag3_h=0
		* beginning2 before end1, end2 after end1
			forvalues x=1/13 { // index
				replace partflag3_h=1 if marbeg>0 & marbeg[_n+`x']>0 & marend>0 & marbeg[_n+`x']<marend & ///
							marbeg[_n+`x']>=marbeg & id==id[_n+`x']
			}

			forvalues x=1/13 { // index
				replace partflag3_h=1 if marbeg>0 & marbeg[_n-`x']>0 & marend>0 & marbeg[_n-`x']<marend & ///
							marbeg[_n-`x']>=marbeg & id==id[_n-`x']
			}
	
			* beginning2 before end1, end2 before or same as end1
			forvalues x=1/13 { // index
				replace partflag3_h=1 if marbeg>0 & marbeg[_n+`x']>0 & marend[_n+`x']>0 & marbeg[_n+`x']<marend ///
							& marend[_n+`x']<=marend & marbeg[_n+`x']>=marbeg & id==id[_n+`x']
			}
			forvalues x=1/13 { // index
				replace partflag3_h=1 if marbeg>0 & marbeg[_n-`x']>0 & marend[_n-`x']>0 & marbeg[_n-`x']<marend ///
							& marend[_n-`x']<=marend & marbeg[_n-`x']>=marbeg & id==id[_n-`x']
			}
			* beide Enden -99
			forvalues x=1/13 {
				replace partflag3_h=1 if marend==-99 & marend[_n+`x']==-99 & id==id[_n+`x']
			}
			forvalues x=1/13 {
				replace partflag3_h=1 if marend==-99 & marend[_n-`x']==-99 & id==id[_n-`x']
			}
			* exactly same beginning and end 
			forvalues x=1/13 {
				replace partflag3_h=1 if marbeg>0 & marbeg[_n+`x']>0 & marbeg==marbeg[_n+`x'] & ///
						marend[_n+`x']==marend & id==id[_n+`x']
			}
			forvalues x=1/13 {
				replace partflag3_h=1 if marbeg>0 & marbeg[_n-`x']>0 & marbeg==marbeg[_n-`x'] & ///
						marend[_n-`x']==marend & id==id[_n-`x']
			}
			
			bysort id: egen biopartflag3=max(partflag3_h)
			tab biopartflag3, m
			lab var biopartflag3 "Inconsistency biopart: Beginning current and end previous marriage"
			lab val biopartflag3 biopartflag

		
	* flag10: Divorce from partner to whom never married
		tab1 flag10, m
		l id respw2 pno* flag10* mar* if flag10!=0 // case (partner 4) does not exist any more
		tab marend if marbeg!=-3 // no problem!
	
	
	* flag11: Separation through death/divorce current spouse
		tab1 flag11, m
		l id respw2 pno* flag11* mar* if flag11!=0 // no problems any more
	
	
	* flag12 and flag12w2: Year of birth current spouse  --> biopartflag4
		tab1 flag12, m
		tab1 flag12w2, m
		l id intdat* respw2 pno* flag12* dob* if flag12!=0 
		l id intdat* respw2 pno* flag12* dob* if flag12w2!=0 & flag12w2!=.  // dobp=-7
			* potential inconsistencies relevant for this file: 
				* 1) "younger than 10 years old" & 2) "Date of birth after beginning of relationship with anchor"
				gen biopartflag4=0
				* ad 1)
				l id intdat* respw2 pno* flag12* dob* if intdatw1-dobp<120 & dobp>0
				l id intdat* respw2 pno* flag12* dob* if intdatw2-dobp<120 & dobp>0 & intdatw2>0 
				replace biopartflag4=1 if (intdatw1-dobp<120 & dobp>0) | (intdatw2-dobp<120 & dobp>0 & intdatw2>0 )
				* ad 2)
				l id intdat* respw2 pno* flag12* dob* beg if dobp>beg & dobp>0 & beg>0 // no such case
			lab var biopartflag4 "Inconsistency biopart: Year of birth partner"
			lab val biopartflag4 flag12

			
	* flag14: Separation before beginning relationship (current partner)
		tab1 flag14, m
		l id respw2 pno* flag14* beg end b*beg b*end if flag14!=0 // no problems any more
		* check beginning
		l id respw2 pno* flag14* beg end b*beg b*end if b1beg<beg & b1beg!=-3 & beg!=-3 & b1beg!=-7 & beg!=-7 // no problem
		l id respw2 pno* flag14* beg end b*beg b*end if b2beg<beg & b2beg!=-3 & beg!=-3 & b2beg!=-7 & beg!=-7 // no problem
		l id respw2 pno* flag14* beg end b*beg b*end if b3beg<beg & b3beg!=-3 & beg!=-3 & b3beg!=-7 & beg!=-7 // no problem
		* check end
		l id respw2 pno* flag14* beg end b*beg b*end if b1end>end & b1end!=-3 & end!=-3 & b1end!=-7 & end!=-7 & end!=-99 & end!=-66 // no problem
		l id respw2 pno* flag14* beg end b*beg b*end if b2end>end & b2end!=-3 & end!=-3 & b2end!=-7 & end!=-7 & end!=-99 & end!=-66 // no problem
		l id respw2 pno* flag14* beg end b*beg b*end if b3end>end & b3end!=-3 & end!=-3 & b3end!=-7 & end!=-7 & end!=-99 & end!=-66 // no problem
	
	
	* flag20: Beginning relationship before first meeting
		* first meeting not part of this data set any more --> irrelevant!
	
	
	* flag21: Cohabitation before first meeting
		* first meeting not part of this data set any more --> irrelevant!
	
	
	* flag22: Marriage before first meeting
		* first meeting not part of this data set any more --> irrelevant!


		
*-----------------------------------------------
** FINALIZE DATA SET 		
*-----------------------------------------------

* delete auxiliary variables
	drop sex_gen
	drop dob_gen
	drop *end_c *beg_c 
	drop help
	drop numbr
	drop double*
	drop flag*
	drop dropp*
	drop cohbeg1-cohend4
	drop *_hg *_h
	
	

* order of variables
	order id intdatw1 intdatw2 sex dob homosex respw* index pid dobp pnow* currw*  sexp  dodp beg end b1beg-b7end cohbeg cohend b1cohbeg-b3cohend ///
	marbeg marend marcer biopartflag*

	
* sort 
	sort id index
	

* copy labels for english version of data set
	label language en, delete
	label language de
	label language en, new copy
	
	
* label data set	
	label language en
	label data "pairfam anchor-partner episode data, release 2.0 (15-05-11)"
	label language de
	label data "pairfam anchor-partner episode data, release 2.0 (15-05-11)"

	
compress
datasignature set, reset
cd "$w2data_local_v2_1"
save biopart, replace


*check_commit, use(biopart) master($w2data_v2_1\biopart)


* delete interim data sets
	cd "$w2data_v2_1"
	capture noi erase biopart1_v2_reshaped.dta
	capture noi erase biopart_w2.dta
	capture noi erase biopart_w2_p1.dta
	capture noi erase biopart_w2_p2ff.dta
	cd "$w2data_local_v2_1"
	capture noi erase biopart1_v2_reshaped.dta
	capture noi erase biopart_w2.dta
	capture noi erase biopart_w2_p1.dta
	capture noi erase biopart_w2_p2ff.dta
	



*--------------------------------------------------------------------------------------------------*
*--------------------------------------------------------------------------------------------------*
* STEP III) modifications/corrections wave 1 & 2 (release 2.0)
*--------------------------------------------------------------------------------------------------*
*--------------------------------------------------------------------------------------------------*


cd "$w2data_local_v2_1"
use biopart, clear


* A) not current partner of wave 2 (currw2=0), but end=-99 (also cohend, marend) and participation in wave 2
	* solution: change end if necessary (see anchor2.dta)
	* (if no participation in wave 2: end/cohend/marend=-99 okay)

	* 1) relationship
		count if currw2==0 & end==-99 & intdatw2!=-3	// 214 cases 
		
		bysort id: gen mark1=1 if currw2==0 & end==-99 & intdatw2!=-3
				
		l id  intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1==1 
				// all of these cases: preloaded partners deleted (-3 in ehc; see anchor2.dta)

		tab pnow2 if mark1==1	
		l id  intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1==1 & pnow2!=-3  
				// 1 case (id= 350320000): two parallel relationships, but only one defined as "current relationship" --> no change!
		
		replace end=intdatw1 if  mark1==1 & currw2==0 & end==-99 & intdatw2!=-3	& id!= 350320000 // assign date of interview wave 1 as end
		
		* Check:	
		l id  intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1==1
		
	
	* 2) cohabitation
		count if currw2==0 & cohend==-99 & intdatw2!=-3		// 54 cases
	
		count if currw2==0 & cohend==-99 & intdatw2!=-3	& end>=intdatw1	// 53 cases of partners from wave 3
		count if currw2==0 & cohend==-99 & intdatw2!=-3 & mark1==1 & end>=intdatw1	 // 34 same cases as above
		count if currw2==0 & cohend==-99 & intdatw2!=-3 & mark1!=1 & end>=intdatw1	 // 19 different cases than above
		
		bysort id: gen mark2=1 if currw2==0 & cohend==-99 & intdatw2!=-3 & end>=intdatw1	
		
		* a) same cases as for relationship (mark1=1 & mark2=1)
		count if mark1==1 & mark2==1		// 34 cases
		l id mark1 intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1==1 & mark2==1
				// all of these cases: preloaded partners deleted (-3 in ehc; see anchor2.dta)
		replace cohend=intdatw1 if mark2==1 & mark1==1 & currw2==0 & cohend==-99 & intdatw2!=-3  // assign date of interview wave 1 as end
		
		* b) new cases for cohabitation
		count if mark1!=1 & mark2==1  	// 19 cases
		l id mark1 intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1!=1 & mark2==1  
			// all cases: still cohabiting (or some special cases, see do-file biopart.do release 2.0)
		

	* 3) marriage
		count if currw2==0 & marend==-99 & intdatw2!=-3		// 73 cases in total
		
		count if currw2==0 & marend==-99 & intdatw2!=-3 & end>=intdatw1	 // 53 cases of preloaded partners in wave 2
		
		* mark3: only preloaded partners; do not change cases without any information in wave 2
		bysort id: gen mark3=1 if currw2==0 & marend==-99 & intdatw2!=-3 & end>=intdatw1  // if end before intdatw1: partner not preloaded in wave 2
				
		* a) same cases as for relationship and cohabitation (mark1=1 & mark2=1 & mark3=1)
		count if mark1==1 & mark2==1 & mark3==1			// 11 cases
		l id mark1 intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1==1 & mark2==1 & mark3==1
				// all of these cases: preloaded partners deleted (-3 in ehc; see anchor2.dta)
		replace marend=intdatw1 if mark3==1 & mark2==1 & mark1==1 & currw2==0 & marend==-99 & intdatw2!=-3  // assign date of interview wave 1 as end
		
		* b) same cases as for relationship (mark1=1 & mark2!=1 & mark3=1)
		count if mark1==1 & mark2!=1 & mark3==1			// 1 case
		l id mark1 intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1==1 & mark2!=1 & mark3==1
				// id==285875000: preloaded partner deleted (-3 in ehc; see anchor2.dta)
		replace marend=intdatw1 if mark3==1 & mark2!=1 & mark1==1 & currw2==0 & marend==-99 & intdatw2!=-3  // assign date of interview wave 1 as end
		
		* c) same cases as for cohabitation (mark1!=1 & mark2=1 & mark3=1)
		count if mark1!=1 & mark2==1 & mark3==1			// 2 cases	
		l id mark1 intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1!=1 & mark2==1 & mark3==1
				// all cases: still married --> no change
		
		* d) completely new cases for marriage (mark1!=1 & mark2!=1 & mark3=1)
		count if mark1!=1 & mark2!=1 & mark3==1			// 39 cases
		l id mark1 intdat* respw2 index pid pno* currw* beg end cohbeg cohend marbeg marend if mark1!=1 & mark2!=1 & mark3==1
				// all cases: still married --> no change
		
		drop mark*
				
* B) breaks of cohabitation for some cases (same partner in wave 1 and wave 2) not considered
	* examples: ID = 51744000, 126167000, 586293000
	* solution: changed in do-file (lines 6647 et seq.); breaks now incorporated


* C) marriage ceremony: 

		* should be -3 instead of -7 if marbeg=-3
			tab marcer if marbeg==-3, m
			replace marcer=-3 if marcer==-7 & marbeg==-3

		* should not be -3 if marbeg!=-3
			tab marcer if marbeg!=-3, m
			merge m:1 id using "anchor2", keepusing(ehc4p* ehc5p?)				
			drop if _merge==2
			drop _merge
			tab1 ehc5p* if marbeg!=-3 & marcer==-3	
			l id ehc5p* if marbeg!=-3 & marcer==-3	
			recode marcer -3=-7 if marbeg!=-3 & marcer==-3	
			drop ehc4p* ehc5p*
			
			
* D) partner's sex: 4 cases with missing values
	* problems: ehc missing or change of partner number (p2 --> p1)
	l if sexp==.
	replace sexp=-7 if id==307529000 					// ehc was missing in wave 2, but partner survey exists
	replace sexp=2 	if id==355861000 					// change of partner number
	replace sexp=1 	if id==516298000 | id==595569000	// change of partner number
	lab def sex -7 "-7 Incomplete data", modify
	tab sexp, m


* E) problem: date of interview wave 2 instead of date of interview wave 1 for cases with currw1=1 & currw2=0 and end/cohend/marend still -99
	* solution: changed in do-file (lines 7225 et seq.)
	
	
* F) pdoby_gen instead of pdobm_gen (line 232) 	


* G) syntax changed for checks cohabitation and marriage (lines 6650 et seq.)
	

	
	
	
* save this modified dataset				
	cd "$w2data_local_v2_1"
	save biopart2_v2.dta, replace

	
