*********************************************************
*EXAMPLE ANALYSIS 2
********************************************************

*TRANSITION TO SEPARATION AFTER FIRST CHILDBIRTH
***********************************************************

	clear all
	set mem 300m
	set more off
	
	* Set path to directory where you stored Eventhistory.dta and anchor1.dta:
	global EHDIR "XXXX"
	

* 1. Merge anchor information with histories data set (for sample restriction purpose)
*******************************************************
	cd "$EHDIR"
	use  "anchor1.dta", clear
	
	* for illustration, we keep only birth cohort information
	g COHORT=.
		replace COHORT=1 if  doby==1971 | doby==1972 | doby==1973 | doby==1974 | doby==1970
		replace COHORT=2 if  doby==1981 | doby==1982 | doby==1983 | doby==1980
		replace COHORT=3 if  doby==1991 | doby==1992 | doby==1993
		lab var COHORT "Birth Cohort"
		lab def COHORT 1 "1971-73" 2 "1981-83" 3 "1991-93" 
		lab val COHORT COHORT

		
	keep id COHORT
	sort id
	merge id using "Eventhistory.dta"

*2. Define central variables 
*************************************************************
	sort id START

* Partnership status at first childbirth	

	g BI1=0
		by id: replace BI1=1 if  AGEBIOK1==2 &  AGEBIOK1[_n-1]==1
		lab var BI1 "First birth"


	g TYPEB1=. 
			replace	TYPEB1=0 if BI1==1 & UNION==0
			replace	TYPEB1=1 if BI1==1 & UNION==1 
			by id: egen TYPE_B1=min(TYPEB1)
			lab var TYPE_B1 "Union status at 1st birth"		
			lab def TYPE_B1 0 "No union" 1 "In union" 
			lab val TYPE_B1 TYPE_B1

* Flag variables (later needed for sample restriction)
	
			
* a) Age at first childbirth
	g AGEBI1=.
		replace AGEBI1=START if BI1==1
		sort id START
		by id: egen AGE_BI1=min(AGEBI1)
		

* b) Union duration until first childbirth (later used as flag variable)
		sort id START
		by id: egen PAR_NOK1=max( UNIONORDER_BIOK1)
	g UNIONSTART=START if ( PAR_NOK1==UNIONORDER |  PAR_NOK1==UNIONORDER_SIM) & UNION==1 
		sort id START
		by id: egen UNION_START=min(UNIONSTART)
	g UNIONDUR=AGE_BI1-UNION_START
	
* c) Short union duration after first childbirth (later used as flag variables)
	by id: gen N=1 if START>=12 & START!=.
		by id: egen NN=min(N)
		lab def NN 1 "Union lasted longer than 1 year after 1st childbirth"
	
	by id: gen O=1 if START>=4 & START!=.
		by id: egen OO=min(O)
		lab def OO 1 "Union lasted longer than 3 months after 1st childbirth"


* 3. REDUCE SAMPLE TO POPULATION AT RISK 
*******************************************

* 3.1. Basic reductions
******************************************
*Drop childless episodes 
	drop if AGEBIOK1<2

*Drop partnerless persons at 1st childbirth
	drop if TYPE_B1==0

	
	sort id START END
	by id: g ORDER=_n
	
**********************************************
* 3.2. Reductions due to imputations
********************************************
	*Do imputed dates influence the results? (birth date of first child, union dates, separation dates)
	* concrete: is the union status at the time of first birth unclear due to imputations?
	
	
	* a) imputed birth date of the child
	*****************************************
	*omission procedure: the birth date as well as the union dates can be imputed.
	* if the child's birth date and the union start date is imputed: 
	*					a) we drop persons who stated year information and have a union duration until first birth of less than 12 months
	*					b) we drop persons who stated only season information and have a union duration until first birth of less than 4 months
	
		drop if  IMP_dobbiok1==1  & UNIONDUR<12
		drop if  IMP_dobbiok1==2 & IMP_UNION==1 & UNIONDUR<12
		drop if  IMP_dobbiok1==2 & IMP_UNION==2 & UNIONDUR<4
		drop if  IMP_dobbiok1==2 & IMP_UNION==0 & UNIONDUR<4
		

	* if the child's birth date and the union end date is imputed: 
	*					a) we drop persons who stated year information and have a union duration until after birth of less than 12 months
	*					b) we drop persons who stated only season information and have a union duration until after birth of less than 4 months
	
	l id  IMP_dobbiok1 IMP_SEP OO if IMP_dobbiok1!=0 & NN==.
		drop if IMP_dobbiok1==1  & NN==.
		drop if  IMP_dobbiok1==2 & IMP_SEP==0 & OO==.
		drop if  IMP_dobbiok1==2 & IMP_SEP==1 & NN==.
		drop if  IMP_dobbiok1==2 & IMP_SEP==2 & OO==.

	
	* b) imputations in the union biography
	*****************************************
	*persons are dropped from the analysis if the union status at the time of first birth remains unclear. 
	
	*Imputations in the union formation date:
	* Persons are dropped if only year information on union formation was given and the union duration until first childbirth was shorter than 12 months.
	* Persons are dropped if only season information on union formation was given and the union lasted shorter than 4 months until first childbirth.
	
	tab UNIONDUR if IMP_UNION==1
		drop if IMP_UNION==1 & UNIONDUR<12
	tab UNIONDUR if IMP_UNION==2
		drop if IMP_UNION==2 & UNIONDUR<4
	
	*Imputations in the union dissolution date:
	* Persons are dropped if only year information on union dissolution was given and the union duration after first childbirth was shorter than 13 months.
	* Persons are dropped if only season information on union dissolution was given and the union lasted shorter than 4 months after first childbirth.

	tab IMP_SEP if NN==.
		drop if NN==. & IMP_SEP==1
	tab IMP_SEP if OO==.
		drop if OO==. & IMP_SEP==2
	
**********************************************	
* 3.3 Further reduction of the sample (optional - depending on research question)
**********************************************
	
*Drop males
	drop if sex==1

*Drop if age at first childbirth is below 18 years
	drop if AGE_BI1<216

*Drop if person does not coreside with child at the time of first childbirth
	g BIO_LIVK1=1 if  LIVBIOK1==1 & BI1==1
	sort id
	by id: egen BIO_LIVK1_=min(BIO_LIVK1)
	keep if BIO_LIVK1_==1
	drop BIO_LIVK1*

*Drop if person does not coreside with partner at the time of first childbirth
	g COHAB_BI=1 if COHAB==1 & BI1==1
	sort id
	by id: egen COHAB_BI_=min(COHAB_BI)
	keep if COHAB_BI_==1
	drop COHAB_BI*
	
*Drop if person lives in a blended family (= with non-biological children in the household)
	g LIV2_GETHER=1 if LIVKIDS==1 & BI1==1
	sort id
	by id: egen LIV2_GETHER_=min(LIV2_GETHER)
	keep if LIV2_GETHER_==1
	drop LIV2_GETHER*
	

*Partner at the time of first birth = the father of the first child?
	g  FATHER=1 if (  PAR_NOK1==UNIONORDER |   PAR_NOK1==UNIONORDER_SIM) & BI1==1
		sort id START
		by id: egen FATHER_=min(FATHER)
	tab FATHER_ if ORDER==1
	*drop ids in which partner at time of first childbirth is not father.
	drop if FATHER_==.
	drop FATHER FATHER_

*Drop if person lived in a homosexual partnership at the time of first childbirth
					
	g HOMO_BI=1 if HOMOSEX==2 & BI1==1
	sort id
	by id: egen HOMO_SEX=max(HOMO_BI)
	drop if HOMO_SEX==2
	drop HOMOSEX HOMO_SEX HOMO_BI	
	
*Simultaneous partnerships at the time of first childbirth?
	tab UNIONORDER_SIM if BI1==1
	*Drop these ids
	g SIM=1 if UNIONORDER_SIM!=0 & BI1==1
	by id: egen SIM_=min(SIM)
	drop if SIM_==1
	drop SIM SIM_
	
*Possible after merge with anchor data: drop youngest cohort
	drop if COHORT==3
	

************************************************************

*Adjust time variable
	sort id START
	by id: egen TEST02=min(START)
	replace START=START-TEST02
	replace END=END-TEST02
	
*Mark the first episode (row) after the event occured
	
	g EVENT2=0
	by id: replace EVENT2=1 if UNION==1 & UNION[_n+1]==0
	by id: replace EVENT2=1 if UNION==1 & UNION[_n+1]==1 & UNIONORDER[_n+1]!=UNIONORDER 
		
	
*Take forward information and drop episodes after the event occured 
	stset END,f(id==0) time0(START) id(id)
			
	g UNIT1=1 if EVENT2==1
	stfill UNIT1, forward


	by id: drop if UNIT1==1 & UNIT1[_n-1]==1
		
	************************************************************************	
	stset END, f(EVENT2==1) time0(START) id(id) exit(time 8*12)
	******************************************************
	
	sts graph
	
	*Visualization of the effect of marital status at childbirth on separation
	
	g MARSTATUS=0
	replace MARSTATUS=1 if MARR!=1 & BI1==1
	replace MARSTATUS=2 if MARR==1 & BI1==1
	replace MARSTATUS=1 if UNIONORDER_MARR!=UNIONORDER & BI1==1
	sort id
	by id: egen MAR_STATUS=max(MARSTATUS)
	
	lab var MAR_STATUS "Marital status at time of 1st childbirth"
	lab def MAR_STATUS 1"Not married" 2"Married"
	lab val MAR_STATUS MAR_STATUS
	

	sts graph, by (MAR_STATUS) ylabel(,format(%3.1f)grid) xtitle(Age of first child in months) ///
	xlabel(0(12)96, grid) legend(label(1 "Not married") label(2 "Married"))
	
	sts list if MAR_STATUS==1, at (0(1)96)
	sts list if MAR_STATUS==2, at (0(1)96)

	*Visualize the transition to separation by marital status (time-varying)
	
	drop if AGEBIOK1>9
	
	*generate binary time-varying variable for marital status
	g TVMARR=-1
	*unmarried if unmarried
	replace TVMARR=0 if MARR==0
	*unmarried if married, but to former partner
	replace TVMARR=0 if MARR==1 & UNIONORDER_MARR!=UNIONORDER
	*unmarried if divorced
	replace TVMARR=0 if MARR==2 
	*married if married with father of the child
	replace TVMARR=1 if MARR==1 & UNIONORDER_MARR==UNIONORDER
	
	lab var TVMARR "Time-variant marital status"
	lab def TVMARR 0"Not married" 1"Married"
	lab val TVMARR TVMARR
	
	
	streg ib2.AGEBIOK1 ib0.TVMARR,d(e)
	
	predict double hrAGEBIOK1, hr
	
	gen hrE0=hrAGEBIOK1 if TVMARR==0
	lab var hrE0 "Not married"
	gen hrE1=hrAGEBIOK1 if TVMARR==1 
	lab var hrE1 "Married"
	
	*gen t0=START/12
	
	twoway(line hrE0 START, sort lwidth(thick))(line hrE1 START, sort lwidth(thick)), ///
	ytitle(Hazard ratio (separation)) ylabel(,format(%3.1f)grid) xtitle(Age of first child in months) ///
	xlabel(0(12)96, grid)
	
	
	

	
