
************************************************************
************************************************************
***														 ***
***		    Do-file for working with pairfam data   	 ***
***        	    CORRECTION OF FRT6 IN WAVE 1		     ***
***           	     ANCHOR DATA WAVE 1          		 ***
***                     Release 5.0			             ***
***	  													 ***
***					   December 2014                     ***
***														 ***
************************************************************
************************************************************


* realistically expected additional children*
* estimation proportion of those who do not *
* expect another child                      *
* using expected age at next birth          *
* and number of biol. children  + adopted   *

****************************************************************************************************
*Important note: This do file was originally written based on release 1.0 of pairfam and stata 10.
*It was adapted to release 5.0 and stata 12 in December 2014. 
****************************************************************************************************



set more off 

use "l:\anchor1.dta", clear

* new variable nkidsbioa = biological kids+adopted kids *

gen a1=0
gen a2=0
gen a3=0
gen a4=0
gen a5=0
gen a6=0
gen a7=0
gen a8=0
gen a9=0
gen a10=0

replace a1=1 if sd15k1==2
replace a2=1 if sd15k2==2
replace a3=1 if sd15k3==2
replace a4=1 if sd15k4==2
replace a5=1 if sd15k5==2
replace a6=1 if sd15k6==2
replace a7=1 if sd15k7==2
replace a8=1 if sd15k8==2
replace a9=1 if sd15k9==2
replace a10=1 if sd15k10==2

gen ag = a1+a2+a3+a4+a5+a6+a7+a8+a9+a10

*tab ag

gen nkidsbioa=nkidsbio+ag if nkidsbio > -7

recode nkidsbioa (.=-7)

tab nkidsbioa
lab var nkidsbioa "Number of children of one's own and adopted"

*drop val1i1-val1i8
*drop sat1i1-pa28
*drop  sex1i1-sex1i3
*drop bce2i1-bce2i10
*drop lsr1i1-sd31
*drop per1i1-hlt4
*drop cps5-gkpol
*drop flag1-fage
*drop hhsizemrd-hhcomp
*drop ag a1-a10

keep id nkidsbioa frt3 frt5 frt6 frt7 frt8 frt9 inty intm doby dobm pregnant infertile 

save "l:\expect.dta", replace


* drop cases which are ok without doubt: = respondents without children *and not pregnant; respondents who do not expect children or don't 
* know/no answer/haven't thought about it

keep if nkidsbioa>0 | pregnant==1
drop if frt6>=5
drop if frt6==-2

save "l:\expect klein.dta", replace


* new variable for age at next birth

gen ageshort=frt9
replace ageshort=0 if frt9 >=-4 & frt9 <=-2
replace ageshort=1 if frt9 >= 18 & frt9 <= 42
lab val ageshort liste55_en
tab ageshort


* Is expected age at birth larger than current age?

gen age=((inty*12+intm)-(doby*12+dobm))/12
gen agei=int(age)
tab agei

gen adiff=-999
replace adiff=frt9-agei if ageshort==1
tab adiff

* 8 cases with age at expected birth smaller than age at interview

gen ageshort2=ageshort
replace ageshort2=-2 if adiff < 0 & adiff > -999
tab ageshort ageshort2


* intention of next birth when adiff le 2?

gen adiff2=adiff
replace adiff2=4 if adiff>=3
tab adiff2 frt7 
tab adiff2 frt8

* 2 cases with definitely no intention and adiff2=0
* other 5 cases with definitely no intention and adiff2=1,2



**********************************************************
* using ageshort2 and intention and pregnant for construction of
* a dummy: 'additional) children expected?: realexp
* number of expected (additional) children: realexpno

gen sumgivex=nkidsbioa+frt6
gen realexp=1
label variable realexp "another child?"

tab ageshort2 frt7

* set realexp to 0 if
* ageshort2 = 'does not apply', 'k.A.', 'Filterfehler'
* and not 1 or 2 as answer to frt7 (this means if a yes is replied to intention [1 case])
* and not pregnant

replace realexp=0 if ageshort2==0 & (frt7 ~= 1 & frt7 ~= 2) & pregnant~=1
tab realexp

* cases being not pregnant
* for cases with adiff2<0 and not 1 or 2 as answer to frt7 (intention)
replace realexp=0 if ageshort2==-2 & (frt7 ~= 1 & frt7 ~= 2)

* for cases with adiff2= 0 and no child in next two years
replace realexp=0 if adiff2==0 & frt7>=3

* set realexp1 to 0 if
* no valid age (ageshort2 not eq 1)
* and not 1 or 2 as answer to frt7 (intention) 
* and not pregnant
* and the actual and expected number is equal
* and their sum is greater than the ideal number
* !!! the condition ageshort2 ~= 1 is restrictive

gen realexp1=realexp
replace realexp1=0 if  (frt6 == nkidsbioa & sumgivex > frt5) ///
                   &  ageshort2 ~= 1 & (frt7 ~= 1 & frt7 ~= 2) ///
                   & frt5 >=0 & pregnant ~= 1


* Alternative:
* set realexp2 to 0 if
* ageshort==-1 
* and not 1 or 2 as answer to frt7 (intention) 
* and not pregnant
* and the actual and expected number is equal
* and their sum is greater than the ideal number

gen realexp2=realexp
replace realexp2=0 if  (frt6 == nkidsbioa & sumgivex > frt5) ///
                   &  ageshort2 == -1 & (frt7 ~= 1 & frt7 ~= 2) ///
                   & frt5 >=0 & pregnant ~= 1



tab realexp1 frt6
tab realexp2 frt6

* Pregnant and infertile cases
* both --> no valid answer to frt7 & frt9 (skipped)
* pregnant respondents treated on the basis of ideal, 
* actual (including pregnancy) and expected number of children 


recode pregnant(-7=0)
replace realexp1=0 if  (frt6 == (nkidsbioa+1) & (sumgivex+1) > frt5) ///
                        & pregnant==1

replace realexp2=0 if  (frt6 == (nkidsbioa+1) & (sumgivex+1) > frt5) ///
                        & pregnant==1



* infertile couples who have tried to have a child are considered to expect another child

replace realexp1=1 if infertile==1 & frt3==1
replace realexp2=1 if infertile==1 & frt3==1

tab realexp1 realexp2


************************************************************************
* generating a corrected number of additional children rexpno1 and rexpno2

gen rexpno1=frt6
gen rexpno2=frt6
replace rexpno1=0 if realexp1==0
replace rexpno2=0 if realexp2==0

* if the sum of actual and expected number of children exceeds the ideal number
* but the number of expected is larger than the actual then take the 
* difference between them as new number of expected children

replace rexpno1=frt6-nkidsbioa if frt6 > nkidsbioa & sumgivex > frt5 ///
               & pregnant==0 & realexp1==1

replace rexpno1=frt6-(nkidsbioa+1)  if frt6 > (nkidsbioa+1) ///
               & (sumgivex+1) > frt5 & pregnant==1 & realexp1==1

replace rexpno2=frt6-nkidsbioa if frt6 > nkidsbioa & sumgivex > frt5 ///
               & pregnant==0 & realexp2==1

replace rexpno2=frt6-(nkidsbioa+1)  if frt6 > (nkidsbioa+1) ///
               & (sumgivex+1) > frt5 & pregnant==1 & realexp2==1


* if the sum of actual and expected number of children exceeds the ideal number
* and the number of expected is equal to the number of actual then set a 1
* assuming a conservative expectation of only one additional child


replace rexpno1=1 if frt6 == nkidsbioa & sumgivex > frt5 & pregnant==0 & realexp1==1
replace rexpno2=1 if frt6 == nkidsbioa & sumgivex > frt5 & pregnant==0 & realexp2==1

replace rexpno1=1 if frt6 == (nkidsbioa+1) & sumgivex > frt5 & pregnant==1 ///
                       & realexp1==1
replace rexpno2=1 if frt6 == (nkidsbioa+1) & sumgivex > frt5 & pregnant==1 ///
                       & realexp2==1

tab rexpno1 frt6
tab rexpno2 frt6

*sum rexpno1 rexpno2 frt6

lab var realexp1 "Another child expected? restricted version"
lab var realexp2 "Another child expected? less restricted version"

lab var rexpno1 "Number expected children, restricted version"
lab var rexpno2 "Number expected children, less restricted version"

*drop wave-realexp

keep id realexp1 realexp2 rexpno1 rexpno2

sort id
save "l:\realexp_short.dta", replace


* saving and merge with the complete sample


use "l:\expect.dta", clear

merge 1:1 id using "l:\realexp_short.dta"
drop _merge

***************************************************************
* kid yes no

gen expon=frt6
recode expon (7=0) (2 3 4=1)

replace realexp1 = expon if realexp1 ==.
replace realexp2 = expon if realexp2 ==.

lab val realexp1 liste53_en
lab val realexp2 liste53_en

tab realexp1 realexp2 

tab frt6 realexp1


****************************************************
* number of children

tab frt6 rexpno1 

gen exponno=frt6
recode exponno (7=0) 

replace rexpno1 = exponno if rexpno1 ==.
replace rexpno2 = exponno if rexpno2 ==.

lab val rexpno1 liste53_en
lab val rexpno2 liste53_en

tab frt6 rexpno1

tab rexpno1 rexpno2


*** compare frt6 and rexpno1/2 for respondents with children **

gen exp_total=exponno+nkidsbio if nkidsbio>=0 & exponno >= 0 & exponno < 5
gen rexp1_total=rexpno1+nkidsbio if nkidsbio>=0 & rexpno1 >= 0 & rexpno1 < 5
gen rexp2_total=rexpno2+nkidsbio if nkidsbio>=0 & rexpno2 >= 0 & rexpno2 < 5

*tab1 expon realexp1 realexp2 if nkidsbio==0 & pregnant==0
tab1 expon realexp1 realexp2 if nkidsbio>0
*tab1 exponno rexpno1 rexpno2 if nkidsbio==0 & pregnant==0
tab1 exponno rexpno1 rexpno2 if nkidsbio>0

sum exp_total if nkidsbio>0 & exponno >=0 & exponno < 5
sum rexp1_total if nkidsbio>0 & rexpno1 >=0 & rexpno2 < 5
sum rexp2_total if nkidsbio>0 & rexpno2 >=0 & rexpno2 < 5

*** compare frt6 and rexpno1/2 for respondents without children **

sum exp_total if nkidsbio==0 & exponno >=0 & exponno < 5
sum rexp1_total if nkidsbio==0 & rexpno1 >=0 & rexpno2 < 5
sum rexp2_total if nkidsbio==0 & rexpno2 >=0 & rexpno2 < 5

** small differences in the group of respondents without children are due to changes in regard to pregnancy **


*saving

*drop pid - intage expon - rexp2_total

keep id realexp1 realexp2 rexpno1 rexpno2 

sort id

save "l:\realexp_long_w1.dta", replace





