﻿* Encoding: UTF-8.

*************************************************************************************************.
                                       *** SYNTAX FAMILYTYPE ***                                 .
                           *** SEE PAIRFAM TECHNICAL PAPER NO. 21 (2023) ***                     .
              ** AUTHORS: Barbara Sawatzki, Julia Reim, Rüdiger Edinger, Sabine Walper ***       .
*************************************************************************************************.


* Auxiliary variable: Relationship and cohabitation status of anchor and, if applicable, partner  *.

***** Only necessary for wave 2 ********************************************************************************.
    *IF hp=0 relcohab=1.
    *IF hp=1 AND (ehc3p1 = 0 OR ehc3p2 = 0 OR ehc3p3 = 0 OR ehc3p4 = 0 OR ehc3p5 = 0) relcohab=2.
    *IF hp=1 AND (ehc3p1 = 1 OR ehc3p2 = 1 OR ehc3p3 = 1 OR ehc3p4 = 1 OR ehc3p5 = 1) relcohab=3.
    *EXECUTE.
    *VARIABLE LABELS relcohab 'Relationship and cohabitation status anchor'.
    *VALUE LABELS relcohab 
    *'1' '1 Single' 
    *'2' '2 Partner, not cohabiting' 
    *'3' '3 Partner, cohabiting'. 
    *FRE relcohab.
*******************************************************************************************************************.

* For Waves 3 to 14 *.

IF hp=0 relcohab=1.
IF hp=1 AND hpc=0 relcohab=2.
IF hp=1 AND hpc=1 relcohab=3.
EXECUTE.
VARIABLE LABELS relcohab 'Relationship and cohabitation status anchor'.
VALUE LABELS relcohab 
'1' '1 Single' 
'2' '2 Partner, not cohabiting' 
'3' '3 Partner, cohabiting'. 
FRE relcohab.


* Auxiliary variable: same-sex anchor-partner-dyad, for all waves *.

IF sex_gen=1 AND psex_gen=1 homosexcouple=1.
IF sex_gen=2 AND psex_gen=2 homosexcouple=2.
EXECUTE.
VARIABLE LABELS homosexcouple 'Homosexual anchor-partner dyad'.
VALUE LABELS homosexcouple 
'1' '1 male partners' 
'2' '2 female partners'.
FRE homosexcouple.

***** Only necessary for wave 14 ********************************************************************************.

*If cid1 > 0 ehc9k1 = di50.  
*If cid1 > 0 AND bcrn5k1 = 1 ehc9k1 = 1.
*If cid1 > 0 AND bcrn5k1 = 2 ehc9k1 = 2.
*If cid1 > 0 AND bcrn5k1 = 3 ehc9k1 = 3.
*If cid1 > 0 AND bcrn5k1 = 4 ehc9k1 = 4.
*EXECUTE.

*If cid2 > 0 ehc9k2 = di51.   
*If cid2 > 0 AND bcrn5k2 = 1 ehc9k2 = 1.
*If cid2 > 0 AND bcrn5k2 = 2 ehc9k2 = 2.
*If cid2 > 0 AND bcrn5k2 = 3 ehc9k2 = 3.
*If cid2 > 0 AND bcrn5k2 = 4 ehc9k2 = 4.
*EXECUTE.

*If cid3 > 0 ehc9k3 = di52.   
*If cid3 > 0 AND bcrn5k3 = 1 ehc9k3 = 1.
*If cid3 > 0 AND bcrn5k3 = 2 ehc9k3 = 2.
*If cid3 > 0 AND bcrn5k3 = 3 ehc9k3 = 3.
*If cid3 > 0 AND bcrn5k3 = 4 ehc9k3 = 4.
*EXECUTE.

*If cid4 > 0 ehc9k4 = di53.    
*If cid4 > 0 AND bcrn5k4 = 1 ehc9k4 = 1.
*If cid4 > 0 AND bcrn5k4 = 2 ehc9k4 = 2.
*If cid4 > 0 AND bcrn5k4 = 3 ehc9k4 = 3.
*If cid4 > 0 AND bcrn5k4 = 4 ehc9k4 = 4.
*EXECUTE.

*If cid5 > 0 ehc9k5 = di54.  
*If cid5 > 0 AND bcrn5k5 = 1 ehc9k5 = 1.
*If cid5 > 0 AND bcrn5k5 = 2 ehc9k5 = 2.
*If cid5 > 0 AND bcrn5k5 = 3 ehc9k5 = 3.
*If cid5 > 0 AND bcrn5k5 = 4 ehc9k5 = 4.
*EXECUTE.

*If cid6 > 0 ehc9k6 = di55.    
*If cid6 > 0 AND bcrn5k6 = 1 ehc9k6 = 1.
*If cid6 > 0 AND bcrn5k6 = 2 ehc9k6 = 2.
*If cid6 > 0 AND bcrn5k6 = 3 ehc9k6 = 3.
*If cid6 > 0 AND bcrn5k6 = 4 ehc9k6 = 4.
*EXECUTE.

*If cid7 > 0 ehc9k7 = di56.    
*If cid7 > 0 AND bcrn5k7 = 1 ehc9k7 = 1.
*If cid7 > 0 AND bcrn5k7 = 2 ehc9k7 = 2.
*If cid7 > 0 AND bcrn5k7 = 3 ehc9k7 = 3.
*If cid7 > 0 AND bcrn5k7 = 4 ehc9k7 = 4.
*EXECUTE.

*If cid8 > 0 ehc9k8 = di57.    
*If cid8 > 0 AND bcrn5k8 = 1 ehc9k8 = 1.
*If cid8 > 0 AND bcrn5k8 = 2 ehc9k8 = 2.
*If cid8 > 0 AND bcrn5k8 = 3 ehc9k8 = 3.
*If cid8 > 0 AND bcrn5k8 = 4 ehc9k8 = 4.
*EXECUTE.

*If cid9 > 0 ehc9k9 = di58.   
*If cid9 > 0 AND bcrn5k9 = 1 ehc9k9 = 1.
*If cid9 > 0 AND bcrn5k9 = 2 ehc9k9 = 2.
*If cid9 > 0 AND bcrn5k9 = 3 ehc9k9 = 3.
*If cid9 > 0 AND bcrn5k9 = 4 ehc9k9 = 4. 
*EXECUTE.

*If cid10 > 0 ehc9k10 = di59.    
*If cid10 > 0 AND bcrn5k10 = 1 ehc9k10 = 1.
*If cid10 > 0 AND bcrn5k10 = 2 ehc9k10 = 2.
*If cid10 > 0 AND bcrn5k10 = 3 ehc9k10 = 3.
*If cid10 > 0 AND bcrn5k10 = 4 ehc9k10 = 4.
*EXECUTE.

*If cid11 > 0 ehc9k11 = di60.    
*If cid11 > 0 AND bcrn5k11 = 1 ehc9k11 = 1.
*If cid11 > 0 AND bcrn5k11 = 2 ehc9k11 = 2.
*If cid11 > 0 AND bcrn5k11 = 3 ehc9k11 = 3.
*If cid11 > 0 AND bcrn5k11 = 4 ehc9k11 = 4.
*EXECUTE.

*If cid12 > 0 ehc9k12 = di61.   
*If cid12 > 0 AND bcrn5k12 = 1 ehc9k12 = 1.
*If cid12 > 0 AND bcrn5k12 = 2 ehc9k12 = 2.
*If cid12 > 0 AND bcrn5k12 = 3 ehc9k12 = 3.
*If cid12 > 0 AND bcrn5k12 = 4 ehc9k12 = 4. 
*EXECUTE.

*If cid13 > 0 ehc9k13 = di62.    
*If cid13 > 0 AND bcrn5k13 = 1 ehc9k13 = 1.
*If cid13 > 0 AND bcrn5k13 = 2 ehc9k13 = 2.
*If cid13 > 0 AND bcrn5k13 = 3 ehc9k13 = 3.
*If cid13 > 0 AND bcrn5k13 = 4 ehc9k13 = 4.
*EXECUTE.

*If cid14 > 0 ehc9k14 = di63.    
*If cid14 > 0 AND bcrn5k14 = 1 ehc9k14 = 1.
*If cid14 > 0 AND bcrn5k14 = 2 ehc9k14 = 2.
*If cid14 > 0 AND bcrn5k14 = 3 ehc9k14 = 3.
*If cid14 > 0 AND bcrn5k14 = 4 ehc9k14 = 4.
*EXECUTE.

*If cid15 > 0 ehc9k15 = di64.    
*If cid15 > 0 AND bcrn5k15 = 1 ehc9k15 = 1.
*If cid15 > 0 AND bcrn5k15 = 2 ehc9k15 = 2.
*If cid15 > 0 AND bcrn5k15 = 3 ehc9k15 = 3.
*If cid15 > 0 AND bcrn5k15 = 4 ehc9k15 = 4.
*EXECUTE.
*******************************************************************************************************************.


****************************************************************************************************************************************************************************************.
* Family Type *.
      *For all waves*
      *Note: For Waves 2 - 9 delete variables with the prefix or suffix k11 - k15 before running the syntax, as only up to 10 children per family were assessed in these waves.
****************************************************************************************************************************************************************************************.

DO REPEAT
 famtype = familytypek1 familytypek2 familytypek3 familytypek4 familytypek5 familytypek6 familytypek7 familytypek8 familytypek9 familytypek10 familytypek11 familytypek12 familytypek13 familytypek14 familytypek15/
 ktype = k1type k2type k3type k4type k5type k6type k7type k8type k9type k10type k11type k12type k13type k14type k15type/
 ehc9 = ehc9k1 ehc9k2 ehc9k3 ehc9k4 ehc9k5 ehc9k6 ehc9k7 ehc9k8 ehc9k9 ehc9k10 ehc9k11 ehc9k12 ehc9k13 ehc9k14 ehc9k15.
COMPUTE famtype=99.
IF value(ktype)=-3 famtype=-3.
IF value(ktype)=-7 famtype=-7.
IF any(ktype,1,2,3) famtype=-9.
IF ktype=9 famtype=1.
IF ktype=6 famtype=11.
IF ktype=8 AND (relcohab NE 3) AND sex_gen=2 famtype=2.
IF ktype=5 AND (relcohab NE 3) AND sex_gen=2 famtype=12.
IF ktype=8 AND (relcohab NE 3) AND sex_gen=1 famtype=3.
IF ktype=5 AND (relcohab NE 3) AND sex_gen=1 famtype=13.
IF ktype=8 AND relcohab=3 AND sex_gen=1 AND psex_gen=2 famtype=4.
IF ktype=5 AND relcohab=3 AND sex_gen=1 AND psex_gen=2 famtype=14.
IF ktype=8 AND relcohab=3 AND sex_gen=2 AND psex_gen=1 famtype=5.
IF ktype=5 AND relcohab=3 AND sex_gen=2 AND psex_gen=1 famtype=15.
IF ktype=7 AND ehc9=3 AND sex_gen=2 AND psex_gen=1 AND relcohab=3 famtype=4.
IF ktype=4 AND ehc9=3 AND sex_gen=2 AND psex_gen=1 AND relcohab=3 famtype=14.
IF ktype=7 AND ehc9=3 AND sex_gen=1 AND psex_gen=2 AND relcohab=3 famtype=5.            
IF ktype=4 AND ehc9=3 AND sex_gen=1 AND psex_gen=2 AND relcohab=3 famtype=15.      
IF ktype=7 AND ehc9=2 famtype=6.
IF ktype=4 AND ehc9=2 famtype=16.
IF ktype=7 AND ehc9=4 famtype=7.
IF ktype=4 AND ehc9=4 famtype=17.
IF famtype=99 AND homosexcouple=2 AND relcohab=3 AND (ktype=7 OR ktype=8 OR ktype=9) famtype=8.
IF famtype=99 AND homosexcouple=2 AND relcohab=3 AND (ktype=4 OR ktype=5 OR ktype=6) famtype=18.
IF famtype=99 AND homosexcouple=1 AND relcohab=3 AND (ktype=7 OR ktype=8 OR ktype=9) famtype=9.
IF famtype=99 AND homosexcouple=1 AND relcohab=3 AND (ktype=4 OR ktype=5 OR ktype=6) famtype=19.
IF famtype=99 AND (ktype=7 OR ktype=8 OR ktype=9) famtype=10.
IF famtype=99 AND (ktype=4 OR ktype=5 OR ktype=6) famtype=20.
END REPEAT.
EXECUTE.


VARIABLE LABELS
familytypek1 'Family type anchor-partner-child k1' 
familytypek2 'Family type anchor-partner-child k2' 
familytypek3 'Family type anchor-partner-child k3' 
familytypek4 'Family type anchor-partner-child k4'
familytypek5 'Family type anchor-partner-child k5'
familytypek6 'Family type anchor-partner-child k6'
familytypek7 'Family type anchor-partner-child k7'
familytypek8 'Family type anchor-partner-child k8'
familytypek9 'Family type anchor-partner-child k9'
familytypek10 'Family type anchor-partner-child k10'
familytypek11 'Family type anchor-partner-child k11'
familytypek12 'Family type anchor-partner-childd k12'
familytypek13 'Family type anchor-partner-child k13'
familytypek14 'Family type anchor-partner-child k14'
familytypek15 'Family type anchor-partner-child k15'.
EXECUTE.

VALUE LABELS familytypek1 familytypek2 familytypek3 familytypek4 familytypek5 
familytypek6 familytypek7 familytypek8 familytypek9 familytypek10 familytypek11 
familytypek12 familytypek13 familytypek14 familytypek15
'-9' '-9 Child deceased'
'-7' '-7 Incomplete data'
'-3' '-3 Does not apply'
'1' '1 Biological child of anchor and partner'
'2' '2 Biological child of a single mother'
'3' '3 Biological child of a single father'
'4' '4 Child with biological father and stepmother '
'5' '5 Child with biological mother and stepfather'
'6' '6 Adopted child'
'7' '7 Foster child'
'8' '8 Child of a same sex anchor-partner dyad: mothers' 
'9' '9 Child of a same sex anchor-partner dyad: fathers'
'10' '10 Other child'
'11' '11 Biological child of anchor and partner, child not living in household'
'12' '12 Biological child of external single mother'
'13' '13 Biological child of external single father'
'14' '14 Child of external biological father and stepmother'
'15' '15 Child of external biological mother and stepfather'
'16' '16 Adopted child, child not living in household'
'17' '17 Foster child, child not living in household'
'18' '18 Child of a same sex anchor-partner dyad: mothers, child not living in household'
'19' '19 Child of a same sex anchor-partner dyad: fathers, child not living in household'
'20' '20 Other child, child not living in household'.
EXECUTE.

MISSING VALUES familytypek1 familytypek2 familytypek3 familytypek4 familytypek5
 familytypek6 familytypek7 familytypek8 familytypek9 familytypek10 familytypek11 
 familytypek12 familytypek13 familytypek14 familytypek15  (-9 THRU -3).
EXECUTE.


FREQUENCIES familytypek1 familytypek2 familytypek3 familytypek4 familytypek5 familytypek6 familytypek7 familytypek8 familytypek9 familytypek10 familytypek11 familytypek12 familytypek13 familytypek14 familytypek15.
