*************************************************************************************************
                                       *** SYNTAX FAMILYTYPE ***   
						   *** SEE PAIRFAM TECHNICAL PAPER NO. 21 (2023) ***
		   *** AUTHORS: Barbara Sawatzki, Julia Reim, Rüdiger Edinger, Sabine Walper  ***
											     *** 
*************************************************************************************************
*	Attention for wave 12 & wave 13: Before running the dofile please append the 
*		datasets anchor12_capi.dta (anchor13_capi.dta) and anchor12_cati.dta 
*      (anchor13_cati.dta) and name the combined dataset anchor12.dta 
*	   (anchor13.dta)! For more information on the mode change in W12/W13, 
*      please see the Data Manual, Chapter 12. 
********************************************************************************************
*	Attention for wave 14: Before running the dofile please append the datasets 
*		anchor14_capi.dta, anchor14_cawi.dta and anchor14_papi.dta and name the 
*	    combined dataset anchor14.dta! For more information on the mode change 
*	    in W14, please see the Data Manual, Chapter 13.
********************************************************************************************


clear 
set more off

*global w "14"							// <--- IMPORTANT: Uncomment this for setting wave you want to run syntax with, here wave 14


* Load data 
	cd "$work_loc" 					// global datapath "X:\pairfam_dta\"
	use "anchor$w.dta", clear
	
	
* Auxiliary variable: Relationship and cohabitation status of anchor and, if applicable, partner
	gen relcohab=.

	if `=$w'==2 {
		replace relcohab=1 if hp==0
		replace relcohab=2 if hp==1 & (ehc3p1==0 | ehc3p2==0 | ehc3p3==0 | ehc3p4==0 | ehc3p5==0)
		replace relcohab=3 if hp==1 & (ehc3p1==1 | ehc3p2==1 | ehc3p3==1 | ehc3p4==1 | ehc3p5==1)
	}
	
	
	if `=$w'>2 {
		replace relcohab=1 if hp==0
		replace relcohab=2 if hp==1 & hpc==0
		replace relcohab=3 if hp==1 & hpc==1
	}
	
	label var relcohab "Relationship and cohabitation status anchor"
	label def relcohab 1 "1 Single" 2 "2 Partner, not cohabiting" 3 "3 Partner, cohabiting"
	label val relcohab relcohab
	tab relcohab, m
	
	
* Auxiliary variable: same-sex anchor-partner-dyad, for all waves
	gen homosexcouple=.
	replace homosexcouple=1 if sex_gen==1 & psex_gen==1
	replace homosexcouple=2 if sex_gen==2 & psex_gen==2

	label var homosexcouple "Homosexual anchor-partner dyad"
	label def homosexcouple 1 "1 male partners" 2 "2 female partners"
	label val homosexcouple homosexcouple
	tab homosexcouple, m

	
* Rebuild ehc9kX (only necessary for wave 14)
	if `=$w'==14 {
		forvalues x=1/15 {
			local y=49+`x'
			gen ehc9k`x'=di`y' if cid`x'!=.
			replace ehc9k`x'=1 if cid`x'!=. & bcrn5k`x'==1
			replace ehc9k`x'=2 if cid`x'!=. & bcrn5k`x'==2
			replace ehc9k`x'=3 if cid`x'!=. & bcrn5k`x'==3
			replace ehc9k`x'=4 if cid`x'!=. & bcrn5k`x'==4
		}
	}
	
	
* Family Type (for all waves)
* Note: For Waves 2 - 9 only for child 1 to 10, as only up to 10 children per family were assessed in these waves.

	local i=15
	
	if inrange(`=$w',2,9) {
		local i=10
	}
	
	forvalues x=1/`i' {
		gen familytypek`x'=99
		replace familytypek`x'=-3 	if k`x'type==-3
		replace familytypek`x'=-7 	if k`x'type==-7
		replace familytypek`x'=-9 	if inlist(k`x'type,1,2,3)
		replace familytypek`x'=1 	if k`x'type==9
		replace familytypek`x'=11 	if k`x'type==6
		replace familytypek`x'=2 	if k`x'type==8 & relcohab!=3 & sex_gen==2
		replace familytypek`x'=12	if k`x'type==5 & relcohab!=3 & sex_gen==2
		replace familytypek`x'=3 	if k`x'type==8 & relcohab!=3 & sex_gen==1
		replace familytypek`x'=13	if k`x'type==5 & relcohab!=3 & sex_gen==1
		replace familytypek`x'=4 	if k`x'type==8 & relcohab==3 & sex_gen==1 & psex_gen==2
		replace familytypek`x'=14	if k`x'type==5 & relcohab==3 & sex_gen==1 & psex_gen==2
		replace familytypek`x'=5 	if k`x'type==8 & relcohab==3 & sex_gen==2 & psex_gen==1
		replace familytypek`x'=15	if k`x'type==5 & relcohab==3 & sex_gen==2 & psex_gen==1
		replace familytypek`x'=4 	if k`x'type==7 & ehc9k`x'==3 & sex_gen==2 & psex_gen==1 & relcohab==3
		replace familytypek`x'=14	if k`x'type==4 & ehc9k`x'==3 & sex_gen==2 & psex_gen==1 & relcohab==3
		replace familytypek`x'=5 	if k`x'type==7 & ehc9k`x'==3 & sex_gen==1 & psex_gen==2 & relcohab==3
		replace familytypek`x'=15	if k`x'type==4 & ehc9k`x'==3 & sex_gen==1 & psex_gen==2 & relcohab==3
		replace familytypek`x'=6 	if k`x'type==7 & ehc9k`x'==2
		replace familytypek`x'=16 	if k`x'type==4 & ehc9k`x'==2
		replace familytypek`x'=7 	if k`x'type==7 & ehc9k`x'==4
		replace familytypek`x'=17 	if k`x'type==4 & ehc9k`x'==4
		replace familytypek`x'=8 	if familytypek`x'==99 & homosexcouple==2 & relcohab==3 & inrange(k`x'type,7,9)
		replace familytypek`x'=18 	if familytypek`x'==99 & homosexcouple==2 & relcohab==3 & inrange(k`x'type,4,6)
		replace familytypek`x'=9 	if familytypek`x'==99 & homosexcouple==1 & relcohab==3 & inrange(k`x'type,7,9)
		replace familytypek`x'=19 	if familytypek`x'==99 & homosexcouple==1 & relcohab==3 & inrange(k`x'type,4,6)
		replace familytypek`x'=10 	if familytypek`x'==99 & inrange(k`x'type,7,9)
		replace familytypek`x'=20 	if familytypek`x'==99 & inrange(k`x'type,4,6)
	}
	
	
	local i=15
	if inrange(`=$w',2,9) {
		local i=10
	}
	
	forvalues x=1/`i' {
		label var familytypek`x' "Family type anchor-partner-child k`x'"
		
		#delimit ; 
		lab def familytypek`x'	-9 "-9 Child deceased"
								-7 "-7 Incomplete data"
								-3 "-3 Does not apply"
								1 "1 Biological child of anchor and partner"
								2 "2 Biological child of a single mother"
								3 "3 Biological child of a single father"
								4 "4 Child with biological father and stepmother"
								5 "5 Child with biological mother and stepfather"
								6 "6 Adopted child"
								7 "7 Foster child"
								8 "8 Child of a same sex anchor-partner dyad: mothers"
								9 "9 Child of a same sex anchor-partner dyad: fathers"
								10 "10 Other child"
								11 "11 Biological child of anchor and partner, child not living in household"
								12 "12 Biological child of external single mother"
								13 "13 Biological child of external single father"
								14 "14 Child of external biological father and stepmother"
								15 "15 Child of external biological mother and stepfather"
								16 "16 Adopted child, child not living in household"
								17 "17 Foster child, child not living in household"
								18 "18 Child of a same sex anchor-partner dyad: mothers, child not living in household"
								19 "19 Child of a same sex anchor-partner dyad: fathers, child not living in household"
								20 "20 Other child, child not living in household" ;
		#delimit cr
		label val familytypek`x' familytypek`x'
	}
	
	
	tab1 familytypek*, m
	