#' @title Random Learner
#'
#' @include Learner.R
#'
#' @description
#' This Learner specializes [Learner] to match the random algorithm
#'
Random = R6Class("Random", inherit = Learner,
              public = list(
                
                
                   #' @field z_t (`numeric(d)`)\cr
                   #' Stores the contrast vectors over the time.
                   z_t = NULL,
                
                   #' @field o_t (`integer()`)\cr
                   #' Stores the feedback obtained by the learner over the time.
                   o_t = NULL,
                
                   #' @field d (`integer()`)\cr
                   #' dimensionality of the problem.
                   d = NULL,
                   
                   #' @field n (`integer()`)\cr
                   #' number of arms.
                   n = NULL,
                
                
                #' @description
                #' Creates a new instance of this [R6][R6::R6Class] class.
                initialize = function(data_model_specs = list(num_arms = 2, dim = 1), aggregation){
                  super$initialize(aggregation = aggregation, action_size = 2)
                  
                  self$n            = data_model_specs$num_arms
                  self$d            = data_model_specs$dim
                  self$z_t          = list()
                  self$o_t          = c()
                  
                },
                
                action = function(data_model) {
                  
                  sample(1:self$n,2,replace=FALSE)
                  
                },
                
                
                update = function(chosen_arms,data_model) { 
                  temp = data_model$getFeedback(c(chosen_arms[1],chosen_arms[2]),self$timestep)
 
                  self$z_t[[self$timestep]]		=	data_model$context_matrices[[self$timestep]][,chosen_arms[1]] - data_model$context_matrices[[self$timestep]][,chosen_arms[2]]
                  self$o_t[self$timestep]     = temp

                }
              )
)