


# function to sample 'sample_size' many points uniformly at random from the L_2-ring (specified by 'rad1' and 'rad_2')  of dimension 'dim' with 

genRandomSampleL2Ring <- function(sample_size = 1, dim = 1, rad_1=0,rad_2=1){
  
  norm_samples       <- matrix(rnorm(dim*sample_size), ncol=dim)
  lambda    <- runif(sample_size,rad_1,rad_2)^(1/dim) / sqrt(rowSums(norm_samples^2))
  t(norm_samples*lambda)
  
}
 
