#' @title Learner Class
#' 
#' @include Feedback.R
#'
#' @description
#' This is the abstract base class for learner objects like [COLSTIM], [MaxInP], [Self-Sparring] and [DTS].
#'



Learner = R6Class("Learner",
                  public = list(
                    
                    
                    #' @field aggregation (`function()`)\cr
                    #' A function describing the aggregation of arm utilities.
                    aggregation = NULL,
                    
                    #' @field regret (`numeric()`)\cr
                    #' Stores the regret suffered by the learner over the time.
                    regret = NULL,
					
					#' @field weak_regret (`numeric()`)\cr
                    #' Stores the weak regret suffered by the learner over the time.
                    weak_regret = NULL,
                    
                    #' @field times (`numeric()`)\cr
                    #' Stores the time elapsed the learner needed to make an action and update its internal statistics.
                    times = NULL,
                    
                    #' @field choices (`integer()`)\cr
                    #' Stores the choices made by the learner over the time.
                    choices = NULL,
                    
                    #' @field timestep (`integer()`)\cr
                    #' Stores the current iteration step of the learner.
                    timestep = 0,
                    
                    #' @field action_size (`integer()`)\cr
                    #' Stores the size of the action space.
                    action_size = 0,
                    
                    #' @description
                    #' Creates a new instance of this [R6][R6::R6Class] class.
                    #'
                    #' Note that this object is typically constructed via a derived classes, e.g., [COLSTIM], [MaxInP], [Self-Sparring] and [DTS].
                    initialize = function(aggregation, action_size) {
                       
                      self$aggregation    = aggregation
                      self$timestep       = 1
                      self$action_size    = action_size
                      self$choices        = list()
                      self$regret         = c()
					  self$weak_regret	  = c()
                      self$times          = c()
                    },
                    
                    
                    #' @description
                    #' Printer.
                    #' @param ... (ignored).
                    print = function() { 
                      cat(" BLA ")
                    },
                    
                    #' @description
                    #' provides the learner with the problem instance to interact with
                    #' 
                    setDataModel = function(feedback) {
                      data_model = feedback
                    },
                    
					#' @description
                    #' resets the internal statistics of the learner
                    #' 
                    clear = function(){
                      self$timestep       = 1
                      self$choices        = list()
                      self$regret         = c()
					  self$weak_regret	  = c()
                      self$times          = c()
                    },
                    
                    #' @description
                    #' performs an action of the learner.
                    #' Note that this function is defined via the derived classes, e.g., [COLSTIM], [MaxInP], [Self-Sparring] and [DTS].
                    #'
                    #' @return
                    #' Returns the index of the arms to be chosen. 
                    action = function(data_model) {

                    },
                    
                    #' @description
                    #' updates the internal statistics of the learner.
                    #' Note that this function is defined via the derived classes, e.g., [COLSTIM], [MaxInP], [Self-Sparring] and [DTS].
                    #'
                    #' @param choice (`integer(action_size)`)\cr.
                    #' 
                    #' @param feedback \cr.
                    #' 
                    #'
                    update = function(chosen_arms, data_model) {

                    },
                    
                    #' @description
                    #' running the learner for the given problem instance.
                    #'
                    #' @param feedback \cr.
                    #' 
                    #'
                    run = function(data_model) {
                      
                      for (t in 1:data_model$getTimeHorizon()){

                        start_time 							  = Sys.time()
                        chosen_arms   						  = self$action(data_model)
                        self$update(chosen_arms, data_model)
                        end_time 							  = Sys.time()
                        self$times[t]                         = end_time - start_time
                        self$choices[[t]]                     = chosen_arms
                        self$regret[t]                        = mean(max(data_model$getUtilities(self$timestep)) - data_model$getUtilities(self$timestep)[chosen_arms])				
						self$weak_regret[t]	  				  = max(data_model$getUtilities(self$timestep)) - max(data_model$getUtilities(self$timestep)[chosen_arms])
                        self$timestep                         = self$timestep       + 1
                        
                      }
                      
                    }
                    
                    
                  ),

                  

)

