


MLE_estimate <- function(feedback,covariates,comparison, comparison_der = NULL, theta_start = NULL){
  
  f_t <- function(x,t){
    as.numeric(feedback[t]-comparison(covariates[[t]]%*%x))*covariates[[t]]
  }
  
  j_t <- function(x,t){
    as.numeric(comparison_der(covariates[[t]]%*%x))*outer(covariates[[t]],covariates[[t]])
  }
  
  fun <- function(x){
    apply(matrix(unlist(lapply(1:(length(feedback)),f_t, x=x )), ncol = length(feedback)),1,sum)
  }
  
  jfun <- function (x){ 
    -apply(array(unlist(lapply(1:(length(feedback)),j_t, x=x )), dim = c(length(covariates[[1]]),length(covariates[[1]]),length(feedback))),1:2,sum)
  }
  
  if(is.null(theta_start)){
    theta_star=runif(length(covariates[[1]]))
  }
  
  multiroot(start = theta_start, f = fun, jactype = "fullusr", jacfunc = jfun)$root
  
}


gradLikelihood <- function(theta, covariates, comparison, feedback){
  
  as.numeric(feedback-comparison(covariates%*%theta))*covariates
  
  
}


