

library("parallel")
library('ExtDist')
library(R6)
library(evd)
library(rootSolve)





source("Feedback.R")
source("Performance.R")
source("Auxiliary.R")
source("Learner.R")
source("MLE.R")
source("Random.R")
source("MaxInP.R")
source("COLSTIM.R")
source("SelfSparring.R")
source("DTS.R")


set.seed(21)

#	global parameters 

T 			= 3000
num_arms 	= 50
dim 		= 10
num.cores 	<- 16 # number of CPU cores
reps 		= 100

# choice of tau, p_t, c_1 and C_threshold

tau_0 		= dim*num_arms

p_t = function(x){
min(1,dim/(sqrt(x-tau_0))*log(dim*T) )
}

threshold	= sqrt(dim * log(T))



###################################################################################################################
##################	BTL Model Easy Problem (no misspeficifation)  
###################################################################################################################

rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = plogis, df =dlogis, pert_dis = rgumbel,  fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t )
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec 	= c("easy","medium","hard")
perf 		= Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="easy", time_horizon = T, n = num_arms, pert_dis = rgumbel, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()

tagetfile=paste("Easy_Run_BTL",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)


###################################################################################################################
##################	BTL Model Medium Problem (no misspeficifation)  
###################################################################################################################


rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = plogis, df =dlogis, pert_dis = rgumbel, fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t )
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec = c("easy","medium","hard")
perf = Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="medium", time_horizon = T, n = num_arms, pert_dis = rgumbel, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()


tagetfile=paste("Medium_Run_BTL",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)


###################################################################################################################
##################	BTL Model Hard Problem (no misspeficifation)  
###################################################################################################################


rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = plogis, df =dlogis, pert_dis = rgumbel,fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t )
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec 	= c("easy","medium","hard")
perf 		= Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="hard", time_horizon = T, n = num_arms, pert_dis = rgumbel, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()

tagetfile=paste("Hard_Run_BTL",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)



###################################################################################################################
##################	TM Model Easy Problem (no misspeficifation)  
###################################################################################################################

rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = pnorm, df =dnorm, pert_dis = rnorm, fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t )
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec 	= c("easy","medium","hard")
perf 		= Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="easy", time_horizon = T, n = num_arms, pert_dis = rnorm, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()


tagetfile=paste("Easy_Run_TM",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)


###################################################################################################################
##################	TM Model Medium Problem (no misspeficifation)  
###################################################################################################################


rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = pnorm, df =dnorm, pert_dis = rnorm, fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t ) 
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec 	= c("easy","medium","hard")
perf 		= Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="medium", time_horizon = T, n = num_arms, pert_dis = rnorm, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()


tagetfile=paste("Medium_Run_TM",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)

###################################################################################################################
##################	TM Model Hard Problem (no misspeficifation)  
###################################################################################################################


rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = pnorm, df =dnorm, pert_dis = rnorm, fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t )
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec = c("easy","medium","hard")
perf = Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="hard", time_horizon = T, n = num_arms, pert_dis = rnorm, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()



tagetfile=paste("Hard_Run_TM",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)




###################################################################################################################
##################	BTL Model Easy Problem (misspeficifation)  
###################################################################################################################

rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = pnorm, df =dnorm, pert_dis = rnorm,  fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t )
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec = c("easy","medium","hard")
perf = Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="easy", time_horizon = T, n = num_arms, pert_dis = rgumbel, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()



tagetfile=paste("Easy_Run_BTL_mis",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)

###################################################################################################################
##################	BTL Model Medium Problem (misspeficifation)  
###################################################################################################################



rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = pnorm, df =dnorm, pert_dis = rnorm,  fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t )
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec 	= c("easy","medium","hard")
perf 		= Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="medium", time_horizon = T, n = num_arms, pert_dis = rgumbel, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()


tagetfile=paste("Medium_Run_BTL_mis",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)


###################################################################################################################
##################	BTL Model Hard Problem (misspeficifation)  
###################################################################################################################

rand    <- Random$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean )
maxinp  <- MaxInP$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean, eta = threshold, tau_0 = tau_0, fullMLE = FALSE, alpha = 0.5 )
colstim <- COLSTIM$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean,  tau_0 = tau_0, cdf = pnorm, df =dnorm, pert_dis = rnorm,  fullMLE = FALSE, 
		eta = 0.5 , threshold = threshold, p_t = p_t )
ss 		<- SelfSparring$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , action_size = 2, eta = 3.5)
dts 	<- DTS$new(data_model_specs = list(num_arms = num_arms, dim = dim), aggregation = mean , alpha = 0.51)

diff_vec 	= c("easy","medium","hard")
perf 		= Performance$new(learners = list(rand,maxinp,colstim,ss,dts), d = dim, diff="hard", time_horizon = T, n = num_arms, pert_dis = rgumbel, reps= reps )


perf$runSimulations()
perf$getStatistics()
perf$plotCumRegret()


tagetfile=paste("Hard_Run_BTL_mis",Sys.Date(),"_N_arms",num_arms,"_dim",dim,"_Repetitions",reps,"_",".RData",sep="")

save.image(file=tagetfile)


